/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.net.LinkProperties;
import android.net.metrics.DefaultNetworkEvent;
import android.os.SystemClock;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.BitUtils;
import com.android.internal.util.RingBuffer;
import com.android.server.connectivity.IpConnectivityEventBuilder;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DefaultNetworkMetrics {
    private static final int ROLLING_LOG_SIZE = 64;
    public final long creationTimeMs = SystemClock.elapsedRealtime();
    @GuardedBy(value="this")
    private final List<DefaultNetworkEvent> mEvents = new ArrayList<DefaultNetworkEvent>();
    @GuardedBy(value="this")
    private final RingBuffer<DefaultNetworkEvent> mEventsLog = new RingBuffer<DefaultNetworkEvent>(DefaultNetworkEvent.class, 64);
    @GuardedBy(value="this")
    private DefaultNetworkEvent mCurrentDefaultNetwork;
    @GuardedBy(value="this")
    private boolean mIsCurrentlyValid;
    @GuardedBy(value="this")
    private long mLastValidationTimeMs;
    @GuardedBy(value="this")
    private int mLastTransports;

    public DefaultNetworkMetrics() {
        this.newDefaultNetwork(this.creationTimeMs, null);
    }

    public synchronized void listEvents(PrintWriter pw) {
        pw.println("default network events:");
        long localTimeMs = System.currentTimeMillis();
        long timeMs = SystemClock.elapsedRealtime();
        for (DefaultNetworkEvent ev : this.mEventsLog.toArray()) {
            DefaultNetworkMetrics.printEvent(localTimeMs, pw, ev);
        }
        this.mCurrentDefaultNetwork.updateDuration(timeMs);
        if (this.mIsCurrentlyValid) {
            this.updateValidationTime(timeMs);
            this.mLastValidationTimeMs = timeMs;
        }
        DefaultNetworkMetrics.printEvent(localTimeMs, pw, this.mCurrentDefaultNetwork);
    }

    public synchronized void listEventsAsProto(PrintWriter pw) {
        for (DefaultNetworkEvent ev : this.mEventsLog.toArray()) {
            pw.print(IpConnectivityEventBuilder.toProto(ev));
        }
    }

    public synchronized void flushEvents(List<IpConnectivityLogClass.IpConnectivityEvent> out) {
        for (DefaultNetworkEvent ev : this.mEvents) {
            out.add(IpConnectivityEventBuilder.toProto(ev));
        }
        this.mEvents.clear();
    }

    public synchronized void logDefaultNetworkValidity(long timeMs, boolean isValid) {
        if (!isValid && this.mIsCurrentlyValid) {
            this.mIsCurrentlyValid = false;
            this.updateValidationTime(timeMs);
        }
        if (isValid && !this.mIsCurrentlyValid) {
            this.mIsCurrentlyValid = true;
            this.mLastValidationTimeMs = timeMs;
        }
    }

    private void updateValidationTime(long timeMs) {
        this.mCurrentDefaultNetwork.validatedMs += timeMs - this.mLastValidationTimeMs;
    }

    public synchronized void logDefaultNetworkEvent(long timeMs, NetworkAgentInfo newNai, NetworkAgentInfo oldNai) {
        this.logCurrentDefaultNetwork(timeMs, oldNai);
        this.newDefaultNetwork(timeMs, newNai);
    }

    private void logCurrentDefaultNetwork(long timeMs, NetworkAgentInfo oldNai) {
        if (this.mIsCurrentlyValid) {
            this.updateValidationTime(timeMs);
        }
        DefaultNetworkEvent ev = this.mCurrentDefaultNetwork;
        ev.updateDuration(timeMs);
        ev.previousTransports = this.mLastTransports;
        if (oldNai != null) {
            DefaultNetworkMetrics.fillLinkInfo(ev, oldNai);
            ev.finalScore = oldNai.getCurrentScore();
        }
        if (ev.transports != 0) {
            this.mLastTransports = ev.transports;
        }
        this.mEvents.add(ev);
        this.mEventsLog.append(ev);
    }

    private void newDefaultNetwork(long timeMs, NetworkAgentInfo newNai) {
        DefaultNetworkEvent ev = new DefaultNetworkEvent(timeMs);
        ev.durationMs = timeMs;
        if (newNai != null) {
            DefaultNetworkMetrics.fillLinkInfo(ev, newNai);
            ev.initialScore = newNai.getCurrentScore();
            if (newNai.lastValidated) {
                this.mIsCurrentlyValid = true;
                this.mLastValidationTimeMs = timeMs;
            }
        } else {
            this.mIsCurrentlyValid = false;
        }
        this.mCurrentDefaultNetwork = ev;
    }

    private static void fillLinkInfo(DefaultNetworkEvent ev, NetworkAgentInfo nai) {
        LinkProperties lp = nai.linkProperties;
        ev.netId = nai.network().netId;
        ev.transports = (int)((long)ev.transports | BitUtils.packBits(nai.networkCapabilities.getTransportTypes()));
        ev.ipv4 = ev.ipv4 | (lp.hasIPv4Address() && lp.hasIPv4DefaultRoute());
        ev.ipv6 = ev.ipv6 | (lp.hasGlobalIPv6Address() && lp.hasIPv6DefaultRoute());
    }

    private static void printEvent(long localTimeMs, PrintWriter pw, DefaultNetworkEvent ev) {
        long localCreationTimeMs = localTimeMs - ev.durationMs;
        pw.println(String.format("%tT.%tL: %s", localCreationTimeMs, localCreationTimeMs, ev));
    }
}

