/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkUtils;
import android.net.Uri;
import android.net.dns.ResolvUtil;
import android.os.Binder;
import android.os.INetworkManagementService;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import com.android.server.connectivity.MockableSystemProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class DnsManager {
    private static final String TAG = DnsManager.class.getSimpleName();
    private static final PrivateDnsConfig PRIVATE_DNS_OFF = new PrivateDnsConfig();
    private static final int DNS_RESOLVER_DEFAULT_SAMPLE_VALIDITY_SECONDS = 1800;
    private static final int DNS_RESOLVER_DEFAULT_SUCCESS_THRESHOLD_PERCENT = 25;
    private static final int DNS_RESOLVER_DEFAULT_MIN_SAMPLES = 8;
    private static final int DNS_RESOLVER_DEFAULT_MAX_SAMPLES = 64;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final INetworkManagementService mNMS;
    private final MockableSystemProperties mSystemProperties;
    private final Map<Integer, PrivateDnsConfig> mPrivateDnsMap;
    private final Map<Integer, PrivateDnsValidationStatuses> mPrivateDnsValidationMap;
    private int mNumDnsEntries;
    private int mSampleValidity;
    private int mSuccessThreshold;
    private int mMinSamples;
    private int mMaxSamples;
    private String mPrivateDnsMode;
    private String mPrivateDnsSpecifier;

    public static PrivateDnsConfig getPrivateDnsConfig(ContentResolver cr) {
        boolean useTls;
        String mode = DnsManager.getPrivateDnsMode(cr);
        boolean bl = useTls = !TextUtils.isEmpty(mode) && !"off".equals(mode);
        if ("hostname".equals(mode)) {
            String specifier = DnsManager.getStringSetting(cr, "private_dns_specifier");
            return new PrivateDnsConfig(specifier, null);
        }
        return new PrivateDnsConfig(useTls);
    }

    public static PrivateDnsConfig tryBlockingResolveOf(Network network, String name) {
        try {
            InetAddress[] ips = ResolvUtil.blockingResolveAllLocally(network, name);
            return new PrivateDnsConfig(name, ips);
        }
        catch (UnknownHostException uhe) {
            return new PrivateDnsConfig(name, null);
        }
    }

    public static Uri[] getPrivateDnsSettingsUris() {
        return new Uri[]{Settings.Global.getUriFor("private_dns_default_mode"), Settings.Global.getUriFor("private_dns_mode"), Settings.Global.getUriFor("private_dns_specifier")};
    }

    public DnsManager(Context ctx, INetworkManagementService nms, MockableSystemProperties sp) {
        this.mContext = ctx;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mNMS = nms;
        this.mSystemProperties = sp;
        this.mPrivateDnsMap = new HashMap<Integer, PrivateDnsConfig>();
        this.mPrivateDnsValidationMap = new HashMap<Integer, PrivateDnsValidationStatuses>();
    }

    public PrivateDnsConfig getPrivateDnsConfig() {
        return DnsManager.getPrivateDnsConfig(this.mContentResolver);
    }

    public void removeNetwork(Network network) {
        this.mPrivateDnsMap.remove(network.netId);
        this.mPrivateDnsValidationMap.remove(network.netId);
    }

    public PrivateDnsConfig updatePrivateDns(Network network, PrivateDnsConfig cfg) {
        Slog.w(TAG, "updatePrivateDns(" + network + ", " + cfg + ")");
        return cfg != null ? this.mPrivateDnsMap.put(network.netId, cfg) : this.mPrivateDnsMap.remove(network.netId);
    }

    public void updatePrivateDnsStatus(int netId, LinkProperties lp) {
        PrivateDnsConfig privateDnsCfg = this.mPrivateDnsMap.getOrDefault(netId, PRIVATE_DNS_OFF);
        boolean useTls = privateDnsCfg.useTls;
        PrivateDnsValidationStatuses statuses = useTls ? this.mPrivateDnsValidationMap.get(netId) : null;
        boolean validated = null != statuses && statuses.hasValidatedServer();
        boolean strictMode = privateDnsCfg.inStrictMode();
        String tlsHostname = strictMode ? privateDnsCfg.hostname : null;
        boolean usingPrivateDns = strictMode || validated;
        lp.setUsePrivateDns(usingPrivateDns);
        lp.setPrivateDnsServerName(tlsHostname);
        if (usingPrivateDns && null != statuses) {
            statuses.fillInValidatedPrivateDns(lp);
        } else {
            lp.setValidatedPrivateDnsServers(Collections.EMPTY_LIST);
        }
    }

    public void updatePrivateDnsValidation(PrivateDnsValidationUpdate update) {
        PrivateDnsValidationStatuses statuses = this.mPrivateDnsValidationMap.get(update.netId);
        if (statuses == null) {
            return;
        }
        statuses.updateStatus(update);
    }

    public void setDnsConfigurationForNetwork(int netId, LinkProperties lp, boolean isDefaultNetwork) {
        Object[] tlsServers;
        String tlsHostname;
        Object[] assignedServers = NetworkUtils.makeStrings(lp.getDnsServers());
        Object[] domainStrs = DnsManager.getDomainStrings(lp.getDomains());
        this.updateParametersSettings();
        int[] params = new int[]{this.mSampleValidity, this.mSuccessThreshold, this.mMinSamples, this.mMaxSamples};
        PrivateDnsConfig privateDnsCfg = this.mPrivateDnsMap.getOrDefault(netId, PRIVATE_DNS_OFF);
        boolean useTls = privateDnsCfg.useTls;
        boolean strictMode = privateDnsCfg.inStrictMode();
        String string2 = tlsHostname = strictMode ? privateDnsCfg.hostname : "";
        Object[] objectArray = strictMode ? NetworkUtils.makeStrings(Arrays.stream(privateDnsCfg.ips).filter(ip -> lp.isReachable((InetAddress)ip)).collect(Collectors.toList())) : (tlsServers = useTls ? assignedServers : new String[]{});
        if (useTls) {
            if (!this.mPrivateDnsValidationMap.containsKey(netId)) {
                this.mPrivateDnsValidationMap.put(netId, new PrivateDnsValidationStatuses());
            }
            this.mPrivateDnsValidationMap.get(netId).updateTrackedDnses((String[])tlsServers, tlsHostname);
        } else {
            this.mPrivateDnsValidationMap.remove(netId);
        }
        Slog.d(TAG, String.format("setDnsConfigurationForNetwork(%d, %s, %s, %s, %s, %s)", netId, Arrays.toString(assignedServers), Arrays.toString(domainStrs), Arrays.toString(params), tlsHostname, Arrays.toString(tlsServers)));
        try {
            this.mNMS.setDnsConfigurationForNetwork(netId, (String[])assignedServers, (String[])domainStrs, params, tlsHostname, (String[])tlsServers);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error setting DNS configuration: " + e);
            return;
        }
        if (isDefaultNetwork) {
            this.setDefaultDnsSystemProperties(lp.getDnsServers());
        }
        this.flushVmDnsCache();
    }

    public void setDefaultDnsSystemProperties(Collection<InetAddress> dnses) {
        int last = 0;
        for (InetAddress dns : dnses) {
            this.setNetDnsProperty(++last, dns.getHostAddress());
        }
        for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
            this.setNetDnsProperty(i, "");
        }
        this.mNumDnsEntries = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVmDnsCache() {
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x4000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void updateParametersSettings() {
        this.mSampleValidity = this.getIntSetting("dns_resolver_sample_validity_seconds", 1800);
        if (this.mSampleValidity < 0 || this.mSampleValidity > 65535) {
            Slog.w(TAG, "Invalid sampleValidity=" + this.mSampleValidity + ", using default=" + 1800);
            this.mSampleValidity = 1800;
        }
        this.mSuccessThreshold = this.getIntSetting("dns_resolver_success_threshold_percent", 25);
        if (this.mSuccessThreshold < 0 || this.mSuccessThreshold > 100) {
            Slog.w(TAG, "Invalid successThreshold=" + this.mSuccessThreshold + ", using default=" + 25);
            this.mSuccessThreshold = 25;
        }
        this.mMinSamples = this.getIntSetting("dns_resolver_min_samples", 8);
        this.mMaxSamples = this.getIntSetting("dns_resolver_max_samples", 64);
        if (this.mMinSamples < 0 || this.mMinSamples > this.mMaxSamples || this.mMaxSamples > 64) {
            Slog.w(TAG, "Invalid sample count (min, max)=(" + this.mMinSamples + ", " + this.mMaxSamples + "), using default=(" + 8 + ", " + 64 + ")");
            this.mMinSamples = 8;
            this.mMaxSamples = 64;
        }
    }

    private int getIntSetting(String which, int dflt) {
        return Settings.Global.getInt(this.mContentResolver, which, dflt);
    }

    private void setNetDnsProperty(int which, String value) {
        String key = "net.dns" + which;
        try {
            this.mSystemProperties.set(key, value);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error setting unsupported net.dns property: ", e);
        }
    }

    private static String getPrivateDnsMode(ContentResolver cr) {
        String mode = DnsManager.getStringSetting(cr, "private_dns_mode");
        if (TextUtils.isEmpty(mode)) {
            mode = DnsManager.getStringSetting(cr, "private_dns_default_mode");
        }
        if (TextUtils.isEmpty(mode)) {
            mode = "opportunistic";
        }
        return mode;
    }

    private static String getStringSetting(ContentResolver cr, String which) {
        return Settings.Global.getString(cr, which);
    }

    private static String[] getDomainStrings(String domains) {
        return TextUtils.isEmpty(domains) ? new String[]{} : domains.split(" ");
    }

    private static class PrivateDnsValidationStatuses {
        private Map<Pair<String, InetAddress>, ValidationStatus> mValidationMap = new HashMap<Pair<String, InetAddress>, ValidationStatus>();

        private PrivateDnsValidationStatuses() {
        }

        private boolean hasValidatedServer() {
            for (ValidationStatus status : this.mValidationMap.values()) {
                if (status != ValidationStatus.SUCCEEDED) continue;
                return true;
            }
            return false;
        }

        private void updateTrackedDnses(String[] ipAddresses, String hostname) {
            HashSet<Pair<String, InetAddress>> latestDnses = new HashSet<Pair<String, InetAddress>>();
            for (String ipAddress : ipAddresses) {
                try {
                    latestDnses.add(new Pair<String, InetAddress>(hostname, InetAddress.parseNumericAddress((String)ipAddress)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Iterator<Map.Entry<Pair<String, InetAddress>, ValidationStatus>> it = this.mValidationMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Pair<String, InetAddress>, ValidationStatus> entry = it.next();
                if (latestDnses.contains(entry.getKey())) continue;
                it.remove();
            }
            for (Pair pair : latestDnses) {
                if (this.mValidationMap.containsKey(pair)) continue;
                this.mValidationMap.put(pair, ValidationStatus.IN_PROGRESS);
            }
        }

        private void updateStatus(PrivateDnsValidationUpdate update) {
            Pair<String, InetAddress> p = new Pair<String, InetAddress>(update.hostname, update.ipAddress);
            if (!this.mValidationMap.containsKey(p)) {
                return;
            }
            if (update.validated) {
                this.mValidationMap.put(p, ValidationStatus.SUCCEEDED);
            } else {
                this.mValidationMap.put(p, ValidationStatus.FAILED);
            }
        }

        private LinkProperties fillInValidatedPrivateDns(LinkProperties lp) {
            lp.setValidatedPrivateDnsServers(Collections.EMPTY_LIST);
            this.mValidationMap.forEach((key, value) -> {
                if (value == ValidationStatus.SUCCEEDED) {
                    lp.addValidatedPrivateDnsServer((InetAddress)key.second);
                }
            });
            return lp;
        }

        static enum ValidationStatus {
            IN_PROGRESS,
            FAILED,
            SUCCEEDED;

        }
    }

    public static class PrivateDnsValidationUpdate {
        public final int netId;
        public final InetAddress ipAddress;
        public final String hostname;
        public final boolean validated;

        public PrivateDnsValidationUpdate(int netId, InetAddress ipAddress, String hostname, boolean validated) {
            this.netId = netId;
            this.ipAddress = ipAddress;
            this.hostname = hostname;
            this.validated = validated;
        }
    }

    public static class PrivateDnsConfig {
        public final boolean useTls;
        public final String hostname;
        public final InetAddress[] ips;

        public PrivateDnsConfig() {
            this(false);
        }

        public PrivateDnsConfig(boolean useTls) {
            this.useTls = useTls;
            this.hostname = "";
            this.ips = new InetAddress[0];
        }

        public PrivateDnsConfig(String hostname, InetAddress[] ips) {
            this.useTls = !TextUtils.isEmpty(hostname);
            this.hostname = this.useTls ? hostname : "";
            this.ips = ips != null ? ips : new InetAddress[]{};
        }

        public PrivateDnsConfig(PrivateDnsConfig cfg) {
            this.useTls = cfg.useTls;
            this.hostname = cfg.hostname;
            this.ips = cfg.ips;
        }

        public boolean inStrictMode() {
            return this.useTls && !TextUtils.isEmpty(this.hostname);
        }

        public String toString() {
            return PrivateDnsConfig.class.getSimpleName() + "{" + this.useTls + ":" + this.hostname + "/" + Arrays.toString(this.ips) + "}";
        }
    }
}

