/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetdEventCallback;
import android.net.MacAddress;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.metrics.ConnectStats;
import android.net.metrics.DnsEvent;
import android.net.metrics.INetdEventListener;
import android.net.metrics.NetworkMetrics;
import android.net.metrics.WakeupEvent;
import android.net.metrics.WakeupStats;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.RingBuffer;
import com.android.internal.util.TokenBucket;
import com.android.server.connectivity.IpConnectivityEventBuilder;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class NetdEventListenerService
extends INetdEventListener.Stub {
    public static final String SERVICE_NAME = "netd_listener";
    private static final String TAG = NetdEventListenerService.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int CONNECT_LATENCY_BURST_LIMIT = 5000;
    private static final int CONNECT_LATENCY_FILL_RATE = 15000;
    private static final long METRICS_SNAPSHOT_SPAN_MS = 300000L;
    private static final int METRICS_SNAPSHOT_BUFFER_SIZE = 48;
    @VisibleForTesting
    static final int WAKEUP_EVENT_BUFFER_LENGTH = 1024;
    @VisibleForTesting
    static final String WAKEUP_EVENT_IFACE_PREFIX = "iface:";
    @GuardedBy(value="this")
    private final SparseArray<NetworkMetrics> mNetworkMetrics = new SparseArray();
    @GuardedBy(value="this")
    private final RingBuffer<NetworkMetricsSnapshot> mNetworkMetricsSnapshots = new RingBuffer<NetworkMetricsSnapshot>(NetworkMetricsSnapshot.class, 48);
    @GuardedBy(value="this")
    private long mLastSnapshot = 0L;
    @GuardedBy(value="this")
    private final ArrayMap<String, WakeupStats> mWakeupStats = new ArrayMap();
    @GuardedBy(value="this")
    private final RingBuffer<WakeupEvent> mWakeupEvents = new RingBuffer<WakeupEvent>(WakeupEvent.class, 1024);
    private final ConnectivityManager mCm;
    @GuardedBy(value="this")
    private final TokenBucket mConnectTb = new TokenBucket(15000, 5000);
    @GuardedBy(value="this")
    private static final int[] ALLOWED_CALLBACK_TYPES = new int[]{0, 1, 2};
    @GuardedBy(value="this")
    private INetdEventCallback[] mNetdEventCallbackList = new INetdEventCallback[ALLOWED_CALLBACK_TYPES.length];

    public synchronized boolean addNetdEventCallback(int callerType, INetdEventCallback callback) {
        if (!NetdEventListenerService.isValidCallerType(callerType)) {
            Log.e(TAG, "Invalid caller type: " + callerType);
            return false;
        }
        this.mNetdEventCallbackList[callerType] = callback;
        return true;
    }

    public synchronized boolean removeNetdEventCallback(int callerType) {
        if (!NetdEventListenerService.isValidCallerType(callerType)) {
            Log.e(TAG, "Invalid caller type: " + callerType);
            return false;
        }
        this.mNetdEventCallbackList[callerType] = null;
        return true;
    }

    private static boolean isValidCallerType(int callerType) {
        for (int i = 0; i < ALLOWED_CALLBACK_TYPES.length; ++i) {
            if (callerType != ALLOWED_CALLBACK_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public NetdEventListenerService(Context context) {
        this(context.getSystemService(ConnectivityManager.class));
    }

    @VisibleForTesting
    public NetdEventListenerService(ConnectivityManager cm) {
        this.mCm = cm;
    }

    private static long projectSnapshotTime(long timeMs) {
        return timeMs / 300000L * 300000L;
    }

    private NetworkMetrics getMetricsForNetwork(long timeMs, int netId) {
        this.collectPendingMetricsSnapshot(timeMs);
        NetworkMetrics metrics = this.mNetworkMetrics.get(netId);
        if (metrics == null) {
            metrics = new NetworkMetrics(netId, this.getTransports(netId), this.mConnectTb);
            this.mNetworkMetrics.put(netId, metrics);
        }
        return metrics;
    }

    private NetworkMetricsSnapshot[] getNetworkMetricsSnapshots() {
        this.collectPendingMetricsSnapshot(System.currentTimeMillis());
        return this.mNetworkMetricsSnapshots.toArray();
    }

    private void collectPendingMetricsSnapshot(long timeMs) {
        if (Math.abs(timeMs - this.mLastSnapshot) <= 300000L) {
            return;
        }
        this.mLastSnapshot = NetdEventListenerService.projectSnapshotTime(timeMs);
        NetworkMetricsSnapshot snapshot = NetworkMetricsSnapshot.collect(this.mLastSnapshot, this.mNetworkMetrics);
        if (snapshot.stats.isEmpty()) {
            return;
        }
        this.mNetworkMetricsSnapshots.append(snapshot);
    }

    @Override
    public synchronized void onDnsEvent(int netId, int eventType, int returnCode, int latencyMs, String hostname, String[] ipAddresses, int ipAddressesCount, int uid) throws RemoteException {
        long timestamp = System.currentTimeMillis();
        this.getMetricsForNetwork(timestamp, netId).addDnsResult(eventType, returnCode, latencyMs);
        for (INetdEventCallback callback : this.mNetdEventCallbackList) {
            if (callback == null) continue;
            callback.onDnsEvent(hostname, ipAddresses, ipAddressesCount, timestamp, uid);
        }
    }

    @Override
    public synchronized void onPrivateDnsValidationEvent(int netId, String ipAddress, String hostname, boolean validated) throws RemoteException {
        for (INetdEventCallback callback : this.mNetdEventCallbackList) {
            if (callback == null) continue;
            callback.onPrivateDnsValidationEvent(netId, ipAddress, hostname, validated);
        }
    }

    @Override
    public synchronized void onConnectEvent(int netId, int error, int latencyMs, String ipAddr, int port, int uid) throws RemoteException {
        long timestamp = System.currentTimeMillis();
        this.getMetricsForNetwork(timestamp, netId).addConnectResult(error, latencyMs, ipAddr);
        for (INetdEventCallback callback : this.mNetdEventCallbackList) {
            if (callback == null) continue;
            callback.onConnectEvent(ipAddr, port, timestamp, uid);
        }
    }

    @Override
    public synchronized void onWakeupEvent(String prefix, int uid, int ethertype, int ipNextHeader, byte[] dstHw, String srcIp, String dstIp, int srcPort, int dstPort, long timestampNs) {
        String iface = prefix.replaceFirst(WAKEUP_EVENT_IFACE_PREFIX, "");
        long timestampMs = timestampNs > 0L ? timestampNs / 1000000L : System.currentTimeMillis();
        WakeupEvent event = new WakeupEvent();
        event.iface = iface;
        event.timestampMs = timestampMs;
        event.uid = uid;
        event.ethertype = ethertype;
        event.dstHwAddr = MacAddress.fromBytes(dstHw);
        event.srcIp = srcIp;
        event.dstIp = dstIp;
        event.ipNextHeader = ipNextHeader;
        event.srcPort = srcPort;
        event.dstPort = dstPort;
        this.addWakeupEvent(event);
        String dstMac = event.dstHwAddr.toString();
        StatsLog.write(44, uid, iface, ethertype, dstMac, srcIp, dstIp, ipNextHeader, srcPort, dstPort);
    }

    @Override
    public synchronized void onTcpSocketStatsEvent(int[] networkIds, int[] sentPackets, int[] lostPackets, int[] rttsUs, int[] sentAckDiffsMs) {
        if (networkIds.length != sentPackets.length || networkIds.length != lostPackets.length || networkIds.length != rttsUs.length || networkIds.length != sentAckDiffsMs.length) {
            Log.e(TAG, "Mismatched lengths of TCP socket stats data arrays");
            return;
        }
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < networkIds.length; ++i) {
            int netId = networkIds[i];
            int sent = sentPackets[i];
            int lost = lostPackets[i];
            int rttUs = rttsUs[i];
            int sentAckDiffMs = sentAckDiffsMs[i];
            this.getMetricsForNetwork(timestamp, netId).addTcpStatsResult(sent, lost, rttUs, sentAckDiffMs);
        }
    }

    private void addWakeupEvent(WakeupEvent event) {
        String iface = event.iface;
        this.mWakeupEvents.append(event);
        WakeupStats stats = this.mWakeupStats.get(iface);
        if (stats == null) {
            stats = new WakeupStats(iface);
            this.mWakeupStats.put(iface, stats);
        }
        stats.countEvent(event);
    }

    public synchronized void flushStatistics(List<IpConnectivityLogClass.IpConnectivityEvent> events) {
        int i;
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            ConnectStats stats = this.mNetworkMetrics.valueAt((int)i).connectMetrics;
            if (stats.eventCount == 0) continue;
            events.add(IpConnectivityEventBuilder.toProto(stats));
        }
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            DnsEvent ev = this.mNetworkMetrics.valueAt((int)i).dnsMetrics;
            if (ev.eventCount == 0) continue;
            events.add(IpConnectivityEventBuilder.toProto(ev));
        }
        for (i = 0; i < this.mWakeupStats.size(); ++i) {
            events.add(IpConnectivityEventBuilder.toProto(this.mWakeupStats.valueAt(i)));
        }
        this.mNetworkMetrics.clear();
        this.mWakeupStats.clear();
    }

    public synchronized void list(PrintWriter pw) {
        int i;
        pw.println("dns/connect events:");
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            pw.println(this.mNetworkMetrics.valueAt((int)i).connectMetrics);
        }
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            pw.println(this.mNetworkMetrics.valueAt((int)i).dnsMetrics);
        }
        pw.println("");
        pw.println("network statistics:");
        for (NetworkMetricsSnapshot s : this.getNetworkMetricsSnapshots()) {
            pw.println(s);
        }
        pw.println("");
        pw.println("packet wakeup events:");
        for (int i2 = 0; i2 < this.mWakeupStats.size(); ++i2) {
            pw.println(this.mWakeupStats.valueAt(i2));
        }
        for (WakeupEvent wakeup : this.mWakeupEvents.toArray()) {
            pw.println(wakeup);
        }
    }

    public synchronized void listAsProtos(PrintWriter pw) {
        int i;
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            pw.print(IpConnectivityEventBuilder.toProto(this.mNetworkMetrics.valueAt((int)i).connectMetrics));
        }
        for (i = 0; i < this.mNetworkMetrics.size(); ++i) {
            pw.print(IpConnectivityEventBuilder.toProto(this.mNetworkMetrics.valueAt((int)i).dnsMetrics));
        }
        for (i = 0; i < this.mWakeupStats.size(); ++i) {
            pw.print(IpConnectivityEventBuilder.toProto(this.mWakeupStats.valueAt(i)));
        }
    }

    private long getTransports(int netId) {
        NetworkCapabilities nc = this.mCm.getNetworkCapabilities(new Network(netId));
        if (nc == null) {
            return 0L;
        }
        return BitUtils.packBits(nc.getTransportTypes());
    }

    private static void maybeLog(String s, Object ... args) {
    }

    static class NetworkMetricsSnapshot {
        public long timeMs;
        public List<NetworkMetrics.Summary> stats = new ArrayList<NetworkMetrics.Summary>();

        NetworkMetricsSnapshot() {
        }

        static NetworkMetricsSnapshot collect(long timeMs, SparseArray<NetworkMetrics> networkMetrics) {
            NetworkMetricsSnapshot snapshot = new NetworkMetricsSnapshot();
            snapshot.timeMs = timeMs;
            for (int i = 0; i < networkMetrics.size(); ++i) {
                NetworkMetrics.Summary s = networkMetrics.valueAt(i).getPendingStats();
                if (s == null) continue;
                snapshot.stats.add(s);
            }
            return snapshot;
        }

        public String toString() {
            StringJoiner j = new StringJoiner(", ");
            for (NetworkMetrics.Summary s : this.stats) {
                j.add(s.toString());
            }
            return String.format("%tT.%tL: %s", this.timeMs, this.timeMs, j.toString());
        }
    }
}

