/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.CaptivePortal;
import android.net.ICaptivePortal;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.ProxyInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.net.captiveportal.CaptivePortalProbeResult;
import android.net.captiveportal.CaptivePortalProbeSpec;
import android.net.dns.ResolvUtil;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.NetworkEvent;
import android.net.metrics.ValidationProbeEvent;
import android.net.util.Stopwatch;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.DnsManager;
import com.android.server.connectivity.NetworkAgentInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class NetworkMonitor
extends StateMachine {
    private static final String TAG = NetworkMonitor.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String DEFAULT_HTTPS_URL = "https://www.google.com/generate_204";
    private static final String DEFAULT_HTTP_URL = "http://connectivitycheck.gstatic.com/generate_204";
    private static final String DEFAULT_FALLBACK_URL = "http://www.google.com/gen_204";
    private static final String DEFAULT_OTHER_FALLBACK_URLS = "http://play.googleapis.com/generate_204";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.32 Safari/537.36";
    private static final int SOCKET_TIMEOUT_MS = 10000;
    private static final int PROBE_TIMEOUT_MS = 3000;
    public static final int NETWORK_TEST_RESULT_VALID = 0;
    public static final int NETWORK_TEST_RESULT_INVALID = 1;
    private static final int BASE = 532480;
    public static final int CMD_NETWORK_CONNECTED = 532481;
    public static final int EVENT_NETWORK_TESTED = 532482;
    private static final int CMD_REEVALUATE = 532486;
    public static final int CMD_NETWORK_DISCONNECTED = 532487;
    private static final int CMD_FORCE_REEVALUATION = 532488;
    private static final int CMD_CAPTIVE_PORTAL_APP_FINISHED = 532489;
    public static final int EVENT_PROVISIONING_NOTIFICATION = 532490;
    public static final int CMD_LAUNCH_CAPTIVE_PORTAL_APP = 532491;
    private static final int CMD_CAPTIVE_PORTAL_RECHECK = 532492;
    private static final int CMD_PRIVATE_DNS_SETTINGS_CHANGED = 532493;
    public static final int EVENT_PRIVATE_DNS_CONFIG_RESOLVED = 532494;
    private static final int CMD_EVALUATE_PRIVATE_DNS = 532495;
    private static final int INITIAL_REEVALUATE_DELAY_MS = 1000;
    private static final int MAX_REEVALUATE_DELAY_MS = 600000;
    private static final int IGNORE_REEVALUATE_ATTEMPTS = 5;
    private int mReevaluateToken = 0;
    private static final int NO_UID = 0;
    private static final int INVALID_UID = -1;
    private int mUidResponsibleForReeval = -1;
    private static final int BLAME_FOR_EVALUATION_ATTEMPTS = 5;
    private static final int CAPTIVE_PORTAL_REEVALUATE_DELAY_MS = 600000;
    private static final int NUM_VALIDATION_LOG_LINES = 20;
    private String mPrivateDnsProviderHostname = "";
    private final Context mContext;
    private final Handler mConnectivityServiceHandler;
    private final NetworkAgentInfo mNetworkAgentInfo;
    private final Network mNetwork;
    private final int mNetId;
    private final TelephonyManager mTelephonyManager;
    private final WifiManager mWifiManager;
    private final NetworkRequest mDefaultRequest;
    private final IpConnectivityLog mMetricsLog;
    private final NetworkMonitorSettings mSettings;
    private final String mCaptivePortalUserAgent;
    private final URL mCaptivePortalHttpsUrl;
    private final URL mCaptivePortalHttpUrl;
    private final URL[] mCaptivePortalFallbackUrls;
    private final CaptivePortalProbeSpec[] mCaptivePortalFallbackSpecs;
    @VisibleForTesting
    protected boolean mIsCaptivePortalCheckEnabled;
    private boolean mUseHttps;
    private int mValidations = 0;
    private boolean mUserDoesNotWant = false;
    private boolean mDontDisplaySigninNotification = false;
    public boolean systemReady = false;
    private final State mDefaultState = new DefaultState();
    private final State mValidatedState = new ValidatedState();
    private final State mMaybeNotifyState = new MaybeNotifyState();
    private final State mEvaluatingState = new EvaluatingState();
    private final State mCaptivePortalState = new CaptivePortalState();
    private final State mEvaluatingPrivateDnsState = new EvaluatingPrivateDnsState();
    private CustomIntentReceiver mLaunchCaptivePortalAppBroadcastReceiver = null;
    private final LocalLog validationLogs = new LocalLog(20);
    private final Stopwatch mEvaluationTimer = new Stopwatch();
    private CaptivePortalProbeResult mLastPortalProbeResult = CaptivePortalProbeResult.FAILED;
    private int mNextFallbackUrlIndex = 0;

    public static boolean isValidationRequired(NetworkCapabilities dfltNetCap, NetworkCapabilities nc) {
        return dfltNetCap.satisfiedByNetworkCapabilities(nc);
    }

    public NetworkMonitor(Context context, Handler handler, NetworkAgentInfo networkAgentInfo, NetworkRequest defaultRequest) {
        this(context, handler, networkAgentInfo, defaultRequest, new IpConnectivityLog(), NetworkMonitorSettings.DEFAULT);
    }

    @VisibleForTesting
    protected NetworkMonitor(Context context, Handler handler, NetworkAgentInfo networkAgentInfo, NetworkRequest defaultRequest, IpConnectivityLog logger, NetworkMonitorSettings settings) {
        super(TAG + networkAgentInfo.name());
        this.setDbg(false);
        this.mContext = context;
        this.mMetricsLog = logger;
        this.mConnectivityServiceHandler = handler;
        this.mSettings = settings;
        this.mNetworkAgentInfo = networkAgentInfo;
        this.mNetwork = new OneAddressPerFamilyNetwork(networkAgentInfo.network());
        this.mNetId = this.mNetwork.netId;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mDefaultRequest = defaultRequest;
        this.addState(this.mDefaultState);
        this.addState(this.mMaybeNotifyState, this.mDefaultState);
        this.addState(this.mEvaluatingState, this.mMaybeNotifyState);
        this.addState(this.mCaptivePortalState, this.mMaybeNotifyState);
        this.addState(this.mEvaluatingPrivateDnsState, this.mDefaultState);
        this.addState(this.mValidatedState, this.mDefaultState);
        this.setInitialState(this.mDefaultState);
        this.mIsCaptivePortalCheckEnabled = this.getIsCaptivePortalCheckEnabled();
        this.mUseHttps = this.getUseHttpsValidation();
        this.mCaptivePortalUserAgent = this.getCaptivePortalUserAgent();
        this.mCaptivePortalHttpsUrl = this.makeURL(this.getCaptivePortalServerHttpsUrl());
        this.mCaptivePortalHttpUrl = this.makeURL(NetworkMonitor.getCaptivePortalServerHttpUrl(settings, context));
        this.mCaptivePortalFallbackUrls = this.makeCaptivePortalFallbackUrls();
        this.mCaptivePortalFallbackSpecs = this.makeCaptivePortalFallbackProbeSpecs();
        this.start();
    }

    public void forceReevaluation(int responsibleUid) {
        this.sendMessage(532488, responsibleUid, 0);
    }

    public void notifyPrivateDnsSettingsChanged(DnsManager.PrivateDnsConfig newCfg) {
        this.removeMessages(532493);
        this.sendMessage(532493, newCfg);
    }

    @Override
    protected void log(String s) {
        Log.d(TAG + "/" + this.mNetworkAgentInfo.name(), s);
    }

    private void validationLog(int probeType, Object url, String msg) {
        String probeName = ValidationProbeEvent.getProbeName(probeType);
        this.validationLog(String.format("%s %s %s", probeName, url, msg));
    }

    private void validationLog(String s) {
        this.log(s);
        this.validationLogs.log(s);
    }

    public LocalLog.ReadOnlyLocalLog getValidationLogs() {
        return this.validationLogs.readOnlyLocalLog();
    }

    private ValidationStage validationStage() {
        return 0 == this.mValidations ? ValidationStage.FIRST_VALIDATION : ValidationStage.REVALIDATION;
    }

    private boolean isValidationRequired() {
        return NetworkMonitor.isValidationRequired(this.mDefaultRequest.networkCapabilities, this.mNetworkAgentInfo.networkCapabilities);
    }

    private void notifyNetworkTestResultInvalid(Object obj) {
        this.mConnectivityServiceHandler.sendMessage(this.obtainMessage(532482, 1, this.mNetId, obj));
    }

    public boolean getIsCaptivePortalCheckEnabled() {
        String symbol = "captive_portal_mode";
        int defaultValue = 1;
        int mode = this.mSettings.getSetting(this.mContext, symbol, defaultValue);
        return mode != 0;
    }

    public boolean getUseHttpsValidation() {
        return this.mSettings.getSetting(this.mContext, "captive_portal_use_https", 1) == 1;
    }

    public boolean getWifiScansAlwaysAvailableDisabled() {
        return this.mSettings.getSetting(this.mContext, "wifi_scan_always_enabled", 0) == 0;
    }

    private String getCaptivePortalServerHttpsUrl() {
        return this.mSettings.getSetting(this.mContext, "captive_portal_https_url", DEFAULT_HTTPS_URL);
    }

    public static String getCaptivePortalServerHttpUrl(Context context) {
        return NetworkMonitor.getCaptivePortalServerHttpUrl(NetworkMonitorSettings.DEFAULT, context);
    }

    public static String getCaptivePortalServerHttpUrl(NetworkMonitorSettings settings, Context context) {
        return settings.getSetting(context, "captive_portal_http_url", DEFAULT_HTTP_URL);
    }

    private URL[] makeCaptivePortalFallbackUrls() {
        try {
            String separator = ",";
            String firstUrl = this.mSettings.getSetting(this.mContext, "captive_portal_fallback_url", DEFAULT_FALLBACK_URL);
            String joinedUrls = firstUrl + separator + this.mSettings.getSetting(this.mContext, "captive_portal_other_fallback_urls", DEFAULT_OTHER_FALLBACK_URLS);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String s : joinedUrls.split(separator)) {
                URL u = this.makeURL(s);
                if (u == null) continue;
                urls.add(u);
            }
            if (urls.isEmpty()) {
                Log.e(TAG, String.format("could not create any url from %s", joinedUrls));
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (Exception e) {
            Log.e(TAG, "Error parsing configured fallback URLs", e);
            return new URL[0];
        }
    }

    private CaptivePortalProbeSpec[] makeCaptivePortalFallbackProbeSpecs() {
        try {
            String settingsValue = this.mSettings.getSetting(this.mContext, "captive_portal_fallback_probe_specs", null);
            if (TextUtils.isEmpty(settingsValue)) {
                return null;
            }
            return CaptivePortalProbeSpec.parseCaptivePortalProbeSpecs(settingsValue);
        }
        catch (Exception e) {
            Log.e(TAG, "Error parsing configured fallback probe specs", e);
            return null;
        }
    }

    private String getCaptivePortalUserAgent() {
        return this.mSettings.getSetting(this.mContext, "captive_portal_user_agent", DEFAULT_USER_AGENT);
    }

    private URL nextFallbackUrl() {
        if (this.mCaptivePortalFallbackUrls.length == 0) {
            return null;
        }
        int idx = Math.abs(this.mNextFallbackUrlIndex) % this.mCaptivePortalFallbackUrls.length;
        this.mNextFallbackUrlIndex += new Random().nextInt();
        return this.mCaptivePortalFallbackUrls[idx];
    }

    private CaptivePortalProbeSpec nextFallbackSpec() {
        if (ArrayUtils.isEmpty(this.mCaptivePortalFallbackSpecs)) {
            return null;
        }
        int idx = Math.abs(new Random().nextInt()) % this.mCaptivePortalFallbackSpecs.length;
        return this.mCaptivePortalFallbackSpecs[idx];
    }

    @VisibleForTesting
    protected CaptivePortalProbeResult isCaptivePortal() {
        if (!this.mIsCaptivePortalCheckEnabled) {
            this.validationLog("Validation disabled.");
            return CaptivePortalProbeResult.SUCCESS;
        }
        URL pacUrl = null;
        URL httpsUrl = this.mCaptivePortalHttpsUrl;
        URL httpUrl = this.mCaptivePortalHttpUrl;
        ProxyInfo proxyInfo = this.mNetworkAgentInfo.linkProperties.getHttpProxy();
        if (proxyInfo != null && !Uri.EMPTY.equals(proxyInfo.getPacFileUrl()) && (pacUrl = this.makeURL(proxyInfo.getPacFileUrl().toString())) == null) {
            return CaptivePortalProbeResult.FAILED;
        }
        if (pacUrl == null && (httpUrl == null || httpsUrl == null)) {
            return CaptivePortalProbeResult.FAILED;
        }
        long startTime = SystemClock.elapsedRealtime();
        CaptivePortalProbeResult result = pacUrl != null ? this.sendDnsAndHttpProbes(null, pacUrl, 3) : (this.mUseHttps ? this.sendParallelHttpProbes(proxyInfo, httpsUrl, httpUrl) : this.sendDnsAndHttpProbes(proxyInfo, httpUrl, 1));
        long endTime = SystemClock.elapsedRealtime();
        this.sendNetworkConditionsBroadcast(true, result.isPortal(), startTime, endTime);
        return result;
    }

    private CaptivePortalProbeResult sendDnsAndHttpProbes(ProxyInfo proxy, URL url, int probeType) {
        String host = proxy != null ? proxy.getHost() : url.getHost();
        this.sendDnsProbe(host);
        return this.sendHttpProbe(url, probeType, null);
    }

    private void sendDnsProbe(String host) {
        String connectInfo;
        int result;
        if (TextUtils.isEmpty(host)) {
            return;
        }
        String name = ValidationProbeEvent.getProbeName(0);
        Stopwatch watch = new Stopwatch().start();
        try {
            InetAddress[] addresses = this.mNetwork.getAllByName(host);
            StringBuffer buffer = new StringBuffer();
            for (InetAddress address : addresses) {
                buffer.append(',').append(address.getHostAddress());
            }
            result = 1;
            connectInfo = "OK " + buffer.substring(1);
        }
        catch (UnknownHostException e) {
            result = 0;
            connectInfo = "FAIL";
        }
        long latency = watch.stop();
        this.validationLog(0, host, String.format("%dms %s", latency, connectInfo));
        this.logValidationProbe(latency, 0, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected CaptivePortalProbeResult sendHttpProbe(URL url, int probeType, CaptivePortalProbeSpec probeSpec) {
        HttpURLConnection urlConnection = null;
        int httpResponseCode = 599;
        String redirectUrl = null;
        Stopwatch probeTimer = new Stopwatch().start();
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-190);
        try {
            urlConnection = (HttpURLConnection)this.mNetwork.openConnection(url);
            urlConnection.setInstanceFollowRedirects(probeType == 3);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(false);
            if (this.mCaptivePortalUserAgent != null) {
                urlConnection.setRequestProperty("User-Agent", this.mCaptivePortalUserAgent);
            }
            String requestHeader = urlConnection.getRequestProperties().toString();
            long requestTimestamp = SystemClock.elapsedRealtime();
            httpResponseCode = urlConnection.getResponseCode();
            redirectUrl = urlConnection.getHeaderField("location");
            long responseTimestamp = SystemClock.elapsedRealtime();
            this.validationLog(probeType, url, "time=" + (responseTimestamp - requestTimestamp) + "ms ret=" + httpResponseCode + " request=" + requestHeader + " headers=" + urlConnection.getHeaderFields());
            if (httpResponseCode == 200) {
                if (probeType == 3) {
                    this.validationLog(probeType, url, "PAC fetch 200 response interpreted as 204 response.");
                    httpResponseCode = 204;
                } else if (urlConnection.getContentLengthLong() == 0L) {
                    this.validationLog(probeType, url, "200 response with Content-length=0 interpreted as 204 response.");
                    httpResponseCode = 204;
                } else if (urlConnection.getContentLengthLong() == -1L && urlConnection.getInputStream().read() == -1) {
                    this.validationLog(probeType, url, "Empty 200 response interpreted as 204 response.");
                    httpResponseCode = 204;
                }
            }
        }
        catch (IOException e) {
            this.validationLog(probeType, url, "Probe failed with exception " + e);
            if (httpResponseCode == 599) {
                // empty if block
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            TrafficStats.setThreadStatsTag(oldTag);
        }
        this.logValidationProbe(probeTimer.stop(), probeType, httpResponseCode);
        if (probeSpec == null) {
            return new CaptivePortalProbeResult(httpResponseCode, redirectUrl, url.toString());
        }
        return probeSpec.getResult(httpResponseCode, redirectUrl);
    }

    private CaptivePortalProbeResult sendParallelHttpProbes(final ProxyInfo proxy, final URL httpsUrl, final URL httpUrl) {
        CaptivePortalProbeResult result;
        URL fallbackUrl;
        final CountDownLatch latch = new CountDownLatch(2);
        final class ProbeThread
        extends Thread {
            private final boolean mIsHttps;
            private volatile CaptivePortalProbeResult mResult = CaptivePortalProbeResult.FAILED;

            public ProbeThread(boolean isHttps) {
                this.mIsHttps = isHttps;
            }

            public CaptivePortalProbeResult result() {
                return this.mResult;
            }

            @Override
            public void run() {
                this.mResult = this.mIsHttps ? NetworkMonitor.this.sendDnsAndHttpProbes(proxy, httpsUrl, 2) : NetworkMonitor.this.sendDnsAndHttpProbes(proxy, httpUrl, 1);
                if (this.mIsHttps && this.mResult.isSuccessful() || !this.mIsHttps && this.mResult.isPortal()) {
                    while (latch.getCount() > 0L) {
                        latch.countDown();
                    }
                }
                latch.countDown();
            }
        }
        ProbeThread httpsProbe = new ProbeThread(true);
        ProbeThread httpProbe = new ProbeThread(false);
        try {
            httpsProbe.start();
            httpProbe.start();
            latch.await(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.validationLog("Error: probes wait interrupted!");
            return CaptivePortalProbeResult.FAILED;
        }
        CaptivePortalProbeResult httpsResult = httpsProbe.result();
        CaptivePortalProbeResult httpResult = httpProbe.result();
        if (httpResult.isPortal()) {
            return httpResult;
        }
        if (httpsResult.isPortal() || httpsResult.isSuccessful()) {
            return httpsResult;
        }
        CaptivePortalProbeSpec probeSpec = this.nextFallbackSpec();
        URL uRL = fallbackUrl = probeSpec != null ? probeSpec.getUrl() : this.nextFallbackUrl();
        if (fallbackUrl != null && (result = this.sendHttpProbe(fallbackUrl, 4, probeSpec)).isPortal()) {
            return result;
        }
        try {
            httpProbe.join();
            if (httpProbe.result().isPortal()) {
                return httpProbe.result();
            }
            httpsProbe.join();
            return httpsProbe.result();
        }
        catch (InterruptedException e) {
            this.validationLog("Error: http or https probe wait interrupted!");
            return CaptivePortalProbeResult.FAILED;
        }
    }

    private URL makeURL(String url) {
        if (url != null) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                this.validationLog("Bad URL: " + url);
            }
        }
        return null;
    }

    private void sendNetworkConditionsBroadcast(boolean responseReceived, boolean isCaptivePortal, long requestTimestampMs, long responseTimestampMs) {
        if (this.getWifiScansAlwaysAvailableDisabled()) {
            return;
        }
        if (!this.systemReady) {
            return;
        }
        Intent latencyBroadcast = new Intent("android.net.conn.NETWORK_CONDITIONS_MEASURED");
        switch (this.mNetworkAgentInfo.networkInfo.getType()) {
            case 1: {
                WifiInfo currentWifiInfo = this.mWifiManager.getConnectionInfo();
                if (currentWifiInfo != null) {
                    latencyBroadcast.putExtra("extra_ssid", currentWifiInfo.getSSID());
                    latencyBroadcast.putExtra("extra_bssid", currentWifiInfo.getBSSID());
                    break;
                }
                return;
            }
            case 0: {
                latencyBroadcast.putExtra("extra_network_type", this.mTelephonyManager.getNetworkType());
                List<CellInfo> info = this.mTelephonyManager.getAllCellInfo();
                if (info == null) {
                    return;
                }
                int numRegisteredCellInfo = 0;
                for (CellInfo cellInfo : info) {
                    CellIdentity cellId;
                    if (!cellInfo.isRegistered()) continue;
                    if (++numRegisteredCellInfo > 1) {
                        return;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        cellId = ((CellInfoCdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra("extra_cellid", cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoGsm) {
                        cellId = ((CellInfoGsm)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra("extra_cellid", cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        cellId = ((CellInfoLte)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra("extra_cellid", cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoWcdma) {
                        cellId = ((CellInfoWcdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra("extra_cellid", cellId);
                        continue;
                    }
                    return;
                }
                break;
            }
            default: {
                return;
            }
        }
        latencyBroadcast.putExtra("extra_connectivity_type", this.mNetworkAgentInfo.networkInfo.getType());
        latencyBroadcast.putExtra("extra_response_received", responseReceived);
        latencyBroadcast.putExtra("extra_request_timestamp_ms", requestTimestampMs);
        if (responseReceived) {
            latencyBroadcast.putExtra("extra_is_captive_portal", isCaptivePortal);
            latencyBroadcast.putExtra("extra_response_timestamp_ms", responseTimestampMs);
        }
        this.mContext.sendBroadcastAsUser(latencyBroadcast, UserHandle.CURRENT, "android.permission.ACCESS_NETWORK_CONDITIONS");
    }

    private void logNetworkEvent(int evtype) {
        int[] transports = this.mNetworkAgentInfo.networkCapabilities.getTransportTypes();
        this.mMetricsLog.log(this.mNetId, transports, new NetworkEvent(evtype));
    }

    private int networkEventType(ValidationStage s, EvaluationResult r) {
        if (s.isFirstValidation) {
            if (r.isValidated) {
                return 8;
            }
            return 10;
        }
        if (r.isValidated) {
            return 9;
        }
        return 11;
    }

    private void maybeLogEvaluationResult(int evtype) {
        if (this.mEvaluationTimer.isRunning()) {
            int[] transports = this.mNetworkAgentInfo.networkCapabilities.getTransportTypes();
            this.mMetricsLog.log(this.mNetId, transports, new NetworkEvent(evtype, this.mEvaluationTimer.stop()));
            this.mEvaluationTimer.reset();
        }
    }

    private void logValidationProbe(long durationMs, int probeType, int probeResult) {
        int[] transports = this.mNetworkAgentInfo.networkCapabilities.getTransportTypes();
        boolean isFirstValidation = this.validationStage().isFirstValidation;
        ValidationProbeEvent ev = new ValidationProbeEvent();
        ev.probeType = ValidationProbeEvent.makeProbeType(probeType, isFirstValidation);
        ev.returnCode = probeResult;
        ev.durationMs = durationMs;
        this.mMetricsLog.log(this.mNetId, transports, ev);
    }

    @VisibleForTesting
    public static class DefaultNetworkMonitorSettings
    implements NetworkMonitorSettings {
        @Override
        public int getSetting(Context context, String symbol, int defaultValue) {
            return Settings.Global.getInt(context.getContentResolver(), symbol, defaultValue);
        }

        @Override
        public String getSetting(Context context, String symbol, String defaultValue) {
            String value = Settings.Global.getString(context.getContentResolver(), symbol);
            return value != null ? value : defaultValue;
        }
    }

    @VisibleForTesting
    public static interface NetworkMonitorSettings {
        public static final NetworkMonitorSettings DEFAULT = new DefaultNetworkMonitorSettings();

        public int getSetting(Context var1, String var2, int var3);

        public String getSetting(Context var1, String var2, String var3);
    }

    private static class OneAddressPerFamilyNetwork
    extends Network {
        public OneAddressPerFamilyNetwork(Network network) {
            super(network);
        }

        @Override
        public InetAddress[] getAllByName(String host) throws UnknownHostException {
            List<InetAddress> addrs = Arrays.asList(ResolvUtil.blockingResolveAllLocally(this, host));
            LinkedHashMap addressByFamily = new LinkedHashMap();
            addressByFamily.put(addrs.get(0).getClass(), addrs.get(0));
            Collections.shuffle(addrs);
            for (InetAddress addr : addrs) {
                addressByFamily.put(addr.getClass(), addr);
            }
            return addressByFamily.values().toArray(new InetAddress[addressByFamily.size()]);
        }
    }

    private class EvaluatingPrivateDnsState
    extends State {
        private int mPrivateDnsReevalDelayMs;
        private DnsManager.PrivateDnsConfig mPrivateDnsConfig;

        private EvaluatingPrivateDnsState() {
        }

        @Override
        public void enter() {
            this.mPrivateDnsReevalDelayMs = 1000;
            this.mPrivateDnsConfig = null;
            NetworkMonitor.this.sendMessage(532495);
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 532495: {
                    if (this.inStrictMode()) {
                        if (!this.isStrictModeHostnameResolved()) {
                            this.resolveStrictModeHostname();
                            if (this.isStrictModeHostnameResolved()) {
                                this.notifyPrivateDnsConfigResolved();
                            } else {
                                this.handlePrivateDnsEvaluationFailure();
                                break;
                            }
                        }
                        if (!this.sendPrivateDnsProbe()) {
                            this.handlePrivateDnsEvaluationFailure();
                            break;
                        }
                    }
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private boolean inStrictMode() {
            return !TextUtils.isEmpty(NetworkMonitor.this.mPrivateDnsProviderHostname);
        }

        private boolean isStrictModeHostnameResolved() {
            return this.mPrivateDnsConfig != null && this.mPrivateDnsConfig.hostname.equals(NetworkMonitor.this.mPrivateDnsProviderHostname) && this.mPrivateDnsConfig.ips.length > 0;
        }

        private void resolveStrictModeHostname() {
            try {
                InetAddress[] ips = ResolvUtil.blockingResolveAllLocally(NetworkMonitor.this.mNetwork, NetworkMonitor.this.mPrivateDnsProviderHostname, 0);
                this.mPrivateDnsConfig = new DnsManager.PrivateDnsConfig(NetworkMonitor.this.mPrivateDnsProviderHostname, ips);
            }
            catch (UnknownHostException uhe) {
                this.mPrivateDnsConfig = null;
            }
        }

        private void notifyPrivateDnsConfigResolved() {
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532494, 0, NetworkMonitor.this.mNetId, this.mPrivateDnsConfig));
        }

        private void handlePrivateDnsEvaluationFailure() {
            NetworkMonitor.this.notifyNetworkTestResultInvalid(null);
            NetworkMonitor.this.sendMessageDelayed(532495, (long)this.mPrivateDnsReevalDelayMs);
            this.mPrivateDnsReevalDelayMs *= 2;
            if (this.mPrivateDnsReevalDelayMs > 600000) {
                this.mPrivateDnsReevalDelayMs = 600000;
            }
        }

        private boolean sendPrivateDnsProbe() {
            String ONE_TIME_HOSTNAME_SUFFIX = "-dnsotls-ds.metric.gstatic.com";
            String host = UUID.randomUUID().toString().substring(0, 8) + "-dnsotls-ds.metric.gstatic.com";
            try {
                InetAddress[] ips = NetworkMonitor.this.mNetworkAgentInfo.network().getAllByName(host);
                return ips != null && ips.length > 0;
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
    }

    private class CaptivePortalState
    extends State {
        private static final String ACTION_LAUNCH_CAPTIVE_PORTAL_APP = "android.net.netmon.launchCaptivePortalApp";

        private CaptivePortalState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.maybeLogEvaluationResult(NetworkMonitor.this.networkEventType(NetworkMonitor.this.validationStage(), EvaluationResult.CAPTIVE_PORTAL));
            if (NetworkMonitor.this.mDontDisplaySigninNotification) {
                return;
            }
            if (NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver == null) {
                NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver = new CustomIntentReceiver(ACTION_LAUNCH_CAPTIVE_PORTAL_APP, new Random().nextInt(), 532491);
            }
            Message message = NetworkMonitor.this.obtainMessage(532490, 1, NetworkMonitor.this.mNetId, NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver.getPendingIntent());
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
            NetworkMonitor.this.sendMessageDelayed(532492, 0, 600000L);
            NetworkMonitor.this.mValidations++;
        }

        @Override
        public void exit() {
            NetworkMonitor.this.removeMessages(532492);
        }
    }

    private class CustomIntentReceiver
    extends BroadcastReceiver {
        private final int mToken;
        private final int mWhat;
        private final String mAction;

        CustomIntentReceiver(String action, int token, int what) {
            this.mToken = token;
            this.mWhat = what;
            this.mAction = action + "_" + NetworkMonitor.this.mNetId + "_" + token;
            NetworkMonitor.this.mContext.registerReceiver(this, new IntentFilter(this.mAction));
        }

        public PendingIntent getPendingIntent() {
            Intent intent = new Intent(this.mAction);
            intent.setPackage(NetworkMonitor.this.mContext.getPackageName());
            return PendingIntent.getBroadcast(NetworkMonitor.this.mContext, 0, intent, 0);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(this.mAction)) {
                NetworkMonitor.this.sendMessage(NetworkMonitor.this.obtainMessage(this.mWhat, this.mToken));
            }
        }
    }

    private class EvaluatingState
    extends State {
        private int mReevaluateDelayMs;
        private int mAttempts;

        private EvaluatingState() {
        }

        @Override
        public void enter() {
            if (!NetworkMonitor.this.mEvaluationTimer.isStarted()) {
                NetworkMonitor.this.mEvaluationTimer.start();
            }
            NetworkMonitor.this.sendMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
            if (NetworkMonitor.this.mUidResponsibleForReeval != -1) {
                TrafficStats.setThreadStatsUid(NetworkMonitor.this.mUidResponsibleForReeval);
                NetworkMonitor.this.mUidResponsibleForReeval = -1;
            }
            this.mReevaluateDelayMs = 1000;
            this.mAttempts = 0;
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532486: {
                    if (message.arg1 != NetworkMonitor.this.mReevaluateToken || NetworkMonitor.this.mUserDoesNotWant) {
                        return true;
                    }
                    if (!NetworkMonitor.this.isValidationRequired()) {
                        NetworkMonitor.this.validationLog("Network would not satisfy default request, not validating");
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                        return true;
                    }
                    ++this.mAttempts;
                    CaptivePortalProbeResult probeResult = NetworkMonitor.this.isCaptivePortal();
                    if (probeResult.isSuccessful()) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingPrivateDnsState);
                    } else if (probeResult.isPortal()) {
                        NetworkMonitor.this.notifyNetworkTestResultInvalid(probeResult.redirectUrl);
                        NetworkMonitor.this.mLastPortalProbeResult = probeResult;
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mCaptivePortalState);
                    } else {
                        Message msg = NetworkMonitor.this.obtainMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
                        NetworkMonitor.this.sendMessageDelayed(msg, (long)this.mReevaluateDelayMs);
                        NetworkMonitor.this.logNetworkEvent(3);
                        NetworkMonitor.this.notifyNetworkTestResultInvalid(probeResult.redirectUrl);
                        if (this.mAttempts >= 5) {
                            TrafficStats.clearThreadStatsUid();
                        }
                        this.mReevaluateDelayMs *= 2;
                        if (this.mReevaluateDelayMs > 600000) {
                            this.mReevaluateDelayMs = 600000;
                        }
                    }
                    return true;
                }
                case 532488: {
                    return this.mAttempts < 5;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            TrafficStats.clearThreadStatsUid();
        }
    }

    private class MaybeNotifyState
    extends State {
        private MaybeNotifyState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532491: {
                    Intent intent = new Intent("android.net.conn.CAPTIVE_PORTAL");
                    intent.putExtra("android.net.extra.NETWORK", new Network(NetworkMonitor.this.mNetwork));
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL", new CaptivePortal(new ICaptivePortal.Stub(){

                        @Override
                        public void appResponse(int response) {
                            if (response == 2) {
                                NetworkMonitor.this.mContext.enforceCallingPermission("android.permission.CONNECTIVITY_INTERNAL", "CaptivePortal");
                            }
                            NetworkMonitor.this.sendMessage(532489, response);
                        }
                    }));
                    CaptivePortalProbeResult probeRes = NetworkMonitor.this.mLastPortalProbeResult;
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL_URL", probeRes.detectUrl);
                    if (probeRes.probeSpec != null) {
                        String encodedSpec = probeRes.probeSpec.getEncodedSpec();
                        intent.putExtra("android.net.extra.CAPTIVE_PORTAL_PROBE_SPEC", encodedSpec);
                    }
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL_USER_AGENT", NetworkMonitor.this.mCaptivePortalUserAgent);
                    intent.setFlags(0x10400000);
                    NetworkMonitor.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            Message message = NetworkMonitor.this.obtainMessage(532490, 0, NetworkMonitor.this.mNetId, null);
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
        }
    }

    private class ValidatedState
    extends State {
        private ValidatedState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.maybeLogEvaluationResult(NetworkMonitor.this.networkEventType(NetworkMonitor.this.validationStage(), EvaluationResult.VALIDATED));
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 0, NetworkMonitor.this.mNetId, null));
            NetworkMonitor.this.mValidations++;
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    break;
                }
                case 532495: {
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingPrivateDnsState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.logNetworkEvent(1);
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
                case 532487: {
                    NetworkMonitor.this.logNetworkEvent(7);
                    if (NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver != null) {
                        NetworkMonitor.this.mContext.unregisterReceiver(NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver);
                        NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver = null;
                    }
                    NetworkMonitor.this.quit();
                    return true;
                }
                case 532488: 
                case 532492: {
                    NetworkMonitor.this.log("Forcing reevaluation for UID " + message.arg1);
                    NetworkMonitor.this.mUidResponsibleForReeval = message.arg1;
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
                case 532489: {
                    NetworkMonitor.this.log("CaptivePortal App responded with " + message.arg1);
                    NetworkMonitor.this.mUseHttps = false;
                    switch (message.arg1) {
                        case 0: {
                            NetworkMonitor.this.sendMessage(532488, 0, 0);
                            break;
                        }
                        case 2: {
                            NetworkMonitor.this.mDontDisplaySigninNotification = true;
                            NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingPrivateDnsState);
                            break;
                        }
                        case 1: {
                            NetworkMonitor.this.mDontDisplaySigninNotification = true;
                            NetworkMonitor.this.mUserDoesNotWant = true;
                            NetworkMonitor.this.notifyNetworkTestResultInvalid(null);
                            NetworkMonitor.this.mUidResponsibleForReeval = 0;
                            NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                        }
                    }
                    return true;
                }
                case 532493: {
                    DnsManager.PrivateDnsConfig cfg = (DnsManager.PrivateDnsConfig)message.obj;
                    if (!NetworkMonitor.this.isValidationRequired() || cfg == null || !cfg.inStrictMode()) {
                        NetworkMonitor.this.mPrivateDnsProviderHostname = "";
                        break;
                    }
                    NetworkMonitor.this.mPrivateDnsProviderHostname = cfg.hostname;
                    NetworkMonitor.this.sendMessage(532495);
                    break;
                }
            }
            return true;
        }
    }

    static enum ValidationStage {
        FIRST_VALIDATION(true),
        REVALIDATION(false);

        final boolean isFirstValidation;

        private ValidationStage(boolean isFirstValidation) {
            this.isFirstValidation = isFirstValidation;
        }
    }

    static enum EvaluationResult {
        VALIDATED(true),
        CAPTIVE_PORTAL(false);

        final boolean isValidated;

        private EvaluationResult(boolean isValidated) {
            this.isValidated = isValidated;
        }
    }
}

