/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.util.VersionedBroadcastListener;
import android.os.Handler;
import android.util.Log;
import java.util.function.Consumer;

public class SimChangeListener
extends VersionedBroadcastListener {
    private static final String TAG = SimChangeListener.class.getSimpleName();
    private static final boolean DBG = false;

    public SimChangeListener(Context ctx, Handler handler, Runnable onSimCardLoadedCallback) {
        super(TAG, ctx, handler, SimChangeListener.makeIntentFilter(), SimChangeListener.makeCallback(onSimCardLoadedCallback));
    }

    private static IntentFilter makeIntentFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        return filter;
    }

    private static Consumer<Intent> makeCallback(final Runnable onSimCardLoadedCallback) {
        return new Consumer<Intent>(){
            private boolean mSimNotLoadedSeen = false;

            @Override
            public void accept(Intent intent) {
                String state = intent.getStringExtra("ss");
                Log.d(TAG, "got Sim changed to state " + state + ", mSimNotLoadedSeen=" + this.mSimNotLoadedSeen);
                if (!"LOADED".equals(state)) {
                    this.mSimNotLoadedSeen = true;
                    return;
                }
                if (this.mSimNotLoadedSeen) {
                    this.mSimNotLoadedSeen = false;
                    onSimCardLoadedCallback.run();
                }
            }
        };
    }
}

