/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.content.Context;
import android.database.ContentObserver;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.internal.os.BackgroundThread;
import java.io.PrintWriter;

public class SyncManagerConstants
extends ContentObserver {
    private static final String TAG = "SyncManagerConfig";
    private final Object mLock = new Object();
    private final Context mContext;
    private static final String KEY_INITIAL_SYNC_RETRY_TIME_IN_SECONDS = "initial_sync_retry_time_in_seconds";
    private static final int DEF_INITIAL_SYNC_RETRY_TIME_IN_SECONDS = 30;
    private int mInitialSyncRetryTimeInSeconds = 30;
    private static final String KEY_RETRY_TIME_INCREASE_FACTOR = "retry_time_increase_factor";
    private static final float DEF_RETRY_TIME_INCREASE_FACTOR = 2.0f;
    private float mRetryTimeIncreaseFactor = 2.0f;
    private static final String KEY_MAX_SYNC_RETRY_TIME_IN_SECONDS = "max_sync_retry_time_in_seconds";
    private static final int DEF_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600;
    private int mMaxSyncRetryTimeInSeconds = 3600;
    private static final String KEY_MAX_RETRIES_WITH_APP_STANDBY_EXEMPTION = "max_retries_with_app_standby_exemption";
    private static final int DEF_MAX_RETRIES_WITH_APP_STANDBY_EXEMPTION = 5;
    private int mMaxRetriesWithAppStandbyExemption = 5;
    private static final String KEY_EXEMPTION_TEMP_WHITELIST_DURATION_IN_SECONDS = "exemption_temp_whitelist_duration_in_seconds";
    private static final int DEF_EXEMPTION_TEMP_WHITELIST_DURATION_IN_SECONDS = 600;
    private int mKeyExemptionTempWhitelistDurationInSeconds = 600;

    protected SyncManagerConstants(Context context) {
        super(null);
        this.mContext = context;
    }

    public void start() {
        BackgroundThread.getHandler().post(() -> {
            this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("sync_manager_constants"), false, this);
            this.refresh();
        });
    }

    @Override
    public void onChange(boolean selfChange) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Object object = this.mLock;
        synchronized (object) {
            String newValue = Settings.Global.getString(this.mContext.getContentResolver(), "sync_manager_constants");
            KeyValueListParser parser = new KeyValueListParser(',');
            try {
                parser.setString(newValue);
            }
            catch (IllegalArgumentException e) {
                Slog.wtf(TAG, "Bad constants: " + newValue);
            }
            this.mInitialSyncRetryTimeInSeconds = parser.getInt(KEY_INITIAL_SYNC_RETRY_TIME_IN_SECONDS, 30);
            this.mMaxSyncRetryTimeInSeconds = parser.getInt(KEY_MAX_SYNC_RETRY_TIME_IN_SECONDS, 3600);
            this.mRetryTimeIncreaseFactor = parser.getFloat(KEY_RETRY_TIME_INCREASE_FACTOR, 2.0f);
            this.mMaxRetriesWithAppStandbyExemption = parser.getInt(KEY_MAX_RETRIES_WITH_APP_STANDBY_EXEMPTION, 5);
            this.mKeyExemptionTempWhitelistDurationInSeconds = parser.getInt(KEY_EXEMPTION_TEMP_WHITELIST_DURATION_IN_SECONDS, 600);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInitialSyncRetryTimeInSeconds() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInitialSyncRetryTimeInSeconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRetryTimeIncreaseFactor() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRetryTimeIncreaseFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSyncRetryTimeInSeconds() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxSyncRetryTimeInSeconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRetriesWithAppStandbyExemption() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxRetriesWithAppStandbyExemption;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyExemptionTempWhitelistDurationInSeconds() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mKeyExemptionTempWhitelistDurationInSeconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.println("SyncManager Config:");
            pw.print(prefix);
            pw.print("  mInitialSyncRetryTimeInSeconds=");
            pw.println(this.mInitialSyncRetryTimeInSeconds);
            pw.print(prefix);
            pw.print("  mRetryTimeIncreaseFactor=");
            pw.println(this.mRetryTimeIncreaseFactor);
            pw.print(prefix);
            pw.print("  mMaxSyncRetryTimeInSeconds=");
            pw.println(this.mMaxSyncRetryTimeInSeconds);
            pw.print(prefix);
            pw.print("  mMaxRetriesWithAppStandbyExemption=");
            pw.println(this.mMaxRetriesWithAppStandbyExemption);
            pw.print(prefix);
            pw.print("  mKeyExemptionTempWhitelistDurationInSeconds=");
            pw.println(this.mKeyExemptionTempWhitelistDurationInSeconds);
        }
    }
}

