/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.security.Credentials;
import android.security.KeyChain;
import android.util.Log;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

public class CertificateMonitor {
    protected static final String LOG_TAG = "DevicePolicyManager";
    protected static final int MONITORING_CERT_NOTIFICATION_ID = 33;
    private final DevicePolicyManagerService mService;
    private final DevicePolicyManagerService.Injector mInjector;
    private final Handler mHandler;
    private final BroadcastReceiver mRootCaReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (StorageManager.inCryptKeeperBounce()) {
                return;
            }
            int userId = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            CertificateMonitor.this.updateInstalledCertificates(UserHandle.of(userId));
        }
    };

    public CertificateMonitor(DevicePolicyManagerService service, DevicePolicyManagerService.Injector injector, Handler handler) {
        this.mService = service;
        this.mInjector = injector;
        this.mHandler = handler;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.addAction("android.security.action.TRUST_STORE_CHANGED");
        filter.setPriority(1000);
        this.mInjector.mContext.registerReceiverAsUser(this.mRootCaReceiver, UserHandle.ALL, filter, null, this.mHandler);
    }

    public String installCaCert(UserHandle userHandle, byte[] certBuffer) {
        block12: {
            String string2;
            block11: {
                byte[] pemCert;
                try {
                    X509Certificate cert = CertificateMonitor.parseCert(certBuffer);
                    pemCert = Credentials.convertToPem(cert);
                }
                catch (IOException | CertificateException ce) {
                    Log.e(LOG_TAG, "Problem converting cert", ce);
                    return null;
                }
                KeyChain.KeyChainConnection keyChainConnection = this.mInjector.keyChainBindAsUser(userHandle);
                Throwable throwable = null;
                try {
                    string2 = keyChainConnection.getService().installCaCertificate(pemCert);
                    if (keyChainConnection == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (keyChainConnection != null) {
                                CertificateMonitor.$closeResource(throwable, keyChainConnection);
                            }
                            throw throwable3;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(LOG_TAG, "installCaCertsToKeyChain(): ", e);
                        break block12;
                    }
                    catch (InterruptedException e1) {
                        Log.w(LOG_TAG, "installCaCertsToKeyChain(): ", e1);
                        Thread.currentThread().interrupt();
                    }
                }
                CertificateMonitor.$closeResource(throwable, keyChainConnection);
            }
            return string2;
        }
        return null;
    }

    public void uninstallCaCerts(UserHandle userHandle, String[] aliases) {
        try (KeyChain.KeyChainConnection keyChainConnection = this.mInjector.keyChainBindAsUser(userHandle);){
            for (int i = 0; i < aliases.length; ++i) {
                keyChainConnection.getService().deleteCaCertificate(aliases[i]);
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "from CaCertUninstaller: ", e);
        }
        catch (InterruptedException ie) {
            Log.w(LOG_TAG, "CaCertUninstaller: ", ie);
            Thread.currentThread().interrupt();
        }
    }

    public List<String> getInstalledCaCertificates(UserHandle userHandle) throws RemoteException, RuntimeException {
        List list;
        block9: {
            KeyChain.KeyChainConnection conn = this.mInjector.keyChainBindAsUser(userHandle);
            Throwable throwable = null;
            try {
                list = conn.getService().getUserCaAliases().getList();
                if (conn == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn != null) {
                            CertificateMonitor.$closeResource(throwable, conn);
                        }
                        throw throwable3;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (AssertionError e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
            CertificateMonitor.$closeResource(throwable, conn);
        }
        return list;
    }

    public void onCertificateApprovalsChanged(int userId) {
        this.mHandler.post(() -> this.updateInstalledCertificates(UserHandle.of(userId)));
    }

    private void updateInstalledCertificates(UserHandle userHandle) {
        List<String> installedCerts;
        if (!this.mInjector.getUserManager().isUserUnlocked(userHandle.getIdentifier())) {
            return;
        }
        try {
            installedCerts = this.getInstalledCaCertificates(userHandle);
        }
        catch (RemoteException | RuntimeException e) {
            Log.e(LOG_TAG, "Could not retrieve certificates from KeyChain service", e);
            return;
        }
        this.mService.onInstalledCertificatesChanged(userHandle, installedCerts);
        int pendingCertificateCount = installedCerts.size() - this.mService.getAcceptedCaCertificates(userHandle).size();
        if (pendingCertificateCount != 0) {
            Notification noti = this.buildNotification(userHandle, pendingCertificateCount);
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 33, noti, userHandle);
        } else {
            this.mInjector.getNotificationManager().cancelAsUser(LOG_TAG, 33, userHandle);
        }
    }

    private Notification buildNotification(UserHandle userHandle, int pendingCertificateCount) {
        int smallIconId;
        String contentText;
        Context userContext;
        try {
            userContext = this.mInjector.createContextAsUser(userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOG_TAG, "Create context as " + userHandle + " failed", e);
            return null;
        }
        Resources resources = this.mInjector.getResources();
        int parentUserId = userHandle.getIdentifier();
        if (this.mService.getProfileOwner(userHandle.getIdentifier()) != null) {
            contentText = resources.getString(17040905, this.mService.getProfileOwnerName(userHandle.getIdentifier()));
            smallIconId = 17303480;
            parentUserId = this.mService.getProfileParentId(userHandle.getIdentifier());
        } else if (this.mService.getDeviceOwnerUserId() == userHandle.getIdentifier()) {
            String ownerName = this.mService.getDeviceOwnerName();
            contentText = resources.getString(17040905, this.mService.getDeviceOwnerName());
            smallIconId = 17303480;
        } else {
            contentText = resources.getString(17040904);
            smallIconId = 17301642;
        }
        Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
        dialogIntent.setFlags(0x10008000);
        dialogIntent.putExtra("android.settings.extra.number_of_certificates", pendingCertificateCount);
        dialogIntent.putExtra("android.intent.extra.USER_ID", userHandle.getIdentifier());
        ActivityInfo targetInfo = dialogIntent.resolveActivityInfo(this.mInjector.getPackageManager(), 0x100000);
        if (targetInfo != null) {
            dialogIntent.setComponent(targetInfo.getComponentName());
        }
        PendingIntent notifyIntent = this.mInjector.pendingIntentGetActivityAsUser(userContext, 0, dialogIntent, 0x8000000, null, UserHandle.of(parentUserId));
        return new Notification.Builder(userContext, SystemNotificationChannels.SECURITY).setSmallIcon(smallIconId).setContentTitle(resources.getQuantityText(18153496, pendingCertificateCount)).setContentText(contentText).setContentIntent(notifyIntent).setShowWhen(false).setColor(17170774).build();
    }

    private static X509Certificate parseCert(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
    }
}

