/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArraySet;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.internal.view.IInputMethodManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class OverlayPackagesProvider {
    protected static final String TAG = "OverlayPackagesProvider";
    private final PackageManager mPm;
    private final IInputMethodManager mIInputMethodManager;
    private final Context mContext;

    public OverlayPackagesProvider(Context context) {
        this(context, OverlayPackagesProvider.getIInputMethodManager());
    }

    @VisibleForTesting
    OverlayPackagesProvider(Context context, IInputMethodManager iInputMethodManager) {
        this.mContext = context;
        this.mPm = Preconditions.checkNotNull(context.getPackageManager());
        this.mIInputMethodManager = Preconditions.checkNotNull(iInputMethodManager);
    }

    public Set<String> getNonRequiredApps(ComponentName admin, int userId, String provisioningAction) {
        Set<String> nonRequiredApps = this.getLaunchableApps(userId);
        nonRequiredApps.removeAll(this.getRequiredApps(provisioningAction, admin.getPackageName()));
        if ("android.app.action.PROVISION_MANAGED_DEVICE".equals(provisioningAction) || "android.app.action.PROVISION_MANAGED_USER".equals(provisioningAction)) {
            nonRequiredApps.removeAll(this.getSystemInputMethods());
        }
        nonRequiredApps.addAll(this.getDisallowedApps(provisioningAction));
        return nonRequiredApps;
    }

    private Set<String> getLaunchableApps(int userId) {
        Intent launcherIntent = new Intent("android.intent.action.MAIN");
        launcherIntent.addCategory("android.intent.category.LAUNCHER");
        List<ResolveInfo> resolveInfos = this.mPm.queryIntentActivitiesAsUser(launcherIntent, 795136, userId);
        ArraySet<String> apps = new ArraySet<String>();
        for (ResolveInfo resolveInfo : resolveInfos) {
            apps.add(resolveInfo.activityInfo.packageName);
        }
        return apps;
    }

    private Set<String> getSystemInputMethods() {
        List<InputMethodInfo> inputMethods;
        try {
            inputMethods = this.mIInputMethodManager.getInputMethodList();
        }
        catch (RemoteException e) {
            return null;
        }
        ArraySet<String> systemInputMethods = new ArraySet<String>();
        for (InputMethodInfo inputMethodInfo : inputMethods) {
            ApplicationInfo applicationInfo = inputMethodInfo.getServiceInfo().applicationInfo;
            if (!applicationInfo.isSystemApp()) continue;
            systemInputMethods.add(inputMethodInfo.getPackageName());
        }
        return systemInputMethods;
    }

    private Set<String> getRequiredApps(String provisioningAction, String dpcPackageName) {
        ArraySet<String> requiredApps = new ArraySet<String>();
        requiredApps.addAll(this.getRequiredAppsSet(provisioningAction));
        requiredApps.addAll(this.getVendorRequiredAppsSet(provisioningAction));
        requiredApps.add(dpcPackageName);
        return requiredApps;
    }

    private Set<String> getDisallowedApps(String provisioningAction) {
        ArraySet<String> disallowedApps = new ArraySet<String>();
        disallowedApps.addAll(this.getDisallowedAppsSet(provisioningAction));
        disallowedApps.addAll(this.getVendorDisallowedAppsSet(provisioningAction));
        return disallowedApps;
    }

    private static IInputMethodManager getIInputMethodManager() {
        IBinder b = ServiceManager.getService("input_method");
        return IInputMethodManager.Stub.asInterface(b);
    }

    private Set<String> getRequiredAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236075;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236074;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236073;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getDisallowedAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236059;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236058;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236057;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getVendorRequiredAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 0x1070077;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236086;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236085;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getVendorDisallowedAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236084;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236083;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236082;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }
}

