/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.AppOpsManagerInternal;
import android.app.admin.SystemUpdateInfo;
import android.app.admin.SystemUpdatePolicy;
import android.content.ComponentName;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.LocalServices;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class Owners {
    private static final String TAG = "DevicePolicyManagerService";
    private static final boolean DEBUG = false;
    private static final String DEVICE_OWNER_XML_LEGACY = "device_owner.xml";
    private static final String DEVICE_OWNER_XML = "device_owner_2.xml";
    private static final String PROFILE_OWNER_XML = "profile_owner.xml";
    private static final String TAG_ROOT = "root";
    private static final String TAG_DEVICE_OWNER = "device-owner";
    private static final String TAG_DEVICE_INITIALIZER = "device-initializer";
    private static final String TAG_SYSTEM_UPDATE_POLICY = "system-update-policy";
    private static final String TAG_FREEZE_PERIOD_RECORD = "freeze-record";
    private static final String TAG_PENDING_OTA_INFO = "pending-ota-info";
    private static final String TAG_PROFILE_OWNER = "profile-owner";
    private static final String TAG_DEVICE_OWNER_CONTEXT = "device-owner-context";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PACKAGE = "package";
    private static final String ATTR_COMPONENT_NAME = "component";
    private static final String ATTR_REMOTE_BUGREPORT_URI = "remoteBugreportUri";
    private static final String ATTR_REMOTE_BUGREPORT_HASH = "remoteBugreportHash";
    private static final String ATTR_USERID = "userId";
    private static final String ATTR_USER_RESTRICTIONS_MIGRATED = "userRestrictionsMigrated";
    private static final String ATTR_FREEZE_RECORD_START = "start";
    private static final String ATTR_FREEZE_RECORD_END = "end";
    private final UserManager mUserManager;
    private final UserManagerInternal mUserManagerInternal;
    private final PackageManagerInternal mPackageManagerInternal;
    private boolean mSystemReady;
    private OwnerInfo mDeviceOwner;
    private int mDeviceOwnerUserId = -10000;
    private final ArrayMap<Integer, OwnerInfo> mProfileOwners = new ArrayMap();
    private SystemUpdatePolicy mSystemUpdatePolicy;
    private LocalDate mSystemUpdateFreezeStart;
    private LocalDate mSystemUpdateFreezeEnd;
    private SystemUpdateInfo mSystemUpdateInfo;
    private final Object mLock = new Object();
    private final Injector mInjector;

    public Owners(UserManager userManager, UserManagerInternal userManagerInternal, PackageManagerInternal packageManagerInternal) {
        this(userManager, userManagerInternal, packageManagerInternal, new Injector());
    }

    @VisibleForTesting
    Owners(UserManager userManager, UserManagerInternal userManagerInternal, PackageManagerInternal packageManagerInternal, Injector injector) {
        this.mUserManager = userManager;
        this.mUserManagerInternal = userManagerInternal;
        this.mPackageManagerInternal = packageManagerInternal;
        this.mInjector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Object object = this.mLock;
        synchronized (object) {
            File legacy = this.getLegacyConfigFile();
            List<UserInfo> users = this.mUserManager.getUsers(true);
            if (this.readLegacyOwnerFileLocked(legacy)) {
                this.writeDeviceOwner();
                Iterator<Object> iterator = this.getProfileOwnerKeys().iterator();
                while (iterator.hasNext()) {
                    int userId = (Integer)iterator.next();
                    this.writeProfileOwner(userId);
                }
                if (!legacy.delete()) {
                    Slog.e(TAG, "Failed to remove the legacy setting file");
                }
            } else {
                new DeviceOwnerReadWriter().readFromFileLocked();
                for (UserInfo ui : users) {
                    new ProfileOwnerReadWriter(ui.id).readFromFileLocked();
                }
            }
            this.mUserManagerInternal.setDeviceManaged(this.hasDeviceOwner());
            for (UserInfo ui : users) {
                this.mUserManagerInternal.setUserManaged(ui.id, this.hasProfileOwner(ui.id));
            }
            if (this.hasDeviceOwner() && this.hasProfileOwner(this.getDeviceOwnerUserId())) {
                Slog.w(TAG, String.format("User %d has both DO and PO, which is not supported", this.getDeviceOwnerUserId()));
            }
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    private void pushToPackageManagerLocked() {
        SparseArray<String> po = new SparseArray<String>();
        for (int i = this.mProfileOwners.size() - 1; i >= 0; --i) {
            po.put(this.mProfileOwners.keyAt(i), this.mProfileOwners.valueAt((int)i).packageName);
        }
        this.mPackageManagerInternal.setDeviceAndProfileOwnerPackages(this.mDeviceOwnerUserId, this.mDeviceOwner != null ? this.mDeviceOwner.packageName : null, po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceOwnerPackageName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null ? this.mDeviceOwner.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDeviceOwnerUserId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwnerUserId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Integer, ComponentName> getDeviceOwnerUserIdAndComponent() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceOwner == null) {
                return null;
            }
            return Pair.create(this.mDeviceOwnerUserId, this.mDeviceOwner.admin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceOwnerName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null ? this.mDeviceOwner.name : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getDeviceOwnerComponent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null ? this.mDeviceOwner.admin : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceOwnerRemoteBugreportUri() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null ? this.mDeviceOwner.remoteBugreportUri : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceOwnerRemoteBugreportHash() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null ? this.mDeviceOwner.remoteBugreportHash : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceOwner(ComponentName admin, String ownerName, int userId) {
        if (userId < 0) {
            Slog.e(TAG, "Invalid user id for device owner user: " + userId);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.setDeviceOwnerWithRestrictionsMigrated(admin, ownerName, userId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceOwnerWithRestrictionsMigrated(ComponentName admin, String ownerName, int userId, boolean userRestrictionsMigrated) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceOwner = new OwnerInfo(ownerName, admin, userRestrictionsMigrated, null, null);
            this.mDeviceOwnerUserId = userId;
            this.mUserManagerInternal.setDeviceManaged(true);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDeviceOwner() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceOwner = null;
            this.mDeviceOwnerUserId = -10000;
            this.mUserManagerInternal.setDeviceManaged(false);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileOwner(ComponentName admin, String ownerName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProfileOwners.put(userId, new OwnerInfo(ownerName, admin, true, null, null));
            this.mUserManagerInternal.setUserManaged(userId, true);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProfileOwner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProfileOwners.remove(userId);
            this.mUserManagerInternal.setUserManaged(userId, false);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferProfileOwner(ComponentName target, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo ownerInfo = this.mProfileOwners.get(userId);
            OwnerInfo newOwnerInfo = new OwnerInfo(target.getPackageName(), target, ownerInfo.userRestrictionsMigrated, ownerInfo.remoteBugreportUri, ownerInfo.remoteBugreportHash);
            this.mProfileOwners.put(userId, newOwnerInfo);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferDeviceOwnership(ComponentName target) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceOwner = new OwnerInfo(null, target, this.mDeviceOwner.userRestrictionsMigrated, this.mDeviceOwner.remoteBugreportUri, this.mDeviceOwner.remoteBugreportHash);
            this.pushToPackageManagerLocked();
            this.pushToAppOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getProfileOwnerComponent(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo profileOwner = this.mProfileOwners.get(userId);
            return profileOwner != null ? profileOwner.admin : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProfileOwnerName(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo profileOwner = this.mProfileOwners.get(userId);
            return profileOwner != null ? profileOwner.name : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProfileOwnerPackage(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo profileOwner = this.mProfileOwners.get(userId);
            return profileOwner != null ? profileOwner.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getProfileOwnerKeys() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProfileOwners.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemUpdatePolicy getSystemUpdatePolicy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSystemUpdatePolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSystemUpdatePolicy(SystemUpdatePolicy systemUpdatePolicy) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemUpdatePolicy = systemUpdatePolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSystemUpdatePolicy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemUpdatePolicy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<LocalDate, LocalDate> getSystemUpdateFreezePeriodRecord() {
        Object object = this.mLock;
        synchronized (object) {
            return new Pair<LocalDate, LocalDate>(this.mSystemUpdateFreezeStart, this.mSystemUpdateFreezeEnd);
        }
    }

    String getSystemUpdateFreezePeriodRecordAsString() {
        StringBuilder freezePeriodRecord = new StringBuilder();
        freezePeriodRecord.append("start: ");
        if (this.mSystemUpdateFreezeStart != null) {
            freezePeriodRecord.append(this.mSystemUpdateFreezeStart.toString());
        } else {
            freezePeriodRecord.append("null");
        }
        freezePeriodRecord.append("; end: ");
        if (this.mSystemUpdateFreezeEnd != null) {
            freezePeriodRecord.append(this.mSystemUpdateFreezeEnd.toString());
        } else {
            freezePeriodRecord.append("null");
        }
        return freezePeriodRecord.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSystemUpdateFreezePeriodRecord(LocalDate start, LocalDate end) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (!Objects.equals(this.mSystemUpdateFreezeStart, start)) {
                this.mSystemUpdateFreezeStart = start;
                changed = true;
            }
            if (!Objects.equals(this.mSystemUpdateFreezeEnd, end)) {
                this.mSystemUpdateFreezeEnd = end;
                changed = true;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDeviceOwner() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeviceOwnerUserId(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null && this.mDeviceOwnerUserId == userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasProfileOwner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getProfileOwnerComponent(userId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDeviceOwnerUserRestrictionsNeedsMigration() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceOwner != null && !this.mDeviceOwner.userRestrictionsMigrated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getProfileOwnerUserRestrictionsNeedsMigration(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo profileOwner = this.mProfileOwners.get(userId);
            return profileOwner != null && !profileOwner.userRestrictionsMigrated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceOwnerUserRestrictionsMigrated() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.userRestrictionsMigrated = true;
            }
            this.writeDeviceOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceOwnerRemoteBugreportUriAndHash(String remoteBugreportUri, String remoteBugreportHash) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.remoteBugreportUri = remoteBugreportUri;
                this.mDeviceOwner.remoteBugreportHash = remoteBugreportHash;
            }
            this.writeDeviceOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileOwnerUserRestrictionsMigrated(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            OwnerInfo profileOwner = this.mProfileOwners.get(userId);
            if (profileOwner != null) {
                profileOwner.userRestrictionsMigrated = true;
            }
            this.writeProfileOwner(userId);
        }
    }

    private boolean readLegacyOwnerFileLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            int type;
            FileInputStream input = new AtomicFile(file).openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(input, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                String tag = parser.getName();
                if (tag.equals(TAG_DEVICE_OWNER)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    String packageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                    this.mDeviceOwner = new OwnerInfo(name, packageName, false, null, null);
                    this.mDeviceOwnerUserId = 0;
                    continue;
                }
                if (tag.equals(TAG_DEVICE_INITIALIZER)) continue;
                if (tag.equals(TAG_PROFILE_OWNER)) {
                    String profileOwnerPackageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                    String profileOwnerName = parser.getAttributeValue(null, ATTR_NAME);
                    String profileOwnerComponentStr = parser.getAttributeValue(null, ATTR_COMPONENT_NAME);
                    int userId = Integer.parseInt(parser.getAttributeValue(null, ATTR_USERID));
                    OwnerInfo profileOwnerInfo = null;
                    if (profileOwnerComponentStr != null) {
                        ComponentName admin = ComponentName.unflattenFromString(profileOwnerComponentStr);
                        if (admin != null) {
                            profileOwnerInfo = new OwnerInfo(profileOwnerName, admin, false, null, null);
                        } else {
                            Slog.e(TAG, "Error parsing device-owner file. Bad component name " + profileOwnerComponentStr);
                        }
                    }
                    if (profileOwnerInfo == null) {
                        profileOwnerInfo = new OwnerInfo(profileOwnerName, profileOwnerPackageName, false, null, null);
                    }
                    this.mProfileOwners.put(userId, profileOwnerInfo);
                    continue;
                }
                if (TAG_SYSTEM_UPDATE_POLICY.equals(tag)) {
                    this.mSystemUpdatePolicy = SystemUpdatePolicy.restoreFromXml(parser);
                    continue;
                }
                throw new XmlPullParserException("Unexpected tag in device owner file: " + tag);
            }
            ((InputStream)input).close();
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Error parsing device-owner file", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDeviceOwner() {
        Object object = this.mLock;
        synchronized (object) {
            new DeviceOwnerReadWriter().writeToFileLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeProfileOwner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            new ProfileOwnerReadWriter(userId).writeToFileLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveSystemUpdateInfo(SystemUpdateInfo newInfo) {
        Object object = this.mLock;
        synchronized (object) {
            if (Objects.equals(newInfo, this.mSystemUpdateInfo)) {
                return false;
            }
            this.mSystemUpdateInfo = newInfo;
            new DeviceOwnerReadWriter().writeToFileLocked();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemUpdateInfo getSystemUpdateInfo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSystemUpdateInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushToAppOpsLocked() {
        if (!this.mSystemReady) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            AppOpsManagerInternal appops;
            int uid;
            SparseIntArray owners = new SparseIntArray();
            if (this.mDeviceOwner != null && (uid = this.mPackageManagerInternal.getPackageUid(this.mDeviceOwner.packageName, 0x422000, this.mDeviceOwnerUserId)) >= 0) {
                owners.put(this.mDeviceOwnerUserId, uid);
            }
            if (this.mProfileOwners != null) {
                for (int poi = this.mProfileOwners.size() - 1; poi >= 0; --poi) {
                    int uid2 = this.mPackageManagerInternal.getPackageUid(this.mProfileOwners.valueAt((int)poi).packageName, 0x422000, this.mProfileOwners.keyAt(poi));
                    if (uid2 < 0) continue;
                    owners.put(this.mProfileOwners.keyAt(poi), uid2);
                }
            }
            if ((appops = LocalServices.getService(AppOpsManagerInternal.class)) != null) {
                appops.setDeviceAndProfileOwners(owners.size() > 0 ? owners : null);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.pushToAppOpsLocked();
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        boolean needBlank = false;
        if (this.mDeviceOwner != null) {
            pw.println(prefix + "Device Owner: ");
            this.mDeviceOwner.dump(prefix + "  ", pw);
            pw.println(prefix + "  User ID: " + this.mDeviceOwnerUserId);
            needBlank = true;
        }
        if (this.mSystemUpdatePolicy != null) {
            if (needBlank) {
                pw.println();
            }
            pw.println(prefix + "System Update Policy: " + this.mSystemUpdatePolicy);
            needBlank = true;
        }
        if (this.mProfileOwners != null) {
            for (Map.Entry<Integer, OwnerInfo> entry : this.mProfileOwners.entrySet()) {
                if (needBlank) {
                    pw.println();
                }
                pw.println(prefix + "Profile Owner (User " + entry.getKey() + "): ");
                entry.getValue().dump(prefix + "  ", pw);
                needBlank = true;
            }
        }
        if (this.mSystemUpdateInfo != null) {
            if (needBlank) {
                pw.println();
            }
            pw.println(prefix + "Pending System Update: " + this.mSystemUpdateInfo);
            needBlank = true;
        }
        if (this.mSystemUpdateFreezeStart != null || this.mSystemUpdateFreezeEnd != null) {
            if (needBlank) {
                pw.println();
            }
            pw.println(prefix + "System update freeze record: " + this.getSystemUpdateFreezePeriodRecordAsString());
            needBlank = true;
        }
    }

    @VisibleForTesting
    File getLegacyConfigFile() {
        return new File(this.mInjector.environmentGetDataSystemDirectory(), DEVICE_OWNER_XML_LEGACY);
    }

    @VisibleForTesting
    File getDeviceOwnerFile() {
        return new File(this.mInjector.environmentGetDataSystemDirectory(), DEVICE_OWNER_XML);
    }

    @VisibleForTesting
    File getProfileOwnerFile(int userId) {
        return new File(this.mInjector.environmentGetUserSystemDirectory(userId), PROFILE_OWNER_XML);
    }

    @VisibleForTesting
    public static class Injector {
        File environmentGetDataSystemDirectory() {
            return Environment.getDataSystemDirectory();
        }

        File environmentGetUserSystemDirectory(int userId) {
            return Environment.getUserSystemDirectory(userId);
        }
    }

    static class OwnerInfo {
        public final String name;
        public final String packageName;
        public final ComponentName admin;
        public boolean userRestrictionsMigrated;
        public String remoteBugreportUri;
        public String remoteBugreportHash;

        public OwnerInfo(String name, String packageName, boolean userRestrictionsMigrated, String remoteBugreportUri, String remoteBugreportHash) {
            this.name = name;
            this.packageName = packageName;
            this.admin = new ComponentName(packageName, "");
            this.userRestrictionsMigrated = userRestrictionsMigrated;
            this.remoteBugreportUri = remoteBugreportUri;
            this.remoteBugreportHash = remoteBugreportHash;
        }

        public OwnerInfo(String name, ComponentName admin, boolean userRestrictionsMigrated, String remoteBugreportUri, String remoteBugreportHash) {
            this.name = name;
            this.admin = admin;
            this.packageName = admin.getPackageName();
            this.userRestrictionsMigrated = userRestrictionsMigrated;
            this.remoteBugreportUri = remoteBugreportUri;
            this.remoteBugreportHash = remoteBugreportHash;
        }

        public void writeToXml(XmlSerializer out, String tag) throws IOException {
            out.startTag(null, tag);
            out.attribute(null, Owners.ATTR_PACKAGE, this.packageName);
            if (this.name != null) {
                out.attribute(null, Owners.ATTR_NAME, this.name);
            }
            if (this.admin != null) {
                out.attribute(null, Owners.ATTR_COMPONENT_NAME, this.admin.flattenToString());
            }
            out.attribute(null, Owners.ATTR_USER_RESTRICTIONS_MIGRATED, String.valueOf(this.userRestrictionsMigrated));
            if (this.remoteBugreportUri != null) {
                out.attribute(null, Owners.ATTR_REMOTE_BUGREPORT_URI, this.remoteBugreportUri);
            }
            if (this.remoteBugreportHash != null) {
                out.attribute(null, Owners.ATTR_REMOTE_BUGREPORT_HASH, this.remoteBugreportHash);
            }
            out.endTag(null, tag);
        }

        public static OwnerInfo readFromXml(XmlPullParser parser) {
            String packageName = parser.getAttributeValue(null, Owners.ATTR_PACKAGE);
            String name = parser.getAttributeValue(null, Owners.ATTR_NAME);
            String componentName = parser.getAttributeValue(null, Owners.ATTR_COMPONENT_NAME);
            String userRestrictionsMigratedStr = parser.getAttributeValue(null, Owners.ATTR_USER_RESTRICTIONS_MIGRATED);
            boolean userRestrictionsMigrated = "true".equals(userRestrictionsMigratedStr);
            String remoteBugreportUri = parser.getAttributeValue(null, Owners.ATTR_REMOTE_BUGREPORT_URI);
            String remoteBugreportHash = parser.getAttributeValue(null, Owners.ATTR_REMOTE_BUGREPORT_HASH);
            if (componentName != null) {
                ComponentName admin = ComponentName.unflattenFromString(componentName);
                if (admin != null) {
                    return new OwnerInfo(name, admin, userRestrictionsMigrated, remoteBugreportUri, remoteBugreportHash);
                }
                Slog.e(Owners.TAG, "Error parsing owner file. Bad component name " + componentName);
            }
            return new OwnerInfo(name, packageName, userRestrictionsMigrated, remoteBugreportUri, remoteBugreportHash);
        }

        public void dump(String prefix, PrintWriter pw) {
            pw.println(prefix + "admin=" + this.admin);
            pw.println(prefix + "name=" + this.name);
            pw.println(prefix + "package=" + this.packageName);
        }
    }

    private class ProfileOwnerReadWriter
    extends FileReadWriter {
        private final int mUserId;

        ProfileOwnerReadWriter(int userId) {
            super(Owners.this.getProfileOwnerFile(userId));
            this.mUserId = userId;
        }

        @Override
        boolean shouldWrite() {
            return Owners.this.mProfileOwners.get(this.mUserId) != null;
        }

        @Override
        void writeInner(XmlSerializer out) throws IOException {
            OwnerInfo profileOwner = (OwnerInfo)Owners.this.mProfileOwners.get(this.mUserId);
            if (profileOwner != null) {
                profileOwner.writeToXml(out, Owners.TAG_PROFILE_OWNER);
            }
        }

        @Override
        boolean readInner(XmlPullParser parser, int depth, String tag) {
            if (depth > 2) {
                return true;
            }
            switch (tag) {
                case "profile-owner": {
                    Owners.this.mProfileOwners.put(this.mUserId, OwnerInfo.readFromXml(parser));
                    break;
                }
                default: {
                    Slog.e(Owners.TAG, "Unexpected tag: " + tag);
                    return false;
                }
            }
            return true;
        }
    }

    private class DeviceOwnerReadWriter
    extends FileReadWriter {
        protected DeviceOwnerReadWriter() {
            super(Owners.this.getDeviceOwnerFile());
        }

        @Override
        boolean shouldWrite() {
            return Owners.this.mDeviceOwner != null || Owners.this.mSystemUpdatePolicy != null || Owners.this.mSystemUpdateInfo != null;
        }

        @Override
        void writeInner(XmlSerializer out) throws IOException {
            if (Owners.this.mDeviceOwner != null) {
                Owners.this.mDeviceOwner.writeToXml(out, Owners.TAG_DEVICE_OWNER);
                out.startTag(null, Owners.TAG_DEVICE_OWNER_CONTEXT);
                out.attribute(null, Owners.ATTR_USERID, String.valueOf(Owners.this.mDeviceOwnerUserId));
                out.endTag(null, Owners.TAG_DEVICE_OWNER_CONTEXT);
            }
            if (Owners.this.mSystemUpdatePolicy != null) {
                out.startTag(null, Owners.TAG_SYSTEM_UPDATE_POLICY);
                Owners.this.mSystemUpdatePolicy.saveToXml(out);
                out.endTag(null, Owners.TAG_SYSTEM_UPDATE_POLICY);
            }
            if (Owners.this.mSystemUpdateInfo != null) {
                Owners.this.mSystemUpdateInfo.writeToXml(out, Owners.TAG_PENDING_OTA_INFO);
            }
            if (Owners.this.mSystemUpdateFreezeStart != null || Owners.this.mSystemUpdateFreezeEnd != null) {
                out.startTag(null, Owners.TAG_FREEZE_PERIOD_RECORD);
                if (Owners.this.mSystemUpdateFreezeStart != null) {
                    out.attribute(null, Owners.ATTR_FREEZE_RECORD_START, Owners.this.mSystemUpdateFreezeStart.toString());
                }
                if (Owners.this.mSystemUpdateFreezeEnd != null) {
                    out.attribute(null, Owners.ATTR_FREEZE_RECORD_END, Owners.this.mSystemUpdateFreezeEnd.toString());
                }
                out.endTag(null, Owners.TAG_FREEZE_PERIOD_RECORD);
            }
        }

        @Override
        boolean readInner(XmlPullParser parser, int depth, String tag) {
            if (depth > 2) {
                return true;
            }
            switch (tag) {
                case "device-owner": {
                    Owners.this.mDeviceOwner = OwnerInfo.readFromXml(parser);
                    Owners.this.mDeviceOwnerUserId = 0;
                    break;
                }
                case "device-owner-context": {
                    String userIdString = parser.getAttributeValue(null, Owners.ATTR_USERID);
                    try {
                        Owners.this.mDeviceOwnerUserId = Integer.parseInt(userIdString);
                    }
                    catch (NumberFormatException e) {
                        Slog.e(Owners.TAG, "Error parsing user-id " + userIdString);
                    }
                    break;
                }
                case "device-initializer": {
                    break;
                }
                case "system-update-policy": {
                    Owners.this.mSystemUpdatePolicy = SystemUpdatePolicy.restoreFromXml(parser);
                    break;
                }
                case "pending-ota-info": {
                    Owners.this.mSystemUpdateInfo = SystemUpdateInfo.readFromXml(parser);
                    break;
                }
                case "freeze-record": {
                    String startDate = parser.getAttributeValue(null, Owners.ATTR_FREEZE_RECORD_START);
                    String endDate = parser.getAttributeValue(null, Owners.ATTR_FREEZE_RECORD_END);
                    if (startDate == null || endDate == null) break;
                    Owners.this.mSystemUpdateFreezeStart = LocalDate.parse(startDate);
                    Owners.this.mSystemUpdateFreezeEnd = LocalDate.parse(endDate);
                    if (!Owners.this.mSystemUpdateFreezeStart.isAfter(Owners.this.mSystemUpdateFreezeEnd)) break;
                    Slog.e(Owners.TAG, "Invalid system update freeze record loaded");
                    Owners.this.mSystemUpdateFreezeStart = null;
                    Owners.this.mSystemUpdateFreezeEnd = null;
                    break;
                }
                default: {
                    Slog.e(Owners.TAG, "Unexpected tag: " + tag);
                    return false;
                }
            }
            return true;
        }
    }

    private static abstract class FileReadWriter {
        private final File mFile;

        protected FileReadWriter(File file) {
            this.mFile = file;
        }

        abstract boolean shouldWrite();

        void writeToFileLocked() {
            block4: {
                if (!this.shouldWrite()) {
                    if (this.mFile.exists() && !this.mFile.delete()) {
                        Slog.e(Owners.TAG, "Failed to remove " + this.mFile.getPath());
                    }
                    return;
                }
                AtomicFile f = new AtomicFile(this.mFile);
                FileOutputStream outputStream = null;
                try {
                    outputStream = f.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(outputStream, StandardCharsets.UTF_8.name());
                    out.startDocument(null, true);
                    out.startTag(null, Owners.TAG_ROOT);
                    this.writeInner(out);
                    out.endTag(null, Owners.TAG_ROOT);
                    out.endDocument();
                    out.flush();
                    f.finishWrite(outputStream);
                    outputStream = null;
                }
                catch (IOException e) {
                    Slog.e(Owners.TAG, "Exception when writing", e);
                    if (outputStream == null) break block4;
                    f.failWrite(outputStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readFromFileLocked() {
            if (!this.mFile.exists()) {
                return;
            }
            AtomicFile f = new AtomicFile(this.mFile);
            FileInputStream input = null;
            try {
                int type;
                input = f.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(input, StandardCharsets.UTF_8.name());
                int depth = 0;
                block11: while ((type = parser.next()) != 1) {
                    switch (type) {
                        case 2: {
                            break;
                        }
                        case 3: {
                            --depth;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    String tag = parser.getName();
                    if (++depth == 1) {
                        if (Owners.TAG_ROOT.equals(tag)) continue;
                        Slog.e(Owners.TAG, "Invalid root tag: " + tag);
                        return;
                    }
                    if (this.readInner(parser, depth, tag)) continue;
                    return;
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.e(Owners.TAG, "Error parsing owners information file", e);
            }
            finally {
                IoUtils.closeQuietly(input);
            }
        }

        abstract void writeInner(XmlSerializer var1) throws IOException;

        abstract boolean readInner(XmlPullParser var1, int var2, String var3);
    }
}

