/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.UserHandle;
import com.android.internal.notification.SystemNotificationChannels;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class RemoteBugreportUtils {
    static final int NOTIFICATION_ID = 678432343;
    static final long REMOTE_BUGREPORT_TIMEOUT_MILLIS = 600000L;
    static final String CTL_STOP = "ctl.stop";
    static final String REMOTE_BUGREPORT_SERVICE = "bugreportremote";
    static final String BUGREPORT_MIMETYPE = "application/vnd.android.bugreport";

    RemoteBugreportUtils() {
    }

    static Notification buildNotification(Context context, int type) {
        Intent dialogIntent = new Intent("android.settings.SHOW_REMOTE_BUGREPORT_DIALOG");
        dialogIntent.addFlags(0x10008000);
        dialogIntent.putExtra("android.app.extra.bugreport_notification_type", type);
        PendingIntent pendingDialogIntent = PendingIntent.getActivityAsUser(context, type, dialogIntent, 0, null, UserHandle.CURRENT);
        Notification.Builder builder = new Notification.Builder(context, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303450).setOngoing(true).setLocalOnly(true).setContentIntent(pendingDialogIntent).setColor(context.getColor(17170774));
        if (type == 2) {
            builder.setContentTitle(context.getString(17040859)).setProgress(0, 0, true);
        } else if (type == 1) {
            builder.setContentTitle(context.getString(17040963)).setProgress(0, 0, true);
        } else if (type == 3) {
            PendingIntent pendingIntentAccept = PendingIntent.getBroadcast(context, 678432343, new Intent("com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED"), 0x10000000);
            PendingIntent pendingIntentDecline = PendingIntent.getBroadcast(context, 678432343, new Intent("com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED"), 0x10000000);
            builder.addAction(new Notification.Action.Builder(null, (CharSequence)context.getString(17039775), pendingIntentDecline).build()).addAction(new Notification.Action.Builder(null, (CharSequence)context.getString(17040854), pendingIntentAccept).build()).setContentTitle(context.getString(17040856)).setContentText(context.getString(17040855)).setStyle(new Notification.BigTextStyle().bigText(context.getString(17040855)));
        }
        return builder.build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoteBugreportNotificationType {
    }
}

