/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Intent;
import android.os.ShellCommand;
import com.android.server.display.DisplayManagerService;
import java.io.PrintWriter;

class DisplayManagerShellCommand
extends ShellCommand {
    private static final String TAG = "DisplayManagerShellCommand";
    private final DisplayManagerService.BinderService mService;

    DisplayManagerShellCommand(DisplayManagerService.BinderService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        switch (cmd) {
            case "set-brightness": {
                return this.setBrightness();
            }
            case "reset-brightness-configuration": {
                return this.resetBrightnessConfiguration();
            }
        }
        return this.handleDefaultCommands(cmd);
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Display manager commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println();
        pw.println("  set-brightness BRIGHTNESS");
        pw.println("    Sets the current brightness to BRIGHTNESS (a number between 0 and 1).");
        pw.println("  reset-brightness-configuration");
        pw.println("    Reset the brightness to its default configuration.");
        pw.println();
        Intent.printIntentArgsHelp(pw, "");
    }

    private int setBrightness() {
        String brightnessText = this.getNextArg();
        if (brightnessText == null) {
            this.getErrPrintWriter().println("Error: no brightness specified");
            return 1;
        }
        float brightness = -1.0f;
        try {
            brightness = Float.parseFloat(brightnessText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (brightness < 0.0f || brightness > 1.0f) {
            this.getErrPrintWriter().println("Error: brightness should be a number between 0 and 1");
            return 1;
        }
        this.mService.setBrightness((int)brightness * 255);
        return 0;
    }

    private int resetBrightnessConfiguration() {
        this.mService.resetBrightnessConfiguration();
        return 0;
    }
}

