/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.biometrics.IBiometricPromptReceiver;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.fingerprint.ClientMonitor;

public abstract class AuthenticationClient
extends ClientMonitor {
    private long mOpId;
    public static final int LOCKOUT_NONE = 0;
    public static final int LOCKOUT_TIMED = 1;
    public static final int LOCKOUT_PERMANENT = 2;
    private IBiometricPromptReceiver mDialogReceiverFromClient;
    private Bundle mBundle;
    private IStatusBarService mStatusBarService;
    private boolean mInLockout;
    private final FingerprintManager mFingerprintManager;
    protected boolean mDialogDismissed;
    protected IBiometricPromptReceiver mDialogReceiver = new IBiometricPromptReceiver.Stub(){

        @Override
        public void onDialogDismissed(int reason) {
            if (AuthenticationClient.this.mBundle != null && AuthenticationClient.this.mDialogReceiverFromClient != null) {
                try {
                    AuthenticationClient.this.mDialogReceiverFromClient.onDialogDismissed(reason);
                    if (reason == 3) {
                        AuthenticationClient.this.onError(10, 0);
                    }
                    AuthenticationClient.this.mDialogDismissed = true;
                }
                catch (RemoteException e) {
                    Slog.e("FingerprintService", "Unable to notify dialog dismissed", e);
                }
                AuthenticationClient.this.stop(true);
            }
        }
    };

    public abstract int handleFailedAttempt();

    public abstract void resetFailedAttempts();

    public abstract void onStart();

    public abstract void onStop();

    public AuthenticationClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int targetUserId, int groupId, long opId, boolean restricted, String owner, Bundle bundle, IBiometricPromptReceiver dialogReceiver, IStatusBarService statusBarService) {
        super(context, halDeviceId, token, receiver, targetUserId, groupId, restricted, owner);
        this.mOpId = opId;
        this.mBundle = bundle;
        this.mDialogReceiverFromClient = dialogReceiver;
        this.mStatusBarService = statusBarService;
        this.mFingerprintManager = (FingerprintManager)this.getContext().getSystemService("fingerprint");
    }

    @Override
    public void binderDied() {
        super.binderDied();
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onAcquired(int acquiredInfo, int vendorCode) {
        if (this.mBundle != null) {
            try {
                if (acquiredInfo != 0) {
                    this.mStatusBarService.onFingerprintHelp(this.mFingerprintManager.getAcquiredString(acquiredInfo, vendorCode));
                }
                boolean bl = false;
                return bl;
            }
            catch (RemoteException e) {
                Slog.e("FingerprintService", "Remote exception when sending acquired message", e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (acquiredInfo == 0) {
                    this.notifyUserActivity();
                }
            }
        }
        return super.onAcquired(acquiredInfo, vendorCode);
    }

    @Override
    public boolean onError(int error, int vendorCode) {
        if (this.mDialogDismissed) {
            return true;
        }
        if (this.mBundle != null) {
            try {
                this.mStatusBarService.onFingerprintError(this.mFingerprintManager.getErrorString(error, vendorCode));
            }
            catch (RemoteException e) {
                Slog.e("FingerprintService", "Remote exception when sending error", e);
            }
        }
        return super.onError(error, vendorCode);
    }

    @Override
    public boolean onAuthenticated(int fingerId, int groupId) {
        IFingerprintServiceReceiver receiver;
        boolean authenticated;
        boolean result;
        block18: {
            result = false;
            boolean bl = authenticated = fingerId != 0;
            if (this.mBundle != null) {
                try {
                    if (authenticated) {
                        this.mStatusBarService.onFingerprintAuthenticated();
                    } else {
                        this.mStatusBarService.onFingerprintHelp(this.getContext().getResources().getString(17039916));
                    }
                }
                catch (RemoteException e) {
                    Slog.e("FingerprintService", "Failed to notify Authenticated:", e);
                }
            }
            if ((receiver = this.getReceiver()) != null) {
                try {
                    MetricsLogger.action(this.getContext(), 252, authenticated);
                    if (!authenticated) {
                        receiver.onAuthenticationFailed(this.getHalDeviceId());
                        break block18;
                    }
                    Slog.v("FingerprintService", "onAuthenticated(owner=" + this.getOwnerString() + ", id=" + fingerId + ", gp=" + groupId + ")");
                    Fingerprint fp = !this.getIsRestricted() ? new Fingerprint("", groupId, fingerId, this.getHalDeviceId()) : null;
                    receiver.onAuthenticationSucceeded(this.getHalDeviceId(), fp, this.getTargetUserId());
                }
                catch (RemoteException e) {
                    Slog.w("FingerprintService", "Failed to notify Authenticated:", e);
                    result = true;
                }
            } else {
                result = true;
            }
        }
        if (!authenticated) {
            int lockoutMode;
            if (receiver != null) {
                this.vibrateError();
            }
            if ((lockoutMode = this.handleFailedAttempt()) != 0) {
                try {
                    this.mInLockout = true;
                    Slog.w("FingerprintService", "Forcing lockout (fp driver code should do this!), mode(" + lockoutMode + ")");
                    this.stop(false);
                    int errorCode = lockoutMode == 1 ? 7 : 9;
                    receiver.onError(this.getHalDeviceId(), errorCode, 0);
                    if (this.mBundle != null) {
                        this.mStatusBarService.onFingerprintError(this.mFingerprintManager.getErrorString(errorCode, 0));
                    }
                }
                catch (RemoteException e) {
                    Slog.w("FingerprintService", "Failed to notify lockout:", e);
                }
            }
            result |= lockoutMode != 0;
        } else {
            if (receiver != null) {
                this.vibrateSuccess();
            }
            result |= true;
            this.resetFailedAttempts();
            this.onStop();
        }
        return result;
    }

    @Override
    public int start() {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "start authentication: no fingerprint HAL!");
            return 3;
        }
        this.onStart();
        try {
            int result = daemon.authenticate(this.mOpId, this.getGroupId());
            if (result != 0) {
                Slog.w("FingerprintService", "startAuthentication failed, result=" + result);
                MetricsLogger.histogram(this.getContext(), "fingeprintd_auth_start_error", result);
                this.onError(1, 0);
                return result;
            }
            Slog.w("FingerprintService", "client " + this.getOwnerString() + " is authenticating...");
            if (this.mBundle != null) {
                try {
                    this.mStatusBarService.showFingerprintDialog(this.mBundle, this.mDialogReceiver);
                }
                catch (RemoteException e) {
                    Slog.e("FingerprintService", "Unable to show fingerprint dialog", e);
                }
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startAuthentication failed", e);
            return 3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w("FingerprintService", "stopAuthentication: already cancelled!");
            return 0;
        }
        this.onStop();
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "stopAuthentication: no fingerprint HAL!");
            return 3;
        }
        try {
            int result = daemon.cancel();
            if (result != 0) {
                Slog.w("FingerprintService", "stopAuthentication failed, result=" + result);
                int n = result;
                return n;
            }
            Slog.w("FingerprintService", "client " + this.getOwnerString() + " is no longer authenticating");
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "stopAuthentication failed", e);
            int n = 3;
            return n;
        }
        finally {
            if (this.mBundle != null && !this.mDialogDismissed && !this.mInLockout) {
                try {
                    this.mStatusBarService.hideFingerprintDialog();
                }
                catch (RemoteException e) {
                    Slog.e("FingerprintService", "Unable to hide fingerprint dialog", e);
                }
            }
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    @Override
    public boolean onEnrollResult(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onEnrollResult() called for authenticate!");
        return true;
    }

    @Override
    public boolean onRemoved(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onRemoved() called for authenticate!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onEnumerationResult() called for authenticate!");
        return true;
    }
}

