/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.hdmi.HdmiCecMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class HdmiUtils {
    private static final int[] ADDRESS_TO_TYPE = new int[]{0, 1, 1, 3, 4, 5, 3, 3, 4, 1, 3, 4, 2, 2, 0};
    private static final String[] DEFAULT_NAMES = new String[]{"TV", "Recorder_1", "Recorder_2", "Tuner_1", "Playback_1", "AudioSystem", "Tuner_2", "Tuner_3", "Playback_2", "Recorder_3", "Tuner_4", "Playback_3", "Reserved_1", "Reserved_2", "Secondary_TV"};

    private HdmiUtils() {
    }

    static boolean isValidAddress(int address) {
        return 0 <= address && address <= 14;
    }

    static int getTypeFromAddress(int address) {
        if (HdmiUtils.isValidAddress(address)) {
            return ADDRESS_TO_TYPE[address];
        }
        return -1;
    }

    static String getDefaultDeviceName(int address) {
        if (HdmiUtils.isValidAddress(address)) {
            return DEFAULT_NAMES[address];
        }
        return "";
    }

    static void verifyAddressType(int logicalAddress, int deviceType) {
        int actualDeviceType = HdmiUtils.getTypeFromAddress(logicalAddress);
        if (actualDeviceType != deviceType) {
            throw new IllegalArgumentException("Device type missmatch:[Expected:" + deviceType + ", Actual:" + actualDeviceType);
        }
    }

    static boolean checkCommandSource(HdmiCecMessage cmd, int expectedAddress, String tag) {
        int src = cmd.getSource();
        if (src != expectedAddress) {
            Slog.w(tag, "Invalid source [Expected:" + expectedAddress + ", Actual:" + src + "]");
            return false;
        }
        return true;
    }

    static boolean parseCommandParamSystemAudioStatus(HdmiCecMessage cmd) {
        return cmd.getParams()[0] == 1;
    }

    static boolean isAudioStatusMute(HdmiCecMessage cmd) {
        byte[] params = cmd.getParams();
        return (params[0] & 0x80) == 128;
    }

    static int getAudioStatusVolume(HdmiCecMessage cmd) {
        byte[] params = cmd.getParams();
        int volume = params[0] & 0x7F;
        if (volume < 0 || 100 < volume) {
            volume = -1;
        }
        return volume;
    }

    static List<Integer> asImmutableList(int[] is) {
        ArrayList<Integer> list = new ArrayList<Integer>(is.length);
        for (int type : is) {
            list.add(type);
        }
        return Collections.unmodifiableList(list);
    }

    static int twoBytesToInt(byte[] data) {
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    static int twoBytesToInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF;
    }

    static int threeBytesToInt(byte[] data) {
        return (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
    }

    static <T> List<T> sparseArrayToList(SparseArray<T> array2) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < array2.size(); ++i) {
            list.add(array2.valueAt(i));
        }
        return list;
    }

    static <T> List<T> mergeToUnmodifiableList(List<T> a, List<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return Collections.emptyList();
        }
        if (a.isEmpty()) {
            return Collections.unmodifiableList(b);
        }
        if (b.isEmpty()) {
            return Collections.unmodifiableList(a);
        }
        ArrayList<T> newList = new ArrayList<T>();
        newList.addAll(a);
        newList.addAll(b);
        return Collections.unmodifiableList(newList);
    }

    static boolean isAffectingActiveRoutingPath(int activePath, int newPath) {
        for (int i = 0; i <= 12; i += 4) {
            int nibble = newPath >> i & 0xF;
            if (nibble == 0) continue;
            int mask = 65520 << i;
            newPath &= mask;
            break;
        }
        if (newPath == 0) {
            return true;
        }
        return HdmiUtils.isInActiveRoutingPath(activePath, newPath);
    }

    static boolean isInActiveRoutingPath(int activePath, int newPath) {
        int nibbleNew;
        int nibbleActive;
        for (int i = 12; i >= 0 && (nibbleActive = activePath >> i & 0xF) != 0 && (nibbleNew = newPath >> i & 0xF) != 0; i -= 4) {
            if (nibbleActive == nibbleNew) continue;
            return false;
        }
        return true;
    }

    static HdmiDeviceInfo cloneHdmiDeviceInfo(HdmiDeviceInfo info, int newPowerStatus) {
        return new HdmiDeviceInfo(info.getLogicalAddress(), info.getPhysicalAddress(), info.getPortId(), info.getDeviceType(), info.getVendorId(), info.getDisplayName(), newPowerStatus);
    }
}

