/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.hardware.location.ContextHubTransaction;
import android.hardware.location.NanoAppState;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class ContextHubServiceTransaction {
    private final int mTransactionId;
    private final int mTransactionType;
    private boolean mIsComplete = false;

    ContextHubServiceTransaction(int id2, int type) {
        this.mTransactionId = id2;
        this.mTransactionType = type;
    }

    abstract int onTransact();

    void onTransactionComplete(int result) {
    }

    void onQueryResponse(int result, List<NanoAppState> nanoAppStateList) {
    }

    int getTransactionId() {
        return this.mTransactionId;
    }

    int getTransactionType() {
        return this.mTransactionType;
    }

    long getTimeout(TimeUnit unit) {
        switch (this.mTransactionType) {
            case 0: {
                return unit.convert(30L, TimeUnit.SECONDS);
            }
        }
        return unit.convert(5L, TimeUnit.SECONDS);
    }

    void setComplete() {
        this.mIsComplete = true;
    }

    boolean isComplete() {
        return this.mIsComplete;
    }

    public String toString() {
        return ContextHubTransaction.typeToString(this.mTransactionType, true) + " transaction (ID = " + this.mTransactionId + ")";
    }
}

