/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.app.KeyguardManager;
import android.content.Context;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyProtection;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.locksettings.recoverablekeystore.InsecureUserException;
import com.android.server.locksettings.recoverablekeystore.KeyStoreProxy;
import com.android.server.locksettings.recoverablekeystore.KeyStoreProxyImpl;
import com.android.server.locksettings.recoverablekeystore.PlatformDecryptionKey;
import com.android.server.locksettings.recoverablekeystore.PlatformEncryptionKey;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDb;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class PlatformKeyManager {
    private static final String TAG = "PlatformKeyManager";
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_SIZE_BITS = 256;
    private static final String KEY_ALIAS_PREFIX = "com.android.server.locksettings.recoverablekeystore/platform/";
    private static final String ENCRYPT_KEY_ALIAS_SUFFIX = "encrypt";
    private static final String DECRYPT_KEY_ALIAS_SUFFIX = "decrypt";
    private static final int USER_AUTHENTICATION_VALIDITY_DURATION_SECONDS = 15;
    private final Context mContext;
    private final KeyStoreProxy mKeyStore;
    private final RecoverableKeyStoreDb mDatabase;
    private static final String ANDROID_KEY_STORE_PROVIDER = "AndroidKeyStore";

    public static PlatformKeyManager getInstance(Context context, RecoverableKeyStoreDb database) throws KeyStoreException, NoSuchAlgorithmException {
        return new PlatformKeyManager(context.getApplicationContext(), new KeyStoreProxyImpl(PlatformKeyManager.getAndLoadAndroidKeyStore()), database);
    }

    @VisibleForTesting
    PlatformKeyManager(Context context, KeyStoreProxy keyStore, RecoverableKeyStoreDb database) {
        this.mKeyStore = keyStore;
        this.mContext = context;
        this.mDatabase = database;
    }

    public int getGenerationId(int userId) {
        return this.mDatabase.getPlatformKeyGenerationId(userId);
    }

    public boolean isAvailable(int userId) {
        return this.mContext.getSystemService(KeyguardManager.class).isDeviceSecure(userId);
    }

    public void invalidatePlatformKey(int userId, int generationId) {
        if (generationId != -1) {
            try {
                this.mKeyStore.deleteEntry(this.getEncryptAlias(userId, generationId));
                this.mKeyStore.deleteEntry(this.getDecryptAlias(userId, generationId));
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    void regenerate(int userId) throws NoSuchAlgorithmException, KeyStoreException, InsecureUserException, IOException {
        int nextId;
        if (!this.isAvailable(userId)) {
            throw new InsecureUserException(String.format(Locale.US, "%d does not have a lock screen set.", userId));
        }
        int generationId = this.getGenerationId(userId);
        if (generationId == -1) {
            nextId = 1;
        } else {
            this.invalidatePlatformKey(userId, generationId);
            nextId = generationId + 1;
        }
        this.generateAndLoadKey(userId, nextId);
    }

    public PlatformEncryptionKey getEncryptKey(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InsecureUserException, IOException {
        this.init(userId);
        try {
            this.getDecryptKeyInternal(userId);
            return this.getEncryptKeyInternal(userId);
        }
        catch (UnrecoverableKeyException e) {
            Log.i(TAG, String.format(Locale.US, "Regenerating permanently invalid Platform key for user %d.", userId));
            this.regenerate(userId);
            return this.getEncryptKeyInternal(userId);
        }
    }

    private PlatformEncryptionKey getEncryptKeyInternal(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InsecureUserException {
        int generationId = this.getGenerationId(userId);
        String alias = this.getEncryptAlias(userId, generationId);
        if (!this.isKeyLoaded(userId, generationId)) {
            throw new UnrecoverableKeyException("KeyStore doesn't contain key " + alias);
        }
        AndroidKeyStoreSecretKey key = (AndroidKeyStoreSecretKey)this.mKeyStore.getKey(alias, null);
        return new PlatformEncryptionKey(generationId, key);
    }

    public PlatformDecryptionKey getDecryptKey(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InsecureUserException, IOException {
        this.init(userId);
        try {
            return this.getDecryptKeyInternal(userId);
        }
        catch (UnrecoverableKeyException e) {
            Log.i(TAG, String.format(Locale.US, "Regenerating permanently invalid Platform key for user %d.", userId));
            this.regenerate(userId);
            return this.getDecryptKeyInternal(userId);
        }
    }

    private PlatformDecryptionKey getDecryptKeyInternal(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InsecureUserException {
        int generationId = this.getGenerationId(userId);
        String alias = this.getDecryptAlias(userId, generationId);
        if (!this.isKeyLoaded(userId, generationId)) {
            throw new UnrecoverableKeyException("KeyStore doesn't contain key " + alias);
        }
        AndroidKeyStoreSecretKey key = (AndroidKeyStoreSecretKey)this.mKeyStore.getKey(alias, null);
        return new PlatformDecryptionKey(generationId, key);
    }

    void init(int userId) throws KeyStoreException, NoSuchAlgorithmException, InsecureUserException, IOException {
        if (!this.isAvailable(userId)) {
            throw new InsecureUserException(String.format(Locale.US, "%d does not have a lock screen set.", userId));
        }
        int generationId = this.getGenerationId(userId);
        if (this.isKeyLoaded(userId, generationId)) {
            Log.i(TAG, String.format(Locale.US, "Platform key generation %d exists already.", generationId));
            return;
        }
        if (generationId == -1) {
            Log.i(TAG, "Generating initial platform key generation ID.");
            generationId = 1;
        } else {
            Log.w(TAG, String.format(Locale.US, "Platform generation ID was %d but no entry was present in AndroidKeyStore. Generating fresh key.", generationId));
            ++generationId;
        }
        this.generateAndLoadKey(userId, generationId);
    }

    private String getEncryptAlias(int userId, int generationId) {
        return KEY_ALIAS_PREFIX + userId + "/" + generationId + "/" + ENCRYPT_KEY_ALIAS_SUFFIX;
    }

    private String getDecryptAlias(int userId, int generationId) {
        return KEY_ALIAS_PREFIX + userId + "/" + generationId + "/" + DECRYPT_KEY_ALIAS_SUFFIX;
    }

    private void setGenerationId(int userId, int generationId) throws IOException {
        long updatedRows = this.mDatabase.setPlatformKeyGenerationId(userId, generationId);
        if (updatedRows < 0L) {
            throw new IOException("Failed to set the platform key in the local DB.");
        }
    }

    private boolean isKeyLoaded(int userId, int generationId) throws KeyStoreException {
        return this.mKeyStore.containsAlias(this.getEncryptAlias(userId, generationId)) && this.mKeyStore.containsAlias(this.getDecryptAlias(userId, generationId));
    }

    private void generateAndLoadKey(int userId, int generationId) throws NoSuchAlgorithmException, KeyStoreException, IOException {
        String encryptAlias = this.getEncryptAlias(userId, generationId);
        String decryptAlias = this.getDecryptAlias(userId, generationId);
        SecretKey secretKey = PlatformKeyManager.generateAesKey();
        this.mKeyStore.setEntry(decryptAlias, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(2).setUserAuthenticationRequired(true).setUserAuthenticationValidityDurationSeconds(15).setBlockModes("GCM").setEncryptionPaddings("NoPadding").setBoundToSpecificSecureUserId(userId).build());
        this.mKeyStore.setEntry(encryptAlias, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(1).setBlockModes("GCM").setEncryptionPaddings("NoPadding").build());
        this.setGenerationId(userId, generationId);
    }

    private static SecretKey generateAesKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private static KeyStore getAndLoadAndroidKeyStore() throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_PROVIDER);
        try {
            keyStore.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Unable to load keystore.", e);
        }
        return keyStore;
    }
}

