/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.storage;

import android.os.Environment;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotDeserializer;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotParserException;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;

public class RecoverySnapshotStorage {
    private static final String TAG = "RecoverySnapshotStorage";
    private static final String ROOT_PATH = "system";
    private static final String STORAGE_PATH = "recoverablekeystore/snapshots/";
    @GuardedBy(value="this")
    private final SparseArray<KeyChainSnapshot> mSnapshotByUid = new SparseArray();
    private final File rootDirectory;

    public static RecoverySnapshotStorage newInstance() {
        return new RecoverySnapshotStorage(new File(Environment.getDataDirectory(), ROOT_PATH));
    }

    @VisibleForTesting
    public RecoverySnapshotStorage(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public synchronized void put(int uid, KeyChainSnapshot snapshot) {
        this.mSnapshotByUid.put(uid, snapshot);
        try {
            this.writeToDisk(uid, snapshot);
        }
        catch (IOException | CertificateEncodingException e) {
            Log.e(TAG, String.format(Locale.US, "Error persisting snapshot for %d to disk", uid), e);
        }
    }

    public synchronized KeyChainSnapshot get(int uid) {
        KeyChainSnapshot snapshot = this.mSnapshotByUid.get(uid);
        if (snapshot != null) {
            return snapshot;
        }
        try {
            return this.readFromDisk(uid);
        }
        catch (KeyChainSnapshotParserException | IOException e) {
            Log.e(TAG, String.format(Locale.US, "Error reading snapshot for %d from disk", uid), e);
            return null;
        }
    }

    public synchronized void remove(int uid) {
        this.mSnapshotByUid.remove(uid);
        this.getSnapshotFile(uid).delete();
    }

    private void writeToDisk(int uid, KeyChainSnapshot snapshot) throws IOException, CertificateEncodingException {
        File snapshotFile = this.getSnapshotFile(uid);
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
            KeyChainSnapshotSerializer.serialize(snapshot, fileOutputStream);
        }
        catch (IOException | CertificateEncodingException e) {
            snapshotFile.delete();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyChainSnapshot readFromDisk(int uid) throws IOException, KeyChainSnapshotParserException {
        File snapshotFile = this.getSnapshotFile(uid);
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            KeyChainSnapshot keyChainSnapshot = KeyChainSnapshotDeserializer.deserialize(fileInputStream);
            return keyChainSnapshot;
        }
        catch (KeyChainSnapshotParserException | IOException e) {
            snapshotFile.delete();
            throw e;
        }
    }

    private File getSnapshotFile(int uid) {
        File folder = this.getStorageFolder();
        String fileName = this.getSnapshotFileName(uid);
        return new File(folder, fileName);
    }

    private String getSnapshotFileName(int uid) {
        return String.format(Locale.US, "%d.xml", uid);
    }

    private File getStorageFolder() {
        File folder = new File(this.rootDirectory, STORAGE_PATH);
        folder.mkdirs();
        return folder;
    }
}

