/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.INotificationManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.IRemoteVolumeController;
import android.media.ISessionTokensListener;
import android.media.MediaController2;
import android.media.SessionToken2;
import android.media.session.IActiveSessionsListener;
import android.media.session.ICallback;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionManager;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.media.AudioPlayerStateMonitor;
import com.android.server.media.MediaSessionRecord;
import com.android.server.media.MediaSessionStack;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MediaSessionService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "MediaSessionService";
    static final boolean USE_MEDIA2_APIS = false;
    static final boolean DEBUG = Log.isLoggable("MediaSessionService", 3);
    private static final boolean DEBUG_KEY_EVENT = true;
    private static final int WAKELOCK_TIMEOUT = 5000;
    private static final int MEDIA_KEY_LISTENER_TIMEOUT = 1000;
    private final SessionManagerImpl mSessionManagerImpl;
    private final SparseIntArray mFullUserIds = new SparseIntArray();
    private final SparseArray<FullUserRecord> mUserRecords = new SparseArray();
    private final ArrayList<SessionsListenerRecord> mSessionsListeners = new ArrayList();
    private final Object mLock = new Object();
    private final MessageHandler mHandler = new MessageHandler();
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private final int mLongPressTimeout;
    private final INotificationManager mNotificationManager;
    private final IPackageManager mPackageManager;
    private KeyguardManager mKeyguardManager;
    private IAudioService mAudioService;
    private ContentResolver mContentResolver;
    private SettingsObserver mSettingsObserver;
    private boolean mHasFeatureLeanback;
    private FullUserRecord mCurrentFullUserRecord;
    private MediaSessionRecord mGlobalPrioritySession;
    private AudioPlayerStateMonitor mAudioPlayerStateMonitor;
    private IRemoteVolumeController mRvc;
    private final Map<SessionToken2, MediaController2> mSessionRecords = new ArrayMap<SessionToken2, MediaController2>();
    private final List<SessionTokensListenerRecord> mSessionTokensListeners = new ArrayList<SessionTokensListenerRecord>();

    public MediaSessionService(Context context) {
        super(context);
        this.mSessionManagerImpl = new SessionManagerImpl();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
        this.mLongPressTimeout = ViewConfiguration.getLongPressTimeout();
        this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        this.mPackageManager = AppGlobals.getPackageManager();
    }

    @Override
    public void onStart() {
        this.publishBinderService("media_session", this.mSessionManagerImpl);
        Watchdog.getInstance().addMonitor(this);
        this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        this.mAudioService = this.getAudioService();
        this.mAudioPlayerStateMonitor = AudioPlayerStateMonitor.getInstance();
        this.mAudioPlayerStateMonitor.registerListener((config, isRemoved) -> {
            if (isRemoved || !config.isActive() || config.getPlayerType() == 3) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                FullUserRecord user = this.getFullUserRecordLocked(UserHandle.getUserId(config.getClientUid()));
                if (user != null) {
                    user.mPriorityStack.updateMediaButtonSessionIfNeeded();
                }
            }
        }, null);
        this.mAudioPlayerStateMonitor.registerSelfIntoAudioServiceIfNeeded(this.mAudioService);
        this.mContentResolver = this.getContext().getContentResolver();
        this.mSettingsObserver = new SettingsObserver();
        this.mSettingsObserver.observe();
        this.mHasFeatureLeanback = this.getContext().getPackageManager().hasSystemFeature("android.software.leanback");
        this.updateUser();
        this.registerPackageBroadcastReceivers();
        this.buildMediaSessionService2List();
    }

    private IAudioService getAudioService() {
        IBinder b = ServiceManager.getService("audio");
        return IAudioService.Stub.asInterface(b);
    }

    private boolean isGlobalPriorityActiveLocked() {
        return this.mGlobalPrioritySession != null && this.mGlobalPrioritySession.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null) {
                Log.w(TAG, "Unknown session updated. Ignoring.");
                return;
            }
            if ((record.getFlags() & 0x10000L) != 0L) {
                Log.d(TAG, "Global priority session is updated, active=" + record.isActive());
                user.pushAddressedPlayerChangedLocked();
            } else {
                if (!user.mPriorityStack.contains(record)) {
                    Log.w(TAG, "Unknown session updated. Ignoring.");
                    return;
                }
                user.mPriorityStack.onSessionStateChange(record);
            }
            this.mHandler.postSessionsChanged(record.getUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalPrioritySession(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (this.mGlobalPrioritySession != record) {
                Log.d(TAG, "Global priority session is changed from " + this.mGlobalPrioritySession + " to " + record);
                this.mGlobalPrioritySession = record;
                if (user != null && user.mPriorityStack.contains(record)) {
                    user.mPriorityStack.removeSession(record);
                }
            }
        }
    }

    private List<MediaSessionRecord> getActiveSessionsLocked(int userId) {
        ArrayList<MediaSessionRecord> records = new ArrayList<MediaSessionRecord>();
        if (userId == -1) {
            int size = this.mUserRecords.size();
            for (int i = 0; i < size; ++i) {
                records.addAll(this.mUserRecords.valueAt(i).mPriorityStack.getActiveSessions(userId));
            }
        } else {
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user == null) {
                Log.w(TAG, "getSessions failed. Unknown user " + userId);
                return records;
            }
            records.addAll(user.mPriorityStack.getActiveSessions(userId));
        }
        if (this.isGlobalPriorityActiveLocked() && (userId == -1 || userId == this.mGlobalPrioritySession.getUserId())) {
            records.add(0, this.mGlobalPrioritySession);
        }
        return records;
    }

    public void notifyRemoteVolumeChanged(int flags, MediaSessionRecord session) {
        if (this.mRvc == null || !session.isActive()) {
            return;
        }
        try {
            this.mRvc.remoteVolumeChanged(session.getControllerBinder(), flags);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Error sending volume change to system UI.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionPlaystateChanged(MediaSessionRecord record, int oldState, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null || !user.mPriorityStack.contains(record)) {
                Log.d(TAG, "Unknown session changed playback state. Ignoring.");
                return;
            }
            user.mPriorityStack.onPlaystateChanged(record, oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionPlaybackTypeChanged(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null || !user.mPriorityStack.contains(record)) {
                Log.d(TAG, "Unknown session changed playback type. Ignoring.");
                return;
            }
            this.pushRemoteVolumeUpdateLocked(record.getUserId());
        }
    }

    @Override
    public void onStartUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStartUser: " + userId);
        }
        this.updateUser();
    }

    @Override
    public void onSwitchUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onSwitchUser: " + userId);
        }
        this.updateUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStopUser: " + userId);
        }
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user != null) {
                if (user.mFullUserId == userId) {
                    user.destroySessionsForUserLocked(-1);
                    this.mUserRecords.remove(userId);
                } else {
                    user.destroySessionsForUserLocked(userId);
                }
            }
            this.updateUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    protected void enforcePhoneStatePermission(int pid, int uid) {
        if (this.getContext().checkPermission("android.permission.MODIFY_PHONE_STATE", pid, uid) != 0) {
            throw new SecurityException("Must hold the MODIFY_PHONE_STATE permission.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionDied(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySession(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUser() {
        Object object = this.mLock;
        synchronized (object) {
            UserManager manager = (UserManager)this.getContext().getSystemService("user");
            this.mFullUserIds.clear();
            List<UserInfo> allUsers = manager.getUsers();
            if (allUsers != null) {
                for (UserInfo userInfo : allUsers) {
                    if (userInfo.isManagedProfile()) {
                        this.mFullUserIds.put(userInfo.id, userInfo.profileGroupId);
                        continue;
                    }
                    this.mFullUserIds.put(userInfo.id, userInfo.id);
                    if (this.mUserRecords.get(userInfo.id) != null) continue;
                    this.mUserRecords.put(userInfo.id, new FullUserRecord(userInfo.id));
                }
            }
            int currentFullUserId = ActivityManager.getCurrentUser();
            this.mCurrentFullUserRecord = this.mUserRecords.get(currentFullUserId);
            if (this.mCurrentFullUserRecord == null) {
                Log.w(TAG, "Cannot find FullUserInfo for the current user " + currentFullUserId);
                this.mCurrentFullUserRecord = new FullUserRecord(currentFullUserId);
                this.mUserRecords.put(currentFullUserId, this.mCurrentFullUserRecord);
            }
            this.mFullUserIds.put(currentFullUserId, currentFullUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveSessionListeners() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord listener = this.mSessionsListeners.get(i);
                try {
                    this.enforceMediaPermissions(listener.mComponentName, listener.mPid, listener.mUid, listener.mUserId);
                    continue;
                }
                catch (SecurityException e) {
                    Log.i(TAG, "ActiveSessionsListener " + listener.mComponentName + " is no longer authorized. Disconnecting.");
                    this.mSessionsListeners.remove(i);
                    try {
                        listener.mListener.onActiveSessionsChanged(new ArrayList<MediaSession.Token>());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void destroySessionLocked(MediaSessionRecord session) {
        if (DEBUG) {
            Log.d(TAG, "Destroying " + session);
        }
        FullUserRecord user = this.getFullUserRecordLocked(session.getUserId());
        if (this.mGlobalPrioritySession == session) {
            this.mGlobalPrioritySession = null;
            if (session.isActive() && user != null) {
                user.pushAddressedPlayerChangedLocked();
            }
        } else if (user != null) {
            user.mPriorityStack.removeSession(session);
        }
        try {
            session.getCallback().asBinder().unlinkToDeath(session, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.onDestroy();
        this.mHandler.postSessionsChanged(session.getUserId());
    }

    private void registerPackageBroadcastReceivers() {
        IntentFilter filter = new IntentFilter();
        filter.addDataScheme("package");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        filter.addAction("android.intent.action.PACKAGES_UNSUSPENDED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        this.getContext().registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int changeUserId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if (changeUserId == -10000) {
                    Log.w(MediaSessionService.TAG, "Intent broadcast does not contain user handle: " + intent);
                    return;
                }
                boolean isReplacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (DEBUG) {
                    Log.d(MediaSessionService.TAG, "Received change in packages, intent=" + intent);
                }
                switch (intent.getAction()) {
                    case "android.intent.action.PACKAGE_ADDED": 
                    case "android.intent.action.PACKAGE_REMOVED": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": {
                        if (isReplacing) break;
                    }
                    case "android.intent.action.PACKAGE_CHANGED": 
                    case "android.intent.action.PACKAGES_SUSPENDED": 
                    case "android.intent.action.PACKAGES_UNSUSPENDED": 
                    case "android.intent.action.PACKAGE_REPLACED": {
                        MediaSessionService.this.buildMediaSessionService2List();
                    }
                }
            }
        }, UserHandle.ALL, filter, null, BackgroundThread.getHandler());
    }

    private void buildMediaSessionService2List() {
    }

    private void enforcePackageName(String packageName, int uid) {
        if (TextUtils.isEmpty(packageName)) {
            throw new IllegalArgumentException("packageName may not be empty");
        }
        String[] packages = this.getContext().getPackageManager().getPackagesForUid(uid);
        int packageCount = packages.length;
        for (int i = 0; i < packageCount; ++i) {
            if (!packageName.equals(packages[i])) continue;
            return;
        }
        throw new IllegalArgumentException("packageName is not owned by the calling process");
    }

    private void enforceMediaPermissions(ComponentName compName, int pid, int uid, int resolvedUserId) {
        if (this.isCurrentVolumeController(pid, uid)) {
            return;
        }
        if (this.getContext().checkPermission("android.permission.MEDIA_CONTENT_CONTROL", pid, uid) != 0 && !this.isEnabledNotificationListener(compName, UserHandle.getUserId(uid), resolvedUserId)) {
            throw new SecurityException("Missing permission to control media.");
        }
    }

    private boolean isCurrentVolumeController(int pid, int uid) {
        return this.getContext().checkPermission("android.permission.STATUS_BAR_SERVICE", pid, uid) == 0;
    }

    private void enforceSystemUiPermission(String action, int pid, int uid) {
        if (!this.isCurrentVolumeController(pid, uid)) {
            throw new SecurityException("Only system ui may " + action);
        }
    }

    private boolean isEnabledNotificationListener(ComponentName compName, int userId, int forUserId) {
        if (userId != forUserId) {
            return false;
        }
        if (DEBUG) {
            Log.d(TAG, "Checking if enabled notification listener " + compName);
        }
        if (compName != null) {
            try {
                return this.mNotificationManager.isNotificationListenerAccessGrantedForUser(compName, userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Dead NotificationManager in isEnabledNotificationListener", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSessionRecord createSessionInternal(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.createSessionLocked(callerPid, callerUid, userId, callerPackageName, cb, tag);
        }
    }

    private MediaSessionRecord createSessionLocked(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag) {
        FullUserRecord user = this.getFullUserRecordLocked(userId);
        if (user == null) {
            Log.wtf(TAG, "Request from invalid user: " + userId);
            throw new RuntimeException("Session request from invalid user.");
        }
        MediaSessionRecord session = new MediaSessionRecord(callerPid, callerUid, userId, callerPackageName, cb, tag, this, this.mHandler.getLooper());
        try {
            cb.asBinder().linkToDeath(session, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Media Session owner died prematurely.", e);
        }
        user.mPriorityStack.addSession(session);
        this.mHandler.postSessionsChanged(userId);
        if (DEBUG) {
            Log.d(TAG, "Created session for " + callerPackageName + " with tag " + tag);
        }
        return session;
    }

    private int findIndexOfSessionsListenerLocked(IActiveSessionsListener listener) {
        for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
            if (this.mSessionsListeners.get(i).mListener.asBinder() != listener.asBinder()) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSessionsChanged(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user == null) {
                Log.w(TAG, "pushSessionsChanged failed. No user with id=" + userId);
                return;
            }
            List<MediaSessionRecord> records = this.getActiveSessionsLocked(userId);
            int size = records.size();
            ArrayList<MediaSession.Token> tokens = new ArrayList<MediaSession.Token>();
            for (i = 0; i < size; ++i) {
                tokens.add(new MediaSession.Token(records.get(i).getControllerBinder()));
            }
            this.pushRemoteVolumeUpdateLocked(userId);
            for (i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord record = this.mSessionsListeners.get(i);
                if (record.mUserId != -1 && record.mUserId != userId) continue;
                try {
                    record.mListener.onActiveSessionsChanged(tokens);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Dead ActiveSessionsListener in pushSessionsChanged, removing", e);
                    this.mSessionsListeners.remove(i);
                }
            }
        }
    }

    private void pushRemoteVolumeUpdateLocked(int userId) {
        if (this.mRvc != null) {
            try {
                FullUserRecord user = this.getFullUserRecordLocked(userId);
                if (user == null) {
                    Log.w(TAG, "pushRemoteVolumeUpdateLocked failed. No user with id=" + userId);
                    return;
                }
                MediaSessionRecord record = user.mPriorityStack.getDefaultRemoteSession(userId);
                this.mRvc.updateRemoteController(record == null ? null : record.getControllerBinder());
            }
            catch (RemoteException e) {
                Log.wtf(TAG, "Error sending default remote volume to sys ui.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMediaButtonReceiverChanged(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            MediaSessionRecord mediaButtonSession = user.mPriorityStack.getMediaButtonSession();
            if (record == mediaButtonSession) {
                user.rememberMediaButtonReceiverLocked(mediaButtonSession);
            }
        }
    }

    private String getCallingPackageName(int uid) {
        String[] packages = this.getContext().getPackageManager().getPackagesForUid(uid);
        if (packages != null && packages.length > 0) {
            return packages[0];
        }
        return "";
    }

    private void dispatchVolumeKeyLongPressLocked(KeyEvent keyEvent) {
        if (this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener == null) {
            return;
        }
        try {
            this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener.onVolumeKeyLongPress(keyEvent);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to send " + keyEvent + " to volume key long-press listener");
        }
    }

    private FullUserRecord getFullUserRecordLocked(int userId) {
        int fullUserId = this.mFullUserIds.get(userId, -1);
        if (fullUserId < 0) {
            return null;
        }
        return this.mUserRecords.get(fullUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySession2Internal(SessionToken2 token) {
        Object object = this.mLock;
        synchronized (object) {
            boolean notifySessionTokensUpdated = false;
            notifySessionTokensUpdated = token.getType() == 0 ? (notifySessionTokensUpdated |= this.removeSessionRecordLocked(token)) : (notifySessionTokensUpdated |= this.addSessionRecordLocked(token));
            if (notifySessionTokensUpdated) {
                this.postSessionTokensUpdated(UserHandle.getUserId(token.getUid()));
            }
        }
    }

    private void postSessionTokensUpdated(int userId) {
        this.mHandler.obtainMessage(3, userId).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSessionTokensChanged(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<Bundle> tokens = new ArrayList<Bundle>();
            for (SessionToken2 token : this.mSessionRecords.keySet()) {
                if (UserHandle.getUserId(token.getUid()) != userId && -1 != userId) continue;
                tokens.add(token.toBundle());
            }
            for (SessionTokensListenerRecord record : this.mSessionTokensListeners) {
                if (record.mUserId != userId && record.mUserId != -1) continue;
                try {
                    record.mListener.onSessionTokensChanged(tokens);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to notify session tokens changed", e);
                }
            }
        }
    }

    private boolean addSessionRecordLocked(SessionToken2 token) {
        return this.addSessionRecordLocked(token, null);
    }

    private boolean addSessionRecordLocked(SessionToken2 token, MediaController2 controller) {
        if (this.mSessionRecords.containsKey(token) && this.mSessionRecords.get(token) == controller) {
            return false;
        }
        this.mSessionRecords.put(token, controller);
        return true;
    }

    private boolean removeSessionRecordLocked(SessionToken2 token) {
        if (!this.mSessionRecords.containsKey(token)) {
            return false;
        }
        this.mSessionRecords.remove(token);
        return true;
    }

    static /* synthetic */ Map access$4200(MediaSessionService x0) {
        return x0.mSessionRecords;
    }

    static /* synthetic */ boolean access$4300(MediaSessionService x0, SessionToken2 x1, MediaController2 x2) {
        return x0.addSessionRecordLocked(x1, x2);
    }

    static /* synthetic */ void access$4400(MediaSessionService x0, int x1) {
        x0.postSessionTokensUpdated(x1);
    }

    private final class SessionTokensListenerRecord
    implements IBinder.DeathRecipient {
        private final ISessionTokensListener mListener;
        private final int mUserId;

        public SessionTokensListenerRecord(ISessionTokensListener listener, int userId) {
            this.mListener = listener;
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                MediaSessionService.this.mSessionTokensListeners.remove(this);
            }
        }
    }

    private class ControllerCallback
    extends MediaController2.ControllerCallback {
        private final SessionToken2 mToken;

        ControllerCallback(SessionToken2 token) {
            this.mToken = token;
        }

        @Override
        public void onDisconnected(MediaController2 controller) {
            MediaSessionService.this.destroySession2Internal(this.mToken);
        }
    }

    final class MessageHandler
    extends Handler {
        private static final int MSG_SESSIONS_CHANGED = 1;
        private static final int MSG_VOLUME_INITIAL_DOWN = 2;
        private static final int MSG_SESSIONS_TOKENS_CHANGED = 3;
        private final SparseArray<Integer> mIntegerCache = new SparseArray();

        MessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaSessionService.this.pushSessionsChanged((Integer)msg.obj);
                    break;
                }
                case 2: {
                    Object object = MediaSessionService.this.mLock;
                    synchronized (object) {
                        FullUserRecord user = (FullUserRecord)MediaSessionService.this.mUserRecords.get(msg.arg1);
                        if (user != null && user.mInitialDownVolumeKeyEvent != null) {
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(user.mInitialDownVolumeKeyEvent);
                            user.mInitialDownVolumeKeyEvent = null;
                        }
                        break;
                    }
                }
                case 3: {
                    MediaSessionService.this.pushSessionTokensChanged((Integer)msg.obj);
                }
            }
        }

        public void postSessionsChanged(int userId) {
            Integer userIdInteger = this.mIntegerCache.get(userId);
            if (userIdInteger == null) {
                userIdInteger = userId;
                this.mIntegerCache.put(userId, userIdInteger);
            }
            this.removeMessages(1, userIdInteger);
            this.obtainMessage(1, userIdInteger).sendToTarget();
        }
    }

    class SessionManagerImpl
    extends ISessionManager.Stub {
        private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
        private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
        private boolean mVoiceButtonDown = false;
        private boolean mVoiceButtonHandled = false;
        private KeyEventWakeLockReceiver mKeyEventReceiver = new KeyEventWakeLockReceiver(MediaSessionService.access$1800(MediaSessionService.this));
        BroadcastReceiver mKeyEventDone = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (extras.containsKey(SessionManagerImpl.EXTRA_WAKELOCK_ACQUIRED) && MediaSessionService.this.mMediaEventWakeLock.isHeld()) {
                        MediaSessionService.this.mMediaEventWakeLock.release();
                    }
                }
            }
        };

        SessionManagerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ISession createSession(String packageName, ISessionCallback cb, String tag, int userId) throws RemoteException {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionService.this.enforcePackageName(packageName, uid);
                int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, false, true, "createSession", packageName);
                if (cb == null) {
                    throw new IllegalArgumentException("Controller callback cannot be null");
                }
                ISession iSession = MediaSessionService.this.createSessionInternal(pid, uid, resolvedUserId, packageName, cb, tag).getSessionBinder();
                return iSession;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<IBinder> getSessions(ComponentName componentName, int userId) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                ArrayList<IBinder> binders = new ArrayList<IBinder>();
                ArrayList<IBinder> arrayList = MediaSessionService.this.mLock;
                synchronized (arrayList) {
                    List records = MediaSessionService.this.getActiveSessionsLocked(resolvedUserId);
                    for (MediaSessionRecord record : records) {
                        binders.add(record.getControllerBinder().asBinder());
                    }
                }
                arrayList = binders;
                return arrayList;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void addSessionsListener(IActiveSessionsListener listener, ComponentName componentName, int userId) throws RemoteException {
            int resolvedUserId;
            long token;
            int uid;
            int pid;
            block10: {
                pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index == -1) break block10;
                Log.w(MediaSessionService.TAG, "ActiveSessionsListener is already added, ignoring");
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            SessionsListenerRecord record = new SessionsListenerRecord(listener, componentName, resolvedUserId, pid, uid);
            try {
                listener.asBinder().linkToDeath(record, 0);
            }
            catch (RemoteException e) {
                Log.e(MediaSessionService.TAG, "ActiveSessionsListener is dead, ignoring it", e);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                MediaSessionService.this.mSessionsListeners.add(record);
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSessionsListener(IActiveSessionsListener listener) throws RemoteException {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index != -1) {
                    SessionsListenerRecord record = (SessionsListenerRecord)MediaSessionService.this.mSessionsListeners.remove(index);
                    try {
                        record.mListener.asBinder().unlinkToDeath(record, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void dispatchMediaKeyEvent(String packageName, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            if (keyEvent == null || !KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
                Log.w("MediaSessionService", "Attempted to dispatch null or non-media key event.");
                return;
            }
            pid = Binder.getCallingPid();
            uid = Binder.getCallingUid();
            token = Binder.clearCallingIdentity();
            if (MediaSessionService.DEBUG) {
                Log.d("MediaSessionService", "dispatchMediaKeyEvent, pkg=" + packageName + " pid=" + pid + ", uid=" + uid + ", asSystem=" + asSystemService + ", event=" + keyEvent);
            }
            if (!this.isUserSetupComplete()) {
                Slog.i("MediaSessionService", "Not dispatching media key event because user setup is in progress.");
            }
            ** GOTO lbl-1000
            {
                catch (Throwable var13_11) {
                    throw var13_11;
                }
                Binder.restoreCallingIdentity(token);
                return;
lbl-1000:
                // 1 sources

                {
                    var9_8 = MediaSessionService.access$1700(MediaSessionService.this);
                    synchronized (var9_8) {
                        isGlobalPriorityActive = MediaSessionService.access$2000(MediaSessionService.this);
                        if (!isGlobalPriorityActive || uid == 1000) ** break block17
                        Slog.i("MediaSessionService", "Only the system can dispatch media key event to the global priority session.");
                    }
                }
                Binder.restoreCallingIdentity(token);
                return;
                {
                    if (!isGlobalPriorityActive && FullUserRecord.access$2800(MediaSessionService.access$1900(MediaSessionService.this)) != null) {
                        Log.d("MediaSessionService", "Send " + keyEvent + " to the media key listener");
                        try {
                            FullUserRecord.access$2800(MediaSessionService.access$1900(MediaSessionService.this)).onMediaKey(keyEvent, new MediaKeyListenerResultReceiver(packageName, pid, uid, asSystemService, keyEvent, needWakeLock));
                        }
                        catch (RemoteException e) {}
                        ** try [egrp 5[TRYBLOCK] [9 : 279->372)] { 
lbl38:
                        // 1 sources

                        Log.w("MediaSessionService", "Failed to send " + keyEvent + " to the media key listener");
                    }
                    if (!isGlobalPriorityActive && this.isVoiceKey(keyEvent.getKeyCode())) {
                        this.handleVoiceKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                    } else {
                        this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                    }
                    return;
lbl45:
                    // 1 sources

                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
            Binder.restoreCallingIdentity(token);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setCallback(ICallback callback) {
            FullUserRecord user;
            long token;
            int uid;
            block12: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (!UserHandle.isSameApp(uid, 1002)) {
                    throw new SecurityException("Only Bluetooth service processes can set Callback");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block12;
                Log.w(MediaSessionService.TAG, "Only the full user can set the callback, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            user.mCallback = callback;
            Log.d(MediaSessionService.TAG, "The callback " + user.mCallback + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
            if (user.mCallback == null) {
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                try {
                    user.mCallback.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void binderDied() {
                            Object object = MediaSessionService.this.mLock;
                            synchronized (object) {
                                user.mCallback = null;
                            }
                        }
                    }, 0);
                    user.pushAddressedPlayerChangedLocked();
                    return;
                }
                catch (RemoteException e) {
                    Log.w(MediaSessionService.TAG, "Failed to set callback", e);
                    user.mCallback = null;
                }
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setOnVolumeKeyLongPressListener(IOnVolumeKeyLongPressListener listener) {
            FullUserRecord user;
            long token;
            int uid;
            block13: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (MediaSessionService.this.getContext().checkPermission("android.permission.SET_VOLUME_KEY_LONG_PRESS_LISTENER", pid, uid) != 0) {
                    throw new SecurityException("Must hold the SET_VOLUME_KEY_LONG_PRESS_LISTENER permission.");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block13;
                Log.w(MediaSessionService.TAG, "Only the full user can set the volume key long-press listener, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            if (user.mOnVolumeKeyLongPressListener != null && user.mOnVolumeKeyLongPressListenerUid != uid) {
                Log.w(MediaSessionService.TAG, "The volume key long-press listener cannot be reset by another app , mOnVolumeKeyLongPressListener=" + user.mOnVolumeKeyLongPressListenerUid + ", uid=" + uid);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                user.mOnVolumeKeyLongPressListener = listener;
                user.mOnVolumeKeyLongPressListenerUid = uid;
                Log.d(MediaSessionService.TAG, "The volume key long-press listener " + listener + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
                if (user.mOnVolumeKeyLongPressListener != null) {
                    try {
                        user.mOnVolumeKeyLongPressListener.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void binderDied() {
                                Object object = MediaSessionService.this.mLock;
                                synchronized (object) {
                                    user.mOnVolumeKeyLongPressListener = null;
                                }
                            }
                        }, 0);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to set death recipient " + user.mOnVolumeKeyLongPressListener);
                        user.mOnVolumeKeyLongPressListener = null;
                    }
                }
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setOnMediaKeyListener(IOnMediaKeyListener listener) {
            FullUserRecord user;
            long token;
            int uid;
            block13: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (MediaSessionService.this.getContext().checkPermission("android.permission.SET_MEDIA_KEY_LISTENER", pid, uid) != 0) {
                    throw new SecurityException("Must hold the SET_MEDIA_KEY_LISTENER permission.");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block13;
                Log.w(MediaSessionService.TAG, "Only the full user can set the media key listener, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            if (user.mOnMediaKeyListener != null && user.mOnMediaKeyListenerUid != uid) {
                Log.w(MediaSessionService.TAG, "The media key listener cannot be reset by another app. , mOnMediaKeyListenerUid=" + user.mOnMediaKeyListenerUid + ", uid=" + uid);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                user.mOnMediaKeyListener = listener;
                user.mOnMediaKeyListenerUid = uid;
                Log.d(MediaSessionService.TAG, "The media key listener " + user.mOnMediaKeyListener + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
                if (user.mOnMediaKeyListener != null) {
                    try {
                        user.mOnMediaKeyListener.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void binderDied() {
                                Object object = MediaSessionService.this.mLock;
                                synchronized (object) {
                                    user.mOnMediaKeyListener = null;
                                }
                            }
                        }, 0);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to set death recipient " + user.mOnMediaKeyListener);
                        user.mOnMediaKeyListener = null;
                    }
                }
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchVolumeKeyEvent(String packageName, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
            if (keyEvent == null || keyEvent.getKeyCode() != 24 && keyEvent.getKeyCode() != 25 && keyEvent.getKeyCode() != 164) {
                Log.w(MediaSessionService.TAG, "Attempted to dispatch null or non-volume key event.");
                return;
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            Log.d(MediaSessionService.TAG, "dispatchVolumeKeyEvent, pkg=" + packageName + ", pid=" + pid + ", uid=" + uid + ", asSystem=" + asSystemService + ", event=" + keyEvent);
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (MediaSessionService.this.isGlobalPriorityActiveLocked() || MediaSessionService.this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener == null) {
                        this.dispatchVolumeKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, stream, musicOnly);
                    } else if (keyEvent.getAction() == 0) {
                        if (keyEvent.getRepeatCount() == 0) {
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent = KeyEvent.obtain(keyEvent);
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeStream = stream;
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownMusicOnly = musicOnly;
                            MediaSessionService.this.mHandler.sendMessageDelayed(MediaSessionService.this.mHandler.obtainMessage(2, MediaSessionService.this.mCurrentFullUserRecord.mFullUserId, 0), MediaSessionService.this.mLongPressTimeout);
                        }
                        if (keyEvent.getRepeatCount() > 0 || keyEvent.isLongPress()) {
                            MediaSessionService.this.mHandler.removeMessages(2);
                            if (MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent != null) {
                                MediaSessionService.this.dispatchVolumeKeyLongPressLocked(MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent);
                                MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent = null;
                            }
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(keyEvent);
                        }
                    } else {
                        MediaSessionService.this.mHandler.removeMessages(2);
                        if (MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent != null && MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent.getDownTime() == keyEvent.getDownTime()) {
                            this.dispatchVolumeKeyEventLocked(packageName, pid, uid, asSystemService, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeStream, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownMusicOnly);
                            this.dispatchVolumeKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, stream, musicOnly);
                        } else {
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(keyEvent);
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private void dispatchVolumeKeyEventLocked(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
            boolean down = keyEvent.getAction() == 0;
            boolean up = keyEvent.getAction() == 1;
            int direction = 0;
            boolean isMute = false;
            switch (keyEvent.getKeyCode()) {
                case 24: {
                    direction = 1;
                    break;
                }
                case 25: {
                    direction = -1;
                    break;
                }
                case 164: {
                    isMute = true;
                }
            }
            if (down || up) {
                int flags = 4096;
                flags = musicOnly ? (flags |= 0x200) : (up ? (flags |= 0x14) : (flags |= 0x11));
                if (direction != 0) {
                    if (up) {
                        direction = 0;
                    }
                    this.dispatchAdjustVolumeLocked(packageName, pid, uid, asSystemService, stream, direction, flags);
                } else if (isMute && down && keyEvent.getRepeatCount() == 0) {
                    this.dispatchAdjustVolumeLocked(packageName, pid, uid, asSystemService, stream, 101, flags);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchAdjustVolume(String packageName, int suggestedStream, int delta, int flags) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    this.dispatchAdjustVolumeLocked(packageName, pid, uid, false, suggestedStream, delta, flags);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRemoteVolumeController(IRemoteVolumeController rvc) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionService.this.enforceSystemUiPermission("listen for volume changes", pid, uid);
                MediaSessionService.this.mRvc = rvc;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isGlobalPriorityActive() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                return MediaSessionService.this.isGlobalPriorityActiveLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(MediaSessionService.this.getContext(), MediaSessionService.TAG, pw)) {
                return;
            }
            pw.println("MEDIA SESSION SERVICE (dumpsys media_session)");
            pw.println();
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                pw.println(MediaSessionService.this.mSessionsListeners.size() + " sessions listeners.");
                pw.println("Global priority session is " + MediaSessionService.this.mGlobalPrioritySession);
                if (MediaSessionService.this.mGlobalPrioritySession != null) {
                    MediaSessionService.this.mGlobalPrioritySession.dump(pw, "  ");
                }
                pw.println("User Records:");
                int count = MediaSessionService.this.mUserRecords.size();
                for (int i = 0; i < count; ++i) {
                    ((FullUserRecord)MediaSessionService.this.mUserRecords.valueAt(i)).dumpLocked(pw, "");
                }
                MediaSessionService.this.mAudioPlayerStateMonitor.dump(MediaSessionService.this.getContext(), pw, "");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int controllerUidFromPackageName;
                int controllerUserId = UserHandle.getUserId(controllerUid);
                try {
                    controllerUidFromPackageName = MediaSessionService.this.getContext().getPackageManager().getPackageUidAsUser(controllerPackageName, controllerUserId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "Package " + controllerPackageName + " doesn't exist");
                    }
                    boolean bl = false;
                    Binder.restoreCallingIdentity(token);
                    return bl;
                }
                if (controllerUidFromPackageName != controllerUid) {
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "Package name " + controllerPackageName + " doesn't match with the uid " + controllerUid);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.hasMediaControlPermission(UserHandle.getUserId(uid), controllerPackageName, controllerPid, controllerUid);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public boolean createSession2(Bundle sessionToken) {
            return false;
        }

        @Override
        public void destroySession2(Bundle sessionToken) {
        }

        @Override
        public List<Bundle> getSessionTokens(boolean activeSessionOnly, boolean sessionServiceOnly, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void addSessionTokensListener(ISessionTokensListener listener, int userId, String packageName) throws RemoteException {
        }

        @Override
        public void removeSessionTokensListener(ISessionTokensListener listener, String packageName) throws RemoteException {
        }

        private int verifySessionsRequest(ComponentName componentName, int userId, int pid, int uid) {
            String packageName = null;
            if (componentName != null) {
                packageName = componentName.getPackageName();
                MediaSessionService.this.enforcePackageName(packageName, uid);
            }
            int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, true, true, "getSessions", packageName);
            MediaSessionService.this.enforceMediaPermissions(componentName, pid, uid, resolvedUserId);
            return resolvedUserId;
        }

        private int verifySessionsRequest2(int targetUserId, String callerPackageName, int callerPid, int callerUid) throws RemoteException {
            int resolvedUserId = ActivityManager.handleIncomingUser(callerPid, callerUid, targetUserId, true, true, "getSessionTokens", callerPackageName);
            if (!this.hasMediaControlPermission(resolvedUserId, callerPackageName, callerPid, callerUid)) {
                throw new SecurityException("Missing permission to control media.");
            }
            return resolvedUserId;
        }

        private boolean hasMediaControlPermission(int resolvedUserId, String packageName, int pid, int uid) throws RemoteException {
            int userId;
            if (MediaSessionService.this.isCurrentVolumeController(pid, uid)) {
                return true;
            }
            if (uid == 1000 || MediaSessionService.this.getContext().checkPermission("android.permission.MEDIA_CONTENT_CONTROL", pid, uid) == 0) {
                return true;
            }
            if (DEBUG) {
                Log.d(MediaSessionService.TAG, packageName + " (uid=" + uid + ") hasn't granted MEDIA_CONTENT_CONTROL");
            }
            if (resolvedUserId != (userId = UserHandle.getUserId(uid))) {
                return false;
            }
            List<ComponentName> enabledNotificationListeners = MediaSessionService.this.mNotificationManager.getEnabledNotificationListeners(userId);
            if (enabledNotificationListeners != null) {
                for (int i = 0; i < enabledNotificationListeners.size(); ++i) {
                    if (!TextUtils.equals(packageName, enabledNotificationListeners.get(i).getPackageName())) continue;
                    return true;
                }
            }
            if (DEBUG) {
                Log.d(MediaSessionService.TAG, packageName + " (uid=" + uid + ") doesn't have an enabled notification listener");
            }
            return false;
        }

        private void dispatchAdjustVolumeLocked(String packageName, int pid, int uid, boolean asSystemService, final int suggestedStream, final int direction, final int flags) {
            MediaSessionRecord session = MediaSessionService.this.isGlobalPriorityActiveLocked() ? MediaSessionService.this.mGlobalPrioritySession : MediaSessionService.this.mCurrentFullUserRecord.mPriorityStack.getDefaultVolumeSession();
            boolean preferSuggestedStream = false;
            if (this.isValidLocalStreamType(suggestedStream) && AudioSystem.isStreamActive(suggestedStream, 0)) {
                preferSuggestedStream = true;
            }
            Log.d(MediaSessionService.TAG, "Adjusting " + session + " by " + direction + ". flags=" + flags + ", suggestedStream=" + suggestedStream + ", preferSuggestedStream=" + preferSuggestedStream);
            if (session == null || preferSuggestedStream) {
                if ((flags & 0x200) != 0 && !AudioSystem.isStreamActive(3, 0)) {
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "No active session to adjust, skipping media only volume event");
                    }
                    return;
                }
                MediaSessionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String packageName = MediaSessionService.this.getContext().getOpPackageName();
                            MediaSessionService.this.mAudioService.adjustSuggestedStreamVolume(direction, suggestedStream, flags, packageName, MediaSessionService.TAG);
                        }
                        catch (RemoteException e) {
                            Log.e(MediaSessionService.TAG, "Error adjusting default volume.", e);
                        }
                        catch (IllegalArgumentException e) {
                            Log.e(MediaSessionService.TAG, "Cannot adjust volume: direction=" + direction + ", suggestedStream=" + suggestedStream + ", flags=" + flags, e);
                        }
                    }
                });
            } else {
                session.adjustVolume(packageName, pid, uid, null, asSystemService, direction, flags, true);
            }
        }

        private void handleVoiceKeyEventLocked(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            boolean isLongPress;
            int action = keyEvent.getAction();
            boolean bl = isLongPress = (keyEvent.getFlags() & 0x80) != 0;
            if (action == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && isLongPress) {
                    this.mVoiceButtonHandled = true;
                    this.startVoiceInput(needWakeLock);
                }
            } else if (action == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    KeyEvent downEvent = KeyEvent.changeAction(keyEvent, 0);
                    this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, downEvent, needWakeLock);
                    this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                }
            }
        }

        private void dispatchMediaKeyEventLocked(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            MediaSessionRecord session = MediaSessionService.this.mCurrentFullUserRecord.getMediaButtonSessionLocked();
            if (session != null) {
                Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to " + session);
                if (needWakeLock) {
                    this.mKeyEventReceiver.aquireWakeLockLocked();
                }
                session.sendMediaButton(packageName, pid, uid, asSystemService, keyEvent, needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, this.mKeyEventReceiver);
                if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null) {
                    try {
                        MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaSession(keyEvent, new MediaSession.Token(session.getControllerBinder()));
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to send callback", e);
                    }
                }
            } else if (MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver != null || MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiver != null) {
                if (needWakeLock) {
                    this.mKeyEventReceiver.aquireWakeLockLocked();
                }
                Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
                mediaButtonIntent.addFlags(0x10000000);
                mediaButtonIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
                String callerPackageName = asSystemService ? MediaSessionService.this.getContext().getPackageName() : packageName;
                mediaButtonIntent.putExtra("android.intent.extra.PACKAGE_NAME", callerPackageName);
                try {
                    if (MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver != null) {
                        ComponentName componentName;
                        PendingIntent receiver = MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver;
                        Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to the last known PendingIntent " + receiver);
                        receiver.send(MediaSessionService.this.getContext(), needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, mediaButtonIntent, this.mKeyEventReceiver, MediaSessionService.this.mHandler);
                        if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null && (componentName = MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver.getIntent().getComponent()) != null) {
                            MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaButtonReceiver(keyEvent, componentName);
                        }
                    } else {
                        ComponentName receiver = MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiver;
                        Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to the restored intent " + receiver);
                        mediaButtonIntent.setComponent(receiver);
                        MediaSessionService.this.getContext().sendBroadcastAsUser(mediaButtonIntent, UserHandle.of(MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiverUserId));
                        if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null) {
                            MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaButtonReceiver(keyEvent, receiver);
                        }
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    Log.i(MediaSessionService.TAG, "Error sending key event to media button receiver " + MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver, e);
                }
                catch (RemoteException e) {
                    Log.w(MediaSessionService.TAG, "Failed to send callback", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startVoiceInput(boolean needWakeLock) {
            boolean isLocked;
            Intent voiceIntent = null;
            PowerManager pm = (PowerManager)MediaSessionService.this.getContext().getSystemService("power");
            boolean bl = isLocked = MediaSessionService.this.mKeyguardManager != null && MediaSessionService.this.mKeyguardManager.isKeyguardLocked();
            if (!isLocked && pm.isScreenOn()) {
                voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
            } else {
                voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && MediaSessionService.this.mKeyguardManager.isKeyguardSecure());
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
            }
            if (needWakeLock) {
                MediaSessionService.this.mMediaEventWakeLock.acquire();
            }
            try {
                if (voiceIntent != null) {
                    voiceIntent.setFlags(0x10800000);
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "voiceIntent: " + voiceIntent);
                    }
                    MediaSessionService.this.getContext().startActivityAsUser(voiceIntent, UserHandle.CURRENT);
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(MediaSessionService.TAG, "No activity for search: " + e);
            }
            finally {
                if (needWakeLock) {
                    MediaSessionService.this.mMediaEventWakeLock.release();
                }
            }
        }

        private boolean isVoiceKey(int keyCode) {
            return keyCode == 79 || !MediaSessionService.this.mHasFeatureLeanback && keyCode == 85;
        }

        private boolean isUserSetupComplete() {
            return Settings.Secure.getIntForUser(MediaSessionService.this.getContext().getContentResolver(), "user_setup_complete", 0, -2) != 0;
        }

        private boolean isValidLocalStreamType(int streamType) {
            return streamType >= 0 && streamType <= 5;
        }

        class KeyEventWakeLockReceiver
        extends ResultReceiver
        implements Runnable,
        PendingIntent.OnFinished {
            private final Handler mHandler;
            private int mRefCount;
            private int mLastTimeoutId;

            public KeyEventWakeLockReceiver(Handler handler) {
                super(handler);
                this.mRefCount = 0;
                this.mLastTimeoutId = 0;
                this.mHandler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimeout() {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount == 0) {
                        return;
                    }
                    ++this.mLastTimeoutId;
                    this.mRefCount = 0;
                    this.releaseWakeLockLocked();
                }
            }

            public void aquireWakeLockLocked() {
                if (this.mRefCount == 0) {
                    MediaSessionService.this.mMediaEventWakeLock.acquire();
                }
                ++this.mRefCount;
                this.mHandler.removeCallbacks(this);
                this.mHandler.postDelayed(this, 5000L);
            }

            @Override
            public void run() {
                this.onTimeout();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode < this.mLastTimeoutId) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount > 0) {
                        --this.mRefCount;
                        if (this.mRefCount == 0) {
                            this.releaseWakeLockLocked();
                        }
                    }
                }
            }

            private void releaseWakeLockLocked() {
                MediaSessionService.this.mMediaEventWakeLock.release();
                this.mHandler.removeCallbacks(this);
            }

            @Override
            public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
                this.onReceiveResult(resultCode, null);
            }
        }

        private class MediaKeyListenerResultReceiver
        extends ResultReceiver
        implements Runnable {
            private final String mPackageName;
            private final int mPid;
            private final int mUid;
            private final boolean mAsSystemService;
            private final KeyEvent mKeyEvent;
            private final boolean mNeedWakeLock;
            private boolean mHandled;

            private MediaKeyListenerResultReceiver(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
                super(MediaSessionService.this.mHandler);
                MediaSessionService.this.mHandler.postDelayed(this, 1000L);
                this.mPackageName = packageName;
                this.mPid = pid;
                this.mUid = uid;
                this.mAsSystemService = asSystemService;
                this.mKeyEvent = keyEvent;
                this.mNeedWakeLock = needWakeLock;
            }

            @Override
            public void run() {
                Log.d(MediaSessionService.TAG, "The media key listener is timed-out for " + this.mKeyEvent);
                this.dispatchMediaKeyEvent();
            }

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 1) {
                    this.mHandled = true;
                    MediaSessionService.this.mHandler.removeCallbacks(this);
                    return;
                }
                this.dispatchMediaKeyEvent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void dispatchMediaKeyEvent() {
                if (this.mHandled) {
                    return;
                }
                this.mHandled = true;
                MediaSessionService.this.mHandler.removeCallbacks(this);
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (!MediaSessionService.this.isGlobalPriorityActiveLocked() && SessionManagerImpl.this.isVoiceKey(this.mKeyEvent.getKeyCode())) {
                        SessionManagerImpl.this.handleVoiceKeyEventLocked(this.mPackageName, this.mPid, this.mUid, this.mAsSystemService, this.mKeyEvent, this.mNeedWakeLock);
                    } else {
                        SessionManagerImpl.this.dispatchMediaKeyEventLocked(this.mPackageName, this.mPid, this.mUid, this.mAsSystemService, this.mKeyEvent, this.mNeedWakeLock);
                    }
                }
            }
        }
    }

    final class SettingsObserver
    extends ContentObserver {
        private final Uri mSecureSettingsUri;

        private SettingsObserver() {
            super(null);
            this.mSecureSettingsUri = Settings.Secure.getUriFor("enabled_notification_listeners");
        }

        private void observe() {
            MediaSessionService.this.mContentResolver.registerContentObserver(this.mSecureSettingsUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            MediaSessionService.this.updateActiveSessionListeners();
        }
    }

    final class SessionsListenerRecord
    implements IBinder.DeathRecipient {
        private final IActiveSessionsListener mListener;
        private final ComponentName mComponentName;
        private final int mUserId;
        private final int mPid;
        private final int mUid;

        public SessionsListenerRecord(IActiveSessionsListener listener, ComponentName componentName, int userId, int pid, int uid) {
            this.mListener = listener;
            this.mComponentName = componentName;
            this.mUserId = userId;
            this.mPid = pid;
            this.mUid = uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                MediaSessionService.this.mSessionsListeners.remove(this);
            }
        }
    }

    final class FullUserRecord
    implements MediaSessionStack.OnMediaButtonSessionChangedListener {
        private static final String COMPONENT_NAME_USER_ID_DELIM = ",";
        private final int mFullUserId;
        private final MediaSessionStack mPriorityStack;
        private PendingIntent mLastMediaButtonReceiver;
        private ComponentName mRestoredMediaButtonReceiver;
        private int mRestoredMediaButtonReceiverUserId;
        private IOnVolumeKeyLongPressListener mOnVolumeKeyLongPressListener;
        private int mOnVolumeKeyLongPressListenerUid;
        private KeyEvent mInitialDownVolumeKeyEvent;
        private int mInitialDownVolumeStream;
        private boolean mInitialDownMusicOnly;
        private IOnMediaKeyListener mOnMediaKeyListener;
        private int mOnMediaKeyListenerUid;
        private ICallback mCallback;

        public FullUserRecord(int fullUserId) {
            this.mFullUserId = fullUserId;
            this.mPriorityStack = new MediaSessionStack(MediaSessionService.this.mAudioPlayerStateMonitor, this);
            String mediaButtonReceiver = Settings.Secure.getStringForUser(MediaSessionService.this.mContentResolver, "media_button_receiver", this.mFullUserId);
            if (mediaButtonReceiver == null) {
                return;
            }
            String[] tokens = mediaButtonReceiver.split(COMPONENT_NAME_USER_ID_DELIM);
            if (tokens == null || tokens.length != 2) {
                return;
            }
            this.mRestoredMediaButtonReceiver = ComponentName.unflattenFromString(tokens[0]);
            this.mRestoredMediaButtonReceiverUserId = Integer.parseInt(tokens[1]);
        }

        public void destroySessionsForUserLocked(int userId) {
            ArrayList<MediaSessionRecord> sessions = this.mPriorityStack.getPriorityList(false, userId);
            for (MediaSessionRecord session : sessions) {
                MediaSessionService.this.destroySessionLocked(session);
            }
        }

        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.print(prefix + "Record for full_user=" + this.mFullUserId);
            int size = MediaSessionService.this.mFullUserIds.size();
            for (int i = 0; i < size; ++i) {
                if (MediaSessionService.this.mFullUserIds.keyAt(i) == MediaSessionService.this.mFullUserIds.valueAt(i) || MediaSessionService.this.mFullUserIds.valueAt(i) != this.mFullUserId) continue;
                pw.print(", profile_user=" + MediaSessionService.this.mFullUserIds.keyAt(i));
            }
            pw.println();
            String indent = prefix + "  ";
            pw.println(indent + "Volume key long-press listener: " + this.mOnVolumeKeyLongPressListener);
            pw.println(indent + "Volume key long-press listener package: " + MediaSessionService.this.getCallingPackageName(this.mOnVolumeKeyLongPressListenerUid));
            pw.println(indent + "Media key listener: " + this.mOnMediaKeyListener);
            pw.println(indent + "Media key listener package: " + MediaSessionService.this.getCallingPackageName(this.mOnMediaKeyListenerUid));
            pw.println(indent + "Callback: " + this.mCallback);
            pw.println(indent + "Last MediaButtonReceiver: " + this.mLastMediaButtonReceiver);
            pw.println(indent + "Restored MediaButtonReceiver: " + this.mRestoredMediaButtonReceiver);
            this.mPriorityStack.dump(pw, indent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaButtonSessionChanged(MediaSessionRecord oldMediaButtonSession, MediaSessionRecord newMediaButtonSession) {
            Log.d(MediaSessionService.TAG, "Media button session is changed to " + newMediaButtonSession);
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                if (oldMediaButtonSession != null) {
                    MediaSessionService.this.mHandler.postSessionsChanged(oldMediaButtonSession.getUserId());
                }
                if (newMediaButtonSession != null) {
                    this.rememberMediaButtonReceiverLocked(newMediaButtonSession);
                    MediaSessionService.this.mHandler.postSessionsChanged(newMediaButtonSession.getUserId());
                }
                this.pushAddressedPlayerChangedLocked();
            }
        }

        public void rememberMediaButtonReceiverLocked(MediaSessionRecord record) {
            ComponentName component;
            PendingIntent receiver;
            this.mLastMediaButtonReceiver = receiver = record.getMediaButtonReceiver();
            this.mRestoredMediaButtonReceiver = null;
            String componentName = "";
            if (receiver != null && (component = receiver.getIntent().getComponent()) != null && record.getPackageName().equals(component.getPackageName())) {
                componentName = component.flattenToString();
            }
            Settings.Secure.putStringForUser(MediaSessionService.this.mContentResolver, "media_button_receiver", componentName + COMPONENT_NAME_USER_ID_DELIM + record.getUserId(), this.mFullUserId);
        }

        private void pushAddressedPlayerChangedLocked() {
            if (this.mCallback == null) {
                return;
            }
            try {
                MediaSessionRecord mediaButtonSession = this.getMediaButtonSessionLocked();
                if (mediaButtonSession != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaSession(new MediaSession.Token(mediaButtonSession.getControllerBinder()));
                } else if (((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mLastMediaButtonReceiver != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaButtonReceiver(((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mLastMediaButtonReceiver.getIntent().getComponent());
                } else if (((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mRestoredMediaButtonReceiver != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaButtonReceiver(((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mRestoredMediaButtonReceiver);
                }
            }
            catch (RemoteException e) {
                Log.w(MediaSessionService.TAG, "Failed to pushAddressedPlayerChangedLocked", e);
            }
        }

        private MediaSessionRecord getMediaButtonSessionLocked() {
            return MediaSessionService.this.isGlobalPriorityActiveLocked() ? MediaSessionService.this.mGlobalPrioritySession : this.mPriorityStack.getMediaButtonSession();
        }
    }
}

