/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.media.session.MediaSession;
import android.os.Debug;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseArray;
import com.android.server.media.AudioPlayerStateMonitor;
import com.android.server.media.MediaSessionRecord;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class MediaSessionStack {
    private static final boolean DEBUG = MediaSessionService.DEBUG;
    private static final String TAG = "MediaSessionStack";
    private static final int[] ALWAYS_PRIORITY_STATES = new int[]{4, 5, 9, 10};
    private static final int[] TRANSITION_PRIORITY_STATES = new int[]{6, 8, 3};
    private final List<MediaSessionRecord> mSessions = new ArrayList<MediaSessionRecord>();
    private final AudioPlayerStateMonitor mAudioPlayerStateMonitor;
    private final OnMediaButtonSessionChangedListener mOnMediaButtonSessionChangedListener;
    private MediaSessionRecord mMediaButtonSession;
    private MediaSessionRecord mCachedVolumeDefault;
    private final SparseArray<ArrayList<MediaSessionRecord>> mCachedActiveLists = new SparseArray();

    MediaSessionStack(AudioPlayerStateMonitor monitor, OnMediaButtonSessionChangedListener listener) {
        this.mAudioPlayerStateMonitor = monitor;
        this.mOnMediaButtonSessionChangedListener = listener;
    }

    public void addSession(MediaSessionRecord record) {
        this.mSessions.add(record);
        this.clearCache(record.getUserId());
        this.updateMediaButtonSessionIfNeeded();
    }

    public void removeSession(MediaSessionRecord record) {
        this.mSessions.remove(record);
        if (this.mMediaButtonSession == record) {
            this.updateMediaButtonSession(null);
        }
        this.clearCache(record.getUserId());
    }

    public boolean contains(MediaSessionRecord record) {
        return this.mSessions.contains(record);
    }

    public void onPlaystateChanged(MediaSessionRecord record, int oldState, int newState) {
        MediaSessionRecord newMediaButtonSession;
        if (this.shouldUpdatePriority(oldState, newState)) {
            this.mSessions.remove(record);
            this.mSessions.add(0, record);
            this.clearCache(record.getUserId());
        } else if (!MediaSession.isActiveState(newState)) {
            this.mCachedVolumeDefault = null;
        }
        if (this.mMediaButtonSession != null && this.mMediaButtonSession.getUid() == record.getUid() && (newMediaButtonSession = this.findMediaButtonSession(this.mMediaButtonSession.getUid())) != this.mMediaButtonSession) {
            this.updateMediaButtonSession(newMediaButtonSession);
        }
    }

    public void onSessionStateChange(MediaSessionRecord record) {
        this.clearCache(record.getUserId());
    }

    public void updateMediaButtonSessionIfNeeded() {
        if (DEBUG) {
            Log.d(TAG, "updateMediaButtonSessionIfNeeded, callers=" + Debug.getCallers(2));
        }
        IntArray audioPlaybackUids = this.mAudioPlayerStateMonitor.getSortedAudioPlaybackClientUids();
        for (int i = 0; i < audioPlaybackUids.size(); ++i) {
            MediaSessionRecord mediaButtonSession = this.findMediaButtonSession(audioPlaybackUids.get(i));
            if (mediaButtonSession == null) continue;
            this.mAudioPlayerStateMonitor.cleanUpAudioPlaybackUids(mediaButtonSession.getUid());
            if (this.mMediaButtonSession != mediaButtonSession) {
                this.updateMediaButtonSession(mediaButtonSession);
            }
            return;
        }
    }

    private MediaSessionRecord findMediaButtonSession(int uid) {
        MediaSessionRecord mediaButtonSession = null;
        for (MediaSessionRecord session : this.mSessions) {
            if (uid != session.getUid()) continue;
            if (session.getPlaybackState() != null && session.isPlaybackActive() == this.mAudioPlayerStateMonitor.isPlaybackActive(session.getUid())) {
                return session;
            }
            if (mediaButtonSession != null) continue;
            mediaButtonSession = session;
        }
        return mediaButtonSession;
    }

    public ArrayList<MediaSessionRecord> getActiveSessions(int userId) {
        ArrayList<MediaSessionRecord> cachedActiveList = this.mCachedActiveLists.get(userId);
        if (cachedActiveList == null) {
            cachedActiveList = this.getPriorityList(true, userId);
            this.mCachedActiveLists.put(userId, cachedActiveList);
        }
        return cachedActiveList;
    }

    public MediaSessionRecord getMediaButtonSession() {
        return this.mMediaButtonSession;
    }

    private void updateMediaButtonSession(MediaSessionRecord newMediaButtonSession) {
        MediaSessionRecord oldMediaButtonSession = this.mMediaButtonSession;
        this.mMediaButtonSession = newMediaButtonSession;
        this.mOnMediaButtonSessionChangedListener.onMediaButtonSessionChanged(oldMediaButtonSession, newMediaButtonSession);
    }

    public MediaSessionRecord getDefaultVolumeSession() {
        if (this.mCachedVolumeDefault != null) {
            return this.mCachedVolumeDefault;
        }
        ArrayList<MediaSessionRecord> records = this.getPriorityList(true, -1);
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord record = records.get(i);
            if (!record.isPlaybackActive()) continue;
            this.mCachedVolumeDefault = record;
            return record;
        }
        return null;
    }

    public MediaSessionRecord getDefaultRemoteSession(int userId) {
        ArrayList<MediaSessionRecord> records = this.getPriorityList(true, userId);
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord record = records.get(i);
            if (record.getPlaybackType() != 2) continue;
            return record;
        }
        return null;
    }

    public void dump(PrintWriter pw, String prefix) {
        ArrayList<MediaSessionRecord> sortedSessions = this.getPriorityList(false, -1);
        int count = sortedSessions.size();
        pw.println(prefix + "Media button session is " + this.mMediaButtonSession);
        pw.println(prefix + "Sessions Stack - have " + count + " sessions:");
        String indent = prefix + "  ";
        for (int i = 0; i < count; ++i) {
            MediaSessionRecord record = sortedSessions.get(i);
            record.dump(pw, indent);
            pw.println();
        }
    }

    public ArrayList<MediaSessionRecord> getPriorityList(boolean activeOnly, int userId) {
        ArrayList<MediaSessionRecord> result = new ArrayList<MediaSessionRecord>();
        int lastPlaybackActiveIndex = 0;
        int lastActiveIndex = 0;
        int size = this.mSessions.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord session = this.mSessions.get(i);
            if (userId != -1 && userId != session.getUserId()) continue;
            if (!session.isActive()) {
                if (activeOnly) continue;
                result.add(session);
                continue;
            }
            if (session.isPlaybackActive()) {
                result.add(lastPlaybackActiveIndex++, session);
                ++lastActiveIndex;
                continue;
            }
            result.add(lastActiveIndex++, session);
        }
        return result;
    }

    private boolean shouldUpdatePriority(int oldState, int newState) {
        if (this.containsState(newState, ALWAYS_PRIORITY_STATES)) {
            return true;
        }
        return !this.containsState(oldState, TRANSITION_PRIORITY_STATES) && this.containsState(newState, TRANSITION_PRIORITY_STATES);
    }

    private boolean containsState(int state, int[] states) {
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != state) continue;
            return true;
        }
        return false;
    }

    private void clearCache(int userId) {
        this.mCachedVolumeDefault = null;
        this.mCachedActiveLists.remove(userId);
        this.mCachedActiveLists.remove(-1);
    }

    static interface OnMediaButtonSessionChangedListener {
        public void onMediaButtonSessionChanged(MediaSessionRecord var1, MediaSessionRecord var2);
    }
}

