/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import android.util.Log;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;

public class ZenModeExtractor
implements NotificationSignalExtractor {
    private static final String TAG = "ZenModeExtractor";
    private static final boolean DBG = Log.isLoggable("ZenModeExtractor", 3);
    private ZenModeHelper mZenModeHelper;

    @Override
    public void initialize(Context ctx, NotificationUsageStats usageStats) {
        if (DBG) {
            Slog.d(TAG, "Initializing  " + this.getClass().getSimpleName() + ".");
        }
    }

    @Override
    public RankingReconsideration process(NotificationRecord record) {
        if (record == null || record.getNotification() == null) {
            if (DBG) {
                Slog.d(TAG, "skipping empty notification");
            }
            return null;
        }
        if (this.mZenModeHelper == null) {
            if (DBG) {
                Slog.d(TAG, "skipping - no zen info available");
            }
            return null;
        }
        record.setIntercepted(this.mZenModeHelper.shouldIntercept(record));
        if (record.isIntercepted()) {
            record.setSuppressedVisualEffects(this.mZenModeHelper.getNotificationPolicy().suppressedVisualEffects);
        } else {
            record.setSuppressedVisualEffects(0);
        }
        return null;
    }

    @Override
    public void setConfig(RankingConfig config) {
    }

    @Override
    public void setZenHelper(ZenModeHelper helper) {
        this.mZenModeHelper = helper;
    }
}

