/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AppOpsManager;
import android.app.AutomaticZenRule;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.AudioManagerInternal;
import android.media.VolumePolicy;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.server.LocalServices;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.EventConditionProvider;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.ScheduleConditionProvider;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeConditions;
import com.android.server.notification.ZenModeFiltering;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeHelper {
    static final String TAG = "ZenModeHelper";
    static final boolean DEBUG = Log.isLoggable("ZenModeHelper", 3);
    private static final int RULE_INSTANCE_GRACE_PERIOD = 259200000;
    private final Context mContext;
    private final H mHandler;
    private final SettingsObserver mSettingsObserver;
    @VisibleForTesting
    protected final AppOpsManager mAppOps;
    @VisibleForTesting
    protected final NotificationManager mNotificationManager;
    protected ZenModeConfig mDefaultConfig;
    private final ArrayList<Callback> mCallbacks = new ArrayList();
    private final ZenModeFiltering mFiltering;
    protected final RingerModeDelegate mRingerModeDelegate = new RingerModeDelegate();
    private final ZenModeConditions mConditions;
    private final SparseArray<ZenModeConfig> mConfigs = new SparseArray();
    private final Metrics mMetrics = new Metrics();
    private final ManagedServices.Config mServiceConfig;
    @VisibleForTesting
    protected int mZenMode;
    private int mUser = 0;
    @VisibleForTesting
    protected ZenModeConfig mConfig;
    @VisibleForTesting
    protected AudioManagerInternal mAudioManager;
    protected PackageManager mPm;
    private long mSuppressedEffects;
    public static final long SUPPRESSED_EFFECT_NOTIFICATIONS = 1L;
    public static final long SUPPRESSED_EFFECT_CALLS = 2L;
    public static final long SUPPRESSED_EFFECT_ALL = 3L;
    protected String mDefaultRuleEveryNightName;
    protected String mDefaultRuleEventsName;
    @VisibleForTesting
    protected boolean mIsBootComplete;

    public ZenModeHelper(Context context, Looper looper, ConditionProviders conditionProviders) {
        this.mContext = context;
        this.mHandler = new H(looper);
        this.addCallback(this.mMetrics);
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mNotificationManager = context.getSystemService(NotificationManager.class);
        this.mDefaultConfig = new ZenModeConfig();
        this.setDefaultZenRules(this.mContext);
        this.mConfig = this.mDefaultConfig;
        this.mConfigs.put(0, this.mConfig);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mFiltering = new ZenModeFiltering(this.mContext);
        this.mConditions = new ZenModeConditions(this, conditionProviders);
        this.mServiceConfig = conditionProviders.getConfig();
    }

    public Looper getLooper() {
        return this.mHandler.getLooper();
    }

    public String toString() {
        return TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchesCallFilter(UserHandle userHandle, Bundle extras, ValidateNotificationPeople validator, int contactsTimeoutMs, float timeoutAffinity) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return ZenModeFiltering.matchesCallFilter(this.mContext, this.mZenMode, this.mConfig, userHandle, extras, validator, contactsTimeoutMs, timeoutAffinity);
        }
    }

    public boolean isCall(NotificationRecord record) {
        return this.mFiltering.isCall(record);
    }

    public void recordCaller(NotificationRecord record) {
        this.mFiltering.recordCall(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldIntercept(NotificationRecord record) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return this.mFiltering.shouldIntercept(this.mZenMode, this.mConfig, record);
        }
    }

    public void addCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void initZenMode() {
        if (DEBUG) {
            Log.d(TAG, "initZenMode");
        }
        this.evaluateZenMode("init", true);
    }

    public void onSystemReady() {
        if (DEBUG) {
            Log.d(TAG, "onSystemReady");
        }
        this.mAudioManager = LocalServices.getService(AudioManagerInternal.class);
        if (this.mAudioManager != null) {
            this.mAudioManager.setRingerModeDelegate(this.mRingerModeDelegate);
        }
        this.mPm = this.mContext.getPackageManager();
        this.mHandler.postMetricsTimer();
        this.cleanUpZenRules();
        this.evaluateZenMode("onSystemReady", true);
        this.mIsBootComplete = true;
        this.showZenUpgradeNotification(this.mZenMode);
    }

    public void onUserSwitched(int user) {
        this.loadConfigForUser(user, "onUserSwitched");
    }

    public void onUserRemoved(int user) {
        if (user < 0) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "onUserRemoved u=" + user);
        }
        this.mConfigs.remove(user);
    }

    public void onUserUnlocked(int user) {
        this.loadConfigForUser(user, "onUserUnlocked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigForUser(int user, String reason) {
        ZenModeConfig config;
        if (this.mUser == user || user < 0) {
            return;
        }
        this.mUser = user;
        if (DEBUG) {
            Log.d(TAG, reason + " u=" + user);
        }
        if ((config = this.mConfigs.get(user)) == null) {
            if (DEBUG) {
                Log.d(TAG, reason + " generating default config for user " + user);
            }
            config = this.mDefaultConfig.copy();
            config.user = user;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            this.setConfigLocked(config, null, reason);
        }
        this.cleanUpZenRules();
    }

    public int getZenModeListenerInterruptionFilter() {
        return NotificationManager.zenModeToInterruptionFilter(this.mZenMode);
    }

    public void requestFromListener(ComponentName name, int filter) {
        int newZen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
        if (newZen != -1) {
            this.setManualZenMode(newZen, null, name != null ? name.getPackageName() : null, "listener:" + (name != null ? name.flattenToShortString() : null));
        }
    }

    public void setSuppressedEffects(long suppressedEffects) {
        if (this.mSuppressedEffects == suppressedEffects) {
            return;
        }
        this.mSuppressedEffects = suppressedEffects;
        this.applyRestrictions();
    }

    public long getSuppressedEffects() {
        return this.mSuppressedEffects;
    }

    public int getZenMode() {
        return this.mZenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZenModeConfig.ZenRule> getZenRules() {
        ArrayList<ZenModeConfig.ZenRule> rules = new ArrayList<ZenModeConfig.ZenRule>();
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return rules;
            }
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (!this.canManageAutomaticZenRule(rule)) continue;
                rules.add(rule);
            }
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutomaticZenRule getAutomaticZenRule(String id2) {
        ZenModeConfig.ZenRule rule;
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return null;
            }
            rule = this.mConfig.automaticRules.get(id2);
        }
        if (rule == null) {
            return null;
        }
        if (this.canManageAutomaticZenRule(rule)) {
            return this.createAutomaticZenRule(rule);
        }
        return null;
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule, String reason) {
        if (!this.isSystemRule(automaticZenRule)) {
            ServiceInfo owner = this.getServiceInfo(automaticZenRule.getOwner());
            if (owner == null) {
                throw new IllegalArgumentException("Owner is not a condition provider service");
            }
            int ruleInstanceLimit = -1;
            if (owner.metaData != null) {
                ruleInstanceLimit = owner.metaData.getInt("android.service.zen.automatic.ruleInstanceLimit", -1);
            }
            if (ruleInstanceLimit > 0 && ruleInstanceLimit < this.getCurrentInstanceCount(automaticZenRule.getOwner()) + 1) {
                throw new IllegalArgumentException("Rule instance limit exceeded");
            }
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                throw new AndroidRuntimeException("Could not create rule");
            }
            if (DEBUG) {
                Log.d(TAG, "addAutomaticZenRule rule= " + automaticZenRule + " reason=" + reason);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
            this.populateZenRule(automaticZenRule, rule, true);
            newConfig.automaticRules.put(rule.id, rule);
            if (this.setConfigLocked(newConfig, reason, rule.component, true)) {
                return rule.id;
            }
            throw new AndroidRuntimeException("Could not create rule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAutomaticZenRule(String ruleId, AutomaticZenRule automaticZenRule, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            if (DEBUG) {
                Log.d(TAG, "updateAutomaticZenRule zenRule=" + automaticZenRule + " reason=" + reason);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            if (ruleId == null) {
                throw new IllegalArgumentException("Rule doesn't exist");
            }
            ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(ruleId);
            if (rule == null || !this.canManageAutomaticZenRule(rule)) {
                throw new SecurityException("Cannot update rules not owned by your condition provider");
            }
            this.populateZenRule(automaticZenRule, rule, false);
            newConfig.automaticRules.put(ruleId, rule);
            return this.setConfigLocked(newConfig, reason, rule.component, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAutomaticZenRule(String id2, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(id2);
            if (rule == null) {
                return false;
            }
            if (this.canManageAutomaticZenRule(rule)) {
                newConfig.automaticRules.remove(id2);
                if (DEBUG) {
                    Log.d(TAG, "removeZenRule zenRule=" + id2 + " reason=" + reason);
                }
            } else {
                throw new SecurityException("Cannot delete rules not owned by your condition provider");
            }
            return this.setConfigLocked(newConfig, reason, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAutomaticZenRules(String packageName, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            for (int i = newConfig.automaticRules.size() - 1; i >= 0; --i) {
                ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(newConfig.automaticRules.keyAt(i));
                if (!rule.component.getPackageName().equals(packageName) || !this.canManageAutomaticZenRule(rule)) continue;
                newConfig.automaticRules.removeAt(i);
            }
            return this.setConfigLocked(newConfig, reason, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentInstanceCount(ComponentName owner) {
        int count = 0;
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (rule.component == null || !rule.component.equals(owner)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean canManageAutomaticZenRule(ZenModeConfig.ZenRule rule) {
        int callingUid = Binder.getCallingUid();
        if (callingUid == 0 || callingUid == 1000) {
            return true;
        }
        if (this.mContext.checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS") == 0) {
            return true;
        }
        String[] packages = this.mPm.getPackagesForUid(Binder.getCallingUid());
        if (packages != null) {
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!packages[i].equals(rule.component.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setDefaultZenRules(Context context) {
        this.mDefaultConfig = this.readDefaultConfig(context.getResources());
        this.appendDefaultRules(this.mDefaultConfig);
    }

    private void appendDefaultRules(ZenModeConfig config) {
        this.getDefaultRuleNames();
        this.appendDefaultEveryNightRule(config);
        this.appendDefaultEventRules(config);
    }

    private boolean ruleValuesEqual(AutomaticZenRule rule, ZenModeConfig.ZenRule defaultRule) {
        if (rule == null || defaultRule == null) {
            return false;
        }
        return rule.getInterruptionFilter() == NotificationManager.zenModeToInterruptionFilter(defaultRule.zenMode) && rule.getConditionId().equals(defaultRule.conditionId) && rule.getOwner().equals(defaultRule.component);
    }

    protected void updateDefaultZenRules() {
        ZenModeConfig configDefaultRules = new ZenModeConfig();
        this.appendDefaultRules(configDefaultRules);
        for (String ruleId : ZenModeConfig.DEFAULT_RULE_IDS) {
            ZenModeConfig.ZenRule defaultRule;
            AutomaticZenRule currRule = this.getAutomaticZenRule(ruleId);
            if (!this.ruleValuesEqual(currRule, defaultRule = configDefaultRules.automaticRules.get(ruleId)) || defaultRule.name.equals(currRule.getName()) || !this.canManageAutomaticZenRule(defaultRule)) continue;
            if (DEBUG) {
                Slog.d(TAG, "Locale change - updating default zen rule name from " + currRule.getName() + " to " + defaultRule.name);
            }
            AutomaticZenRule defaultAutoRule = this.createAutomaticZenRule(defaultRule);
            defaultAutoRule.setEnabled(currRule.isEnabled());
            this.updateAutomaticZenRule(ruleId, defaultAutoRule, "locale changed");
        }
    }

    private boolean isSystemRule(AutomaticZenRule rule) {
        return "android".equals(rule.getOwner().getPackageName());
    }

    private ServiceInfo getServiceInfo(ComponentName owner) {
        Intent queryIntent = new Intent();
        queryIntent.setComponent(owner);
        List<ResolveInfo> installedServices = this.mPm.queryIntentServicesAsUser(queryIntent, 132, UserHandle.getCallingUserId());
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                if (!this.mServiceConfig.bindPermission.equals(info.permission)) continue;
                return info;
            }
        }
        return null;
    }

    private void populateZenRule(AutomaticZenRule automaticZenRule, ZenModeConfig.ZenRule rule, boolean isNew) {
        if (isNew) {
            rule.id = ZenModeConfig.newRuleId();
            rule.creationTime = System.currentTimeMillis();
            rule.component = automaticZenRule.getOwner();
        }
        if (rule.enabled != automaticZenRule.isEnabled()) {
            rule.snoozing = false;
        }
        rule.name = automaticZenRule.getName();
        rule.condition = null;
        rule.conditionId = automaticZenRule.getConditionId();
        rule.enabled = automaticZenRule.isEnabled();
        rule.zenMode = NotificationManager.zenModeFromInterruptionFilter(automaticZenRule.getInterruptionFilter(), 0);
    }

    protected AutomaticZenRule createAutomaticZenRule(ZenModeConfig.ZenRule rule) {
        return new AutomaticZenRule(rule.name, rule.component, rule.conditionId, NotificationManager.zenModeToInterruptionFilter(rule.zenMode), rule.enabled, rule.creationTime);
    }

    public void setManualZenMode(int zenMode, Uri conditionId, String caller, String reason) {
        this.setManualZenMode(zenMode, conditionId, reason, caller, true);
        Settings.Global.putInt(this.mContext.getContentResolver(), "show_zen_settings_suggestion", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setManualZenMode(int zenMode, Uri conditionId, String reason, String caller, boolean setRingerMode) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return;
            }
            if (!Settings.Global.isValidZenMode(zenMode)) {
                return;
            }
            if (DEBUG) {
                Log.d(TAG, "setManualZenMode " + Settings.Global.zenModeToString(zenMode) + " conditionId=" + conditionId + " reason=" + reason + " setRingerMode=" + setRingerMode);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            if (zenMode == 0) {
                newConfig.manualRule = null;
                for (ZenModeConfig.ZenRule automaticRule : newConfig.automaticRules.values()) {
                    if (!automaticRule.isAutomaticActive()) continue;
                    automaticRule.snoozing = true;
                }
            } else {
                ZenModeConfig.ZenRule newRule = new ZenModeConfig.ZenRule();
                newRule.enabled = true;
                newRule.zenMode = zenMode;
                newRule.conditionId = conditionId;
                newRule.enabler = caller;
                newConfig.manualRule = newRule;
            }
            this.setConfigLocked(newConfig, reason, null, setRingerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(ProtoOutputStream proto) {
        proto.write(0x10E00000001L, this.mZenMode);
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig.manualRule != null) {
                this.mConfig.manualRule.writeToProto(proto, 0x20B00000002L);
            }
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (!rule.enabled || rule.condition.state != 1 || rule.snoozing) continue;
                rule.writeToProto(proto, 0x20B00000002L);
            }
            this.mConfig.toNotificationPolicy().writeToProto(proto, 1146756268037L);
            proto.write(1120986464259L, this.mSuppressedEffects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mZenMode=");
        pw.println(Settings.Global.zenModeToString(this.mZenMode));
        int N = this.mConfigs.size();
        for (int i = 0; i < N; ++i) {
            ZenModeHelper.dump(pw, prefix, "mConfigs[u=" + this.mConfigs.keyAt(i) + "]", this.mConfigs.valueAt(i));
        }
        pw.print(prefix);
        pw.print("mUser=");
        pw.println(this.mUser);
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeHelper.dump(pw, prefix, "mConfig", this.mConfig);
        }
        pw.print(prefix);
        pw.print("mSuppressedEffects=");
        pw.println(this.mSuppressedEffects);
        this.mFiltering.dump(pw, prefix);
        this.mConditions.dump(pw, prefix);
    }

    private static void dump(PrintWriter pw, String prefix, String var, ZenModeConfig config) {
        pw.print(prefix);
        pw.print(var);
        pw.print('=');
        if (config == null) {
            pw.println(config);
            return;
        }
        pw.printf("allow(alarms=%b,media=%b,system=%b,calls=%b,callsFrom=%s,repeatCallers=%b,messages=%b,messagesFrom=%s,events=%b,reminders=%b)\n", config.allowAlarms, config.allowMedia, config.allowSystem, config.allowCalls, ZenModeConfig.sourceToString(config.allowCallsFrom), config.allowRepeatCallers, config.allowMessages, ZenModeConfig.sourceToString(config.allowMessagesFrom), config.allowEvents, config.allowReminders);
        pw.printf(" disallow(visualEffects=%s)\n", config.suppressedVisualEffects);
        pw.print(prefix);
        pw.print("  manualRule=");
        pw.println(config.manualRule);
        if (config.automaticRules.isEmpty()) {
            return;
        }
        int N = config.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            pw.print(prefix);
            pw.print(i == 0 ? "  automaticRules=" : "                 ");
            pw.println(config.automaticRules.valueAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        ZenModeConfig config = ZenModeConfig.readXml(parser);
        String reason = "readXml";
        if (config != null) {
            if (forRestore) {
                if (config.user != 0) {
                    return;
                }
                config.manualRule = null;
            }
            boolean resetToDefaultRules = true;
            long time = System.currentTimeMillis();
            if (config.automaticRules != null && config.automaticRules.size() > 0) {
                for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
                    if (forRestore) {
                        automaticRule.snoozing = false;
                        automaticRule.condition = null;
                        automaticRule.creationTime = time;
                    }
                    resetToDefaultRules &= !automaticRule.enabled;
                }
            }
            if (config.version < 8 || forRestore) {
                Settings.Global.putInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 1);
                if (resetToDefaultRules) {
                    config.automaticRules = new ArrayMap();
                    this.appendDefaultRules(config);
                    reason = reason + ", reset to default rules";
                }
            } else {
                Settings.Global.putInt(this.mContext.getContentResolver(), "zen_settings_updated", 1);
            }
            if (DEBUG) {
                Log.d(TAG, reason);
            }
            ZenModeConfig zenModeConfig = this.mConfig;
            synchronized (zenModeConfig) {
                this.setConfigLocked(config, null, reason);
            }
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup, Integer version) throws IOException {
        int N = this.mConfigs.size();
        for (int i = 0; i < N; ++i) {
            if (forBackup && this.mConfigs.keyAt(i) != 0) continue;
            this.mConfigs.valueAt(i).writeXml(out, version);
        }
    }

    public NotificationManager.Policy getNotificationPolicy() {
        return ZenModeHelper.getNotificationPolicy(this.mConfig);
    }

    private static NotificationManager.Policy getNotificationPolicy(ZenModeConfig config) {
        return config == null ? null : config.toNotificationPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null || this.mConfig == null) {
            return;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeConfig newConfig = this.mConfig.copy();
            newConfig.applyNotificationPolicy(policy);
            this.setConfigLocked(newConfig, null, "setNotificationPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpZenRules() {
        long currentTime = System.currentTimeMillis();
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeConfig newConfig = this.mConfig.copy();
            if (newConfig.automaticRules != null) {
                for (int i = newConfig.automaticRules.size() - 1; i >= 0; --i) {
                    ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(newConfig.automaticRules.keyAt(i));
                    if (259200000L >= currentTime - rule.creationTime) continue;
                    try {
                        this.mPm.getPackageInfo(rule.component.getPackageName(), 0x400000);
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        newConfig.automaticRules.removeAt(i);
                    }
                }
            }
            this.setConfigLocked(newConfig, null, "cleanUpZenRules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenModeConfig getConfig() {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return this.mConfig.copy();
        }
    }

    public boolean setConfigLocked(ZenModeConfig config, ComponentName triggeringComponent, String reason) {
        return this.setConfigLocked(config, reason, triggeringComponent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(ZenModeConfig config, ComponentName triggeringComponent, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            this.setConfigLocked(config, triggeringComponent, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setConfigLocked(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
        long identity = Binder.clearCallingIdentity();
        try {
            boolean policyChanged;
            if (config == null || !config.isValid()) {
                Log.w(TAG, "Invalid config in setConfigLocked; " + config);
                boolean bl = false;
                return bl;
            }
            if (config.user != this.mUser) {
                this.mConfigs.put(config.user, config);
                if (DEBUG) {
                    Log.d(TAG, "setConfigLocked: store config for user " + config.user);
                }
                boolean bl = true;
                return bl;
            }
            this.mConditions.evaluateConfig(config, null, false);
            this.mConfigs.put(config.user, config);
            if (DEBUG) {
                Log.d(TAG, "setConfigLocked reason=" + reason, new Throwable());
            }
            ZenLog.traceConfig(reason, this.mConfig, config);
            boolean bl = policyChanged = !Objects.equals(ZenModeHelper.getNotificationPolicy(this.mConfig), ZenModeHelper.getNotificationPolicy(config));
            if (!config.equals(this.mConfig)) {
                this.dispatchOnConfigChanged();
            }
            if (policyChanged) {
                this.dispatchOnPolicyChanged();
            }
            this.mConfig = config;
            this.mHandler.postApplyConfig(config, reason, triggeringComponent, setRingerMode);
            boolean bl2 = true;
            return bl2;
        }
        catch (SecurityException e) {
            Log.wtf(TAG, "Invalid rule in config", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void applyConfig(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
        String val = Integer.toString(config.hashCode());
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_config_etag", val);
        if (!this.evaluateZenMode(reason, setRingerMode)) {
            this.applyRestrictions();
        }
        this.mConditions.evaluateConfig(config, triggeringComponent, true);
    }

    private int getZenModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode", 0);
    }

    @VisibleForTesting
    protected void setZenModeSetting(int zen) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "zen_mode", zen);
        this.showZenUpgradeNotification(zen);
    }

    private int getPreviousRingerModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode_ringer_level", 2);
    }

    private void setPreviousRingerModeSetting(Integer previousRingerLevel) {
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_ringer_level", previousRingerLevel == null ? null : Integer.toString(previousRingerLevel));
    }

    @VisibleForTesting
    protected boolean evaluateZenMode(String reason, boolean setRingerMode) {
        if (DEBUG) {
            Log.d(TAG, "evaluateZenMode");
        }
        int zenBefore = this.mZenMode;
        int zen = this.computeZenMode();
        ZenLog.traceSetZenMode(zen, reason);
        this.mZenMode = zen;
        this.setZenModeSetting(this.mZenMode);
        this.updateRingerModeAffectedStreams();
        if (setRingerMode && zen != zenBefore) {
            this.applyZenToRingerMode();
        }
        this.applyRestrictions();
        if (zen != zenBefore) {
            this.mHandler.postDispatchOnZenModeChanged();
        }
        return true;
    }

    private void updateRingerModeAffectedStreams() {
        if (this.mAudioManager != null) {
            this.mAudioManager.updateRingerModeAffectedStreamsInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeZenMode() {
        if (this.mConfig == null) {
            return 0;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig.manualRule != null) {
                return this.mConfig.manualRule.zenMode;
            }
            int zen = 0;
            for (ZenModeConfig.ZenRule automaticRule : this.mConfig.automaticRules.values()) {
                if (!automaticRule.isAutomaticActive() || ZenModeHelper.zenSeverity(automaticRule.zenMode) <= ZenModeHelper.zenSeverity(zen)) continue;
                if (Settings.Global.getInt(this.mContext.getContentResolver(), "zen_settings_suggestion_viewed", 1) == 0) {
                    Settings.Global.putInt(this.mContext.getContentResolver(), "show_zen_settings_suggestion", 1);
                }
                zen = automaticRule.zenMode;
            }
            return zen;
        }
    }

    private void getDefaultRuleNames() {
        this.mDefaultRuleEveryNightName = this.mContext.getResources().getString(17041143);
        this.mDefaultRuleEventsName = this.mContext.getResources().getString(17041142);
    }

    @VisibleForTesting
    protected void applyRestrictions() {
        boolean zenPriorityOnly = this.mZenMode == 1;
        boolean zenSilence = this.mZenMode == 2;
        boolean zenAlarmsOnly = this.mZenMode == 3;
        boolean muteNotifications = (this.mSuppressedEffects & 1L) != 0L;
        boolean muteCalls = zenAlarmsOnly || zenPriorityOnly && !this.mConfig.allowCalls && !this.mConfig.allowRepeatCallers || (this.mSuppressedEffects & 2L) != 0L;
        boolean muteAlarms = zenPriorityOnly && !this.mConfig.allowAlarms;
        boolean muteMedia = zenPriorityOnly && !this.mConfig.allowMedia;
        boolean muteSystem = zenAlarmsOnly || zenPriorityOnly && !this.mConfig.allowSystem;
        boolean muteEverything = zenSilence || zenPriorityOnly && ZenModeConfig.areAllZenBehaviorSoundsMuted(this.mConfig);
        for (int usage : AudioAttributes.SDK_USAGES) {
            int suppressionBehavior = AudioAttributes.SUPPRESSIBLE_USAGES.get(usage);
            if (suppressionBehavior == 3) {
                this.applyRestrictions(false, usage);
                continue;
            }
            if (suppressionBehavior == 1) {
                this.applyRestrictions(muteNotifications || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 2) {
                this.applyRestrictions(muteCalls || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 4) {
                this.applyRestrictions(muteAlarms || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 5) {
                this.applyRestrictions(muteMedia || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 6) {
                if (usage == 13) {
                    this.applyRestrictions(muteSystem || muteEverything, usage, 28);
                    this.applyRestrictions(false, usage, 3);
                    continue;
                }
                this.applyRestrictions(muteSystem || muteEverything, usage);
                continue;
            }
            this.applyRestrictions(muteEverything, usage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void applyRestrictions(boolean mute, int usage, int code) {
        String[] exceptionPackages = null;
        if (Process.myUid() == 1000) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mAppOps.setRestriction(code, usage, mute ? 1 : 0, exceptionPackages);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    @VisibleForTesting
    protected void applyRestrictions(boolean mute, int usage) {
        this.applyRestrictions(mute, usage, 3);
        this.applyRestrictions(mute, usage, 28);
    }

    @VisibleForTesting
    protected void applyZenToRingerMode() {
        int ringerModeInternal;
        if (this.mAudioManager == null) {
            return;
        }
        int newRingerModeInternal = ringerModeInternal = this.mAudioManager.getRingerModeInternal();
        switch (this.mZenMode) {
            case 2: 
            case 3: {
                if (ringerModeInternal == 0) break;
                this.setPreviousRingerModeSetting(ringerModeInternal);
                newRingerModeInternal = 0;
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (ringerModeInternal != 0) break;
                newRingerModeInternal = this.getPreviousRingerModeSetting();
                this.setPreviousRingerModeSetting(null);
            }
        }
        if (newRingerModeInternal != -1) {
            this.mAudioManager.setRingerModeInternal(newRingerModeInternal, TAG);
        }
    }

    private void dispatchOnConfigChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onConfigChanged();
        }
    }

    private void dispatchOnPolicyChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onPolicyChanged();
        }
    }

    private void dispatchOnZenModeChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onZenModeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenModeConfig readDefaultConfig(Resources resources) {
        XmlResourceParser parser = null;
        try {
            parser = resources.getXml(0x1170007);
            while (parser.next() != 1) {
                ZenModeConfig config = ZenModeConfig.readXml(parser);
                if (config == null) continue;
                ZenModeConfig zenModeConfig = config;
                return zenModeConfig;
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Error reading default zen mode config from resource", e);
        }
        finally {
            IoUtils.closeQuietly(parser);
        }
        return new ZenModeConfig();
    }

    private void appendDefaultEveryNightRule(ZenModeConfig config) {
        if (config == null) {
            return;
        }
        ZenModeConfig.ScheduleInfo weeknights = new ZenModeConfig.ScheduleInfo();
        weeknights.days = ZenModeConfig.ALL_DAYS;
        weeknights.startHour = 22;
        weeknights.endHour = 7;
        weeknights.exitAtAlarm = true;
        ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
        rule.enabled = false;
        rule.name = this.mDefaultRuleEveryNightName;
        rule.conditionId = ZenModeConfig.toScheduleConditionId(weeknights);
        rule.zenMode = 1;
        rule.component = ScheduleConditionProvider.COMPONENT;
        rule.id = "EVERY_NIGHT_DEFAULT_RULE";
        rule.creationTime = System.currentTimeMillis();
        config.automaticRules.put(rule.id, rule);
    }

    private void appendDefaultEventRules(ZenModeConfig config) {
        if (config == null) {
            return;
        }
        ZenModeConfig.EventInfo events = new ZenModeConfig.EventInfo();
        events.calendar = null;
        events.reply = 1;
        ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
        rule.enabled = false;
        rule.name = this.mDefaultRuleEventsName;
        rule.conditionId = ZenModeConfig.toEventConditionId(events);
        rule.zenMode = 1;
        rule.component = EventConditionProvider.COMPONENT;
        rule.id = "EVENTS_DEFAULT_RULE";
        rule.creationTime = System.currentTimeMillis();
        config.automaticRules.put(rule.id, rule);
    }

    private static int zenSeverity(int zen) {
        switch (zen) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private void showZenUpgradeNotification(int zen) {
        boolean showNotification;
        boolean bl = showNotification = this.mIsBootComplete && zen != 0 && Settings.Global.getInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 0) != 0;
        if (showNotification) {
            this.mNotificationManager.notify(TAG, 48, this.createZenUpgradeNotification());
            Settings.Global.putInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 0);
        }
    }

    @VisibleForTesting
    protected Notification createZenUpgradeNotification() {
        Bundle extras = new Bundle();
        extras.putString("android.substName", this.mContext.getResources().getString(17039952));
        int title = 17041153;
        int content = 17041152;
        int drawable2 = 17302785;
        if (NotificationManager.Policy.areAllVisualEffectsSuppressed(this.getNotificationPolicy().suppressedVisualEffects)) {
            title = 17041155;
            content = 17041154;
            drawable2 = 17302344;
        }
        Intent onboardingIntent = new Intent("android.settings.ZEN_MODE_ONBOARDING");
        onboardingIntent.addFlags(0x10008000);
        return new Notification.Builder(this.mContext, SystemNotificationChannels.DO_NOT_DISTURB).setAutoCancel(true).setSmallIcon(17302738).setLargeIcon(Icon.createWithResource(this.mContext, drawable2)).setContentTitle(this.mContext.getResources().getString(title)).setContentText(this.mContext.getResources().getString(content)).setContentIntent(PendingIntent.getActivity(this.mContext, 0, onboardingIntent, 0x8000000)).setAutoCancel(true).setLocalOnly(true).addExtras(extras).setStyle(new Notification.BigTextStyle()).build();
    }

    public static class Callback {
        void onConfigChanged() {
        }

        void onZenModeChanged() {
        }

        void onPolicyChanged() {
        }
    }

    private final class H
    extends Handler {
        private static final int MSG_DISPATCH = 1;
        private static final int MSG_METRICS = 2;
        private static final int MSG_APPLY_CONFIG = 4;
        private static final long METRICS_PERIOD_MS = 21600000L;

        private H(Looper looper) {
            super(looper);
        }

        private void postDispatchOnZenModeChanged() {
            this.removeMessages(1);
            this.sendEmptyMessage(1);
        }

        private void postMetricsTimer() {
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(2, 21600000L);
        }

        private void postApplyConfig(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
            this.sendMessage(this.obtainMessage(4, new ConfigMessageData(config, reason, triggeringComponent, setRingerMode)));
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZenModeHelper.this.dispatchOnZenModeChanged();
                    break;
                }
                case 2: {
                    ZenModeHelper.this.mMetrics.emit();
                    break;
                }
                case 4: {
                    ConfigMessageData applyConfigData = (ConfigMessageData)msg.obj;
                    ZenModeHelper.this.applyConfig(applyConfigData.config, applyConfigData.reason, applyConfigData.triggeringComponent, applyConfigData.setRingerMode);
                }
            }
        }

        private final class ConfigMessageData {
            public final ZenModeConfig config;
            public ComponentName triggeringComponent;
            public final String reason;
            public final boolean setRingerMode;

            ConfigMessageData(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
                this.config = config;
                this.reason = reason;
                this.setRingerMode = setRingerMode;
                this.triggeringComponent = triggeringComponent;
            }
        }
    }

    private final class Metrics
    extends Callback {
        private static final String COUNTER_PREFIX = "dnd_mode_";
        private static final long MINIMUM_LOG_PERIOD_MS = 60000L;
        private int mPreviousZenMode = -1;
        private long mBeginningMs = 0L;

        private Metrics() {
        }

        @Override
        void onZenModeChanged() {
            this.emit();
        }

        private void emit() {
            ZenModeHelper.this.mHandler.postMetricsTimer();
            long now = SystemClock.elapsedRealtime();
            long since = now - this.mBeginningMs;
            if (this.mPreviousZenMode != ZenModeHelper.this.mZenMode || since > 60000L) {
                if (this.mPreviousZenMode != -1) {
                    MetricsLogger.count(ZenModeHelper.this.mContext, COUNTER_PREFIX + this.mPreviousZenMode, (int)since);
                }
                this.mPreviousZenMode = ZenModeHelper.this.mZenMode;
                this.mBeginningMs = now;
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri ZEN_MODE;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.ZEN_MODE = Settings.Global.getUriFor("zen_mode");
        }

        public void observe() {
            ContentResolver resolver = ZenModeHelper.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.ZEN_MODE, false, this);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            if (this.ZEN_MODE.equals(uri) && ZenModeHelper.this.mZenMode != ZenModeHelper.this.getZenModeSetting()) {
                if (DEBUG) {
                    Log.d(ZenModeHelper.TAG, "Fixing zen mode setting");
                }
                ZenModeHelper.this.setZenModeSetting(ZenModeHelper.this.mZenMode);
            }
        }
    }

    @VisibleForTesting
    protected final class RingerModeDelegate
    implements AudioManagerInternal.RingerModeDelegate {
        protected RingerModeDelegate() {
        }

        public String toString() {
            return ZenModeHelper.TAG;
        }

        @Override
        public int onSetRingerModeInternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeExternal, VolumePolicy policy) {
            boolean isChange = ringerModeOld != ringerModeNew;
            int ringerModeExternalOut = ringerModeNew;
            if (ZenModeHelper.this.mZenMode == 0 || ZenModeHelper.this.mZenMode == 1 && !ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig)) {
                ZenModeHelper.this.setPreviousRingerModeSetting(ringerModeNew);
            }
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (!isChange || !policy.doNotDisturbWhenSilent) break;
                    if (ZenModeHelper.this.mZenMode == 0) {
                        newZen = 1;
                    }
                    ZenModeHelper.this.setPreviousRingerModeSetting(ringerModeOld);
                    break;
                }
                case 1: 
                case 2: {
                    if (isChange && ringerModeOld == 0 && (ZenModeHelper.this.mZenMode == 2 || ZenModeHelper.this.mZenMode == 3 || ZenModeHelper.this.mZenMode == 1 && ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig))) {
                        newZen = 0;
                        break;
                    }
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    ringerModeExternalOut = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeInternal", null, false);
            }
            if (isChange || newZen != -1 || ringerModeExternal != ringerModeExternalOut) {
                ZenLog.traceSetRingerModeInternal(ringerModeOld, ringerModeNew, caller, ringerModeExternal, ringerModeExternalOut);
            }
            return ringerModeExternalOut;
        }

        @Override
        public int onSetRingerModeExternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeInternal, VolumePolicy policy) {
            int ringerModeInternalOut = ringerModeNew;
            boolean isChange = ringerModeOld != ringerModeNew;
            boolean isVibrate = ringerModeInternal == 1;
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (isChange) {
                        if (ZenModeHelper.this.mZenMode == 0) {
                            newZen = 1;
                        }
                        ringerModeInternalOut = isVibrate ? 1 : 0;
                        break;
                    }
                    ringerModeInternalOut = ringerModeInternal;
                    break;
                }
                case 1: 
                case 2: {
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    newZen = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeExternal", caller, false);
            }
            ZenLog.traceSetRingerModeExternal(ringerModeOld, ringerModeNew, caller, ringerModeInternal, ringerModeInternalOut);
            return ringerModeInternalOut;
        }

        @Override
        public boolean canVolumeDownEnterSilent() {
            return ZenModeHelper.this.mZenMode == 0;
        }

        @Override
        public int getRingerModeAffectedStreams(int streams) {
            streams |= 0x26;
            streams = ZenModeHelper.this.mZenMode == 2 ? (streams |= 0x18) : (streams &= 0xFFFFFFE7);
            streams = ZenModeHelper.this.mZenMode == 1 && ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig) ? (streams &= 0xFFFFFFFD) : (streams |= 2);
            return streams;
        }
    }
}

