/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.server.pm.ShortcutService;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;

public class ShortcutDumpFiles {
    private static final String TAG = "ShortcutService";
    private static final boolean DEBUG = false;
    private final ShortcutService mService;

    public ShortcutDumpFiles(ShortcutService service) {
        this.mService = service;
    }

    public boolean save(String filename, Consumer<PrintWriter> dumper) {
        try {
            File directory = this.mService.getDumpPath();
            directory.mkdirs();
            if (!directory.exists()) {
                Slog.e(TAG, "Failed to create directory: " + directory);
                return false;
            }
            File path = new File(directory, filename);
            try (PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(path)));){
                dumper.accept(pw);
            }
            return true;
        }
        catch (IOException | RuntimeException e) {
            Slog.w(TAG, "Failed to create dump file: " + filename, e);
            return false;
        }
    }

    public boolean save(String filename, byte[] utf8bytes) {
        return this.save(filename, pw -> pw.println(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(utf8bytes)).toString()));
    }

    public void dumpAll(PrintWriter pw) {
        try {
            File directory = this.mService.getDumpPath();
            File[] files = directory.listFiles(f -> f.isFile());
            if (!directory.exists() || ArrayUtils.isEmpty(files)) {
                pw.print("  No dump files found.");
                return;
            }
            Arrays.sort(files, Comparator.comparing(f -> f.getName()));
            for (File path : files) {
                pw.print("*** Dumping: ");
                pw.println(path.getName());
                pw.print("mtime: ");
                pw.println(ShortcutService.formatTime(path.lastModified()));
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path)));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        pw.println(line);
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            Slog.w(TAG, "Failed to print dump files", e);
        }
    }
}

