/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.ByteStringUtils;
import android.util.EventLog;
import android.util.PackageUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.Installer;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.PackageDexUsage;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

public class DexLogger
implements DexManager.Listener {
    private static final String TAG = "DexLogger";
    private static final int SNET_TAG = 1397638484;
    private static final String DCL_SUBTAG = "dcl";
    private final IPackageManager mPackageManager;
    private final Object mInstallLock;
    @GuardedBy(value="mInstallLock")
    private final Installer mInstaller;

    public static DexManager.Listener getListener(IPackageManager pms, Installer installer, Object installLock) {
        return new DexLogger(pms, installer, installLock);
    }

    @VisibleForTesting
    DexLogger(IPackageManager pms, Installer installer, Object installLock) {
        this.mPackageManager = pms;
        this.mInstaller = installer;
        this.mInstallLock = installLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReconcileSecondaryDexFile(ApplicationInfo appInfo, PackageDexUsage.DexUseInfo dexUseInfo, String dexPath, int storageFlags) {
        int ownerUid = appInfo.uid;
        byte[] hash = null;
        Object object = this.mInstallLock;
        synchronized (object) {
            try {
                hash = this.mInstaller.hashSecondaryDexFile(dexPath, appInfo.packageName, ownerUid, appInfo.volumeUuid, storageFlags);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Got InstallerException when hashing dex " + dexPath + " : " + e.getMessage());
            }
        }
        if (hash == null) {
            return;
        }
        String dexFileName = new File(dexPath).getName();
        String message = PackageUtils.computeSha256Digest(dexFileName.getBytes());
        if (hash.length == 32) {
            message = message + ' ' + ByteStringUtils.toHexString(hash);
        }
        this.writeDclEvent(ownerUid, message);
        if (dexUseInfo.isUsedByOtherApps()) {
            Set<String> otherPackages = dexUseInfo.getLoadingPackages();
            ArraySet<Integer> otherUids = new ArraySet<Integer>(otherPackages.size());
            for (String otherPackageName : otherPackages) {
                try {
                    int otherUid = this.mPackageManager.getPackageUid(otherPackageName, 0, dexUseInfo.getOwnerUserId());
                    if (otherUid == -1 || otherUid == ownerUid) continue;
                    otherUids.add(otherUid);
                }
                catch (RemoteException remoteException) {}
            }
            Iterator<String> iterator = otherUids.iterator();
            while (iterator.hasNext()) {
                int otherUid = (Integer)((Object)iterator.next());
                this.writeDclEvent(otherUid, message);
            }
        }
    }

    @VisibleForTesting
    void writeDclEvent(int uid, String message) {
        EventLog.writeEvent(1397638484, DCL_SUBTAG, uid, message);
    }
}

