/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.os.Build;
import android.util.AtomicFile;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastPrintWriter;
import com.android.server.pm.AbstractStatsBase;
import com.android.server.pm.PackageManagerServiceUtils;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;

public class PackageDexUsage
extends AbstractStatsBase<Void> {
    private static final String TAG = "PackageDexUsage";
    private static final int PACKAGE_DEX_USAGE_SUPPORTED_VERSION_1 = 1;
    private static final int PACKAGE_DEX_USAGE_SUPPORTED_VERSION_2 = 2;
    private static final int PACKAGE_DEX_USAGE_VERSION = 2;
    private static final String PACKAGE_DEX_USAGE_VERSION_HEADER = "PACKAGE_MANAGER__PACKAGE_DEX_USAGE__";
    private static final String SPLIT_CHAR = ",";
    private static final String CODE_PATH_LINE_CHAR = "+";
    private static final String DEX_LINE_CHAR = "#";
    private static final String LOADING_PACKAGE_CHAR = "@";
    static final String VARIABLE_CLASS_LOADER_CONTEXT = "=VariableClassLoaderContext=";
    static final String UNSUPPORTED_CLASS_LOADER_CONTEXT = "=UnsupportedClassLoaderContext=";
    static final String UNKNOWN_CLASS_LOADER_CONTEXT = "=UnknownClassLoaderContext=";
    @GuardedBy(value="mPackageUseInfoMap")
    private final Map<String, PackageUseInfo> mPackageUseInfoMap = new HashMap<String, PackageUseInfo>();

    public PackageDexUsage() {
        super("package-dex-usage.list", "PackageDexUsage_DiskWriter", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean record(String owningPackageName, String dexPath, int ownerUserId, String loaderIsa, boolean isUsedByOtherApps, boolean primaryOrSplit, String loadingPackageName, String classLoaderContext) {
        if (!PackageManagerServiceUtils.checkISA(loaderIsa)) {
            throw new IllegalArgumentException("loaderIsa " + loaderIsa + " is unsupported");
        }
        if (classLoaderContext == null) {
            throw new IllegalArgumentException("Null classLoaderContext");
        }
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(owningPackageName);
            if (packageUseInfo == null) {
                packageUseInfo = new PackageUseInfo();
                if (primaryOrSplit) {
                    packageUseInfo.mergeCodePathUsedByOtherApps(dexPath, isUsedByOtherApps, owningPackageName, loadingPackageName);
                } else {
                    DexUseInfo newData = new DexUseInfo(isUsedByOtherApps, ownerUserId, classLoaderContext, loaderIsa);
                    packageUseInfo.mDexUseInfoMap.put(dexPath, newData);
                    this.maybeAddLoadingPackage(owningPackageName, loadingPackageName, newData.mLoadingPackages);
                }
                this.mPackageUseInfoMap.put(owningPackageName, packageUseInfo);
                return true;
            }
            if (primaryOrSplit) {
                return packageUseInfo.mergeCodePathUsedByOtherApps(dexPath, isUsedByOtherApps, owningPackageName, loadingPackageName);
            }
            DexUseInfo newData = new DexUseInfo(isUsedByOtherApps, ownerUserId, classLoaderContext, loaderIsa);
            boolean updateLoadingPackages = this.maybeAddLoadingPackage(owningPackageName, loadingPackageName, newData.mLoadingPackages);
            DexUseInfo existingData = (DexUseInfo)packageUseInfo.mDexUseInfoMap.get(dexPath);
            if (existingData == null) {
                packageUseInfo.mDexUseInfoMap.put(dexPath, newData);
                return true;
            }
            if (ownerUserId != existingData.mOwnerUserId) {
                throw new IllegalArgumentException("Trying to change ownerUserId for  dex path " + dexPath + " from " + existingData.mOwnerUserId + " to " + ownerUserId);
            }
            return existingData.merge(newData) || updateLoadingPackages;
        }
    }

    public void read() {
        this.read((Void)null);
    }

    void maybeWriteAsync() {
        this.maybeWriteAsync(null);
    }

    void writeNow() {
        this.writeInternal(null);
    }

    @Override
    protected void writeInternal(Void data) {
        AtomicFile file = this.getFile();
        FileOutputStream f = null;
        try {
            f = file.startWrite();
            OutputStreamWriter osw = new OutputStreamWriter(f);
            this.write(osw);
            osw.flush();
            file.finishWrite(f);
        }
        catch (IOException e) {
            if (f != null) {
                file.failWrite(f);
            }
            Slog.e(TAG, "Failed to write usage for dex files", e);
        }
    }

    void write(Writer out) {
        Map<String, PackageUseInfo> packageUseInfoMapClone = this.clonePackageUseInfoMap();
        FastPrintWriter fpw = new FastPrintWriter(out);
        fpw.print(PACKAGE_DEX_USAGE_VERSION_HEADER);
        fpw.println(2);
        for (Map.Entry<String, PackageUseInfo> pEntry : packageUseInfoMapClone.entrySet()) {
            String packageName = pEntry.getKey();
            PackageUseInfo packageUseInfo = pEntry.getValue();
            fpw.println(packageName);
            for (Map.Entry codeEntry : packageUseInfo.mCodePathsUsedByOtherApps.entrySet()) {
                String codePath = (String)codeEntry.getKey();
                Set loadingPackages = (Set)codeEntry.getValue();
                fpw.println(CODE_PATH_LINE_CHAR + codePath);
                fpw.println(LOADING_PACKAGE_CHAR + String.join((CharSequence)SPLIT_CHAR, loadingPackages));
            }
            for (Map.Entry dEntry : packageUseInfo.mDexUseInfoMap.entrySet()) {
                String dexPath = (String)dEntry.getKey();
                DexUseInfo dexUseInfo = (DexUseInfo)dEntry.getValue();
                fpw.println(DEX_LINE_CHAR + dexPath);
                fpw.print(String.join((CharSequence)SPLIT_CHAR, Integer.toString(dexUseInfo.mOwnerUserId), this.writeBoolean(dexUseInfo.mIsUsedByOtherApps)));
                for (String isa : dexUseInfo.mLoaderIsas) {
                    fpw.print(SPLIT_CHAR + isa);
                }
                fpw.println();
                fpw.println(LOADING_PACKAGE_CHAR + String.join((CharSequence)SPLIT_CHAR, dexUseInfo.mLoadingPackages));
                fpw.println(dexUseInfo.getClassLoaderContext());
            }
        }
        fpw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void readInternal(Void data) {
        AtomicFile file = this.getFile();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(file.openRead()));
            this.read(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IoUtils.closeQuietly(in);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to parse package dex usage.", e);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(in);
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void read(Reader reader) throws IOException {
        String line;
        HashMap<String, PackageUseInfo> data = new HashMap<String, PackageUseInfo>();
        BufferedReader in = new BufferedReader(reader);
        String versionLine = in.readLine();
        if (versionLine == null) {
            throw new IllegalStateException("No version line found.");
        }
        if (!versionLine.startsWith(PACKAGE_DEX_USAGE_VERSION_HEADER)) {
            throw new IllegalStateException("Invalid version line: " + versionLine);
        }
        int version = Integer.parseInt(versionLine.substring(PACKAGE_DEX_USAGE_VERSION_HEADER.length()));
        if (!this.isSupportedVersion(version)) {
            throw new IllegalStateException("Unexpected version: " + version);
        }
        String currentPackage = null;
        PackageUseInfo currentPackageData = null;
        HashSet<String> supportedIsas = new HashSet<String>();
        for (String abi : Build.SUPPORTED_ABIS) {
            supportedIsas.add(VMRuntime.getInstructionSet(abi));
        }
        while ((line = in.readLine()) != null) {
            if (line.startsWith(DEX_LINE_CHAR)) {
                if (currentPackage == null) {
                    throw new IllegalStateException("Malformed PackageDexUsage file. Expected package line before dex line.");
                }
                String string2 = line.substring(DEX_LINE_CHAR.length());
                line = in.readLine();
                if (line == null) {
                    throw new IllegalStateException("Could not find dexUseInfo line");
                }
                String[] elems = line.split(SPLIT_CHAR);
                if (elems.length < 3) {
                    throw new IllegalStateException("Invalid PackageDexUsage line: " + line);
                }
                Set<String> loadingPackages = this.maybeReadLoadingPackages(in, version);
                String classLoaderContext = this.maybeReadClassLoaderContext(in, version);
                int ownerUserId = Integer.parseInt(elems[0]);
                boolean isUsedByOtherApps = this.readBoolean(elems[1]);
                DexUseInfo dexUseInfo = new DexUseInfo(isUsedByOtherApps, ownerUserId, classLoaderContext, null);
                dexUseInfo.mLoadingPackages.addAll(loadingPackages);
                for (int i = 2; i < elems.length; ++i) {
                    String isa = elems[i];
                    if (supportedIsas.contains(isa)) {
                        dexUseInfo.mLoaderIsas.add(elems[i]);
                        continue;
                    }
                    Slog.wtf(TAG, "Unsupported ISA when parsing PackageDexUsage: " + isa);
                }
                if (supportedIsas.isEmpty()) {
                    Slog.wtf(TAG, "Ignore dexPath when parsing PackageDexUsage because of unsupported isas. dexPath=" + string2);
                    continue;
                }
                currentPackageData.mDexUseInfoMap.put(string2, dexUseInfo);
                continue;
            }
            if (line.startsWith(CODE_PATH_LINE_CHAR)) {
                if (version < 2) {
                    throw new IllegalArgumentException("Unexpected code path line when parsing PackageDexUseData: " + line);
                }
                String string3 = line.substring(CODE_PATH_LINE_CHAR.length());
                Set<String> loadingPackages = this.maybeReadLoadingPackages(in, version);
                currentPackageData.mCodePathsUsedByOtherApps.put(string3, loadingPackages);
                continue;
            }
            if (version >= 2) {
                currentPackage = line;
                currentPackageData = new PackageUseInfo();
            } else {
                String[] stringArray = line.split(SPLIT_CHAR);
                if (stringArray.length != 2) {
                    throw new IllegalStateException("Invalid PackageDexUsage line: " + line);
                }
                currentPackage = stringArray[0];
                currentPackageData = new PackageUseInfo();
                currentPackageData.mUsedByOtherAppsBeforeUpgrade = this.readBoolean(stringArray[1]);
            }
            data.put(currentPackage, currentPackageData);
        }
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            this.mPackageUseInfoMap.clear();
            this.mPackageUseInfoMap.putAll(data);
        }
    }

    private String maybeReadClassLoaderContext(BufferedReader in, int version) throws IOException {
        String context = null;
        if (version >= 2 && (context = in.readLine()) == null) {
            throw new IllegalStateException("Could not find the classLoaderContext line.");
        }
        return context == null ? UNKNOWN_CLASS_LOADER_CONTEXT : context;
    }

    private Set<String> maybeReadLoadingPackages(BufferedReader in, int version) throws IOException {
        if (version >= 2) {
            String line = in.readLine();
            if (line == null) {
                throw new IllegalStateException("Could not find the loadingPackages line.");
            }
            if (line.length() == LOADING_PACKAGE_CHAR.length()) {
                return Collections.emptySet();
            }
            HashSet<String> result = new HashSet<String>();
            Collections.addAll(result, line.substring(LOADING_PACKAGE_CHAR.length()).split(SPLIT_CHAR));
            return result;
        }
        return Collections.emptySet();
    }

    private boolean maybeAddLoadingPackage(String owningPackage, String loadingPackage, Set<String> loadingPackages) {
        return !owningPackage.equals(loadingPackage) && loadingPackages.add(loadingPackage);
    }

    private boolean isSupportedVersion(int version) {
        return version == 1 || version == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncData(Map<String, Set<Integer>> packageToUsersMap, Map<String, Set<String>> packageToCodePaths) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            Iterator<Map.Entry<String, PackageUseInfo>> pIt = this.mPackageUseInfoMap.entrySet().iterator();
            while (pIt.hasNext()) {
                Map.Entry<String, PackageUseInfo> pEntry = pIt.next();
                String packageName = pEntry.getKey();
                PackageUseInfo packageUseInfo = pEntry.getValue();
                Set<Integer> users = packageToUsersMap.get(packageName);
                if (users == null) {
                    pIt.remove();
                    continue;
                }
                Iterator dIt = packageUseInfo.mDexUseInfoMap.entrySet().iterator();
                while (dIt.hasNext()) {
                    DexUseInfo dexUseInfo = (DexUseInfo)dIt.next().getValue();
                    if (users.contains(dexUseInfo.mOwnerUserId)) continue;
                    dIt.remove();
                }
                Set<String> codePaths = packageToCodePaths.get(packageName);
                Iterator codeIt = packageUseInfo.mCodePathsUsedByOtherApps.entrySet().iterator();
                while (codeIt.hasNext()) {
                    if (codePaths.contains(codeIt.next().getKey())) continue;
                    codeIt.remove();
                }
                if (packageUseInfo.mUsedByOtherAppsBeforeUpgrade) {
                    for (String codePath : codePaths) {
                        packageUseInfo.mergeCodePathUsedByOtherApps(codePath, true, null, null);
                    }
                    continue;
                }
                if (packageUseInfo.isAnyCodePathUsedByOtherApps() || !packageUseInfo.mDexUseInfoMap.isEmpty()) continue;
                pIt.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearUsedByOtherApps(String packageName) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(packageName);
            if (packageUseInfo == null) {
                return false;
            }
            return packageUseInfo.clearCodePathUsedByOtherApps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePackage(String packageName) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            return this.mPackageUseInfoMap.remove(packageName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUserPackage(String packageName, int userId) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(packageName);
            if (packageUseInfo == null) {
                return false;
            }
            boolean updated = false;
            Iterator dIt = packageUseInfo.mDexUseInfoMap.entrySet().iterator();
            while (dIt.hasNext()) {
                DexUseInfo dexUseInfo = (DexUseInfo)dIt.next().getValue();
                if (dexUseInfo.mOwnerUserId != userId) continue;
                dIt.remove();
                updated = true;
            }
            if (packageUseInfo.mDexUseInfoMap.isEmpty() && !packageUseInfo.isAnyCodePathUsedByOtherApps()) {
                this.mPackageUseInfoMap.remove(packageName);
                updated = true;
            }
            return updated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeDexFile(String packageName, String dexFile, int userId) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(packageName);
            if (packageUseInfo == null) {
                return false;
            }
            return this.removeDexFile(packageUseInfo, dexFile, userId);
        }
    }

    private boolean removeDexFile(PackageUseInfo packageUseInfo, String dexFile, int userId) {
        DexUseInfo dexUseInfo = (DexUseInfo)packageUseInfo.mDexUseInfoMap.get(dexFile);
        if (dexUseInfo == null) {
            return false;
        }
        if (dexUseInfo.mOwnerUserId == userId) {
            packageUseInfo.mDexUseInfoMap.remove(dexFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageUseInfo getPackageUseInfo(String packageName) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo useInfo = this.mPackageUseInfoMap.get(packageName);
            return useInfo == null ? null : new PackageUseInfo(useInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllPackagesWithSecondaryDexFiles() {
        HashSet<String> packages = new HashSet<String>();
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            for (Map.Entry<String, PackageUseInfo> entry : this.mPackageUseInfoMap.entrySet()) {
                if (entry.getValue().mDexUseInfoMap.isEmpty()) continue;
                packages.add(entry.getKey());
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            this.mPackageUseInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PackageUseInfo> clonePackageUseInfoMap() {
        HashMap<String, PackageUseInfo> clone = new HashMap<String, PackageUseInfo>();
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            for (Map.Entry<String, PackageUseInfo> e : this.mPackageUseInfoMap.entrySet()) {
                clone.put(e.getKey(), new PackageUseInfo(e.getValue()));
            }
        }
        return clone;
    }

    private String writeBoolean(boolean bool2) {
        return bool2 ? "1" : "0";
    }

    private boolean readBoolean(String bool2) {
        if ("0".equals(bool2)) {
            return false;
        }
        if ("1".equals(bool2)) {
            return true;
        }
        throw new IllegalArgumentException("Unknown bool encoding: " + bool2);
    }

    public String dump() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        return sw.toString();
    }

    public static class DexUseInfo {
        private boolean mIsUsedByOtherApps;
        private final int mOwnerUserId;
        private String mClassLoaderContext;
        private final Set<String> mLoaderIsas;
        private final Set<String> mLoadingPackages;

        public DexUseInfo(boolean isUsedByOtherApps, int ownerUserId, String classLoaderContext, String loaderIsa) {
            this.mIsUsedByOtherApps = isUsedByOtherApps;
            this.mOwnerUserId = ownerUserId;
            this.mClassLoaderContext = classLoaderContext;
            this.mLoaderIsas = new HashSet<String>();
            if (loaderIsa != null) {
                this.mLoaderIsas.add(loaderIsa);
            }
            this.mLoadingPackages = new HashSet<String>();
        }

        public DexUseInfo(DexUseInfo other) {
            this.mIsUsedByOtherApps = other.mIsUsedByOtherApps;
            this.mOwnerUserId = other.mOwnerUserId;
            this.mClassLoaderContext = other.mClassLoaderContext;
            this.mLoaderIsas = new HashSet<String>(other.mLoaderIsas);
            this.mLoadingPackages = new HashSet<String>(other.mLoadingPackages);
        }

        private boolean merge(DexUseInfo dexUseInfo) {
            boolean oldIsUsedByOtherApps = this.mIsUsedByOtherApps;
            this.mIsUsedByOtherApps = this.mIsUsedByOtherApps || dexUseInfo.mIsUsedByOtherApps;
            boolean updateIsas = this.mLoaderIsas.addAll(dexUseInfo.mLoaderIsas);
            boolean updateLoadingPackages = this.mLoadingPackages.addAll(dexUseInfo.mLoadingPackages);
            String oldClassLoaderContext = this.mClassLoaderContext;
            if (PackageDexUsage.UNKNOWN_CLASS_LOADER_CONTEXT.equals(this.mClassLoaderContext)) {
                this.mClassLoaderContext = dexUseInfo.mClassLoaderContext;
            } else if (PackageDexUsage.UNSUPPORTED_CLASS_LOADER_CONTEXT.equals(dexUseInfo.mClassLoaderContext)) {
                this.mClassLoaderContext = PackageDexUsage.UNSUPPORTED_CLASS_LOADER_CONTEXT;
            } else if (!PackageDexUsage.UNSUPPORTED_CLASS_LOADER_CONTEXT.equals(this.mClassLoaderContext) && !Objects.equals(this.mClassLoaderContext, dexUseInfo.mClassLoaderContext)) {
                this.mClassLoaderContext = PackageDexUsage.VARIABLE_CLASS_LOADER_CONTEXT;
            }
            return updateIsas || oldIsUsedByOtherApps != this.mIsUsedByOtherApps || updateLoadingPackages || !Objects.equals(oldClassLoaderContext, this.mClassLoaderContext);
        }

        public boolean isUsedByOtherApps() {
            return this.mIsUsedByOtherApps;
        }

        public int getOwnerUserId() {
            return this.mOwnerUserId;
        }

        public Set<String> getLoaderIsas() {
            return this.mLoaderIsas;
        }

        public Set<String> getLoadingPackages() {
            return this.mLoadingPackages;
        }

        public String getClassLoaderContext() {
            return this.mClassLoaderContext;
        }

        public boolean isUnsupportedClassLoaderContext() {
            return PackageDexUsage.UNSUPPORTED_CLASS_LOADER_CONTEXT.equals(this.mClassLoaderContext);
        }

        public boolean isUnknownClassLoaderContext() {
            return PackageDexUsage.UNKNOWN_CLASS_LOADER_CONTEXT.equals(this.mClassLoaderContext);
        }

        public boolean isVariableClassLoaderContext() {
            return PackageDexUsage.VARIABLE_CLASS_LOADER_CONTEXT.equals(this.mClassLoaderContext);
        }
    }

    public static class PackageUseInfo {
        private final Map<String, Set<String>> mCodePathsUsedByOtherApps = new HashMap<String, Set<String>>();
        private final Map<String, DexUseInfo> mDexUseInfoMap;
        private boolean mUsedByOtherAppsBeforeUpgrade;

        public PackageUseInfo() {
            this.mDexUseInfoMap = new HashMap<String, DexUseInfo>();
        }

        public PackageUseInfo(PackageUseInfo other) {
            for (Map.Entry<String, Set<String>> entry : other.mCodePathsUsedByOtherApps.entrySet()) {
                this.mCodePathsUsedByOtherApps.put(entry.getKey(), new HashSet(entry.getValue()));
            }
            this.mDexUseInfoMap = new HashMap<String, DexUseInfo>();
            for (Map.Entry<String, Object> entry : other.mDexUseInfoMap.entrySet()) {
                this.mDexUseInfoMap.put(entry.getKey(), new DexUseInfo((DexUseInfo)entry.getValue()));
            }
        }

        private boolean mergeCodePathUsedByOtherApps(String codePath, boolean isUsedByOtherApps, String owningPackageName, String loadingPackage) {
            if (!isUsedByOtherApps) {
                return false;
            }
            boolean newCodePath = false;
            Set<String> loadingPackages = this.mCodePathsUsedByOtherApps.get(codePath);
            if (loadingPackages == null) {
                loadingPackages = new HashSet<String>();
                this.mCodePathsUsedByOtherApps.put(codePath, loadingPackages);
                newCodePath = true;
            }
            boolean newLoadingPackage = loadingPackage != null && !loadingPackage.equals(owningPackageName) && loadingPackages.add(loadingPackage);
            return newCodePath || newLoadingPackage;
        }

        public boolean isUsedByOtherApps(String codePath) {
            return this.mCodePathsUsedByOtherApps.containsKey(codePath);
        }

        public Map<String, DexUseInfo> getDexUseInfoMap() {
            return this.mDexUseInfoMap;
        }

        public Set<String> getLoadingPackages(String codePath) {
            return this.mCodePathsUsedByOtherApps.getOrDefault(codePath, null);
        }

        public boolean isAnyCodePathUsedByOtherApps() {
            return !this.mCodePathsUsedByOtherApps.isEmpty();
        }

        boolean clearCodePathUsedByOtherApps() {
            this.mUsedByOtherAppsBeforeUpgrade = true;
            if (this.mCodePathsUsedByOtherApps.isEmpty()) {
                return false;
            }
            this.mCodePathsUsedByOtherApps.clear();
            return true;
        }
    }
}

