/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.permission;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageList;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import com.android.server.LocalServices;
import com.android.server.pm.permission.BasePermission;
import com.android.server.pm.permission.PermissionManagerService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DefaultPermissionGrantPolicy {
    private static final String TAG = "DefaultPermGrantPolicy";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_FLAGS = 794624;
    private static final String AUDIO_MIME_TYPE = "audio/mpeg";
    private static final String TAG_EXCEPTIONS = "exceptions";
    private static final String TAG_EXCEPTION = "exception";
    private static final String TAG_PERMISSION = "permission";
    private static final String ATTR_PACKAGE = "package";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FIXED = "fixed";
    private static final Set<String> PHONE_PERMISSIONS = new ArraySet<String>();
    private static final Set<String> CONTACTS_PERMISSIONS;
    private static final Set<String> LOCATION_PERMISSIONS;
    private static final Set<String> COARSE_LOCATION_PERMISSIONS;
    private static final Set<String> CALENDAR_PERMISSIONS;
    private static final Set<String> SMS_PERMISSIONS;
    private static final Set<String> MICROPHONE_PERMISSIONS;
    private static final Set<String> CAMERA_PERMISSIONS;
    private static final Set<String> SENSORS_PERMISSIONS;
    private static final Set<String> STORAGE_PERMISSIONS;
    private static final int MSG_READ_DEFAULT_PERMISSION_EXCEPTIONS = 1;
    private static final String ACTION_TRACK = "com.android.fitness.TRACK";
    private final Handler mHandler;
    private PackageManagerInternal.PackagesProvider mLocationPackagesProvider;
    private PackageManagerInternal.PackagesProvider mVoiceInteractionPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSmsAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mDialerAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSimCallManagerPackagesProvider;
    private PackageManagerInternal.PackagesProvider mUseOpenWifiAppPackagesProvider;
    private PackageManagerInternal.SyncAdapterPackagesProvider mSyncAdapterPackagesProvider;
    private ArrayMap<String, List<DefaultPermissionGrant>> mGrantExceptions;
    private final Context mContext;
    private final Object mLock = new Object();
    private final PackageManagerInternal mServiceInternal;
    private final PermissionManagerService mPermissionManager;
    private final DefaultPermissionGrantedCallback mPermissionGrantedCallback;

    public DefaultPermissionGrantPolicy(Context context, Looper looper, DefaultPermissionGrantedCallback callback, PermissionManagerService permissionManager) {
        this.mContext = context;
        this.mHandler = new Handler(looper){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    Object object = DefaultPermissionGrantPolicy.this.mLock;
                    synchronized (object) {
                        if (DefaultPermissionGrantPolicy.this.mGrantExceptions == null) {
                            DefaultPermissionGrantPolicy.this.mGrantExceptions = DefaultPermissionGrantPolicy.this.readDefaultPermissionExceptionsLocked();
                        }
                    }
                }
            }
        };
        this.mPermissionGrantedCallback = callback;
        this.mPermissionManager = permissionManager;
        this.mServiceInternal = LocalServices.getService(PackageManagerInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocationPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceInteractionPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mVoiceInteractionPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmsAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSmsAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDialerAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDialerAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSimCallManagerPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSimCallManagerPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseOpenWifiAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUseOpenWifiAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncAdapterPackagesProvider(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSyncAdapterPackagesProvider = provider;
        }
    }

    public void grantDefaultPermissions(int userId) {
        this.grantPermissionsToSysComponentsAndPrivApps(userId);
        this.grantDefaultSystemHandlerPermissions(userId);
        this.grantDefaultPermissionExceptions(userId);
    }

    private void grantRuntimePermissionsForPackage(int userId, PackageParser.Package pkg) {
        ArraySet<String> permissions = new ArraySet<String>();
        for (String permission2 : pkg.requestedPermissions) {
            BasePermission bp = this.mPermissionManager.getPermission(permission2);
            if (bp == null || !bp.isRuntime()) continue;
            permissions.add(permission2);
        }
        if (!permissions.isEmpty()) {
            this.grantRuntimePermissions(pkg, permissions, true, userId);
        }
    }

    private void grantAllRuntimePermissions(int userId) {
        Log.i(TAG, "Granting all runtime permissions for user " + userId);
        PackageList packageList = this.mServiceInternal.getPackageList();
        for (String packageName : packageList.getPackageNames()) {
            PackageParser.Package pkg = this.mServiceInternal.getPackage(packageName);
            if (pkg == null) continue;
            this.grantRuntimePermissionsForPackage(userId, pkg);
        }
    }

    public void scheduleReadDefaultPermissionExceptions() {
        this.mHandler.sendEmptyMessage(1);
    }

    private void grantPermissionsToSysComponentsAndPrivApps(int userId) {
        Log.i(TAG, "Granting permissions to platform components for user " + userId);
        PackageList packageList = this.mServiceInternal.getPackageList();
        for (String packageName : packageList.getPackageNames()) {
            PackageParser.Package pkg = this.mServiceInternal.getPackage(packageName);
            if (pkg == null || !this.isSysComponentOrPersistentPlatformSignedPrivApp(pkg) || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg) || pkg.requestedPermissions.isEmpty()) continue;
            this.grantRuntimePermissionsForPackage(userId, pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantDefaultSystemHandlerPermissions(int userId) {
        PackageParser.Package sharedStorageBackupPackage;
        PackageParser.Package textClassifierPackage;
        String textClassifierPackageName;
        Intent ringtonePickerIntent;
        PackageParser.Package ringtonePickerPackage;
        PackageParser.Package companionDeviceDiscoveryPackage;
        Intent storageManagerIntent;
        PackageParser.Package storageManagerPckg;
        Intent emergencyInfoIntent;
        PackageParser.Package emergencyInfoPckg;
        PackageParser.Package printSpoolerPackage;
        Intent globalSearchIntent;
        PackageParser.Package globalSearchPickerPackage;
        Intent deviceProvisionIntent;
        PackageParser.Package deviceProvisionPackage;
        PackageParser.Package calendarProviderPackage;
        Intent carrierProvIntent;
        PackageParser.Package carrierProvPackage;
        int n;
        Object dialerIntent;
        Intent certInstallerIntent;
        PackageParser.Package certInstallerPackage;
        PackageParser.Package containerPackage;
        PackageParser.Package storagePackage;
        Intent downloadsUiIntent;
        PackageParser.Package downloadsUiPackage;
        PackageParser.Package downloadsPackage;
        PackageParser.Package mediaStorePackage;
        Intent cameraIntent;
        PackageParser.Package cameraPackage;
        String setupWizardPackageName;
        PackageParser.Package setupPackage;
        String verifierPackageName;
        PackageParser.Package verifierPackage;
        PackageManagerInternal.SyncAdapterPackagesProvider syncAdapterPackagesProvider;
        PackageManagerInternal.PackagesProvider useOpenWifiAppPackagesProvider;
        PackageManagerInternal.PackagesProvider simCallManagerPackagesProvider;
        PackageManagerInternal.PackagesProvider dialerAppPackagesProvider;
        PackageManagerInternal.PackagesProvider smsAppPackagesProvider;
        PackageManagerInternal.PackagesProvider voiceInteractionPackagesProvider;
        PackageManagerInternal.PackagesProvider locationPackagesProvider;
        Log.i(TAG, "Granting permissions to default platform handlers for user " + userId);
        Object object = this.mLock;
        synchronized (object) {
            locationPackagesProvider = this.mLocationPackagesProvider;
            voiceInteractionPackagesProvider = this.mVoiceInteractionPackagesProvider;
            smsAppPackagesProvider = this.mSmsAppPackagesProvider;
            dialerAppPackagesProvider = this.mDialerAppPackagesProvider;
            simCallManagerPackagesProvider = this.mSimCallManagerPackagesProvider;
            useOpenWifiAppPackagesProvider = this.mUseOpenWifiAppPackagesProvider;
            syncAdapterPackagesProvider = this.mSyncAdapterPackagesProvider;
        }
        String[] voiceInteractPackageNames = voiceInteractionPackagesProvider != null ? voiceInteractionPackagesProvider.getPackages(userId) : null;
        String[] locationPackageNames = locationPackagesProvider != null ? locationPackagesProvider.getPackages(userId) : null;
        String[] smsAppPackageNames = smsAppPackagesProvider != null ? smsAppPackagesProvider.getPackages(userId) : null;
        String[] dialerAppPackageNames = dialerAppPackagesProvider != null ? dialerAppPackagesProvider.getPackages(userId) : null;
        String[] simCallManagerPackageNames = simCallManagerPackagesProvider != null ? simCallManagerPackagesProvider.getPackages(userId) : null;
        String[] useOpenWifiAppPackageNames = useOpenWifiAppPackagesProvider != null ? useOpenWifiAppPackagesProvider.getPackages(userId) : null;
        String[] contactsSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.contacts", userId) : null;
        String[] calendarSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.calendar", userId) : null;
        String installerPackageName = this.mServiceInternal.getKnownPackageName(2, userId);
        PackageParser.Package installerPackage = this.getSystemPackage(installerPackageName);
        if (installerPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(installerPackage)) {
            this.grantRuntimePermissions(installerPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if ((verifierPackage = this.getSystemPackage(verifierPackageName = this.mServiceInternal.getKnownPackageName(3, userId))) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(verifierPackage)) {
            this.grantRuntimePermissions(verifierPackage, STORAGE_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(verifierPackage, PHONE_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(verifierPackage, SMS_PERMISSIONS, false, userId);
        }
        if ((setupPackage = this.getSystemPackage(setupWizardPackageName = this.mServiceInternal.getKnownPackageName(1, userId))) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(setupPackage)) {
            this.grantRuntimePermissions(setupPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(setupPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(setupPackage, LOCATION_PERMISSIONS, userId);
            this.grantRuntimePermissions(setupPackage, CAMERA_PERMISSIONS, userId);
        }
        if ((cameraPackage = this.getDefaultSystemHandlerActivityPackage(cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(cameraPackage)) {
            this.grantRuntimePermissions(cameraPackage, CAMERA_PERMISSIONS, userId);
            this.grantRuntimePermissions(cameraPackage, MICROPHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(cameraPackage, STORAGE_PERMISSIONS, userId);
        }
        if ((mediaStorePackage = this.getDefaultProviderAuthorityPackage("media", userId)) != null) {
            this.grantRuntimePermissions(mediaStorePackage, STORAGE_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(mediaStorePackage, PHONE_PERMISSIONS, true, userId);
        }
        if ((downloadsPackage = this.getDefaultProviderAuthorityPackage("downloads", userId)) != null) {
            this.grantRuntimePermissions(downloadsPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if ((downloadsUiPackage = this.getDefaultSystemHandlerActivityPackage(downloadsUiIntent = new Intent("android.intent.action.VIEW_DOWNLOADS"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(downloadsUiPackage)) {
            this.grantRuntimePermissions(downloadsUiPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if ((storagePackage = this.getDefaultProviderAuthorityPackage("com.android.externalstorage.documents", userId)) != null) {
            this.grantRuntimePermissions(storagePackage, STORAGE_PERMISSIONS, true, userId);
        }
        if ((containerPackage = this.getSystemPackage("com.android.defcontainer")) != null) {
            this.grantRuntimePermissions(containerPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if ((certInstallerPackage = this.getDefaultSystemHandlerActivityPackage(certInstallerIntent = new Intent("android.credentials.INSTALL"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(certInstallerPackage)) {
            this.grantRuntimePermissions(certInstallerPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if (dialerAppPackageNames == null) {
            dialerIntent = new Intent("android.intent.action.DIAL");
            PackageParser.Package dialerPackage = this.getDefaultSystemHandlerActivityPackage((Intent)dialerIntent, userId);
            if (dialerPackage != null) {
                this.grantDefaultPermissionsToDefaultSystemDialerApp(dialerPackage, userId);
            }
        } else {
            dialerIntent = dialerAppPackageNames;
            int dialerPackage = ((String[])dialerIntent).length;
            for (n = 0; n < dialerPackage; ++n) {
                String dialerAppPackageName = dialerIntent[n];
                PackageParser.Package dialerPackage2 = this.getSystemPackage(dialerAppPackageName);
                if (dialerPackage2 == null) continue;
                this.grantDefaultPermissionsToDefaultSystemDialerApp(dialerPackage2, userId);
            }
        }
        if (simCallManagerPackageNames != null) {
            dialerIntent = simCallManagerPackageNames;
            int dialerPackage = ((String[])dialerIntent).length;
            for (n = 0; n < dialerPackage; ++n) {
                String simCallManagerPackageName = dialerIntent[n];
                PackageParser.Package simCallManagerPackage = this.getSystemPackage(simCallManagerPackageName);
                if (simCallManagerPackage == null) continue;
                this.grantDefaultPermissionsToDefaultSimCallManager(simCallManagerPackage, userId);
            }
        }
        if (useOpenWifiAppPackageNames != null) {
            dialerIntent = useOpenWifiAppPackageNames;
            int dialerPackage = ((String[])dialerIntent).length;
            for (n = 0; n < dialerPackage; ++n) {
                String useOpenWifiPackageName = dialerIntent[n];
                PackageParser.Package useOpenWifiPackage = this.getSystemPackage(useOpenWifiPackageName);
                if (useOpenWifiPackage == null) continue;
                this.grantDefaultPermissionsToDefaultSystemUseOpenWifiApp(useOpenWifiPackage, userId);
            }
        }
        if (smsAppPackageNames == null) {
            Intent smsIntent = new Intent("android.intent.action.MAIN");
            smsIntent.addCategory("android.intent.category.APP_MESSAGING");
            PackageParser.Package smsPackage = this.getDefaultSystemHandlerActivityPackage(smsIntent, userId);
            if (smsPackage != null) {
                this.grantDefaultPermissionsToDefaultSystemSmsApp(smsPackage, userId);
            }
        } else {
            for (String smsPackageName : smsAppPackageNames) {
                PackageParser.Package smsPackage = this.getSystemPackage(smsPackageName);
                if (smsPackage == null) continue;
                this.grantDefaultPermissionsToDefaultSystemSmsApp(smsPackage, userId);
            }
        }
        Intent cbrIntent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
        PackageParser.Package cbrPackage = this.getDefaultSystemHandlerActivityPackage(cbrIntent, userId);
        if (cbrPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(cbrPackage)) {
            this.grantRuntimePermissions(cbrPackage, SMS_PERMISSIONS, userId);
        }
        if ((carrierProvPackage = this.getDefaultSystemHandlerServicePackage(carrierProvIntent = new Intent("android.provider.Telephony.SMS_CARRIER_PROVISION"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(carrierProvPackage)) {
            this.grantRuntimePermissions(carrierProvPackage, SMS_PERMISSIONS, false, userId);
        }
        Intent calendarIntent = new Intent("android.intent.action.MAIN");
        calendarIntent.addCategory("android.intent.category.APP_CALENDAR");
        PackageParser.Package calendarPackage = this.getDefaultSystemHandlerActivityPackage(calendarIntent, userId);
        if (calendarPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(calendarPackage)) {
            this.grantRuntimePermissions(calendarPackage, CALENDAR_PERMISSIONS, userId);
            this.grantRuntimePermissions(calendarPackage, CONTACTS_PERMISSIONS, userId);
        }
        if ((calendarProviderPackage = this.getDefaultProviderAuthorityPackage("com.android.calendar", userId)) != null) {
            this.grantRuntimePermissions(calendarProviderPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(calendarProviderPackage, CALENDAR_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(calendarProviderPackage, STORAGE_PERMISSIONS, userId);
        }
        List<PackageParser.Package> calendarSyncAdapters = this.getHeadlessSyncAdapterPackages(calendarSyncAdapterPackages, userId);
        int calendarSyncAdapterCount = calendarSyncAdapters.size();
        for (int i = 0; i < calendarSyncAdapterCount; ++i) {
            PackageParser.Package calendarSyncAdapter = calendarSyncAdapters.get(i);
            if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(calendarSyncAdapter)) continue;
            this.grantRuntimePermissions(calendarSyncAdapter, CALENDAR_PERMISSIONS, userId);
        }
        Intent contactsIntent = new Intent("android.intent.action.MAIN");
        contactsIntent.addCategory("android.intent.category.APP_CONTACTS");
        PackageParser.Package contactsPackage = this.getDefaultSystemHandlerActivityPackage(contactsIntent, userId);
        if (contactsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(contactsPackage)) {
            this.grantRuntimePermissions(contactsPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(contactsPackage, PHONE_PERMISSIONS, userId);
        }
        List<PackageParser.Package> contactsSyncAdapters = this.getHeadlessSyncAdapterPackages(contactsSyncAdapterPackages, userId);
        int contactsSyncAdapterCount = contactsSyncAdapters.size();
        for (int i = 0; i < contactsSyncAdapterCount; ++i) {
            PackageParser.Package contactsSyncAdapter = contactsSyncAdapters.get(i);
            if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(contactsSyncAdapter)) continue;
            this.grantRuntimePermissions(contactsSyncAdapter, CONTACTS_PERMISSIONS, userId);
        }
        PackageParser.Package contactsProviderPackage = this.getDefaultProviderAuthorityPackage("com.android.contacts", userId);
        if (contactsProviderPackage != null) {
            this.grantRuntimePermissions(contactsProviderPackage, CONTACTS_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(contactsProviderPackage, PHONE_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(contactsProviderPackage, STORAGE_PERMISSIONS, userId);
        }
        if ((deviceProvisionPackage = this.getDefaultSystemHandlerActivityPackage(deviceProvisionIntent = new Intent("android.app.action.PROVISION_MANAGED_DEVICE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(deviceProvisionPackage)) {
            this.grantRuntimePermissions(deviceProvisionPackage, CONTACTS_PERMISSIONS, userId);
        }
        Intent mapsIntent = new Intent("android.intent.action.MAIN");
        mapsIntent.addCategory("android.intent.category.APP_MAPS");
        PackageParser.Package mapsPackage = this.getDefaultSystemHandlerActivityPackage(mapsIntent, userId);
        if (mapsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(mapsPackage)) {
            this.grantRuntimePermissions(mapsPackage, LOCATION_PERMISSIONS, userId);
        }
        Intent galleryIntent = new Intent("android.intent.action.MAIN");
        galleryIntent.addCategory("android.intent.category.APP_GALLERY");
        PackageParser.Package galleryPackage = this.getDefaultSystemHandlerActivityPackage(galleryIntent, userId);
        if (galleryPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(galleryPackage)) {
            this.grantRuntimePermissions(galleryPackage, STORAGE_PERMISSIONS, userId);
        }
        Intent emailIntent = new Intent("android.intent.action.MAIN");
        emailIntent.addCategory("android.intent.category.APP_EMAIL");
        PackageParser.Package emailPackage = this.getDefaultSystemHandlerActivityPackage(emailIntent, userId);
        if (emailPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(emailPackage)) {
            this.grantRuntimePermissions(emailPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(emailPackage, CALENDAR_PERMISSIONS, userId);
        }
        PackageParser.Package browserPackage = null;
        String defaultBrowserPackage = this.mServiceInternal.getKnownPackageName(4, userId);
        if (defaultBrowserPackage != null) {
            browserPackage = this.getPackage(defaultBrowserPackage);
        }
        if (browserPackage == null) {
            String[] browserIntent = new Intent("android.intent.action.MAIN");
            browserIntent.addCategory("android.intent.category.APP_BROWSER");
            browserPackage = this.getDefaultSystemHandlerActivityPackage((Intent)browserIntent, userId);
        }
        if (browserPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(browserPackage)) {
            this.grantRuntimePermissions(browserPackage, LOCATION_PERMISSIONS, userId);
        }
        if (voiceInteractPackageNames != null) {
            for (String voiceInteractPackageName : voiceInteractPackageNames) {
                PackageParser.Package voiceInteractPackage = this.getSystemPackage(voiceInteractPackageName);
                if (voiceInteractPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(voiceInteractPackage)) continue;
                this.grantRuntimePermissions(voiceInteractPackage, CONTACTS_PERMISSIONS, userId);
                this.grantRuntimePermissions(voiceInteractPackage, CALENDAR_PERMISSIONS, userId);
                this.grantRuntimePermissions(voiceInteractPackage, MICROPHONE_PERMISSIONS, userId);
                this.grantRuntimePermissions(voiceInteractPackage, PHONE_PERMISSIONS, userId);
                this.grantRuntimePermissions(voiceInteractPackage, SMS_PERMISSIONS, userId);
                this.grantRuntimePermissions(voiceInteractPackage, LOCATION_PERMISSIONS, userId);
            }
        }
        if (ActivityManager.isLowRamDeviceStatic() && (globalSearchPickerPackage = this.getDefaultSystemHandlerActivityPackage(globalSearchIntent = new Intent("android.search.action.GLOBAL_SEARCH"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(globalSearchPickerPackage)) {
            this.grantRuntimePermissions(globalSearchPickerPackage, MICROPHONE_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(globalSearchPickerPackage, LOCATION_PERMISSIONS, false, userId);
        }
        Intent voiceRecoIntent = new Intent("android.speech.RecognitionService");
        voiceRecoIntent.addCategory("android.intent.category.DEFAULT");
        PackageParser.Package voiceRecoPackage = this.getDefaultSystemHandlerServicePackage(voiceRecoIntent, userId);
        if (voiceRecoPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(voiceRecoPackage)) {
            this.grantRuntimePermissions(voiceRecoPackage, MICROPHONE_PERMISSIONS, userId);
        }
        if (locationPackageNames != null) {
            for (String packageName : locationPackageNames) {
                PackageParser.Package locationPackage = this.getSystemPackage(packageName);
                if (locationPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(locationPackage)) continue;
                this.grantRuntimePermissions(locationPackage, CONTACTS_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, CALENDAR_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, MICROPHONE_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, PHONE_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, SMS_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, LOCATION_PERMISSIONS, true, userId);
                this.grantRuntimePermissions(locationPackage, CAMERA_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, SENSORS_PERMISSIONS, userId);
                this.grantRuntimePermissions(locationPackage, STORAGE_PERMISSIONS, userId);
            }
        }
        Intent musicIntent = new Intent("android.intent.action.VIEW");
        musicIntent.addCategory("android.intent.category.DEFAULT");
        musicIntent.setDataAndType(Uri.fromFile(new File("foo.mp3")), AUDIO_MIME_TYPE);
        PackageParser.Package musicPackage = this.getDefaultSystemHandlerActivityPackage(musicIntent, userId);
        if (musicPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(musicPackage)) {
            this.grantRuntimePermissions(musicPackage, STORAGE_PERMISSIONS, userId);
        }
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        homeIntent.addCategory("android.intent.category.LAUNCHER_APP");
        PackageParser.Package homePackage = this.getDefaultSystemHandlerActivityPackage(homeIntent, userId);
        if (homePackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(homePackage)) {
            this.grantRuntimePermissions(homePackage, LOCATION_PERMISSIONS, false, userId);
        }
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch", 0)) {
            Intent trackIntent;
            PackageParser.Package trackPackage;
            Intent wearHomeIntent = new Intent("android.intent.action.MAIN");
            wearHomeIntent.addCategory("android.intent.category.HOME_MAIN");
            PackageParser.Package wearHomePackage = this.getDefaultSystemHandlerActivityPackage(wearHomeIntent, userId);
            if (wearHomePackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(wearHomePackage)) {
                this.grantRuntimePermissions(wearHomePackage, CONTACTS_PERMISSIONS, false, userId);
                this.grantRuntimePermissions(wearHomePackage, PHONE_PERMISSIONS, true, userId);
                this.grantRuntimePermissions(wearHomePackage, MICROPHONE_PERMISSIONS, false, userId);
                this.grantRuntimePermissions(wearHomePackage, LOCATION_PERMISSIONS, false, userId);
            }
            if ((trackPackage = this.getDefaultSystemHandlerActivityPackage(trackIntent = new Intent(ACTION_TRACK), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(trackPackage)) {
                this.grantRuntimePermissions(trackPackage, SENSORS_PERMISSIONS, false, userId);
                this.grantRuntimePermissions(trackPackage, LOCATION_PERMISSIONS, false, userId);
            }
        }
        if ((printSpoolerPackage = this.getSystemPackage("com.android.printspooler")) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(printSpoolerPackage)) {
            this.grantRuntimePermissions(printSpoolerPackage, LOCATION_PERMISSIONS, true, userId);
        }
        if ((emergencyInfoPckg = this.getDefaultSystemHandlerActivityPackage(emergencyInfoIntent = new Intent("android.telephony.action.EMERGENCY_ASSISTANCE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(emergencyInfoPckg)) {
            this.grantRuntimePermissions(emergencyInfoPckg, CONTACTS_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(emergencyInfoPckg, PHONE_PERMISSIONS, true, userId);
        }
        Intent nfcTagIntent = new Intent("android.intent.action.VIEW");
        nfcTagIntent.setType("vnd.android.cursor.item/ndef_msg");
        PackageParser.Package nfcTagPkg = this.getDefaultSystemHandlerActivityPackage(nfcTagIntent, userId);
        if (nfcTagPkg != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(nfcTagPkg)) {
            this.grantRuntimePermissions(nfcTagPkg, CONTACTS_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(nfcTagPkg, PHONE_PERMISSIONS, false, userId);
        }
        if ((storageManagerPckg = this.getDefaultSystemHandlerActivityPackage(storageManagerIntent = new Intent("android.os.storage.action.MANAGE_STORAGE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(storageManagerPckg)) {
            this.grantRuntimePermissions(storageManagerPckg, STORAGE_PERMISSIONS, true, userId);
        }
        if ((companionDeviceDiscoveryPackage = this.getSystemPackage("com.android.companiondevicemanager")) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(companionDeviceDiscoveryPackage)) {
            this.grantRuntimePermissions(companionDeviceDiscoveryPackage, LOCATION_PERMISSIONS, true, userId);
        }
        if ((ringtonePickerPackage = this.getDefaultSystemHandlerActivityPackage(ringtonePickerIntent = new Intent("android.intent.action.RINGTONE_PICKER"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(ringtonePickerPackage)) {
            this.grantRuntimePermissions(ringtonePickerPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if (!TextUtils.isEmpty(textClassifierPackageName = this.mContext.getPackageManager().getSystemTextClassifierPackageName()) && (textClassifierPackage = this.getSystemPackage(textClassifierPackageName)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(textClassifierPackage)) {
            this.grantRuntimePermissions(textClassifierPackage, PHONE_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(textClassifierPackage, SMS_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(textClassifierPackage, CALENDAR_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(textClassifierPackage, LOCATION_PERMISSIONS, false, userId);
            this.grantRuntimePermissions(textClassifierPackage, CONTACTS_PERMISSIONS, false, userId);
        }
        if ((sharedStorageBackupPackage = this.getSystemPackage("com.android.sharedstoragebackup")) != null) {
            this.grantRuntimePermissions(sharedStorageBackupPackage, STORAGE_PERMISSIONS, true, userId);
        }
        if (this.mPermissionGrantedCallback != null) {
            this.mPermissionGrantedCallback.onDefaultRuntimePermissionsGranted(userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSystemDialerApp(PackageParser.Package dialerPackage, int userId) {
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dialerPackage)) {
            boolean isPhonePermFixed = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch", 0);
            this.grantRuntimePermissions(dialerPackage, PHONE_PERMISSIONS, isPhonePermFixed, userId);
            this.grantRuntimePermissions(dialerPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(dialerPackage, SMS_PERMISSIONS, userId);
            this.grantRuntimePermissions(dialerPackage, MICROPHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(dialerPackage, CAMERA_PERMISSIONS, userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSystemSmsApp(PackageParser.Package smsPackage, int userId) {
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(smsPackage)) {
            this.grantRuntimePermissions(smsPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(smsPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissions(smsPackage, SMS_PERMISSIONS, userId);
            this.grantRuntimePermissions(smsPackage, STORAGE_PERMISSIONS, userId);
            this.grantRuntimePermissions(smsPackage, MICROPHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(smsPackage, CAMERA_PERMISSIONS, userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSystemUseOpenWifiApp(PackageParser.Package useOpenWifiPackage, int userId) {
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(useOpenWifiPackage)) {
            this.grantRuntimePermissions(useOpenWifiPackage, COARSE_LOCATION_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultSmsApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default sms app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package smsPackage = this.getPackage(packageName);
        if (smsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(smsPackage)) {
            this.grantRuntimePermissions(smsPackage, PHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(smsPackage, CONTACTS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(smsPackage, SMS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(smsPackage, STORAGE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(smsPackage, MICROPHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(smsPackage, CAMERA_PERMISSIONS, false, true, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultDialerApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default dialer app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package dialerPackage = this.getPackage(packageName);
        if (dialerPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dialerPackage)) {
            this.grantRuntimePermissions(dialerPackage, PHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(dialerPackage, CONTACTS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(dialerPackage, SMS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(dialerPackage, MICROPHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissions(dialerPackage, CAMERA_PERMISSIONS, false, true, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultUseOpenWifiApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default Use Open WiFi app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package useOpenWifiPackage = this.getPackage(packageName);
        if (useOpenWifiPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(useOpenWifiPackage)) {
            this.grantRuntimePermissions(useOpenWifiPackage, COARSE_LOCATION_PERMISSIONS, false, true, userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSimCallManager(PackageParser.Package simCallManagerPackage, int userId) {
        Log.i(TAG, "Granting permissions to sim call manager for user:" + userId);
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(simCallManagerPackage)) {
            this.grantRuntimePermissions(simCallManagerPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(simCallManagerPackage, MICROPHONE_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultSimCallManager(String packageName, int userId) {
        if (packageName == null) {
            return;
        }
        PackageParser.Package simCallManagerPackage = this.getPackage(packageName);
        if (simCallManagerPackage != null) {
            this.grantDefaultPermissionsToDefaultSimCallManager(simCallManagerPackage, userId);
        }
    }

    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled carrier apps for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package carrierPackage = this.getSystemPackage(packageName);
            if (carrierPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(carrierPackage)) continue;
            this.grantRuntimePermissions(carrierPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(carrierPackage, LOCATION_PERMISSIONS, userId);
            this.grantRuntimePermissions(carrierPackage, SMS_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled ImsServices for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package imsServicePackage = this.getSystemPackage(packageName);
            if (imsServicePackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(imsServicePackage)) continue;
            this.grantRuntimePermissions(imsServicePackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(imsServicePackage, MICROPHONE_PERMISSIONS, userId);
            this.grantRuntimePermissions(imsServicePackage, LOCATION_PERMISSIONS, userId);
            this.grantRuntimePermissions(imsServicePackage, CAMERA_PERMISSIONS, userId);
            this.grantRuntimePermissions(imsServicePackage, CONTACTS_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled data services for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package dataServicePackage = this.getSystemPackage(packageName);
            if (dataServicePackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dataServicePackage)) continue;
            this.grantRuntimePermissions(dataServicePackage, PHONE_PERMISSIONS, true, userId);
            this.grantRuntimePermissions(dataServicePackage, LOCATION_PERMISSIONS, true, userId);
        }
    }

    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) {
        Log.i(TAG, "Revoking permissions from disabled data services for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package dataServicePackage = this.getSystemPackage(packageName);
            if (dataServicePackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dataServicePackage)) continue;
            this.revokeRuntimePermissions(dataServicePackage, PHONE_PERMISSIONS, true, userId);
            this.revokeRuntimePermissions(dataServicePackage, LOCATION_PERMISSIONS, true, userId);
        }
    }

    public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to active LUI app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package luiAppPackage = this.getSystemPackage(packageName);
        if (luiAppPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(luiAppPackage)) {
            this.grantRuntimePermissions(luiAppPackage, CAMERA_PERMISSIONS, true, userId);
        }
    }

    public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) {
        Log.i(TAG, "Revoke permissions from LUI apps for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package luiAppPackage = this.getSystemPackage(packageName);
            if (luiAppPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(luiAppPackage)) continue;
            this.revokeRuntimePermissions(luiAppPackage, CAMERA_PERMISSIONS, true, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultBrowser(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default browser for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package browserPackage = this.getSystemPackage(packageName);
        if (browserPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(browserPackage)) {
            this.grantRuntimePermissions(browserPackage, LOCATION_PERMISSIONS, false, false, userId);
        }
    }

    private PackageParser.Package getDefaultSystemHandlerActivityPackage(Intent intent, int userId) {
        ResolveInfo handler = this.mServiceInternal.resolveIntent(intent, intent.resolveType(this.mContext.getContentResolver()), 794624, userId, false, Binder.getCallingUid());
        if (handler == null || handler.activityInfo == null) {
            return null;
        }
        if (this.mServiceInternal.isResolveActivityComponent(handler.activityInfo)) {
            return null;
        }
        return this.getSystemPackage(handler.activityInfo.packageName);
    }

    private PackageParser.Package getDefaultSystemHandlerServicePackage(Intent intent, int userId) {
        List<ResolveInfo> handlers = this.mServiceInternal.queryIntentServices(intent, 794624, Binder.getCallingUid(), userId);
        if (handlers == null) {
            return null;
        }
        int handlerCount = handlers.size();
        for (int i = 0; i < handlerCount; ++i) {
            ResolveInfo handler = handlers.get(i);
            PackageParser.Package handlerPackage = this.getSystemPackage(handler.serviceInfo.packageName);
            if (handlerPackage == null) continue;
            return handlerPackage;
        }
        return null;
    }

    private List<PackageParser.Package> getHeadlessSyncAdapterPackages(String[] syncAdapterPackageNames, int userId) {
        ArrayList<PackageParser.Package> syncAdapterPackages = new ArrayList<PackageParser.Package>();
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.LAUNCHER");
        for (String syncAdapterPackageName : syncAdapterPackageNames) {
            PackageParser.Package syncAdapterPackage;
            homeIntent.setPackage(syncAdapterPackageName);
            ResolveInfo homeActivity = this.mServiceInternal.resolveIntent(homeIntent, homeIntent.resolveType(this.mContext.getContentResolver()), 794624, userId, false, Binder.getCallingUid());
            if (homeActivity != null || (syncAdapterPackage = this.getSystemPackage(syncAdapterPackageName)) == null) continue;
            syncAdapterPackages.add(syncAdapterPackage);
        }
        return syncAdapterPackages;
    }

    private PackageParser.Package getDefaultProviderAuthorityPackage(String authority, int userId) {
        ProviderInfo provider = this.mServiceInternal.resolveContentProvider(authority, 794624, userId);
        if (provider != null) {
            return this.getSystemPackage(provider.packageName);
        }
        return null;
    }

    private PackageParser.Package getPackage(String packageName) {
        return this.mServiceInternal.getPackage(packageName);
    }

    private PackageParser.Package getSystemPackage(String packageName) {
        PackageParser.Package pkg = this.getPackage(packageName);
        if (pkg != null && pkg.isSystem()) {
            return !this.isSysComponentOrPersistentPlatformSignedPrivApp(pkg) ? pkg : null;
        }
        return null;
    }

    private void grantRuntimePermissions(PackageParser.Package pkg, Set<String> permissions, int userId) {
        this.grantRuntimePermissions(pkg, permissions, false, false, userId);
    }

    private void grantRuntimePermissions(PackageParser.Package pkg, Set<String> permissions, boolean systemFixed, int userId) {
        this.grantRuntimePermissions(pkg, permissions, systemFixed, false, userId);
    }

    private void revokeRuntimePermissions(PackageParser.Package pkg, Set<String> permissions, boolean systemFixed, int userId) {
        if (pkg.requestedPermissions.isEmpty()) {
            return;
        }
        ArraySet<String> revokablePermissions = new ArraySet<String>(pkg.requestedPermissions);
        for (String permission2 : permissions) {
            int flags;
            if (!revokablePermissions.contains(permission2) || ((flags = this.mServiceInternal.getPermissionFlagsTEMP(permission2, pkg.packageName, userId)) & 0x20) == 0 || (flags & 4) != 0 || (flags & 0x10) != 0 && !systemFixed) continue;
            this.mServiceInternal.revokeRuntimePermission(pkg.packageName, permission2, userId, false);
            this.mServiceInternal.updatePermissionFlagsTEMP(permission2, pkg.packageName, 32, 0, userId);
        }
    }

    private void grantRuntimePermissions(PackageParser.Package pkg, Set<String> permissions, boolean systemFixed, boolean ignoreSystemPackage, int userId) {
        PackageParser.Package disabledPkg;
        if (pkg.requestedPermissions.isEmpty()) {
            return;
        }
        ArrayList<String> requestedPermissions = pkg.requestedPermissions;
        ArraySet<String> grantablePermissions = null;
        if (!ignoreSystemPackage && pkg.isUpdatedSystemApp() && (disabledPkg = this.mServiceInternal.getDisabledPackage(pkg.packageName)) != null) {
            if (disabledPkg.requestedPermissions.isEmpty()) {
                return;
            }
            if (!requestedPermissions.equals(disabledPkg.requestedPermissions)) {
                grantablePermissions = new ArraySet<String>(requestedPermissions);
                requestedPermissions = disabledPkg.requestedPermissions;
            }
        }
        int grantablePermissionCount = requestedPermissions.size();
        for (int i = 0; i < grantablePermissionCount; ++i) {
            String permission2 = (String)requestedPermissions.get(i);
            if (grantablePermissions != null && !grantablePermissions.contains(permission2) || !permissions.contains(permission2)) continue;
            int flags = this.mServiceInternal.getPermissionFlagsTEMP(permission2, pkg.packageName, userId);
            if (flags == 0 || ignoreSystemPackage) {
                if ((flags & 4) != 0) continue;
                this.mServiceInternal.grantRuntimePermission(pkg.packageName, permission2, userId, false);
                int newFlags = 32;
                if (systemFixed) {
                    newFlags |= 0x10;
                }
                this.mServiceInternal.updatePermissionFlagsTEMP(permission2, pkg.packageName, newFlags, newFlags, userId);
            }
            if ((flags & 0x20) == 0 || (flags & 0x10) == 0 || systemFixed) continue;
            this.mServiceInternal.updatePermissionFlagsTEMP(permission2, pkg.packageName, 16, 0, userId);
        }
    }

    private boolean isSysComponentOrPersistentPlatformSignedPrivApp(PackageParser.Package pkg) {
        if (UserHandle.getAppId(pkg.applicationInfo.uid) < 10000) {
            return true;
        }
        if (!pkg.isPrivileged()) {
            return false;
        }
        PackageParser.Package disabledPkg = this.mServiceInternal.getDisabledPackage(pkg.packageName);
        if (disabledPkg != null ? (disabledPkg.applicationInfo.flags & 8) == 0 : (pkg.applicationInfo.flags & 8) == 0) {
            return false;
        }
        String systemPackageName = this.mServiceInternal.getKnownPackageName(0, 0);
        PackageParser.Package systemPackage = this.getPackage(systemPackageName);
        return pkg.mSigningDetails.hasAncestorOrSelf(systemPackage.mSigningDetails) || systemPackage.mSigningDetails.checkCapability(pkg.mSigningDetails, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantDefaultPermissionExceptions(int userId) {
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGrantExceptions == null) {
                this.mGrantExceptions = this.readDefaultPermissionExceptionsLocked();
            }
        }
        ArraySet<String> permissions = null;
        int exceptionCount = this.mGrantExceptions.size();
        for (int i = 0; i < exceptionCount; ++i) {
            String packageName = this.mGrantExceptions.keyAt(i);
            PackageParser.Package pkg = this.getSystemPackage(packageName);
            List<DefaultPermissionGrant> permissionGrants = this.mGrantExceptions.valueAt(i);
            int permissionGrantCount = permissionGrants.size();
            for (int j = 0; j < permissionGrantCount; ++j) {
                DefaultPermissionGrant permissionGrant = permissionGrants.get(j);
                if (permissions == null) {
                    permissions = new ArraySet<String>();
                } else {
                    permissions.clear();
                }
                permissions.add(permissionGrant.name);
                this.grantRuntimePermissions(pkg, permissions, permissionGrant.fixed, userId);
            }
        }
    }

    private File[] getDefaultPermissionFiles() {
        ArrayList ret = new ArrayList();
        File dir = new File(Environment.getRootDirectory(), "etc/default-permissions");
        if (dir.isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getVendorDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getOdmDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getProductDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.embedded", 0) && (dir = new File(Environment.getOemDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        return ret.isEmpty() ? null : ret.toArray(new File[0]);
    }

    private ArrayMap<String, List<DefaultPermissionGrant>> readDefaultPermissionExceptionsLocked() {
        File[] files = this.getDefaultPermissionFiles();
        if (files == null) {
            return new ArrayMap<String, List<DefaultPermissionGrant>>(0);
        }
        ArrayMap<String, List<DefaultPermissionGrant>> grantExceptions = new ArrayMap<String, List<DefaultPermissionGrant>>();
        for (File file : files) {
            if (!file.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + file + " in " + file.getParent() + " directory, ignoring");
                continue;
            }
            if (!file.canRead()) {
                Slog.w(TAG, "Default permissions file " + file + " cannot be read");
                continue;
            }
            try (BufferedInputStream str = new BufferedInputStream(new FileInputStream(file));){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(str, null);
                this.parse(parser, grantExceptions);
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "Error reading default permissions file " + file, e);
            }
        }
        return grantExceptions;
    }

    private void parse(XmlPullParser parser, Map<String, List<DefaultPermissionGrant>> outGrantExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_EXCEPTIONS.equals(parser.getName())) {
                this.parseExceptions(parser, outGrantExceptions);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName());
        }
    }

    private void parseExceptions(XmlPullParser parser, Map<String, List<DefaultPermissionGrant>> outGrantExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_EXCEPTION.equals(parser.getName())) {
                String packageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                List<DefaultPermissionGrant> packageExceptions = outGrantExceptions.get(packageName);
                if (packageExceptions == null) {
                    PackageParser.Package pkg = this.getSystemPackage(packageName);
                    if (pkg == null) {
                        Log.w(TAG, "Unknown package:" + packageName);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg)) {
                        Log.w(TAG, "Skipping non supporting runtime permissions package:" + packageName);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    packageExceptions = new ArrayList<DefaultPermissionGrant>();
                    outGrantExceptions.put(packageName, packageExceptions);
                }
                this.parsePermission(parser, packageExceptions);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName() + "under <exceptions>");
        }
    }

    private void parsePermission(XmlPullParser parser, List<DefaultPermissionGrant> outPackageExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_PERMISSION.contains(parser.getName())) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name == null) {
                    Log.w(TAG, "Mandatory name attribute missing for permission tag");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                boolean fixed = XmlUtils.readBooleanAttribute(parser, ATTR_FIXED);
                DefaultPermissionGrant exception = new DefaultPermissionGrant(name, fixed);
                outPackageExceptions.add(exception);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName() + "under <exception>");
        }
    }

    private static boolean doesPackageSupportRuntimePermissions(PackageParser.Package pkg) {
        return pkg.applicationInfo.targetSdkVersion > 22;
    }

    static {
        PHONE_PERMISSIONS.add("android.permission.READ_PHONE_STATE");
        PHONE_PERMISSIONS.add("android.permission.CALL_PHONE");
        PHONE_PERMISSIONS.add("android.permission.READ_CALL_LOG");
        PHONE_PERMISSIONS.add("android.permission.WRITE_CALL_LOG");
        PHONE_PERMISSIONS.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        PHONE_PERMISSIONS.add("android.permission.USE_SIP");
        PHONE_PERMISSIONS.add("android.permission.PROCESS_OUTGOING_CALLS");
        CONTACTS_PERMISSIONS = new ArraySet<String>();
        CONTACTS_PERMISSIONS.add("android.permission.READ_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.WRITE_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.GET_ACCOUNTS");
        LOCATION_PERMISSIONS = new ArraySet<String>();
        LOCATION_PERMISSIONS.add("android.permission.ACCESS_FINE_LOCATION");
        LOCATION_PERMISSIONS.add("android.permission.ACCESS_COARSE_LOCATION");
        COARSE_LOCATION_PERMISSIONS = new ArraySet<String>();
        COARSE_LOCATION_PERMISSIONS.add("android.permission.ACCESS_COARSE_LOCATION");
        CALENDAR_PERMISSIONS = new ArraySet<String>();
        CALENDAR_PERMISSIONS.add("android.permission.READ_CALENDAR");
        CALENDAR_PERMISSIONS.add("android.permission.WRITE_CALENDAR");
        SMS_PERMISSIONS = new ArraySet<String>();
        SMS_PERMISSIONS.add("android.permission.SEND_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_SMS");
        SMS_PERMISSIONS.add("android.permission.READ_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_WAP_PUSH");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_MMS");
        SMS_PERMISSIONS.add("android.permission.READ_CELL_BROADCASTS");
        MICROPHONE_PERMISSIONS = new ArraySet<String>();
        MICROPHONE_PERMISSIONS.add("android.permission.RECORD_AUDIO");
        CAMERA_PERMISSIONS = new ArraySet<String>();
        CAMERA_PERMISSIONS.add("android.permission.CAMERA");
        SENSORS_PERMISSIONS = new ArraySet<String>();
        SENSORS_PERMISSIONS.add("android.permission.BODY_SENSORS");
        STORAGE_PERMISSIONS = new ArraySet<String>();
        STORAGE_PERMISSIONS.add("android.permission.READ_EXTERNAL_STORAGE");
        STORAGE_PERMISSIONS.add("android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private static final class DefaultPermissionGrant {
        final String name;
        final boolean fixed;

        public DefaultPermissionGrant(String name, boolean fixed) {
            this.name = name;
            this.fixed = fixed;
        }
    }

    public static interface DefaultPermissionGrantedCallback {
        public void onDefaultRuntimePermissionsGranted(int var1);
    }
}

