/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.util.DisplayMetrics;

public final class IconUtilities {
    private int mIconWidth = -1;
    private int mIconHeight = -1;
    private int mIconTextureWidth = -1;
    private int mIconTextureHeight = -1;
    private final Rect mOldBounds = new Rect();
    private final Canvas mCanvas = new Canvas();
    private final DisplayMetrics mDisplayMetrics;
    private ColorFilter mDisabledColorFilter;

    public IconUtilities(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = this.mDisplayMetrics = resources.getDisplayMetrics();
        float density = metrics.density;
        float blurPx = 5.0f * density;
        this.mIconWidth = this.mIconHeight = (int)resources.getDimension(0x1050000);
        this.mIconTextureWidth = this.mIconTextureHeight = this.mIconWidth + (int)(blurPx * 2.0f);
        this.mCanvas.setDrawFilter(new PaintFlagsDrawFilter(4, 2));
    }

    public Bitmap createIconBitmap(Drawable icon) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap;
        int width = this.mIconWidth;
        int height = this.mIconHeight;
        if (icon instanceof PaintDrawable) {
            PaintDrawable painter = (PaintDrawable)icon;
            painter.setIntrinsicWidth(width);
            painter.setIntrinsicHeight(height);
        } else if (icon instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)icon).getBitmap()).getDensity() == 0) {
            bitmapDrawable.setTargetDensity(this.mDisplayMetrics);
        }
        int sourceWidth = icon.getIntrinsicWidth();
        int sourceHeight = icon.getIntrinsicHeight();
        if (sourceWidth > 0 && sourceHeight > 0) {
            if (width < sourceWidth || height < sourceHeight) {
                float ratio = (float)sourceWidth / (float)sourceHeight;
                if (sourceWidth > sourceHeight) {
                    height = (int)((float)width / ratio);
                } else if (sourceHeight > sourceWidth) {
                    width = (int)((float)height * ratio);
                }
            } else if (sourceWidth < width && sourceHeight < height) {
                width = sourceWidth;
                height = sourceHeight;
            }
        }
        int textureWidth = this.mIconTextureWidth;
        int textureHeight = this.mIconTextureHeight;
        Bitmap bitmap2 = Bitmap.createBitmap(textureWidth, textureHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = this.mCanvas;
        canvas.setBitmap(bitmap2);
        int left = (textureWidth - width) / 2;
        int top = (textureHeight - height) / 2;
        this.mOldBounds.set(icon.getBounds());
        icon.setBounds(left, top, left + width, top + height);
        icon.draw(canvas);
        icon.setBounds(this.mOldBounds);
        return bitmap2;
    }

    public ColorFilter getDisabledColorFilter() {
        if (this.mDisabledColorFilter != null) {
            return this.mDisabledColorFilter;
        }
        ColorMatrix brightnessMatrix = new ColorMatrix();
        float brightnessF = 0.5f;
        int brightnessI = (int)(255.0f * brightnessF);
        float scale = 1.0f - brightnessF;
        float[] mat = brightnessMatrix.getArray();
        mat[0] = scale;
        mat[6] = scale;
        mat[12] = scale;
        mat[4] = brightnessI;
        mat[9] = brightnessI;
        mat[14] = brightnessI;
        ColorMatrix filterMatrix = new ColorMatrix();
        filterMatrix.setSaturation(0.0f);
        filterMatrix.preConcat(brightnessMatrix);
        this.mDisabledColorFilter = new ColorMatrixColorFilter(filterMatrix);
        return this.mDisabledColorFilter;
    }
}

