/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.app.ActivityManager;
import android.content.Context;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Slog;
import android.view.WindowManager;
import com.android.server.policy.WindowManagerPolicy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class PolicyControl {
    private static String TAG = "PolicyControl";
    private static boolean DEBUG = false;
    private static final String NAME_IMMERSIVE_FULL = "immersive.full";
    private static final String NAME_IMMERSIVE_STATUS = "immersive.status";
    private static final String NAME_IMMERSIVE_NAVIGATION = "immersive.navigation";
    private static final String NAME_IMMERSIVE_PRECONFIRMATIONS = "immersive.preconfirms";
    private static String sSettingValue;
    private static Filter sImmersivePreconfirmationsFilter;
    private static Filter sImmersiveStatusFilter;
    private static Filter sImmersiveNavigationFilter;

    public static int getSystemUiVisibility(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        int vis;
        attrs = attrs != null ? attrs : win.getAttrs();
        int n = vis = win != null ? win.getSystemUiVisibility() : attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            vis |= 0x1404;
            vis &= 0xBFFFFEFF;
        }
        if (sImmersiveNavigationFilter != null && sImmersiveNavigationFilter.matches(attrs)) {
            vis |= 0x1202;
            vis &= 0x7FFFFEFF;
        }
        return vis;
    }

    public static int getWindowFlags(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        attrs = attrs != null ? attrs : win.getAttrs();
        int flags = attrs.flags;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            flags |= 0x400;
            flags &= 0xFBFFF7FF;
        }
        if (sImmersiveNavigationFilter != null && sImmersiveNavigationFilter.matches(attrs)) {
            flags &= 0xF7FFFFFF;
        }
        return flags;
    }

    public static int adjustClearableFlags(WindowManagerPolicy.WindowState win, int clearableFlags) {
        WindowManager.LayoutParams attrs;
        WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            clearableFlags &= 0xFFFFFFFB;
        }
        return clearableFlags;
    }

    public static boolean disableImmersiveConfirmation(String pkg) {
        return sImmersivePreconfirmationsFilter != null && sImmersivePreconfirmationsFilter.matches(pkg) || ActivityManager.isRunningInTestHarness();
    }

    public static void reloadFromSetting(Context context) {
        if (DEBUG) {
            Slog.d(TAG, "reloadFromSetting()");
        }
        String value = null;
        try {
            value = Settings.Global.getStringForUser(context.getContentResolver(), "policy_control", -2);
            if (sSettingValue != null && sSettingValue.equals(value)) {
                return;
            }
            PolicyControl.setFilters(value);
            sSettingValue = value;
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error loading policy control, value=" + value, t);
        }
    }

    public static void dump(String prefix, PrintWriter pw) {
        PolicyControl.dump("sImmersiveStatusFilter", sImmersiveStatusFilter, prefix, pw);
        PolicyControl.dump("sImmersiveNavigationFilter", sImmersiveNavigationFilter, prefix, pw);
        PolicyControl.dump("sImmersivePreconfirmationsFilter", sImmersivePreconfirmationsFilter, prefix, pw);
    }

    private static void dump(String name, Filter filter, String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("PolicyControl.");
        pw.print(name);
        pw.print('=');
        if (filter == null) {
            pw.println("null");
        } else {
            filter.dump(pw);
            pw.println();
        }
    }

    private static void setFilters(String value) {
        if (DEBUG) {
            Slog.d(TAG, "setFilters: " + value);
        }
        sImmersiveStatusFilter = null;
        sImmersiveNavigationFilter = null;
        sImmersivePreconfirmationsFilter = null;
        if (value != null) {
            String[] nvps;
            for (String nvp : nvps = value.split(":")) {
                Filter f;
                int i = nvp.indexOf(61);
                if (i == -1) continue;
                String n = nvp.substring(0, i);
                String v = nvp.substring(i + 1);
                if (n.equals(NAME_IMMERSIVE_FULL)) {
                    sImmersiveStatusFilter = sImmersiveNavigationFilter = (f = Filter.parse(v));
                    if (sImmersivePreconfirmationsFilter != null) continue;
                    sImmersivePreconfirmationsFilter = f;
                    continue;
                }
                if (n.equals(NAME_IMMERSIVE_STATUS)) {
                    sImmersiveStatusFilter = f = Filter.parse(v);
                    continue;
                }
                if (n.equals(NAME_IMMERSIVE_NAVIGATION)) {
                    sImmersiveNavigationFilter = f = Filter.parse(v);
                    if (sImmersivePreconfirmationsFilter != null) continue;
                    sImmersivePreconfirmationsFilter = f;
                    continue;
                }
                if (!n.equals(NAME_IMMERSIVE_PRECONFIRMATIONS)) continue;
                sImmersivePreconfirmationsFilter = f = Filter.parse(v);
            }
        }
        if (DEBUG) {
            Slog.d(TAG, "immersiveStatusFilter: " + sImmersiveStatusFilter);
            Slog.d(TAG, "immersiveNavigationFilter: " + sImmersiveNavigationFilter);
            Slog.d(TAG, "immersivePreconfirmationsFilter: " + sImmersivePreconfirmationsFilter);
        }
    }

    private static class Filter {
        private static final String ALL = "*";
        private static final String APPS = "apps";
        private final ArraySet<String> mWhitelist;
        private final ArraySet<String> mBlacklist;

        private Filter(ArraySet<String> whitelist, ArraySet<String> blacklist) {
            this.mWhitelist = whitelist;
            this.mBlacklist = blacklist;
        }

        boolean matches(WindowManager.LayoutParams attrs) {
            boolean isApp;
            if (attrs == null) {
                return false;
            }
            boolean bl = isApp = attrs.type >= 1 && attrs.type <= 99;
            if (isApp && this.mBlacklist.contains(APPS)) {
                return false;
            }
            if (this.onBlacklist(attrs.packageName)) {
                return false;
            }
            if (isApp && this.mWhitelist.contains(APPS)) {
                return true;
            }
            return this.onWhitelist(attrs.packageName);
        }

        boolean matches(String packageName) {
            return !this.onBlacklist(packageName) && this.onWhitelist(packageName);
        }

        private boolean onBlacklist(String packageName) {
            return this.mBlacklist.contains(packageName) || this.mBlacklist.contains(ALL);
        }

        private boolean onWhitelist(String packageName) {
            return this.mWhitelist.contains(ALL) || this.mWhitelist.contains(packageName);
        }

        void dump(PrintWriter pw) {
            pw.print("Filter[");
            this.dump("whitelist", this.mWhitelist, pw);
            pw.print(',');
            this.dump("blacklist", this.mBlacklist, pw);
            pw.print(']');
        }

        private void dump(String name, ArraySet<String> set, PrintWriter pw) {
            pw.print(name);
            pw.print("=(");
            int n = set.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    pw.print(',');
                }
                pw.print(set.valueAt(i));
            }
            pw.print(')');
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            this.dump(new PrintWriter((Writer)sw, true));
            return sw.toString();
        }

        static Filter parse(String value) {
            if (value == null) {
                return null;
            }
            ArraySet<String> whitelist = new ArraySet<String>();
            ArraySet<String> blacklist = new ArraySet<String>();
            for (String token : value.split(",")) {
                if ((token = token.trim()).startsWith("-") && token.length() > 1) {
                    token = token.substring(1);
                    blacklist.add(token);
                    continue;
                }
                whitelist.add(token);
            }
            return new Filter(whitelist, blacklist);
        }
    }
}

