/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy.keyguard;

import android.app.ActivityManager;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.security.IKeystoreService;
import android.util.Slog;
import com.android.internal.policy.IKeyguardService;
import com.android.internal.policy.IKeyguardStateCallback;
import com.android.internal.widget.LockPatternUtils;
import java.io.PrintWriter;

public class KeyguardStateMonitor
extends IKeyguardStateCallback.Stub {
    private static final String TAG = "KeyguardStateMonitor";
    private volatile boolean mIsShowing = true;
    private volatile boolean mSimSecure = true;
    private volatile boolean mInputRestricted = true;
    private volatile boolean mTrusted = false;
    private volatile boolean mHasLockscreenWallpaper = false;
    private int mCurrentUserId;
    private final LockPatternUtils mLockPatternUtils;
    private final StateCallback mCallback;
    IKeystoreService mKeystoreService;

    public KeyguardStateMonitor(Context context, IKeyguardService service, StateCallback callback) {
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mCurrentUserId = ActivityManager.getCurrentUser();
        this.mCallback = callback;
        this.mKeystoreService = IKeystoreService.Stub.asInterface(ServiceManager.getService("android.security.keystore"));
        try {
            service.addStateMonitorCallback(this);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote Exception", e);
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isSecure(int userId) {
        return this.mLockPatternUtils.isSecure(userId) || this.mSimSecure;
    }

    public boolean isInputRestricted() {
        return this.mInputRestricted;
    }

    public boolean isTrusted() {
        return this.mTrusted;
    }

    public boolean hasLockscreenWallpaper() {
        return this.mHasLockscreenWallpaper;
    }

    @Override
    public void onShowingStateChanged(boolean showing) {
        this.mIsShowing = showing;
        this.mCallback.onShowingChanged();
        try {
            this.mKeystoreService.onKeyguardVisibilityChanged(showing, this.mCurrentUserId);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error informing keystore of screen lock", e);
        }
    }

    @Override
    public void onSimSecureStateChanged(boolean simSecure) {
        this.mSimSecure = simSecure;
    }

    public synchronized void setCurrentUser(int userId) {
        this.mCurrentUserId = userId;
    }

    private synchronized int getCurrentUser() {
        return this.mCurrentUserId;
    }

    @Override
    public void onInputRestrictedStateChanged(boolean inputRestricted) {
        this.mInputRestricted = inputRestricted;
    }

    @Override
    public void onTrustedChanged(boolean trusted) {
        this.mTrusted = trusted;
        this.mCallback.onTrustedChanged();
    }

    @Override
    public void onHasLockscreenWallpaperChanged(boolean hasLockscreenWallpaper) {
        this.mHasLockscreenWallpaper = hasLockscreenWallpaper;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + TAG);
        prefix = prefix + "  ";
        pw.println(prefix + "mIsShowing=" + this.mIsShowing);
        pw.println(prefix + "mSimSecure=" + this.mSimSecure);
        pw.println(prefix + "mInputRestricted=" + this.mInputRestricted);
        pw.println(prefix + "mTrusted=" + this.mTrusted);
        pw.println(prefix + "mCurrentUserId=" + this.mCurrentUserId);
    }

    public static interface StateCallback {
        public void onTrustedChanged();

        public void onShowingChanged();
    }
}

