/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.slice.SliceManagerService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PinnedSliceState {
    private static final long SLICE_TIMEOUT = 5000L;
    private static final String TAG = "PinnedSliceState";
    private final Object mLock;
    private final SliceManagerService mService;
    private final Uri mUri;
    @GuardedBy(value="mLock")
    private final ArraySet<String> mPinnedPkgs = new ArraySet();
    @GuardedBy(value="mLock")
    private final ArrayMap<IBinder, ListenerInfo> mListeners = new ArrayMap();
    private final String mPkg;
    @GuardedBy(value="mLock")
    private SliceSpec[] mSupportedSpecs = null;
    private final IBinder.DeathRecipient mDeathRecipient = this::handleRecheckListeners;
    private boolean mSlicePinned;

    public PinnedSliceState(SliceManagerService service, Uri uri, String pkg) {
        this.mService = service;
        this.mUri = uri;
        this.mPkg = pkg;
        this.mLock = this.mService.getLock();
    }

    public String getPkg() {
        return this.mPkg;
    }

    public SliceSpec[] getSpecs() {
        return this.mSupportedSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeSpecs(SliceSpec[] supportedSpecs) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSupportedSpecs == null) {
                this.mSupportedSpecs = supportedSpecs;
            } else {
                List<SliceSpec> specs = Arrays.asList(this.mSupportedSpecs);
                this.mSupportedSpecs = (SliceSpec[])specs.stream().map(s -> {
                    SliceSpec other = this.findSpec(supportedSpecs, s.getType());
                    if (other == null) {
                        return null;
                    }
                    if (other.getRevision() < s.getRevision()) {
                        return other;
                    }
                    return s;
                }).filter(s -> s != null).toArray(SliceSpec[]::new);
            }
        }
    }

    private SliceSpec findSpec(SliceSpec[] specs, String type) {
        for (SliceSpec spec : specs) {
            if (!Objects.equals(spec.getType(), type)) continue;
            return spec;
        }
        return null;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void destroy() {
        this.setSlicePinned(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSlicePinned(boolean pinned) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSlicePinned == pinned) {
                return;
            }
            this.mSlicePinned = pinned;
            if (pinned) {
                this.mService.getHandler().post(this::handleSendPinned);
            } else {
                this.mService.getHandler().post(this::handleSendUnpinned);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(String pkg, SliceSpec[] specs, IBinder token) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.put(token, new ListenerInfo(token, pkg, true, Binder.getCallingUid(), Binder.getCallingPid()));
            try {
                token.linkToDeath(this.mDeathRecipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mergeSpecs(specs);
            this.setSlicePinned(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unpin(String pkg, IBinder token) {
        Object object = this.mLock;
        synchronized (object) {
            token.unlinkToDeath(this.mDeathRecipient, 0);
            this.mListeners.remove(token);
        }
        return !this.hasPinOrListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean hasPinOrListener() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mPinnedPkgs.isEmpty() || !this.mListeners.isEmpty();
        }
    }

    ContentProviderClient getClient() {
        ContentProviderClient client = this.mService.getContext().getContentResolver().acquireUnstableContentProviderClient(this.mUri);
        if (client == null) {
            return null;
        }
        client.setDetectNotResponding(5000L);
        return client;
    }

    private void checkSelfRemove() {
        if (!this.hasPinOrListener()) {
            this.mService.removePinnedSlice(this.mUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecheckListeners() {
        if (!this.hasPinOrListener()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                ListenerInfo l = this.mListeners.valueAt(i);
                if (l.token.isBinderAlive()) continue;
                this.mListeners.removeAt(i);
            }
            this.checkSelfRemove();
        }
    }

    private void handleSendPinned() {
        try (ContentProviderClient client = this.getClient();){
            if (client == null) {
                return;
            }
            Bundle b = new Bundle();
            b.putParcelable("slice_uri", this.mUri);
            try {
                client.call("pin", null, b);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Unable to contact " + this.mUri, e);
            }
        }
    }

    private void handleSendUnpinned() {
        try (ContentProviderClient client = this.getClient();){
            if (client == null) {
                return;
            }
            Bundle b = new Bundle();
            b.putParcelable("slice_uri", this.mUri);
            try {
                client.call("unpin", null, b);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Unable to contact " + this.mUri, e);
            }
        }
    }

    private class ListenerInfo {
        private IBinder token;
        private String pkg;
        private boolean hasPermission;
        private int callingUid;
        private int callingPid;

        public ListenerInfo(IBinder token, String pkg, boolean hasPermission, int callingUid, int callingPid) {
            this.token = token;
            this.pkg = pkg;
            this.hasPermission = hasPermission;
            this.callingUid = callingUid;
            this.callingPid = callingPid;
        }
    }
}

