/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.soundtrigger;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.hardware.soundtrigger.SoundTrigger;
import java.util.UUID;

public class SoundTriggerDbHelper
extends SQLiteOpenHelper {
    static final String TAG = "SoundTriggerDbHelper";
    static final boolean DBG = false;
    private static final String NAME = "st_sound_model.db";
    private static final int VERSION = 1;
    private static final String CREATE_TABLE_ST_SOUND_MODEL = "CREATE TABLE st_sound_model(model_uuid TEXT PRIMARY KEY,vendor_uuid TEXT,data BLOB )";

    public SoundTriggerDbHelper(Context context) {
        super(context, NAME, null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE_ST_SOUND_MODEL);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS st_sound_model");
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGenericSoundModel(SoundTrigger.GenericSoundModel soundModel) {
        SoundTriggerDbHelper soundTriggerDbHelper = this;
        synchronized (soundTriggerDbHelper) {
            boolean bl;
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("model_uuid", soundModel.uuid.toString());
            values.put("vendor_uuid", soundModel.vendorUuid.toString());
            values.put("data", soundModel.data);
            try {
                bl = db.insertWithOnConflict("st_sound_model", null, values, 5) != -1L;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SoundTrigger.GenericSoundModel getGenericSoundModel(UUID model_uuid) {
        SoundTriggerDbHelper soundTriggerDbHelper = this;
        synchronized (soundTriggerDbHelper) {
            String selectQuery = "SELECT  * FROM st_sound_model WHERE model_uuid= '" + model_uuid + "'";
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor c = db.rawQuery(selectQuery, null);
            try {
                if (!c.moveToFirst()) return null;
                byte[] data = c.getBlob(c.getColumnIndex("data"));
                String vendor_uuid = c.getString(c.getColumnIndex("vendor_uuid"));
                SoundTrigger.GenericSoundModel genericSoundModel = new SoundTrigger.GenericSoundModel(model_uuid, UUID.fromString(vendor_uuid), data);
                return genericSoundModel;
            }
            finally {
                c.close();
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteGenericSoundModel(UUID model_uuid) {
        SoundTriggerDbHelper soundTriggerDbHelper = this;
        synchronized (soundTriggerDbHelper) {
            boolean bl;
            SoundTrigger.GenericSoundModel soundModel = this.getGenericSoundModel(model_uuid);
            if (soundModel == null) {
                return false;
            }
            SQLiteDatabase db = this.getWritableDatabase();
            String soundModelClause = "model_uuid='" + soundModel.uuid.toString() + "'";
            try {
                bl = db.delete("st_sound_model", soundModelClause, null) != 0;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    public static interface GenericSoundModelContract {
        public static final String TABLE = "st_sound_model";
        public static final String KEY_MODEL_UUID = "model_uuid";
        public static final String KEY_VENDOR_UUID = "vendor_uuid";
        public static final String KEY_DATA = "data";
    }
}

