/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.soundtrigger;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.hardware.soundtrigger.SoundTriggerModule;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.PowerManager;
import android.os.RemoteException;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class SoundTriggerHelper
implements SoundTrigger.StatusListener {
    static final String TAG = "SoundTriggerHelper";
    static final boolean DBG = false;
    public static final int STATUS_ERROR = Integer.MIN_VALUE;
    public static final int STATUS_OK = 0;
    private static final int INVALID_VALUE = Integer.MIN_VALUE;
    final SoundTrigger.ModuleProperties mModuleProperties;
    private SoundTriggerModule mModule;
    private final Object mLock = new Object();
    private final Context mContext;
    private final TelephonyManager mTelephonyManager;
    private final PhoneStateListener mPhoneStateListener;
    private final PowerManager mPowerManager;
    private final HashMap<UUID, ModelData> mModelDataMap;
    private HashMap<Integer, UUID> mKeyphraseUuidMap;
    private boolean mCallActive = false;
    private boolean mIsPowerSaveMode = false;
    private boolean mServiceDisabled = false;
    private boolean mRecognitionRunning = false;
    private PowerSaveModeListener mPowerSaveModeListener;

    SoundTriggerHelper(Context context) {
        ArrayList<SoundTrigger.ModuleProperties> modules = new ArrayList<SoundTrigger.ModuleProperties>();
        int status = SoundTrigger.listModules(modules);
        this.mContext = context;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mModelDataMap = new HashMap();
        this.mKeyphraseUuidMap = new HashMap();
        this.mPhoneStateListener = new MyCallStateListener();
        if (status != 0 || modules.size() == 0) {
            Slog.w(TAG, "listModules status=" + status + ", # of modules=" + modules.size());
            this.mModuleProperties = null;
            this.mModule = null;
        } else {
            this.mModuleProperties = modules.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startGenericRecognition(UUID modelId, SoundTrigger.GenericSoundModel soundModel, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig recognitionConfig) {
        MetricsLogger.count(this.mContext, "sth_start_recognition", 1);
        if (modelId == null || soundModel == null || callback == null || recognitionConfig == null) {
            Slog.w(TAG, "Passed in bad data to startGenericRecognition().");
            return Integer.MIN_VALUE;
        }
        Object object = this.mLock;
        synchronized (object) {
            ModelData modelData = this.getOrCreateGenericModelDataLocked(modelId);
            if (modelData == null) {
                Slog.w(TAG, "Irrecoverable error occurred, check UUID / sound model data.");
                return Integer.MIN_VALUE;
            }
            return this.startRecognition(soundModel, modelData, callback, recognitionConfig, Integer.MIN_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startKeyphraseRecognition(int keyphraseId, SoundTrigger.KeyphraseSoundModel soundModel, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig recognitionConfig) {
        Object object = this.mLock;
        synchronized (object) {
            MetricsLogger.count(this.mContext, "sth_start_recognition", 1);
            if (soundModel == null || callback == null || recognitionConfig == null) {
                return Integer.MIN_VALUE;
            }
            ModelData model = this.getKeyphraseModelDataLocked(keyphraseId);
            if (model != null && !model.isKeyphraseModel()) {
                Slog.e(TAG, "Generic model with same UUID exists.");
                return Integer.MIN_VALUE;
            }
            if (model != null && !model.getModelId().equals(soundModel.uuid)) {
                int status = this.cleanUpExistingKeyphraseModelLocked(model);
                if (status != 0) {
                    return status;
                }
                this.removeKeyphraseModelLocked(keyphraseId);
                model = null;
            }
            if (model == null) {
                model = this.createKeyphraseModelDataLocked(soundModel.uuid, keyphraseId);
            }
            return this.startRecognition(soundModel, model, callback, recognitionConfig, keyphraseId);
        }
    }

    private int cleanUpExistingKeyphraseModelLocked(ModelData modelData) {
        int status = this.tryStopAndUnloadLocked(modelData, true, true);
        if (status != 0) {
            Slog.w(TAG, "Unable to stop or unload previous model: " + modelData.toString());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startRecognition(SoundTrigger.SoundModel soundModel, ModelData modelData, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig recognitionConfig, int keyphraseId) {
        Object object = this.mLock;
        synchronized (object) {
            IRecognitionStatusCallback oldCallback;
            int status;
            if (this.mModuleProperties == null) {
                Slog.w(TAG, "Attempting startRecognition without the capability");
                return Integer.MIN_VALUE;
            }
            if (this.mModule == null) {
                this.mModule = SoundTrigger.attachModule(this.mModuleProperties.id, this, null);
                if (this.mModule == null) {
                    Slog.w(TAG, "startRecognition cannot attach to sound trigger module");
                    return Integer.MIN_VALUE;
                }
            }
            if (!this.mRecognitionRunning) {
                this.initializeTelephonyAndPowerStateListeners();
            }
            if (modelData.getSoundModel() != null) {
                boolean stopModel = false;
                boolean unloadModel = false;
                if (modelData.getSoundModel().equals(soundModel) && modelData.isModelStarted()) {
                    stopModel = true;
                    unloadModel = false;
                } else if (!modelData.getSoundModel().equals(soundModel)) {
                    stopModel = modelData.isModelStarted();
                    unloadModel = modelData.isModelLoaded();
                }
                if ((stopModel || unloadModel) && (status = this.tryStopAndUnloadLocked(modelData, stopModel, unloadModel)) != 0) {
                    Slog.w(TAG, "Unable to stop or unload previous model: " + modelData.toString());
                    return status;
                }
            }
            if ((oldCallback = modelData.getCallback()) != null && oldCallback.asBinder() != callback.asBinder()) {
                Slog.w(TAG, "Canceling previous recognition for model id: " + modelData.getModelId());
                try {
                    oldCallback.onError(Integer.MIN_VALUE);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onDetectionStopped", e);
                }
                modelData.clearCallback();
            }
            if (!modelData.isModelLoaded()) {
                this.stopAndUnloadDeadModelsLocked();
                int[] handle = new int[]{Integer.MIN_VALUE};
                status = this.mModule.loadSoundModel(soundModel, handle);
                if (status != 0) {
                    Slog.w(TAG, "loadSoundModel call failed with " + status);
                    return status;
                }
                if (handle[0] == Integer.MIN_VALUE) {
                    Slog.w(TAG, "loadSoundModel call returned invalid sound model handle");
                    return Integer.MIN_VALUE;
                }
                modelData.setHandle(handle[0]);
                modelData.setLoaded();
                Slog.d(TAG, "Sound model loaded with handle:" + handle[0]);
            }
            modelData.setCallback(callback);
            modelData.setRequested(true);
            modelData.setRecognitionConfig(recognitionConfig);
            modelData.setSoundModel(soundModel);
            return this.startRecognitionLocked(modelData, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopGenericRecognition(UUID modelId, IRecognitionStatusCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            MetricsLogger.count(this.mContext, "sth_stop_recognition", 1);
            if (callback == null || modelId == null) {
                Slog.e(TAG, "Null callbackreceived for stopGenericRecognition() for modelid:" + modelId);
                return Integer.MIN_VALUE;
            }
            ModelData modelData = this.mModelDataMap.get(modelId);
            if (modelData == null || !modelData.isGenericModel()) {
                Slog.w(TAG, "Attempting stopRecognition on invalid model with id:" + modelId);
                return Integer.MIN_VALUE;
            }
            int status = this.stopRecognition(modelData, callback);
            if (status != 0) {
                Slog.w(TAG, "stopGenericRecognition failed: " + status);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopKeyphraseRecognition(int keyphraseId, IRecognitionStatusCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            MetricsLogger.count(this.mContext, "sth_stop_recognition", 1);
            if (callback == null) {
                Slog.e(TAG, "Null callback received for stopKeyphraseRecognition() for keyphraseId:" + keyphraseId);
                return Integer.MIN_VALUE;
            }
            ModelData modelData = this.getKeyphraseModelDataLocked(keyphraseId);
            if (modelData == null || !modelData.isKeyphraseModel()) {
                Slog.e(TAG, "No model exists for given keyphrase Id " + keyphraseId);
                return Integer.MIN_VALUE;
            }
            int status = this.stopRecognition(modelData, callback);
            if (status != 0) {
                return status;
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopRecognition(ModelData modelData, IRecognitionStatusCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                return Integer.MIN_VALUE;
            }
            if (this.mModuleProperties == null || this.mModule == null) {
                Slog.w(TAG, "Attempting stopRecognition without the capability");
                return Integer.MIN_VALUE;
            }
            IRecognitionStatusCallback currentCallback = modelData.getCallback();
            if (modelData == null || currentCallback == null || !modelData.isRequested() && !modelData.isModelStarted()) {
                Slog.w(TAG, "Attempting stopRecognition without a successful startRecognition");
                return Integer.MIN_VALUE;
            }
            if (currentCallback.asBinder() != callback.asBinder()) {
                Slog.w(TAG, "Attempting stopRecognition for another recognition");
                return Integer.MIN_VALUE;
            }
            modelData.setRequested(false);
            int status = this.updateRecognitionLocked(modelData, this.isRecognitionAllowed(), false);
            if (status != 0) {
                return status;
            }
            modelData.setLoaded();
            modelData.clearCallback();
            modelData.setRecognitionConfig(null);
            if (!this.computeRecognitionRunningLocked()) {
                this.internalClearGlobalStateLocked();
            }
            return status;
        }
    }

    private int tryStopAndUnloadLocked(ModelData modelData, boolean stopModel, boolean unloadModel) {
        int status = 0;
        if (modelData.isModelNotLoaded()) {
            return status;
        }
        if (stopModel && modelData.isModelStarted() && (status = this.stopRecognitionLocked(modelData, false)) != 0) {
            Slog.w(TAG, "stopRecognition failed: " + status);
            return status;
        }
        if (unloadModel && modelData.isModelLoaded()) {
            Slog.d(TAG, "Unloading previously loaded stale model.");
            status = this.mModule.unloadSoundModel(modelData.getHandle());
            MetricsLogger.count(this.mContext, "sth_unloading_stale_model", 1);
            if (status != 0) {
                Slog.w(TAG, "unloadSoundModel call failed with " + status);
            } else {
                modelData.clearState();
            }
        }
        return status;
    }

    public SoundTrigger.ModuleProperties getModuleProperties() {
        return this.mModuleProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unloadKeyphraseSoundModel(int keyphraseId) {
        Object object = this.mLock;
        synchronized (object) {
            MetricsLogger.count(this.mContext, "sth_unload_keyphrase_sound_model", 1);
            ModelData modelData = this.getKeyphraseModelDataLocked(keyphraseId);
            if (this.mModule == null || modelData == null || modelData.getHandle() == Integer.MIN_VALUE || !modelData.isKeyphraseModel()) {
                return Integer.MIN_VALUE;
            }
            modelData.setRequested(false);
            int status = this.updateRecognitionLocked(modelData, this.isRecognitionAllowed(), false);
            if (status != 0) {
                Slog.w(TAG, "Stop recognition failed for keyphrase ID:" + status);
            }
            if ((status = this.mModule.unloadSoundModel(modelData.getHandle())) != 0) {
                Slog.w(TAG, "unloadKeyphraseSoundModel call failed with " + status);
            }
            this.removeKeyphraseModelLocked(keyphraseId);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unloadGenericSoundModel(UUID modelId) {
        Object object = this.mLock;
        synchronized (object) {
            int status;
            MetricsLogger.count(this.mContext, "sth_unload_generic_sound_model", 1);
            if (modelId == null || this.mModule == null) {
                return Integer.MIN_VALUE;
            }
            ModelData modelData = this.mModelDataMap.get(modelId);
            if (modelData == null || !modelData.isGenericModel()) {
                Slog.w(TAG, "Unload error: Attempting unload invalid generic model with id:" + modelId);
                return Integer.MIN_VALUE;
            }
            if (!modelData.isModelLoaded()) {
                Slog.i(TAG, "Unload: Given generic model is not loaded:" + modelId);
                return 0;
            }
            if (modelData.isModelStarted() && (status = this.stopRecognitionLocked(modelData, false)) != 0) {
                Slog.w(TAG, "stopGenericRecognition failed: " + status);
            }
            if ((status = this.mModule.unloadSoundModel(modelData.getHandle())) != 0) {
                Slog.w(TAG, "unloadGenericSoundModel() call failed with " + status);
                Slog.w(TAG, "unloadGenericSoundModel() force-marking model as unloaded.");
            }
            this.mModelDataMap.remove(modelId);
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRecognitionRequested(UUID modelId) {
        Object object = this.mLock;
        synchronized (object) {
            ModelData modelData = this.mModelDataMap.get(modelId);
            return modelData != null && modelData.isRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecognition(SoundTrigger.RecognitionEvent event) {
        if (event == null) {
            Slog.w(TAG, "Null recognition event!");
            return;
        }
        if (!(event instanceof SoundTrigger.KeyphraseRecognitionEvent) && !(event instanceof SoundTrigger.GenericRecognitionEvent)) {
            Slog.w(TAG, "Invalid recognition event type (not one of generic or keyphrase)!");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            switch (event.status) {
                case 1: {
                    this.onRecognitionAbortLocked(event);
                    break;
                }
                case 2: {
                    this.onRecognitionFailureLocked();
                    break;
                }
                case 0: {
                    if (this.isKeyphraseRecognitionEvent(event)) {
                        this.onKeyphraseRecognitionSuccessLocked((SoundTrigger.KeyphraseRecognitionEvent)event);
                        break;
                    }
                    this.onGenericRecognitionSuccessLocked((SoundTrigger.GenericRecognitionEvent)event);
                }
            }
        }
    }

    private boolean isKeyphraseRecognitionEvent(SoundTrigger.RecognitionEvent event) {
        return event instanceof SoundTrigger.KeyphraseRecognitionEvent;
    }

    private void onGenericRecognitionSuccessLocked(SoundTrigger.GenericRecognitionEvent event) {
        MetricsLogger.count(this.mContext, "sth_generic_recognition_event", 1);
        if (event.status != 0) {
            return;
        }
        ModelData model = this.getModelDataForLocked(event.soundModelHandle);
        if (model == null || !model.isGenericModel()) {
            Slog.w(TAG, "Generic recognition event: Model does not exist for handle: " + event.soundModelHandle);
            return;
        }
        IRecognitionStatusCallback callback = model.getCallback();
        if (callback == null) {
            Slog.w(TAG, "Generic recognition event: Null callback for model handle: " + event.soundModelHandle);
            return;
        }
        model.setStopped();
        try {
            callback.onGenericSoundTriggerDetected(event);
        }
        catch (DeadObjectException e) {
            this.forceStopAndUnloadModelLocked(model, e);
            return;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in onGenericSoundTriggerDetected", e);
        }
        SoundTrigger.RecognitionConfig config = model.getRecognitionConfig();
        if (config == null) {
            Slog.w(TAG, "Generic recognition event: Null RecognitionConfig for model handle: " + event.soundModelHandle);
            return;
        }
        model.setRequested(config.allowMultipleTriggers);
        if (model.isRequested()) {
            this.updateRecognitionLocked(model, this.isRecognitionAllowed(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSoundModelUpdate(SoundTrigger.SoundModelEvent event) {
        if (event == null) {
            Slog.w(TAG, "Invalid sound model event!");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MetricsLogger.count(this.mContext, "sth_sound_model_updated", 1);
            this.onSoundModelUpdatedLocked(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceStateChange(int state) {
        Object object = this.mLock;
        synchronized (object) {
            this.onServiceStateChangedLocked(1 == state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDied() {
        Slog.e(TAG, "onServiceDied!!");
        MetricsLogger.count(this.mContext, "sth_service_died", 1);
        Object object = this.mLock;
        synchronized (object) {
            this.onServiceDiedLocked();
        }
    }

    private void onCallStateChangedLocked(boolean callActive) {
        if (this.mCallActive == callActive) {
            return;
        }
        this.mCallActive = callActive;
        this.updateAllRecognitionsLocked(true);
    }

    private void onPowerSaveModeChangedLocked(boolean isPowerSaveMode) {
        if (this.mIsPowerSaveMode == isPowerSaveMode) {
            return;
        }
        this.mIsPowerSaveMode = isPowerSaveMode;
        this.updateAllRecognitionsLocked(true);
    }

    private void onSoundModelUpdatedLocked(SoundTrigger.SoundModelEvent event) {
    }

    private void onServiceStateChangedLocked(boolean disabled) {
        if (disabled == this.mServiceDisabled) {
            return;
        }
        this.mServiceDisabled = disabled;
        this.updateAllRecognitionsLocked(true);
    }

    private void onRecognitionAbortLocked(SoundTrigger.RecognitionEvent event) {
        Slog.w(TAG, "Recognition aborted");
        MetricsLogger.count(this.mContext, "sth_recognition_aborted", 1);
        ModelData modelData = this.getModelDataForLocked(event.soundModelHandle);
        if (modelData != null && modelData.isModelStarted()) {
            modelData.setStopped();
            try {
                modelData.getCallback().onRecognitionPaused();
            }
            catch (DeadObjectException e) {
                this.forceStopAndUnloadModelLocked(modelData, e);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "RemoteException in onRecognitionPaused", e);
            }
        }
    }

    private void onRecognitionFailureLocked() {
        Slog.w(TAG, "Recognition failure");
        MetricsLogger.count(this.mContext, "sth_recognition_failure_event", 1);
        try {
            this.sendErrorCallbacksToAllLocked(Integer.MIN_VALUE);
        }
        finally {
            this.internalClearModelStateLocked();
            this.internalClearGlobalStateLocked();
        }
    }

    private int getKeyphraseIdFromEvent(SoundTrigger.KeyphraseRecognitionEvent event) {
        if (event == null) {
            Slog.w(TAG, "Null RecognitionEvent received.");
            return Integer.MIN_VALUE;
        }
        SoundTrigger.KeyphraseRecognitionExtra[] keyphraseExtras = event.keyphraseExtras;
        if (keyphraseExtras == null || keyphraseExtras.length == 0) {
            Slog.w(TAG, "Invalid keyphrase recognition event!");
            return Integer.MIN_VALUE;
        }
        return keyphraseExtras[0].id;
    }

    private void onKeyphraseRecognitionSuccessLocked(SoundTrigger.KeyphraseRecognitionEvent event) {
        Slog.i(TAG, "Recognition success");
        MetricsLogger.count(this.mContext, "sth_keyphrase_recognition_event", 1);
        int keyphraseId = this.getKeyphraseIdFromEvent(event);
        ModelData modelData = this.getKeyphraseModelDataLocked(keyphraseId);
        if (modelData == null || !modelData.isKeyphraseModel()) {
            Slog.e(TAG, "Keyphase model data does not exist for ID:" + keyphraseId);
            return;
        }
        if (modelData.getCallback() == null) {
            Slog.w(TAG, "Received onRecognition event without callback for keyphrase model.");
            return;
        }
        modelData.setStopped();
        try {
            modelData.getCallback().onKeyphraseDetected(event);
        }
        catch (DeadObjectException e) {
            this.forceStopAndUnloadModelLocked(modelData, e);
            return;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in onKeyphraseDetected", e);
        }
        SoundTrigger.RecognitionConfig config = modelData.getRecognitionConfig();
        if (config != null) {
            modelData.setRequested(config.allowMultipleTriggers);
        }
        if (modelData.isRequested()) {
            this.updateRecognitionLocked(modelData, this.isRecognitionAllowed(), true);
        }
    }

    private void updateAllRecognitionsLocked(boolean notify) {
        boolean isAllowed = this.isRecognitionAllowed();
        ArrayList<ModelData> modelDatas = new ArrayList<ModelData>(this.mModelDataMap.values());
        for (ModelData modelData : modelDatas) {
            this.updateRecognitionLocked(modelData, isAllowed, notify);
        }
    }

    private int updateRecognitionLocked(ModelData model, boolean isAllowed, boolean notify) {
        boolean start;
        boolean bl = start = model.isRequested() && isAllowed;
        if (start == model.isModelStarted()) {
            return 0;
        }
        if (start) {
            return this.startRecognitionLocked(model, notify);
        }
        return this.stopRecognitionLocked(model, notify);
    }

    private void onServiceDiedLocked() {
        try {
            MetricsLogger.count(this.mContext, "sth_service_died", 1);
            this.sendErrorCallbacksToAllLocked(SoundTrigger.STATUS_DEAD_OBJECT);
        }
        finally {
            this.internalClearModelStateLocked();
            this.internalClearGlobalStateLocked();
            if (this.mModule != null) {
                this.mModule.detach();
                this.mModule = null;
            }
        }
    }

    private void internalClearGlobalStateLocked() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (this.mPowerSaveModeListener != null) {
            this.mContext.unregisterReceiver(this.mPowerSaveModeListener);
            this.mPowerSaveModeListener = null;
        }
    }

    private void internalClearModelStateLocked() {
        for (ModelData modelData : this.mModelDataMap.values()) {
            modelData.clearState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  module properties=");
            pw.println(this.mModuleProperties == null ? "null" : this.mModuleProperties);
            pw.print("  call active=");
            pw.println(this.mCallActive);
            pw.print("  power save mode active=");
            pw.println(this.mIsPowerSaveMode);
            pw.print("  service disabled=");
            pw.println(this.mServiceDisabled);
        }
    }

    private void initializeTelephonyAndPowerStateListeners() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mCallActive = this.mTelephonyManager.getCallState() != 0;
            this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
            if (this.mPowerSaveModeListener == null) {
                this.mPowerSaveModeListener = new PowerSaveModeListener();
                this.mContext.registerReceiver(this.mPowerSaveModeListener, new IntentFilter("android.os.action.POWER_SAVE_MODE_CHANGED"));
            }
            this.mIsPowerSaveMode = this.mPowerManager.getPowerSaveState((int)8).batterySaverEnabled;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void sendErrorCallbacksToAllLocked(int errorCode) {
        for (ModelData modelData : this.mModelDataMap.values()) {
            IRecognitionStatusCallback callback = modelData.getCallback();
            if (callback == null) continue;
            try {
                callback.onError(errorCode);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "RemoteException sendErrorCallbacksToAllLocked for model handle " + modelData.getHandle(), e);
            }
        }
    }

    private void forceStopAndUnloadModelLocked(ModelData modelData, Exception exception) {
        this.forceStopAndUnloadModelLocked(modelData, exception, null);
    }

    private void forceStopAndUnloadModelLocked(ModelData modelData, Exception exception, Iterator modelDataIterator) {
        if (exception != null) {
            Slog.e(TAG, "forceStopAndUnloadModel", exception);
        }
        if (modelData.isModelStarted()) {
            Slog.d(TAG, "Stopping previously started dangling model " + modelData.getHandle());
            if (this.mModule.stopRecognition(modelData.getHandle()) != 0) {
                modelData.setStopped();
                modelData.setRequested(false);
            } else {
                Slog.e(TAG, "Failed to stop model " + modelData.getHandle());
            }
        }
        if (modelData.isModelLoaded()) {
            Slog.d(TAG, "Unloading previously loaded dangling model " + modelData.getHandle());
            if (this.mModule.unloadSoundModel(modelData.getHandle()) == 0) {
                if (modelDataIterator != null) {
                    modelDataIterator.remove();
                } else {
                    this.mModelDataMap.remove(modelData.getModelId());
                }
                Iterator<Map.Entry<Integer, UUID>> it = this.mKeyphraseUuidMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, UUID> pair = it.next();
                    if (!((Object)pair.getValue()).equals(modelData.getModelId())) continue;
                    it.remove();
                }
                modelData.clearState();
            } else {
                Slog.e(TAG, "Failed to unload model " + modelData.getHandle());
            }
        }
    }

    private void stopAndUnloadDeadModelsLocked() {
        Iterator<Map.Entry<UUID, ModelData>> it = this.mModelDataMap.entrySet().iterator();
        while (it.hasNext()) {
            ModelData modelData = it.next().getValue();
            if (!modelData.isModelLoaded() || modelData.getCallback() != null && (modelData.getCallback().asBinder() == null || modelData.getCallback().asBinder().pingBinder())) continue;
            Slog.w(TAG, "Removing model " + modelData.getHandle() + " that has no clients");
            this.forceStopAndUnloadModelLocked(modelData, null, it);
        }
    }

    private ModelData getOrCreateGenericModelDataLocked(UUID modelId) {
        ModelData modelData = this.mModelDataMap.get(modelId);
        if (modelData == null) {
            modelData = ModelData.createGenericModelData(modelId);
            this.mModelDataMap.put(modelId, modelData);
        } else if (!modelData.isGenericModel()) {
            Slog.e(TAG, "UUID already used for non-generic model.");
            return null;
        }
        return modelData;
    }

    private void removeKeyphraseModelLocked(int keyphraseId) {
        UUID uuid = this.mKeyphraseUuidMap.get(keyphraseId);
        if (uuid == null) {
            return;
        }
        this.mModelDataMap.remove(uuid);
        this.mKeyphraseUuidMap.remove(keyphraseId);
    }

    private ModelData getKeyphraseModelDataLocked(int keyphraseId) {
        UUID uuid = this.mKeyphraseUuidMap.get(keyphraseId);
        if (uuid == null) {
            return null;
        }
        return this.mModelDataMap.get(uuid);
    }

    private ModelData createKeyphraseModelDataLocked(UUID modelId, int keyphraseId) {
        this.mKeyphraseUuidMap.remove(keyphraseId);
        this.mModelDataMap.remove(modelId);
        this.mKeyphraseUuidMap.put(keyphraseId, modelId);
        ModelData modelData = ModelData.createKeyphraseModelData(modelId);
        this.mModelDataMap.put(modelId, modelData);
        return modelData;
    }

    private ModelData getModelDataForLocked(int modelHandle) {
        for (ModelData model : this.mModelDataMap.values()) {
            if (model.getHandle() != modelHandle) continue;
            return model;
        }
        return null;
    }

    private boolean isRecognitionAllowed() {
        return !this.mCallActive && !this.mServiceDisabled && !this.mIsPowerSaveMode;
    }

    private int startRecognitionLocked(ModelData modelData, boolean notify) {
        IRecognitionStatusCallback callback = modelData.getCallback();
        int handle = modelData.getHandle();
        SoundTrigger.RecognitionConfig config = modelData.getRecognitionConfig();
        if (callback == null || handle == Integer.MIN_VALUE || config == null) {
            Slog.w(TAG, "startRecognition: Bad data passed in.");
            MetricsLogger.count(this.mContext, "sth_start_recognition_error", 1);
            return Integer.MIN_VALUE;
        }
        if (!this.isRecognitionAllowed()) {
            Slog.w(TAG, "startRecognition requested but not allowed.");
            MetricsLogger.count(this.mContext, "sth_start_recognition_not_allowed", 1);
            return 0;
        }
        int status = this.mModule.startRecognition(handle, config);
        if (status != 0) {
            Slog.w(TAG, "startRecognition failed with " + status);
            MetricsLogger.count(this.mContext, "sth_start_recognition_error", 1);
            if (notify) {
                try {
                    callback.onError(status);
                }
                catch (DeadObjectException e) {
                    this.forceStopAndUnloadModelLocked(modelData, e);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onError", e);
                }
            }
        } else {
            Slog.i(TAG, "startRecognition successful.");
            MetricsLogger.count(this.mContext, "sth_start_recognition_success", 1);
            modelData.setStarted();
            if (notify) {
                try {
                    callback.onRecognitionResumed();
                }
                catch (DeadObjectException e) {
                    this.forceStopAndUnloadModelLocked(modelData, e);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onRecognitionResumed", e);
                }
            }
        }
        return status;
    }

    private int stopRecognitionLocked(ModelData modelData, boolean notify) {
        IRecognitionStatusCallback callback = modelData.getCallback();
        int status = 0;
        status = this.mModule.stopRecognition(modelData.getHandle());
        if (status != 0) {
            Slog.w(TAG, "stopRecognition call failed with " + status);
            MetricsLogger.count(this.mContext, "sth_stop_recognition_error", 1);
            if (notify) {
                try {
                    callback.onError(status);
                }
                catch (DeadObjectException e) {
                    this.forceStopAndUnloadModelLocked(modelData, e);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onError", e);
                }
            }
        } else {
            modelData.setStopped();
            MetricsLogger.count(this.mContext, "sth_stop_recognition_success", 1);
            if (notify) {
                try {
                    callback.onRecognitionPaused();
                }
                catch (DeadObjectException e) {
                    this.forceStopAndUnloadModelLocked(modelData, e);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "RemoteException in onRecognitionPaused", e);
                }
            }
        }
        return status;
    }

    private void dumpModelStateLocked() {
        for (UUID modelId : this.mModelDataMap.keySet()) {
            ModelData modelData = this.mModelDataMap.get(modelId);
            Slog.i(TAG, "Model :" + modelData.toString());
        }
    }

    private boolean computeRecognitionRunningLocked() {
        if (this.mModuleProperties == null || this.mModule == null) {
            this.mRecognitionRunning = false;
            return this.mRecognitionRunning;
        }
        for (ModelData modelData : this.mModelDataMap.values()) {
            if (!modelData.isModelStarted()) continue;
            this.mRecognitionRunning = true;
            return this.mRecognitionRunning;
        }
        this.mRecognitionRunning = false;
        return this.mRecognitionRunning;
    }

    private static class ModelData {
        static final int MODEL_NOTLOADED = 0;
        static final int MODEL_LOADED = 1;
        static final int MODEL_STARTED = 2;
        private int mModelState;
        private UUID mModelId;
        private boolean mRequested = false;
        private int mModelType = -1;
        private IRecognitionStatusCallback mCallback = null;
        private SoundTrigger.RecognitionConfig mRecognitionConfig = null;
        private int mModelHandle = Integer.MIN_VALUE;
        private SoundTrigger.SoundModel mSoundModel = null;

        private ModelData(UUID modelId, int modelType) {
            this.mModelId = modelId;
            this.mModelType = modelType;
        }

        static ModelData createKeyphraseModelData(UUID modelId) {
            return new ModelData(modelId, 0);
        }

        static ModelData createGenericModelData(UUID modelId) {
            return new ModelData(modelId, 1);
        }

        static ModelData createModelDataOfUnknownType(UUID modelId) {
            return new ModelData(modelId, -1);
        }

        synchronized void setCallback(IRecognitionStatusCallback callback) {
            this.mCallback = callback;
        }

        synchronized IRecognitionStatusCallback getCallback() {
            return this.mCallback;
        }

        synchronized boolean isModelLoaded() {
            return this.mModelState == 1 || this.mModelState == 2;
        }

        synchronized boolean isModelNotLoaded() {
            return this.mModelState == 0;
        }

        synchronized void setStarted() {
            this.mModelState = 2;
        }

        synchronized void setStopped() {
            this.mModelState = 1;
        }

        synchronized void setLoaded() {
            this.mModelState = 1;
        }

        synchronized boolean isModelStarted() {
            return this.mModelState == 2;
        }

        synchronized void clearState() {
            this.mModelState = 0;
            this.mModelHandle = Integer.MIN_VALUE;
            this.mRecognitionConfig = null;
            this.mRequested = false;
            this.mCallback = null;
        }

        synchronized void clearCallback() {
            this.mCallback = null;
        }

        synchronized void setHandle(int handle) {
            this.mModelHandle = handle;
        }

        synchronized void setRecognitionConfig(SoundTrigger.RecognitionConfig config) {
            this.mRecognitionConfig = config;
        }

        synchronized int getHandle() {
            return this.mModelHandle;
        }

        synchronized UUID getModelId() {
            return this.mModelId;
        }

        synchronized SoundTrigger.RecognitionConfig getRecognitionConfig() {
            return this.mRecognitionConfig;
        }

        synchronized boolean isRequested() {
            return this.mRequested;
        }

        synchronized void setRequested(boolean requested) {
            this.mRequested = requested;
        }

        synchronized void setSoundModel(SoundTrigger.SoundModel soundModel) {
            this.mSoundModel = soundModel;
        }

        synchronized SoundTrigger.SoundModel getSoundModel() {
            return this.mSoundModel;
        }

        synchronized int getModelType() {
            return this.mModelType;
        }

        synchronized boolean isKeyphraseModel() {
            return this.mModelType == 0;
        }

        synchronized boolean isGenericModel() {
            return this.mModelType == 1;
        }

        synchronized String stateToString() {
            switch (this.mModelState) {
                case 0: {
                    return "NOT_LOADED";
                }
                case 1: {
                    return "LOADED";
                }
                case 2: {
                    return "STARTED";
                }
            }
            return "Unknown state";
        }

        synchronized String requestedToString() {
            return "Requested: " + (this.mRequested ? "Yes" : "No");
        }

        synchronized String callbackToString() {
            return "Callback: " + (this.mCallback != null ? this.mCallback.asBinder() : "null");
        }

        synchronized String uuidToString() {
            return "UUID: " + this.mModelId;
        }

        public synchronized String toString() {
            return "Handle: " + this.mModelHandle + "\nModelState: " + this.stateToString() + "\n" + this.requestedToString() + "\n" + this.callbackToString() + "\n" + this.uuidToString() + "\n" + this.modelTypeToString();
        }

        synchronized String modelTypeToString() {
            String type = null;
            switch (this.mModelType) {
                case 1: {
                    type = "Generic";
                    break;
                }
                case -1: {
                    type = "Unknown";
                    break;
                }
                case 0: {
                    type = "Keyphrase";
                }
            }
            return "Model type: " + type + "\n";
        }
    }

    class PowerSaveModeListener
    extends BroadcastReceiver {
        PowerSaveModeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!"android.os.action.POWER_SAVE_MODE_CHANGED".equals(intent.getAction())) {
                return;
            }
            boolean active = ((SoundTriggerHelper)SoundTriggerHelper.this).mPowerManager.getPowerSaveState((int)8).batterySaverEnabled;
            Object object = SoundTriggerHelper.this.mLock;
            synchronized (object) {
                SoundTriggerHelper.this.onPowerSaveModeChangedLocked(active);
            }
        }
    }

    class MyCallStateListener
    extends PhoneStateListener {
        MyCallStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallStateChanged(int state, String arg1) {
            Object object = SoundTriggerHelper.this.mLock;
            synchronized (object) {
                SoundTriggerHelper.this.onCallStateChangedLocked(0 != state);
            }
        }
    }
}

