/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.stats;

import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.ProcessMemoryState;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.UidTraffic;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.NetworkStats;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.BatteryStatsInternal;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.IStatsCompanionService;
import android.os.IStatsManager;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.StatsDimensionsValue;
import android.os.StatsLogEventWrapper;
import android.os.SynchronousResultReceiver;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.telephony.ModemActivityInfo;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelUidCpuActiveTimeReader;
import com.android.internal.os.KernelUidCpuClusterTimeReader;
import com.android.internal.os.KernelUidCpuFreqTimeReader;
import com.android.internal.os.KernelUidCpuTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StatsCompanionService
extends IStatsCompanionService.Stub {
    private static final long EXTERNAL_STATS_SYNC_TIMEOUT_MILLIS = 2000L;
    private static final long MILLIS_IN_A_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final String RESULT_RECEIVER_CONTROLLER_KEY = "controller_activity";
    public static final String CONFIG_DIR = "/data/misc/stats-service";
    static final String TAG = "StatsCompanionService";
    static final boolean DEBUG = false;
    public static final int CODE_DATA_BROADCAST = 1;
    public static final int CODE_SUBSCRIBER_BROADCAST = 1;
    public static final String EXTRA_LAST_REPORT_TIME = "android.app.extra.LAST_REPORT_TIME";
    public static final int DEATH_THRESHOLD = 10;
    private final Context mContext;
    private final AlarmManager mAlarmManager;
    @GuardedBy(value="sStatsdLock")
    private static IStatsManager sStatsd;
    private static final Object sStatsdLock;
    private final PendingIntent mAnomalyAlarmIntent;
    private final PendingIntent mPullingAlarmIntent;
    private final PendingIntent mPeriodicAlarmIntent;
    private final BroadcastReceiver mAppUpdateReceiver;
    private final BroadcastReceiver mUserUpdateReceiver;
    private final ShutdownEventReceiver mShutdownEventReceiver;
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    private IWifiManager mWifiManager = null;
    private TelephonyManager mTelephony = null;
    private final StatFs mStatFsData = new StatFs(Environment.getDataDirectory().getAbsolutePath());
    private final StatFs mStatFsSystem = new StatFs(Environment.getRootDirectory().getAbsolutePath());
    private final StatFs mStatFsTemp = new StatFs(Environment.getDownloadCacheDirectory().getAbsolutePath());
    @GuardedBy(value="sStatsdLock")
    private final HashSet<Long> mDeathTimeMillis = new HashSet();
    @GuardedBy(value="sStatsdLock")
    private final HashMap<Long, String> mDeletedFiles = new HashMap();
    private KernelUidCpuTimeReader mKernelUidCpuTimeReader = new KernelUidCpuTimeReader();
    private KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    private KernelUidCpuFreqTimeReader mKernelUidCpuFreqTimeReader = new KernelUidCpuFreqTimeReader();
    private KernelUidCpuActiveTimeReader mKernelUidCpuActiveTimeReader = new KernelUidCpuActiveTimeReader();
    private KernelUidCpuClusterTimeReader mKernelUidCpuClusterTimeReader = new KernelUidCpuClusterTimeReader();

    public StatsCompanionService(Context context) {
        this.mContext = context;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mAnomalyAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(this.mContext, AnomalyAlarmReceiver.class), 0);
        this.mPullingAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(this.mContext, PullingAlarmReceiver.class), 0);
        this.mPeriodicAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(this.mContext, PeriodicAlarmReceiver.class), 0);
        this.mAppUpdateReceiver = new AppUpdateReceiver();
        this.mUserUpdateReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Object object = sStatsdLock;
                synchronized (object) {
                    sStatsd = StatsCompanionService.fetchStatsdService();
                    if (sStatsd == null) {
                        Slog.w(StatsCompanionService.TAG, "Could not access statsd for UserUpdateReceiver");
                        return;
                    }
                    try {
                        StatsCompanionService.this.informAllUidsLocked(context);
                    }
                    catch (RemoteException e) {
                        Slog.e(StatsCompanionService.TAG, "Failed to inform statsd latest update of all apps", e);
                        StatsCompanionService.this.forgetEverythingLocked();
                    }
                }
            }
        };
        this.mShutdownEventReceiver = new ShutdownEventReceiver();
        PowerProfile powerProfile = new PowerProfile(context);
        int numClusters = powerProfile.getNumCpuClusters();
        this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
        int firstCpuOfCluster = 0;
        for (int i = 0; i < numClusters; ++i) {
            int numSpeedSteps = powerProfile.getNumSpeedStepsInCpuCluster(i);
            this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
            firstCpuOfCluster += powerProfile.getNumCoresInCpuCluster(i);
        }
        this.mKernelUidCpuFreqTimeReader.setThrottleInterval(0L);
        long[] freqs = this.mKernelUidCpuFreqTimeReader.readFreqs(powerProfile);
        this.mKernelUidCpuClusterTimeReader.setThrottleInterval(0L);
        this.mKernelUidCpuActiveTimeReader.setThrottleInterval(0L);
    }

    @Override
    public void sendDataBroadcast(IBinder intentSenderBinder, long lastReportTimeNs) {
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent();
        intent.putExtra(EXTRA_LAST_REPORT_TIME, lastReportTimeNs);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send using IntentSender");
        }
    }

    @Override
    public void sendSubscriberBroadcast(IBinder intentSenderBinder, long configUid, long configKey, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValue dimensionsValue) {
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent().putExtra("android.app.extra.STATS_CONFIG_UID", configUid).putExtra("android.app.extra.STATS_CONFIG_KEY", configKey).putExtra("android.app.extra.STATS_SUBSCRIPTION_ID", subscriptionId).putExtra("android.app.extra.STATS_SUBSCRIPTION_RULE_ID", subscriptionRuleId).putExtra("android.app.extra.STATS_DIMENSIONS_VALUE", dimensionsValue);
        ArrayList<String> cookieList = new ArrayList<String>(cookies.length);
        for (String cookie : cookies) {
            cookieList.add(cookie);
        }
        intent.putStringArrayListExtra("android.app.extra.STATS_BROADCAST_SUBSCRIBER_COOKIES", cookieList);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send using IntentSender from uid " + configUid + "; presumably it had been cancelled.");
        }
    }

    private static final int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    private static final long[] toLongArray(List<Long> list) {
        long[] ret = new long[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    @GuardedBy(value="sStatsdLock")
    private final void informAllUidsLocked(Context context) throws RemoteException {
        UserManager um = (UserManager)context.getSystemService("user");
        PackageManager pm = context.getPackageManager();
        List<UserInfo> users = um.getUsers(true);
        ArrayList<Integer> uids = new ArrayList<Integer>();
        ArrayList<Long> versions = new ArrayList<Long>();
        ArrayList<String> apps = new ArrayList<String>();
        for (UserInfo profile : users) {
            List<PackageInfo> pi = pm.getInstalledPackagesAsUser(0x402000, profile.id);
            for (int j = 0; j < pi.size(); ++j) {
                if (pi.get((int)j).applicationInfo == null) continue;
                uids.add(pi.get((int)j).applicationInfo.uid);
                versions.add(pi.get(j).getLongVersionCode());
                apps.add(pi.get((int)j).packageName);
            }
        }
        sStatsd.informAllUidData(StatsCompanionService.toIntArray(uids), StatsCompanionService.toLongArray(versions), apps.toArray(new String[apps.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnomalyAlarm(long timestampMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, timestampMs, this.mAnomalyAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelAnomalyAlarm() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mAnomalyAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlarmForSubscriberTriggering(long timestampMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, timestampMs, this.mPeriodicAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelAlarmForSubscriberTriggering() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mPeriodicAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPullingAlarm(long nextPullTimeMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, nextPullTimeMs, this.mPullingAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelPullingAlarm() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mPullingAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    private void addNetworkStats(int tag, List<StatsLogEventWrapper> ret, NetworkStats stats, boolean withFGBG) {
        int size = stats.size();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        NetworkStats.Entry entry = new NetworkStats.Entry();
        for (int j = 0; j < size; ++j) {
            stats.getValues(j, entry);
            StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tag, withFGBG ? 6 : 5);
            e.writeInt(entry.uid);
            if (withFGBG) {
                e.writeInt(entry.set);
            }
            e.writeLong(entry.rxBytes);
            e.writeLong(entry.rxPackets);
            e.writeLong(entry.txBytes);
            e.writeLong(entry.txPackets);
            ret.add(e);
        }
    }

    private NetworkStats rollupNetworkStatsByFGBG(NetworkStats stats) {
        NetworkStats ret = new NetworkStats(stats.getElapsedRealtime(), 1);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        entry.iface = NetworkStats.IFACE_ALL;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        int size = stats.size();
        NetworkStats.Entry recycle = new NetworkStats.Entry();
        for (int i = 0; i < size; ++i) {
            stats.getValues(i, recycle);
            if (recycle.tag != 0) continue;
            entry.set = recycle.set;
            entry.uid = recycle.uid;
            entry.rxBytes = recycle.rxBytes;
            entry.rxPackets = recycle.rxPackets;
            entry.txBytes = recycle.txBytes;
            entry.txPackets = recycle.txPackets;
            ret.combineValues(entry);
        }
        return ret;
    }

    private static <T extends Parcelable> T awaitControllerInfo(SynchronousResultReceiver receiver) {
        if (receiver == null) {
            return null;
        }
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(2000L);
            if (result.bundle != null) {
                result.bundle.setDefusable(true);
                Object data = result.bundle.getParcelable(RESULT_RECEIVER_CONTROLLER_KEY);
                if (data != null) {
                    return data;
                }
            }
            Slog.e(TAG, "no controller energy info supplied for " + receiver.getName());
        }
        catch (TimeoutException e) {
            Slog.w(TAG, "timeout reading " + receiver.getName() + " stats");
        }
        return null;
    }

    private void pullKernelWakelock(int tagId, List<StatsLogEventWrapper> pulledData) {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 4);
            e.writeString(name);
            e.writeInt(kws.mCount);
            e.writeInt(kws.mVersion);
            e.writeLong(kws.mTotalTime);
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = nsf.readNetworkStatsDetail(-1, ifaces, 0, null).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransferByFgBg(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = this.rollupNetworkStatsByFGBG(nsf.readNetworkStatsDetail(-1, ifaces, 0, null));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = nsf.readNetworkStatsDetail(-1, ifaces, 0, null).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullBluetoothBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.pullBluetoothData();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        if (info.getUidTraffic() != null) {
            for (UidTraffic traffic : info.getUidTraffic()) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 3);
                e.writeInt(traffic.getUid());
                e.writeLong(traffic.getRxBytes());
                e.writeLong(traffic.getTxBytes());
                pulledData.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransferByFgBg(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = this.rollupNetworkStatsByFGBG(nsf.readNetworkStatsDetail(-1, ifaces, 0, null));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullCpuTimePerFreq(int tagId, List<StatsLogEventWrapper> pulledData) {
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            long[] clusterTimeMs = this.mKernelCpuSpeedReaders[cluster].readAbsolute();
            if (clusterTimeMs == null) continue;
            for (int speed = clusterTimeMs.length - 1; speed >= 0; --speed) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 3);
                e.writeInt(cluster);
                e.writeInt(speed);
                e.writeLong(clusterTimeMs[speed]);
                pulledData.add(e);
            }
        }
    }

    private void pullKernelUidCpuTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        this.mKernelUidCpuTimeReader.readAbsolute((uid, userTimeUs, systemTimeUs) -> {
            StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 3);
            e.writeInt(uid);
            e.writeLong(userTimeUs);
            e.writeLong(systemTimeUs);
            pulledData.add(e);
        });
    }

    private void pullKernelUidCpuFreqTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        this.mKernelUidCpuFreqTimeReader.readAbsolute((uid, cpuFreqTimeMs) -> {
            for (int freqIndex = 0; freqIndex < cpuFreqTimeMs.length; ++freqIndex) {
                if (cpuFreqTimeMs[freqIndex] == 0L) continue;
                StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 3);
                e.writeInt(uid);
                e.writeInt(freqIndex);
                e.writeLong(cpuFreqTimeMs[freqIndex]);
                pulledData.add(e);
            }
        });
    }

    private void pullKernelUidCpuClusterTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        this.mKernelUidCpuClusterTimeReader.readAbsolute((uid, cpuClusterTimesMs) -> {
            for (int i = 0; i < cpuClusterTimesMs.length; ++i) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 3);
                e.writeInt(uid);
                e.writeInt(i);
                e.writeLong(cpuClusterTimesMs[i]);
                pulledData.add(e);
            }
        });
    }

    private void pullKernelUidCpuActiveTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        this.mKernelUidCpuActiveTimeReader.readAbsolute((uid, cpuActiveTimesMs) -> {
            StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 2);
            e.writeInt(uid);
            e.writeLong(cpuActiveTimesMs);
            pulledData.add(e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiActivityInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        if (this.mWifiManager == null) {
            this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
        }
        if (this.mWifiManager != null) {
            try {
                SynchronousResultReceiver wifiReceiver = new SynchronousResultReceiver("wifi");
                this.mWifiManager.requestActivityInfo(wifiReceiver);
                WifiActivityEnergyInfo wifiInfo = (WifiActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(wifiReceiver);
                StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 6);
                e.writeLong(wifiInfo.getTimeStamp());
                e.writeInt(wifiInfo.getStackState());
                e.writeLong(wifiInfo.getControllerTxTimeMillis());
                e.writeLong(wifiInfo.getControllerRxTimeMillis());
                e.writeLong(wifiInfo.getControllerIdleTimeMillis());
                e.writeLong(wifiInfo.getControllerEnergyUsed());
                pulledData.add(e);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Pulling wifiManager for wifi controller activity energy info has error", e);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private void pullModemActivityInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        if (this.mTelephony == null) {
            this.mTelephony = TelephonyManager.from(this.mContext);
        }
        if (this.mTelephony != null) {
            SynchronousResultReceiver modemReceiver = new SynchronousResultReceiver("telephony");
            this.mTelephony.requestModemActivityInfo(modemReceiver);
            ModemActivityInfo modemInfo = (ModemActivityInfo)StatsCompanionService.awaitControllerInfo(modemReceiver);
            StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 10);
            e.writeLong(modemInfo.getTimestamp());
            e.writeLong(modemInfo.getSleepTimeMillis());
            e.writeLong(modemInfo.getIdleTimeMillis());
            e.writeLong(modemInfo.getTxTimeMillis()[0]);
            e.writeLong(modemInfo.getTxTimeMillis()[1]);
            e.writeLong(modemInfo.getTxTimeMillis()[2]);
            e.writeLong(modemInfo.getTxTimeMillis()[3]);
            e.writeLong(modemInfo.getTxTimeMillis()[4]);
            e.writeLong(modemInfo.getRxTimeMillis());
            e.writeLong(modemInfo.getEnergyUsed());
            pulledData.add(e);
        }
    }

    private void pullBluetoothActivityInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.pullBluetoothData();
        StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 6);
        e.writeLong(info.getTimeStamp());
        e.writeInt(info.getBluetoothStackState());
        e.writeLong(info.getControllerTxTimeMillis());
        e.writeLong(info.getControllerRxTimeMillis());
        e.writeLong(info.getControllerIdleTimeMillis());
        e.writeLong(info.getControllerEnergyUsed());
        pulledData.add(e);
    }

    private synchronized BluetoothActivityEnergyInfo pullBluetoothData() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            SynchronousResultReceiver bluetoothReceiver = new SynchronousResultReceiver("bluetooth");
            adapter.requestControllerActivityEnergyInfo(bluetoothReceiver);
            return (BluetoothActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(bluetoothReceiver);
        }
        Slog.e(TAG, "Failed to get bluetooth adapter!");
        return null;
    }

    private void pullSystemElapsedRealtime(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 1);
        e.writeLong(SystemClock.elapsedRealtime());
        pulledData.add(e);
    }

    private void pullDiskSpace(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 3);
        e.writeLong(this.mStatFsData.getAvailableBytes());
        e.writeLong(this.mStatFsSystem.getAvailableBytes());
        e.writeLong(this.mStatFsTemp.getAvailableBytes());
        pulledData.add(e);
    }

    private void pullSystemUpTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(SystemClock.elapsedRealtimeNanos(), tagId, 1);
        e.writeLong(SystemClock.uptimeMillis());
        pulledData.add(e);
    }

    private void pullProcessMemoryState(int tagId, List<StatsLogEventWrapper> pulledData) {
        List<ProcessMemoryState> processMemoryStates = LocalServices.getService(ActivityManagerInternal.class).getMemoryStateForProcesses();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        for (ProcessMemoryState processMemoryState : processMemoryStates) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(elapsedNanos, tagId, 8);
            e.writeInt(processMemoryState.uid);
            e.writeString(processMemoryState.processName);
            e.writeInt(processMemoryState.oomScore);
            e.writeLong(processMemoryState.pgfault);
            e.writeLong(processMemoryState.pgmajfault);
            e.writeLong(processMemoryState.rssInBytes);
            e.writeLong(processMemoryState.cacheInBytes);
            e.writeLong(processMemoryState.swapInBytes);
            pulledData.add(e);
        }
    }

    @Override
    public StatsLogEventWrapper[] pullData(int tagId) {
        this.enforceCallingPermission();
        ArrayList<StatsLogEventWrapper> ret = new ArrayList<StatsLogEventWrapper>();
        switch (tagId) {
            case 10000: {
                this.pullWifiBytesTransfer(tagId, ret);
                break;
            }
            case 10002: {
                this.pullMobileBytesTransfer(tagId, ret);
                break;
            }
            case 10001: {
                this.pullWifiBytesTransferByFgBg(tagId, ret);
                break;
            }
            case 10003: {
                this.pullMobileBytesTransferByFgBg(tagId, ret);
                break;
            }
            case 10006: {
                this.pullBluetoothBytesTransfer(tagId, ret);
                break;
            }
            case 10004: {
                this.pullKernelWakelock(tagId, ret);
                break;
            }
            case 10008: {
                this.pullCpuTimePerFreq(tagId, ret);
                break;
            }
            case 10009: {
                this.pullKernelUidCpuTime(tagId, ret);
                break;
            }
            case 10010: {
                this.pullKernelUidCpuFreqTime(tagId, ret);
                break;
            }
            case 10017: {
                this.pullKernelUidCpuClusterTime(tagId, ret);
                break;
            }
            case 10016: {
                this.pullKernelUidCpuActiveTime(tagId, ret);
                break;
            }
            case 10011: {
                this.pullWifiActivityInfo(tagId, ret);
                break;
            }
            case 10012: {
                this.pullModemActivityInfo(tagId, ret);
                break;
            }
            case 10007: {
                this.pullBluetoothActivityInfo(tagId, ret);
                break;
            }
            case 10015: {
                this.pullSystemUpTime(tagId, ret);
                break;
            }
            case 10014: {
                this.pullSystemElapsedRealtime(tagId, ret);
                break;
            }
            case 10018: {
                this.pullDiskSpace(tagId, ret);
                break;
            }
            case 10013: {
                this.pullProcessMemoryState(tagId, ret);
                break;
            }
            default: {
                Slog.w(TAG, "No such tagId data as " + tagId);
                return null;
            }
        }
        return ret.toArray(new StatsLogEventWrapper[ret.size()]);
    }

    @Override
    public void statsdReady() {
        this.enforceCallingPermission();
        this.sayHiToStatsd();
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.STATSD_STARTED").addFlags(0x1000000), UserHandle.SYSTEM, "android.permission.DUMP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerUidSnapshot() {
        this.enforceCallingPermission();
        Object object = sStatsdLock;
        synchronized (object) {
            long token = Binder.clearCallingIdentity();
            try {
                this.informAllUidsLocked(this.mContext);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to trigger uid snapshot.", e);
            }
            finally {
                StatsCompanionService.restoreCallingIdentity(token);
            }
        }
    }

    private void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforceCallingPermission("android.permission.STATSCOMPANION", null);
    }

    private static IStatsManager fetchStatsdService() {
        return IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
    }

    private void systemReady() {
        this.sayHiToStatsd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sayHiToStatsd() {
        Object object = sStatsdLock;
        synchronized (object) {
            if (sStatsd != null) {
                Slog.e(TAG, "Trying to fetch statsd, but it was already fetched", new IllegalStateException("sStatsd is not null when being fetched"));
                return;
            }
            sStatsd = StatsCompanionService.fetchStatsdService();
            if (sStatsd == null) {
                Slog.i(TAG, "Could not yet find statsd to tell it that StatsCompanion is alive.");
                return;
            }
            try {
                sStatsd.statsCompanionReady();
                try {
                    sStatsd.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "linkToDeath(StatsdDeathRecipient) failed", e);
                    this.forgetEverythingLocked();
                }
                IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REPLACED");
                filter.addAction("android.intent.action.PACKAGE_ADDED");
                filter.addAction("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.mContext.registerReceiverAsUser(this.mAppUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.USER_INITIALIZE");
                filter.addAction("android.intent.action.USER_REMOVED");
                this.mContext.registerReceiverAsUser(this.mUserUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.REBOOT");
                filter.addAction("android.intent.action.ACTION_SHUTDOWN");
                this.mContext.registerReceiverAsUser(this.mShutdownEventReceiver, UserHandle.ALL, filter, null, null);
                long token = Binder.clearCallingIdentity();
                try {
                    this.informAllUidsLocked(this.mContext);
                }
                finally {
                    StatsCompanionService.restoreCallingIdentity(token);
                }
                Slog.i(TAG, "Told statsd that StatsCompanionService is alive.");
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to inform statsd that statscompanion is ready", e);
                this.forgetEverythingLocked();
            }
        }
    }

    private void forgetEverythingLocked() {
        sStatsd = null;
        this.mContext.unregisterReceiver(this.mAppUpdateReceiver);
        this.mContext.unregisterReceiver(this.mUserUpdateReceiver);
        this.mContext.unregisterReceiver(this.mShutdownEventReceiver);
        this.cancelAnomalyAlarm();
        this.cancelPullingAlarm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        Object object = sStatsdLock;
        synchronized (object) {
            writer.println("Number of configuration files deleted: " + this.mDeletedFiles.size());
            if (this.mDeletedFiles.size() > 0) {
                writer.println("  timestamp, deleted file name");
            }
            long lastBootMillis = SystemClock.currentThreadTimeMillis() - SystemClock.elapsedRealtime();
            for (Long elapsedMillis : this.mDeletedFiles.keySet()) {
                long deletionMillis = lastBootMillis + elapsedMillis;
                writer.println("  " + deletionMillis + ", " + this.mDeletedFiles.get(elapsedMillis));
            }
        }
    }

    static {
        sStatsdLock = new Object();
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Slog.i(StatsCompanionService.TAG, "Statsd is dead - erase all my knowledge.");
            Object object = sStatsdLock;
            synchronized (object) {
                long ageMillis;
                long now = SystemClock.elapsedRealtime();
                for (Long timeMillis : StatsCompanionService.this.mDeathTimeMillis) {
                    ageMillis = now - timeMillis;
                    if (ageMillis <= MILLIS_IN_A_DAY) continue;
                    StatsCompanionService.this.mDeathTimeMillis.remove(timeMillis);
                }
                for (Long timeMillis : StatsCompanionService.this.mDeletedFiles.keySet()) {
                    ageMillis = now - timeMillis;
                    if (ageMillis <= MILLIS_IN_A_DAY * 7L) continue;
                    StatsCompanionService.this.mDeletedFiles.remove(timeMillis);
                }
                StatsCompanionService.this.mDeathTimeMillis.add(now);
                if (StatsCompanionService.this.mDeathTimeMillis.size() >= 10) {
                    StatsCompanionService.this.mDeathTimeMillis.clear();
                    File[] configs = FileUtils.listFilesOrEmpty(new File(StatsCompanionService.CONFIG_DIR));
                    if (configs.length > 0) {
                        String fileName = configs[0].getName();
                        if (configs[0].delete()) {
                            StatsCompanionService.this.mDeletedFiles.put(now, fileName);
                        }
                    }
                }
                StatsCompanionService.this.forgetEverythingLocked();
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private StatsCompanionService mStatsCompanionService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mStatsCompanionService = new StatsCompanionService(this.getContext());
            try {
                this.publishBinderService("statscompanion", this.mStatsCompanionService);
            }
            catch (Exception e) {
                Slog.e(StatsCompanionService.TAG, "Failed to publishBinderService", e);
            }
        }

        @Override
        public void onBootPhase(int phase) {
            super.onBootPhase(phase);
            if (phase == 600) {
                this.mStatsCompanionService.systemReady();
            }
        }
    }

    public static final class ShutdownEventReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!(intent.getAction().equals("android.intent.action.REBOOT") || intent.getAction().equals("android.intent.action.ACTION_SHUTDOWN") && (intent.getFlags() & 0x10000000) != 0)) {
                return;
            }
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService noticed a shutdown.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of a shutdown event.");
                    return;
                }
                try {
                    sStatsd.informDeviceShutdown();
                }
                catch (Exception e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of a shutdown event.", e);
                }
            }
        }
    }

    public static final class PeriodicAlarmReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of periodic alarm firing.");
                    return;
                }
                try {
                    sStatsd.informAlarmForSubscriberTriggeringFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of periodic alarm firing.", e);
                }
            }
        }
    }

    public static final class PullingAlarmReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of pulling alarm firing.");
                    return;
                }
                try {
                    sStatsd.informPollAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of pulling alarm firing.", e);
                }
            }
        }
    }

    public static final class AnomalyAlarmReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService believes an anomaly has occurred at time " + System.currentTimeMillis() + "ms.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of anomaly alarm firing");
                    return;
                }
                try {
                    sStatsd.informAnomalyAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of anomaly alarm firing", e);
                }
            }
        }
    }

    private static final class AppUpdateReceiver
    extends BroadcastReceiver {
        private AppUpdateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.intent.action.PACKAGE_REPLACED") && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                return;
            }
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of an app update");
                    return;
                }
                try {
                    if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) {
                        Bundle b = intent.getExtras();
                        int uid = b.getInt("android.intent.extra.UID");
                        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                        if (!replacing) {
                            PackageManager pm = context.getPackageManager();
                            String app = intent.getData().getSchemeSpecificPart();
                            sStatsd.informOnePackageRemoved(app, uid);
                        }
                    } else {
                        PackageManager pm = context.getPackageManager();
                        Bundle b = intent.getExtras();
                        int uid = b.getInt("android.intent.extra.UID");
                        String app = intent.getData().getSchemeSpecificPart();
                        PackageInfo pi = pm.getPackageInfo(app, 0x400000);
                        sStatsd.informOnePackage(app, uid, pi.getLongVersionCode());
                    }
                }
                catch (Exception e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of an app update", e);
                }
            }
        }
    }
}

