/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.textclassifier;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.service.textclassifier.TextClassifierService;
import android.util.Slog;
import android.util.SparseArray;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;
import java.util.ArrayDeque;
import java.util.Queue;

public final class TextClassificationManagerService
extends ITextClassifierService.Stub {
    private static final String LOG_TAG = "TextClassificationManagerService";
    private final Context mContext;
    private final Object mLock;
    @GuardedBy(value="mLock")
    final SparseArray<UserState> mUserStates = new SparseArray();

    private TextClassificationManagerService(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuggestSelection(TextClassificationSessionId sessionId, TextSelection.Request request, ITextSelectionCallback callback) throws RemoteException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (!userState.bindLocked()) {
                callback.onFailure();
            } else if (userState.isBoundLocked()) {
                userState.mService.onSuggestSelection(sessionId, request, callback);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onSuggestSelection(sessionId, request, callback), callback::onFailure, callback.asBinder(), this, userState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClassifyText(TextClassificationSessionId sessionId, TextClassification.Request request, ITextClassificationCallback callback) throws RemoteException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (!userState.bindLocked()) {
                callback.onFailure();
            } else if (userState.isBoundLocked()) {
                userState.mService.onClassifyText(sessionId, request, callback);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onClassifyText(sessionId, request, callback), callback::onFailure, callback.asBinder(), this, userState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGenerateLinks(TextClassificationSessionId sessionId, TextLinks.Request request, ITextLinksCallback callback) throws RemoteException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (!userState.bindLocked()) {
                callback.onFailure();
            } else if (userState.isBoundLocked()) {
                userState.mService.onGenerateLinks(sessionId, request, callback);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onGenerateLinks(sessionId, request, callback), callback::onFailure, callback.asBinder(), this, userState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) throws RemoteException {
        Preconditions.checkNotNull(event);
        TextClassificationManagerService.validateInput(event.getPackageName(), this.mContext);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (userState.isBoundLocked()) {
                userState.mService.onSelectionEvent(sessionId, event);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onSelectionEvent(sessionId, event), null, null, this, userState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreateTextClassificationSession(TextClassificationContext classificationContext, TextClassificationSessionId sessionId) throws RemoteException {
        Preconditions.checkNotNull(sessionId);
        Preconditions.checkNotNull(classificationContext);
        TextClassificationManagerService.validateInput(classificationContext.getPackageName(), this.mContext);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (userState.isBoundLocked()) {
                userState.mService.onCreateTextClassificationSession(classificationContext, sessionId);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onCreateTextClassificationSession(classificationContext, sessionId), null, null, this, userState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) throws RemoteException {
        Preconditions.checkNotNull(sessionId);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCallingUserStateLocked();
            if (userState.isBoundLocked()) {
                userState.mService.onDestroyTextClassificationSession(sessionId);
            } else {
                userState.mPendingRequests.add(new PendingRequest(() -> this.onDestroyTextClassificationSession(sessionId), null, null, this, userState));
            }
        }
    }

    private UserState getCallingUserStateLocked() {
        return this.getUserStateLocked(UserHandle.getCallingUserId());
    }

    private UserState getUserStateLocked(int userId) {
        UserState result = this.mUserStates.get(userId);
        if (result == null) {
            result = new UserState(userId, this.mContext, this.mLock);
            this.mUserStates.put(userId, result);
        }
        return result;
    }

    UserState peekUserStateLocked(int userId) {
        return this.mUserStates.get(userId);
    }

    private static Runnable logOnFailure(FunctionalUtils.ThrowingRunnable r, String opDesc) {
        if (r == null) {
            return null;
        }
        return FunctionalUtils.handleExceptions(r, e -> Slog.d(LOG_TAG, "Error " + opDesc + ": " + e.getMessage()));
    }

    private static void validateInput(String packageName, Context context) throws RemoteException {
        try {
            int uid = context.getPackageManager().getPackageUid(packageName, 0);
            Preconditions.checkArgument(Binder.getCallingUid() == uid);
        }
        catch (PackageManager.NameNotFoundException | IllegalArgumentException | NullPointerException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private static final class UserState {
        final int mUserId;
        final TextClassifierServiceConnection mConnection = new TextClassifierServiceConnection();
        @GuardedBy(value="mLock")
        final Queue<PendingRequest> mPendingRequests = new ArrayDeque<PendingRequest>();
        @GuardedBy(value="mLock")
        ITextClassifierService mService;
        @GuardedBy(value="mLock")
        boolean mBinding;
        private final Context mContext;
        private final Object mLock;

        private UserState(int userId, Context context, Object lock) {
            this.mUserId = userId;
            this.mContext = Preconditions.checkNotNull(context);
            this.mLock = Preconditions.checkNotNull(lock);
        }

        @GuardedBy(value="mLock")
        boolean isBoundLocked() {
            return this.mService != null;
        }

        @GuardedBy(value="mLock")
        private void handlePendingRequestsLocked() {
            PendingRequest request;
            while ((request = this.mPendingRequests.poll()) != null) {
                if (this.isBoundLocked()) {
                    request.mRequest.run();
                } else if (request.mOnServiceFailure != null) {
                    request.mOnServiceFailure.run();
                }
                if (request.mBinder == null) continue;
                request.mBinder.unlinkToDeath(request, 0);
            }
        }

        private boolean bindIfHasPendingRequestsLocked() {
            return !this.mPendingRequests.isEmpty() && this.bindLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean bindLocked() {
            boolean willBind;
            if (this.isBoundLocked() || this.mBinding) {
                return true;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                ComponentName componentName = TextClassifierService.getServiceComponentName(this.mContext);
                if (componentName == null) {
                    boolean bl = false;
                    return bl;
                }
                Intent serviceIntent = new Intent("android.service.textclassifier.TextClassifierService").setComponent(componentName);
                Slog.d(TextClassificationManagerService.LOG_TAG, "Binding to " + serviceIntent.getComponent());
                this.mBinding = willBind = this.mContext.bindServiceAsUser(serviceIntent, this.mConnection, 0x4000001, UserHandle.of(this.mUserId));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return willBind;
        }

        private final class TextClassifierServiceConnection
        implements ServiceConnection {
            private TextClassifierServiceConnection() {
            }

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                this.init(ITextClassifierService.Stub.asInterface(service));
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onBindingDied(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onNullBinding(ComponentName name) {
                this.cleanupService();
            }

            void cleanupService() {
                this.init(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void init(ITextClassifierService service) {
                Object object = UserState.this.mLock;
                synchronized (object) {
                    UserState.this.mService = service;
                    UserState.this.mBinding = false;
                    UserState.this.handlePendingRequestsLocked();
                }
            }
        }
    }

    private static final class PendingRequest
    implements IBinder.DeathRecipient {
        private final IBinder mBinder;
        private final Runnable mRequest;
        private final Runnable mOnServiceFailure;
        @GuardedBy(value="mLock")
        private final UserState mOwningUser;
        private final TextClassificationManagerService mService;

        PendingRequest(FunctionalUtils.ThrowingRunnable request, FunctionalUtils.ThrowingRunnable onServiceFailure, IBinder binder, TextClassificationManagerService service, UserState owningUser) {
            this.mRequest = TextClassificationManagerService.logOnFailure(Preconditions.checkNotNull(request), "handling pending request");
            this.mOnServiceFailure = TextClassificationManagerService.logOnFailure(onServiceFailure, "notifying callback of service failure");
            this.mBinder = binder;
            this.mService = service;
            this.mOwningUser = owningUser;
            if (this.mBinder != null) {
                try {
                    this.mBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = this.mService.mLock;
            synchronized (object) {
                this.removeLocked();
            }
        }

        @GuardedBy(value="mLock")
        private void removeLocked() {
            this.mOwningUser.mPendingRequests.remove(this);
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final TextClassificationManagerService mManagerService;

        public Lifecycle(Context context) {
            super(context);
            this.mManagerService = new TextClassificationManagerService(context);
        }

        @Override
        public void onStart() {
            try {
                this.publishBinderService("textclassification", this.mManagerService);
            }
            catch (Throwable t) {
                Slog.e(TextClassificationManagerService.LOG_TAG, "Could not start the TextClassificationManagerService.", t);
            }
        }

        @Override
        public void onStartUser(int userId) {
            this.processAnyPendingWork(userId);
        }

        @Override
        public void onUnlockUser(int userId) {
            this.processAnyPendingWork(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAnyPendingWork(int userId) {
            Object object = this.mManagerService.mLock;
            synchronized (object) {
                this.mManagerService.getUserStateLocked(userId).bindIfHasPendingRequestsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStopUser(int userId) {
            Object object = this.mManagerService.mLock;
            synchronized (object) {
                UserState userState = this.mManagerService.peekUserStateLocked(userId);
                if (userState != null) {
                    userState.mConnection.cleanupService();
                    this.mManagerService.mUserStates.remove(userId);
                }
            }
        }
    }
}

