/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.AppOpsManager;
import android.app.usage.ExternalStorageStats;
import android.app.usage.IStorageStatsManager;
import android.app.usage.StorageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelableException;
import android.os.StatFs;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.DataUnit;
import android.util.Slog;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.Installer;
import com.android.server.storage.CacheQuotaStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class StorageStatsService
extends IStorageStatsManager.Stub {
    private static final String TAG = "StorageStatsService";
    private static final String PROP_DISABLE_QUOTA = "fw.disable_quota";
    private static final String PROP_VERIFY_STORAGE = "fw.verify_storage";
    private static final long DELAY_IN_MILLIS = 30000L;
    private static final long DEFAULT_QUOTA = DataUnit.MEBIBYTES.toBytes(64L);
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final UserManager mUser;
    private final PackageManager mPackage;
    private final StorageManager mStorage;
    private final ArrayMap<String, SparseLongArray> mCacheQuotas;
    private final Installer mInstaller;
    private final H mHandler;

    public StorageStatsService(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mAppOps = Preconditions.checkNotNull(context.getSystemService(AppOpsManager.class));
        this.mUser = Preconditions.checkNotNull(context.getSystemService(UserManager.class));
        this.mPackage = Preconditions.checkNotNull(context.getPackageManager());
        this.mStorage = Preconditions.checkNotNull(context.getSystemService(StorageManager.class));
        this.mCacheQuotas = new ArrayMap();
        this.mInstaller = new Installer(context);
        this.mInstaller.onStart();
        this.invalidateMounts();
        this.mHandler = new H(IoThread.get().getLooper());
        this.mHandler.sendEmptyMessage(101);
        this.mStorage.registerListener(new StorageEventListener(){

            @Override
            public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
                switch (vol.type) {
                    case 1: 
                    case 2: {
                        if (newState != 2) break;
                        StorageStatsService.this.invalidateMounts();
                    }
                }
            }
        });
    }

    private void invalidateMounts() {
        try {
            this.mInstaller.invalidateMounts();
        }
        catch (Installer.InstallerException e) {
            Slog.wtf(TAG, "Failed to invalidate mounts", e);
        }
    }

    private void enforcePermission(int callingUid, String callingPackage) {
        int mode = this.mAppOps.noteOp(43, callingUid, callingPackage);
        switch (mode) {
            case 0: {
                return;
            }
            case 3: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", TAG);
                return;
            }
        }
        throw new SecurityException("Package " + callingPackage + " from UID " + callingUid + " blocked by mode " + mode);
    }

    @Override
    public boolean isQuotaSupported(String volumeUuid, String callingPackage) {
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        try {
            return this.mInstaller.isQuotaSupported(volumeUuid);
        }
        catch (Installer.InstallerException e) {
            throw new ParcelableException(new IOException(e.getMessage()));
        }
    }

    @Override
    public boolean isReservedSupported(String volumeUuid, String callingPackage) {
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        if (volumeUuid == StorageManager.UUID_PRIVATE_INTERNAL) {
            return SystemProperties.getBoolean("vold.has_reserved", false);
        }
        return false;
    }

    @Override
    public long getTotalBytes(String volumeUuid, String callingPackage) {
        if (volumeUuid == StorageManager.UUID_PRIVATE_INTERNAL) {
            return FileUtils.roundStorageSize(this.mStorage.getPrimaryStorageSize());
        }
        VolumeInfo vol = this.mStorage.findVolumeByUuid(volumeUuid);
        if (vol == null) {
            throw new ParcelableException(new IOException("Failed to find storage device for UUID " + volumeUuid));
        }
        return FileUtils.roundStorageSize(vol.disk.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFreeBytes(String volumeUuid, String callingPackage) {
        long token = Binder.clearCallingIdentity();
        try {
            File path;
            try {
                path = this.mStorage.findPathForUuid(volumeUuid);
            }
            catch (FileNotFoundException e) {
                throw new ParcelableException(e);
            }
            if (this.isQuotaSupported(volumeUuid, "android")) {
                long cacheTotal = this.getCacheBytes(volumeUuid, "android");
                long cacheReserved = this.mStorage.getStorageCacheBytes(path, 0);
                long cacheClearable = Math.max(0L, cacheTotal - cacheReserved);
                long l = path.getUsableSpace() + cacheClearable;
                return l;
            }
            long l = path.getUsableSpace();
            return l;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public long getCacheBytes(String volumeUuid, String callingPackage) {
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        long cacheBytes = 0L;
        for (UserInfo user : this.mUser.getUsers()) {
            StorageStats stats = this.queryStatsForUser(volumeUuid, user.id, null);
            cacheBytes += stats.cacheBytes;
        }
        return cacheBytes;
    }

    @Override
    public long getCacheQuotaBytes(String volumeUuid, int uid, String callingPackage) {
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        if (this.mCacheQuotas.containsKey(volumeUuid)) {
            SparseLongArray uidMap = this.mCacheQuotas.get(volumeUuid);
            return uidMap.get(uid, DEFAULT_QUOTA);
        }
        return DEFAULT_QUOTA;
    }

    @Override
    public StorageStats queryStatsForPackage(String volumeUuid, String packageName, int userId, String callingPackage) {
        ApplicationInfo appInfo;
        if (userId != UserHandle.getCallingUserId()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", TAG);
        }
        try {
            appInfo = this.mPackage.getApplicationInfoAsUser(packageName, 8192, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ParcelableException(e);
        }
        if (Binder.getCallingUid() != appInfo.uid) {
            this.enforcePermission(Binder.getCallingUid(), callingPackage);
        }
        if (ArrayUtils.defeatNullable(this.mPackage.getPackagesForUid(appInfo.uid)).length == 1) {
            return this.queryStatsForUid(volumeUuid, appInfo.uid, callingPackage);
        }
        int appId = UserHandle.getUserId(appInfo.uid);
        String[] packageNames = new String[]{packageName};
        long[] ceDataInodes = new long[1];
        String[] codePaths = new String[]{};
        if (!appInfo.isSystemApp() || appInfo.isUpdatedSystemApp()) {
            codePaths = ArrayUtils.appendElement(String.class, codePaths, appInfo.getCodePath());
        }
        PackageStats stats = new PackageStats(TAG);
        try {
            this.mInstaller.getAppSize(volumeUuid, packageNames, userId, 0, appId, ceDataInodes, codePaths, stats);
        }
        catch (Installer.InstallerException e) {
            throw new ParcelableException(new IOException(e.getMessage()));
        }
        return StorageStatsService.translate(stats);
    }

    @Override
    public StorageStats queryStatsForUid(String volumeUuid, int uid, String callingPackage) {
        int userId = UserHandle.getUserId(uid);
        int appId = UserHandle.getAppId(uid);
        if (userId != UserHandle.getCallingUserId()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", TAG);
        }
        if (Binder.getCallingUid() != uid) {
            this.enforcePermission(Binder.getCallingUid(), callingPackage);
        }
        String[] packageNames = ArrayUtils.defeatNullable(this.mPackage.getPackagesForUid(uid));
        long[] ceDataInodes = new long[packageNames.length];
        String[] codePaths = new String[]{};
        for (int i = 0; i < packageNames.length; ++i) {
            try {
                ApplicationInfo appInfo = this.mPackage.getApplicationInfoAsUser(packageNames[i], 8192, userId);
                if (appInfo.isSystemApp() && !appInfo.isUpdatedSystemApp()) continue;
                codePaths = ArrayUtils.appendElement(String.class, codePaths, appInfo.getCodePath());
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new ParcelableException(e);
            }
        }
        PackageStats stats = new PackageStats(TAG);
        try {
            this.mInstaller.getAppSize(volumeUuid, packageNames, userId, StorageStatsService.getDefaultFlags(), appId, ceDataInodes, codePaths, stats);
            if (SystemProperties.getBoolean(PROP_VERIFY_STORAGE, false)) {
                PackageStats manualStats = new PackageStats(TAG);
                this.mInstaller.getAppSize(volumeUuid, packageNames, userId, 0, appId, ceDataInodes, codePaths, manualStats);
                StorageStatsService.checkEquals("UID " + uid, manualStats, stats);
            }
        }
        catch (Installer.InstallerException e) {
            throw new ParcelableException(new IOException(e.getMessage()));
        }
        return StorageStatsService.translate(stats);
    }

    @Override
    public StorageStats queryStatsForUser(String volumeUuid, int userId, String callingPackage) {
        if (userId != UserHandle.getCallingUserId()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", TAG);
        }
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        int[] appIds = this.getAppIds(userId);
        PackageStats stats = new PackageStats(TAG);
        try {
            this.mInstaller.getUserSize(volumeUuid, userId, StorageStatsService.getDefaultFlags(), appIds, stats);
            if (SystemProperties.getBoolean(PROP_VERIFY_STORAGE, false)) {
                PackageStats manualStats = new PackageStats(TAG);
                this.mInstaller.getUserSize(volumeUuid, userId, 0, appIds, manualStats);
                StorageStatsService.checkEquals("User " + userId, manualStats, stats);
            }
        }
        catch (Installer.InstallerException e) {
            throw new ParcelableException(new IOException(e.getMessage()));
        }
        return StorageStatsService.translate(stats);
    }

    @Override
    public ExternalStorageStats queryExternalStatsForUser(String volumeUuid, int userId, String callingPackage) {
        long[] stats;
        if (userId != UserHandle.getCallingUserId()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", TAG);
        }
        this.enforcePermission(Binder.getCallingUid(), callingPackage);
        int[] appIds = this.getAppIds(userId);
        try {
            stats = this.mInstaller.getExternalSize(volumeUuid, userId, StorageStatsService.getDefaultFlags(), appIds);
            if (SystemProperties.getBoolean(PROP_VERIFY_STORAGE, false)) {
                long[] manualStats = this.mInstaller.getExternalSize(volumeUuid, userId, 0, appIds);
                StorageStatsService.checkEquals("External " + userId, manualStats, stats);
            }
        }
        catch (Installer.InstallerException e) {
            throw new ParcelableException(new IOException(e.getMessage()));
        }
        ExternalStorageStats res = new ExternalStorageStats();
        res.totalBytes = stats[0];
        res.audioBytes = stats[1];
        res.videoBytes = stats[2];
        res.imageBytes = stats[3];
        res.appBytes = stats[4];
        res.obbBytes = stats[5];
        return res;
    }

    private int[] getAppIds(int userId) {
        int[] appIds = null;
        for (ApplicationInfo app : this.mPackage.getInstalledApplicationsAsUser(8192, userId)) {
            int appId = UserHandle.getAppId(app.uid);
            if (ArrayUtils.contains(appIds, appId)) continue;
            appIds = ArrayUtils.appendInt(appIds, appId);
        }
        return appIds;
    }

    private static int getDefaultFlags() {
        if (SystemProperties.getBoolean(PROP_DISABLE_QUOTA, false)) {
            return 0;
        }
        return 4096;
    }

    private static void checkEquals(String msg, long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            StorageStatsService.checkEquals(msg + "[" + i + "]", a[i], b[i]);
        }
    }

    private static void checkEquals(String msg, PackageStats a, PackageStats b) {
        StorageStatsService.checkEquals(msg + " codeSize", a.codeSize, b.codeSize);
        StorageStatsService.checkEquals(msg + " dataSize", a.dataSize, b.dataSize);
        StorageStatsService.checkEquals(msg + " cacheSize", a.cacheSize, b.cacheSize);
        StorageStatsService.checkEquals(msg + " externalCodeSize", a.externalCodeSize, b.externalCodeSize);
        StorageStatsService.checkEquals(msg + " externalDataSize", a.externalDataSize, b.externalDataSize);
        StorageStatsService.checkEquals(msg + " externalCacheSize", a.externalCacheSize, b.externalCacheSize);
    }

    private static void checkEquals(String msg, long expected, long actual) {
        if (expected != actual) {
            Slog.e(TAG, msg + " expected " + expected + " actual " + actual);
        }
    }

    private static StorageStats translate(PackageStats stats) {
        StorageStats res = new StorageStats();
        res.codeBytes = stats.codeSize + stats.externalCodeSize;
        res.dataBytes = stats.dataSize + stats.externalDataSize;
        res.cacheBytes = stats.cacheSize + stats.externalCacheSize;
        return res;
    }

    @VisibleForTesting
    static boolean isCacheQuotaCalculationsEnabled(ContentResolver resolver) {
        return Settings.Global.getInt(resolver, "enable_cache_quota_calculation", 1) != 0;
    }

    void notifySignificantDelta() {
        this.mContext.getContentResolver().notifyChange(Uri.parse("content://com.android.externalstorage.documents/"), null, false);
    }

    private class H
    extends Handler {
        private static final int MSG_CHECK_STORAGE_DELTA = 100;
        private static final int MSG_LOAD_CACHED_QUOTAS_FROM_FILE = 101;
        private static final double MINIMUM_CHANGE_DELTA = 0.05;
        private static final int UNSET = -1;
        private static final boolean DEBUG = false;
        private final StatFs mStats;
        private long mPreviousBytes;
        private double mMinimumThresholdBytes;

        public H(Looper looper) {
            super(looper);
            this.mStats = new StatFs(Environment.getDataDirectory().getAbsolutePath());
            this.mPreviousBytes = this.mStats.getAvailableBytes();
            this.mMinimumThresholdBytes = (double)this.mStats.getTotalBytes() * 0.05;
        }

        @Override
        public void handleMessage(Message msg) {
            if (!StorageStatsService.isCacheQuotaCalculationsEnabled(StorageStatsService.this.mContext.getContentResolver())) {
                return;
            }
            switch (msg.what) {
                case 100: {
                    long bytesDelta = Math.abs(this.mPreviousBytes - this.mStats.getAvailableBytes());
                    if ((double)bytesDelta > this.mMinimumThresholdBytes) {
                        this.mPreviousBytes = this.mStats.getAvailableBytes();
                        this.recalculateQuotas(this.getInitializedStrategy());
                        StorageStatsService.this.notifySignificantDelta();
                    }
                    this.sendEmptyMessageDelayed(100, 30000L);
                    break;
                }
                case 101: {
                    CacheQuotaStrategy strategy = this.getInitializedStrategy();
                    this.mPreviousBytes = -1L;
                    try {
                        this.mPreviousBytes = strategy.setupQuotasFromFile();
                    }
                    catch (IOException e) {
                        Slog.e(StorageStatsService.TAG, "An error occurred while reading the cache quota file.", e);
                    }
                    catch (IllegalStateException e) {
                        Slog.e(StorageStatsService.TAG, "Cache quota XML file is malformed?", e);
                    }
                    if (this.mPreviousBytes < 0L) {
                        this.mPreviousBytes = this.mStats.getAvailableBytes();
                        this.recalculateQuotas(strategy);
                    }
                    this.sendEmptyMessageDelayed(100, 30000L);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void recalculateQuotas(CacheQuotaStrategy strategy) {
            strategy.recalculateQuotas();
        }

        private CacheQuotaStrategy getInitializedStrategy() {
            UsageStatsManagerInternal usageStatsManager = LocalServices.getService(UsageStatsManagerInternal.class);
            return new CacheQuotaStrategy(StorageStatsService.this.mContext, usageStatsManager, StorageStatsService.this.mInstaller, StorageStatsService.this.mCacheQuotas);
        }
    }

    public static class Lifecycle
    extends SystemService {
        private StorageStatsService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new StorageStatsService(this.getContext());
            this.publishBinderService("storagestats", this.mService);
        }
    }
}

