/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.IUidObserver;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.usage.AppStandbyInfo;
import android.app.usage.ConfigurationStats;
import android.app.usage.EventStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.usage.AppStandbyController;
import com.android.server.usage.AppTimeLimitController;
import com.android.server.usage.UserUsageStatsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class UsageStatsService
extends SystemService
implements UserUsageStatsService.StatsUpdatedListener {
    static final String TAG = "UsageStatsService";
    public static final boolean ENABLE_TIME_CHANGE_CORRECTION = SystemProperties.getBoolean("persist.debug.time_correction", true);
    static final boolean DEBUG = false;
    static final boolean COMPRESS_TIME = false;
    private static final long TEN_SECONDS = 10000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long FLUSH_INTERVAL = 1200000L;
    private static final long TIME_CHANGE_THRESHOLD_MILLIS = 2000L;
    private static final boolean ENABLE_KERNEL_UPDATES = true;
    private static final File KERNEL_COUNTER_FILE = new File("/proc/uid_procstat/set");
    static final int MSG_REPORT_EVENT = 0;
    static final int MSG_FLUSH_TO_DISK = 1;
    static final int MSG_REMOVE_USER = 2;
    static final int MSG_UID_STATE_CHANGED = 3;
    private final Object mLock = new Object();
    Handler mHandler;
    AppOpsManager mAppOps;
    UserManager mUserManager;
    PackageManager mPackageManager;
    PackageManagerInternal mPackageManagerInternal;
    PackageMonitor mPackageMonitor;
    IDeviceIdleController mDeviceIdleController;
    DevicePolicyManagerInternal mDpmInternal;
    private final SparseArray<UserUsageStatsService> mUserState = new SparseArray();
    private final SparseIntArray mUidToKernelCounter = new SparseIntArray();
    private File mUsageStatsDir;
    long mRealTimeSnapshot;
    long mSystemTimeSnapshot;
    AppStandbyController mAppStandby;
    AppTimeLimitController mAppTimeLimit;
    private UsageStatsManagerInternal.AppIdleStateChangeListener mStandbyChangeListener = new UsageStatsManagerInternal.AppIdleStateChangeListener(){

        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            UsageEvents.Event event = new UsageEvents.Event();
            event.mEventType = 11;
            event.mBucketAndReason = bucket << 16 | reason & 0xFFFF;
            event.mPackage = packageName;
            event.mTimeStamp = SystemClock.elapsedRealtime();
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
        }
    };
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            UsageStatsService.this.mHandler.obtainMessage(3, uid, procState).sendToTarget();
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            this.onUidStateChanged(uid, 19, 0L);
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };

    public UsageStatsService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mUserManager = (UserManager)this.getContext().getSystemService("user");
        this.mPackageManager = this.getContext().getPackageManager();
        this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        this.mHandler = new H(BackgroundThread.get().getLooper());
        this.mAppStandby = new AppStandbyController(this.getContext(), BackgroundThread.get().getLooper());
        this.mAppTimeLimit = new AppTimeLimitController((observerId, userId, timeLimit, timeElapsed, callbackIntent) -> {
            Intent intent = new Intent();
            intent.putExtra("android.app.usage.extra.OBSERVER_ID", observerId);
            intent.putExtra("android.app.usage.extra.TIME_LIMIT", timeLimit);
            intent.putExtra("android.app.usage.extra.TIME_USED", timeElapsed);
            try {
                callbackIntent.send(this.getContext(), 0, intent);
            }
            catch (PendingIntent.CanceledException e) {
                Slog.w(TAG, "Couldn't deliver callback: " + callbackIntent);
            }
        }, this.mHandler.getLooper());
        this.mAppStandby.addListener(this.mStandbyChangeListener);
        File systemDataDir = new File(Environment.getDataDirectory(), "system");
        this.mUsageStatsDir = new File(systemDataDir, "usagestats");
        this.mUsageStatsDir.mkdirs();
        if (!this.mUsageStatsDir.exists()) {
            throw new IllegalStateException("Usage stats directory does not exist: " + this.mUsageStatsDir.getAbsolutePath());
        }
        IntentFilter filter = new IntentFilter("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        this.getContext().registerReceiverAsUser(new UserActionsReceiver(), UserHandle.ALL, filter, null, this.mHandler);
        Object object = this.mLock;
        synchronized (object) {
            this.cleanUpRemovedUsersLocked();
        }
        this.mRealTimeSnapshot = SystemClock.elapsedRealtime();
        this.mSystemTimeSnapshot = System.currentTimeMillis();
        this.publishLocalService(UsageStatsManagerInternal.class, new LocalService());
        this.publishBinderService("usagestats", new BinderService());
        this.getUserDataAndInitializeIfNeededLocked(0, this.mSystemTimeSnapshot);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mAppStandby.onBootPhase(phase);
            this.getDpmInternal();
            this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
            if (KERNEL_COUNTER_FILE.exists()) {
                try {
                    ActivityManager.getService().registerUidObserver(this.mUidObserver, 3, -1, null);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Slog.w(TAG, "Missing procfs interface: " + KERNEL_COUNTER_FILE);
            }
        }
    }

    private DevicePolicyManagerInternal getDpmInternal() {
        if (this.mDpmInternal == null) {
            this.mDpmInternal = LocalServices.getService(DevicePolicyManagerInternal.class);
        }
        return this.mDpmInternal;
    }

    @Override
    public void onStatsUpdated() {
        this.mHandler.sendEmptyMessageDelayed(1, 1200000L);
    }

    @Override
    public void onStatsReloaded() {
        this.mAppStandby.postOneTimeCheckIdleStates();
    }

    @Override
    public void onNewUpdate(int userId) {
        this.mAppStandby.initializeDefaultsForSystemApps(userId);
    }

    private boolean shouldObfuscateInstantAppsForCaller(int callingUid, int userId) {
        return !this.mPackageManagerInternal.canAccessInstantApps(callingUid, userId);
    }

    private void cleanUpRemovedUsersLocked() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users == null || users.size() == 0) {
            throw new IllegalStateException("There can't be no users");
        }
        ArraySet<String> toDelete = new ArraySet<String>();
        String[] fileNames = this.mUsageStatsDir.list();
        if (fileNames == null) {
            return;
        }
        toDelete.addAll(Arrays.asList(fileNames));
        int userCount = users.size();
        for (int i = 0; i < userCount; ++i) {
            UserInfo userInfo = users.get(i);
            toDelete.remove(Integer.toString(userInfo.id));
        }
        int deleteCount = toDelete.size();
        for (int i = 0; i < deleteCount; ++i) {
            UsageStatsService.deleteRecursively(new File(this.mUsageStatsDir, (String)toDelete.valueAt(i)));
        }
    }

    private static void deleteRecursively(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (File subFile : files) {
                UsageStatsService.deleteRecursively(subFile);
            }
        }
        if (!f.delete()) {
            Slog.e(TAG, "Failed to delete " + f);
        }
    }

    private UserUsageStatsService getUserDataAndInitializeIfNeededLocked(int userId, long currentTimeMillis) {
        UserUsageStatsService service = this.mUserState.get(userId);
        if (service == null) {
            service = new UserUsageStatsService(this.getContext(), userId, new File(this.mUsageStatsDir, Integer.toString(userId)), this);
            service.init(currentTimeMillis);
            this.mUserState.put(userId, service);
        }
        return service;
    }

    private long checkAndGetTimeLocked() {
        long actualRealtime;
        long expectedSystemTime;
        long actualSystemTime = System.currentTimeMillis();
        long diffSystemTime = actualSystemTime - (expectedSystemTime = (actualRealtime = SystemClock.elapsedRealtime()) - this.mRealTimeSnapshot + this.mSystemTimeSnapshot);
        if (Math.abs(diffSystemTime) > 2000L && ENABLE_TIME_CHANGE_CORRECTION) {
            Slog.i(TAG, "Time changed in UsageStats by " + diffSystemTime / 1000L + " seconds");
            int userCount = this.mUserState.size();
            for (int i = 0; i < userCount; ++i) {
                UserUsageStatsService service = this.mUserState.valueAt(i);
                service.onTimeChanged(expectedSystemTime, actualSystemTime);
            }
            this.mRealTimeSnapshot = actualRealtime;
            this.mSystemTimeSnapshot = actualSystemTime;
        }
        return actualSystemTime;
    }

    private void convertToSystemTimeLocked(UsageEvents.Event event) {
        event.mTimeStamp = Math.max(0L, event.mTimeStamp - this.mRealTimeSnapshot) + this.mSystemTimeSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeMessages(0);
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(UsageEvents.Event event, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            long elapsedRealtime = SystemClock.elapsedRealtime();
            this.convertToSystemTimeLocked(event);
            if (event.getPackageName() != null && this.mPackageManagerInternal.isPackageEphemeral(userId, event.getPackageName())) {
                event.mFlags |= 1;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            service.reportEvent(event);
            this.mAppStandby.reportEvent(event, elapsedRealtime, userId);
            switch (event.mEventType) {
                case 1: {
                    this.mAppTimeLimit.moveToForeground(event.getPackageName(), event.getClassName(), userId);
                    break;
                }
                case 2: {
                    this.mAppTimeLimit.moveToBackground(event.getPackageName(), event.getClassName(), userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushToDisk() {
        Object object = this.mLock;
        synchronized (object) {
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserRemoved(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Removing user " + userId + " and all data.");
            this.mUserState.remove(userId);
            this.mAppStandby.onUserRemoved(userId);
            this.mAppTimeLimit.onUserRemoved(userId);
            this.cleanUpRemovedUsersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UsageStats> queryUsageStats(int userId, int bucketType, long beginTime, long endTime, boolean obfuscateInstantApps) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            List<UsageStats> list = service.queryUsageStats(bucketType, beginTime, endTime);
            if (list == null) {
                return null;
            }
            if (obfuscateInstantApps) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    UsageStats stats = list.get(i);
                    if (!this.mPackageManagerInternal.isPackageEphemeral(userId, stats.mPackageName)) continue;
                    list.set(i, stats.getObfuscatedForInstantApp());
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ConfigurationStats> queryConfigurationStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryConfigurationStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventStats> queryEventStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryEventStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsageEvents queryEvents(int userId, long beginTime, long endTime, boolean shouldObfuscateInstantApps) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryEvents(beginTime, endTime, shouldObfuscateInstantApps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsageEvents queryEventsForPackage(int userId, long beginTime, long endTime, String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryEventsForPackage(beginTime, endTime, packageName);
        }
    }

    private static boolean validRange(long currentTime, long beginTime, long endTime) {
        return beginTime <= currentTime && beginTime < endTime;
    }

    private void flushToDiskLocked() {
        int userCount = this.mUserState.size();
        for (int i = 0; i < userCount; ++i) {
            UserUsageStatsService service = this.mUserState.valueAt(i);
            service.persistActiveStats();
            this.mAppStandby.flushToDisk(this.mUserState.keyAt(i));
        }
        this.mAppStandby.flushDurationsToDisk();
        this.mHandler.removeMessages(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String[] args, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            IndentingPrintWriter idpw = new IndentingPrintWriter((Writer)pw, "  ");
            boolean checkin = false;
            boolean compact = false;
            String pkg = null;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if ("--checkin".equals(arg)) {
                        checkin = true;
                        continue;
                    }
                    if ("-c".equals(arg)) {
                        compact = true;
                        continue;
                    }
                    if ("flush".equals(arg)) {
                        this.flushToDiskLocked();
                        pw.println("Flushed stats to disk");
                        return;
                    }
                    if ("is-app-standby-enabled".equals(arg)) {
                        pw.println(this.mAppStandby.mAppIdleEnabled);
                        return;
                    }
                    if (arg == null || arg.startsWith("-")) continue;
                    pkg = arg;
                    break;
                }
            }
            int userCount = this.mUserState.size();
            for (int i = 0; i < userCount; ++i) {
                int userId = this.mUserState.keyAt(i);
                idpw.printPair("user", userId);
                idpw.println();
                idpw.increaseIndent();
                if (checkin) {
                    this.mUserState.valueAt(i).checkin(idpw);
                } else {
                    this.mUserState.valueAt(i).dump(idpw, pkg, compact);
                    idpw.println();
                }
                this.mAppStandby.dumpUser(idpw, userId, pkg);
                idpw.decreaseIndent();
            }
            if (pkg == null) {
                pw.println();
                this.mAppStandby.dumpState(args, pw);
            }
            this.mAppTimeLimit.dump(pw);
        }
    }

    void registerAppUsageObserver(int callingUid, int observerId, String[] packages, long timeLimitMs, PendingIntent callbackIntent, int userId) {
        this.mAppTimeLimit.addObserver(callingUid, observerId, packages, timeLimitMs, callbackIntent, userId);
    }

    void unregisterAppUsageObserver(int callingUid, int observerId, int userId) {
        this.mAppTimeLimit.removeObserver(callingUid, observerId, userId);
    }

    private final class LocalService
    extends UsageStatsManagerInternal {
        private LocalService() {
        }

        @Override
        public void reportEvent(ComponentName component, int userId, int eventType) {
            if (component == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a component name");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = component.getPackageName();
            event.mClass = component.getClassName();
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = eventType;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportEvent(String packageName, int userId, int eventType) {
            if (packageName == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a package name");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = packageName;
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = eventType;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportConfigurationChange(Configuration config, int userId) {
            if (config == null) {
                Slog.w(UsageStatsService.TAG, "Configuration event reported with a null config");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = "android";
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 5;
            event.mConfiguration = new Configuration(config);
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportInterruptiveNotification(String packageName, String channelId, int userId) {
            if (packageName == null || channelId == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a package name or a channel ID");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = packageName.intern();
            event.mNotificationChannelId = channelId.intern();
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 12;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportShortcutUsage(String packageName, String shortcutId, int userId) {
            if (packageName == null || shortcutId == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a package name or a shortcut ID");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = packageName.intern();
            event.mShortcutId = shortcutId.intern();
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 8;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportContentProviderUsage(String name, String packageName, int userId) {
            UsageStatsService.this.mAppStandby.postReportContentProviderUsage(name, packageName, userId);
        }

        @Override
        public boolean isAppIdle(String packageName, int uidForAppId, int userId) {
            return UsageStatsService.this.mAppStandby.isAppIdleFiltered(packageName, uidForAppId, userId, SystemClock.elapsedRealtime());
        }

        @Override
        public int getAppStandbyBucket(String packageName, int userId, long nowElapsed) {
            return UsageStatsService.this.mAppStandby.getAppStandbyBucket(packageName, userId, nowElapsed, false);
        }

        @Override
        public int[] getIdleUidsForUser(int userId) {
            return UsageStatsService.this.mAppStandby.getIdleUidsForUser(userId);
        }

        @Override
        public boolean isAppIdleParoleOn() {
            return UsageStatsService.this.mAppStandby.isParoledOrCharging();
        }

        @Override
        public void prepareShutdown() {
            UsageStatsService.this.shutdown();
        }

        @Override
        public void addAppIdleStateChangeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
            UsageStatsService.this.mAppStandby.addListener(listener);
            listener.onParoleStateChanged(this.isAppIdleParoleOn());
        }

        @Override
        public void removeAppIdleStateChangeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
            UsageStatsService.this.mAppStandby.removeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBackupPayload(int user, String key) {
            Object object = UsageStatsService.this.mLock;
            synchronized (object) {
                if (user == 0) {
                    UserUsageStatsService userStats = UsageStatsService.this.getUserDataAndInitializeIfNeededLocked(user, UsageStatsService.this.checkAndGetTimeLocked());
                    return userStats.getBackupPayload(key);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyRestoredPayload(int user, String key, byte[] payload) {
            Object object = UsageStatsService.this.mLock;
            synchronized (object) {
                if (user == 0) {
                    UserUsageStatsService userStats = UsageStatsService.this.getUserDataAndInitializeIfNeededLocked(user, UsageStatsService.this.checkAndGetTimeLocked());
                    userStats.applyRestoredPayload(key, payload);
                }
            }
        }

        @Override
        public List<UsageStats> queryUsageStatsForUser(int userId, int intervalType, long beginTime, long endTime, boolean obfuscateInstantApps) {
            return UsageStatsService.this.queryUsageStats(userId, intervalType, beginTime, endTime, obfuscateInstantApps);
        }

        @Override
        public void setLastJobRunTime(String packageName, int userId, long elapsedRealtime) {
            UsageStatsService.this.mAppStandby.setLastJobRunTime(packageName, userId, elapsedRealtime);
        }

        @Override
        public long getTimeSinceLastJobRun(String packageName, int userId) {
            return UsageStatsService.this.mAppStandby.getTimeSinceLastJobRun(packageName, userId);
        }

        @Override
        public void reportAppJobState(String packageName, int userId, int numDeferredJobs, long timeSinceLastJobRun) {
        }

        @Override
        public void onActiveAdminAdded(String packageName, int userId) {
            UsageStatsService.this.mAppStandby.addActiveDeviceAdmin(packageName, userId);
        }

        @Override
        public void setActiveAdminApps(Set<String> packageNames, int userId) {
            UsageStatsService.this.mAppStandby.setActiveAdminApps(packageNames, userId);
        }

        @Override
        public void onAdminDataAvailable() {
            UsageStatsService.this.mAppStandby.onAdminDataAvailable();
        }

        @Override
        public void reportExemptedSyncScheduled(String packageName, int userId) {
            UsageStatsService.this.mAppStandby.postReportExemptedSyncScheduled(packageName, userId);
        }

        @Override
        public void reportExemptedSyncStart(String packageName, int userId) {
            UsageStatsService.this.mAppStandby.postReportExemptedSyncStart(packageName, userId);
        }
    }

    private final class BinderService
    extends IUsageStatsManager.Stub {
        private BinderService() {
        }

        private boolean hasPermission(String callingPackage) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 1000) {
                return true;
            }
            int mode = UsageStatsService.this.mAppOps.noteOp(43, callingUid, callingPackage);
            if (mode == 3) {
                return UsageStatsService.this.getContext().checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
            }
            return mode == 0;
        }

        private boolean hasObserverPermission(String callingPackage) {
            int callingUid = Binder.getCallingUid();
            DevicePolicyManagerInternal dpmInternal = UsageStatsService.this.getDpmInternal();
            if (callingUid == 1000 || dpmInternal != null && dpmInternal.isActiveAdminWithPolicy(callingUid, -1)) {
                return true;
            }
            return UsageStatsService.this.getContext().checkCallingPermission("android.permission.OBSERVE_APP_USAGE") == 0;
        }

        private void checkCallerIsSystemOrSameApp(String pkg) {
            if (this.isCallingUidSystem()) {
                return;
            }
            this.checkCallerIsSameApp(pkg);
        }

        private void checkCallerIsSameApp(String pkg) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            if (UsageStatsService.this.mPackageManagerInternal.getPackageUid(pkg, 0, callingUserId) != callingUid) {
                throw new SecurityException("Calling uid " + pkg + " cannot query eventsfor package " + pkg);
            }
        }

        private boolean isCallingUidSystem() {
            int uid = Binder.getCallingUid();
            return uid == 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<UsageStats> queryUsageStats(int bucketType, long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            boolean obfuscateInstantApps = UsageStatsService.this.shouldObfuscateInstantAppsForCaller(Binder.getCallingUid(), UserHandle.getCallingUserId());
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<UsageStats> results = UsageStatsService.this.queryUsageStats(userId, bucketType, beginTime, endTime, obfuscateInstantApps);
                if (results != null) {
                    ParceledListSlice<UsageStats> parceledListSlice = new ParceledListSlice<UsageStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<ConfigurationStats> queryConfigurationStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<ConfigurationStats> results = UsageStatsService.this.queryConfigurationStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<ConfigurationStats> parceledListSlice = new ParceledListSlice<ConfigurationStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<EventStats> queryEventStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<EventStats> results = UsageStatsService.this.queryEventStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<EventStats> parceledListSlice = new ParceledListSlice<EventStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEvents(long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            boolean obfuscateInstantApps = UsageStatsService.this.shouldObfuscateInstantAppsForCaller(Binder.getCallingUid(), UserHandle.getCallingUserId());
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEvents(userId, beginTime, endTime, obfuscateInstantApps);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEventsForPackage(long beginTime, long endTime, String callingPackage) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            this.checkCallerIsSameApp(callingPackage);
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEventsForPackage(callingUserId, beginTime, endTime, callingPackage);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEventsForUser(long beginTime, long endTime, int userId, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            if (userId != UserHandle.getCallingUserId()) {
                UsageStatsService.this.getContext().enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "No permission to query usage stats for this user");
            }
            boolean obfuscateInstantApps = UsageStatsService.this.shouldObfuscateInstantAppsForCaller(Binder.getCallingUid(), UserHandle.getCallingUserId());
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEvents(userId, beginTime, endTime, obfuscateInstantApps);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEventsForPackageForUser(long beginTime, long endTime, int userId, String pkg, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            if (userId != UserHandle.getCallingUserId()) {
                UsageStatsService.this.getContext().enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "No permission to query usage stats for this user");
            }
            this.checkCallerIsSystemOrSameApp(pkg);
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEventsForPackage(userId, beginTime, endTime, callingPackage);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAppInactive(String packageName, int userId) {
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, "isAppInactive", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            boolean obfuscateInstantApps = UsageStatsService.this.shouldObfuscateInstantAppsForCaller(Binder.getCallingUid(), userId);
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = UsageStatsService.this.mAppStandby.isAppIdleFilteredOrParoled(packageName, userId, SystemClock.elapsedRealtime(), obfuscateInstantApps);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAppInactive(String packageName, boolean idle, int userId) {
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, true, "setAppInactive", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            UsageStatsService.this.getContext().enforceCallingPermission("android.permission.CHANGE_APP_IDLE_STATE", "No permission to change app idle state");
            long token = Binder.clearCallingIdentity();
            try {
                int appId = UsageStatsService.this.mAppStandby.getAppId(packageName);
                if (appId < 0) {
                    return;
                }
                UsageStatsService.this.mAppStandby.setAppIdleAsync(packageName, idle, userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getAppStandbyBucket(String packageName, String callingPackage, int userId) {
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "getAppStandbyBucket", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            int packageUid = UsageStatsService.this.mPackageManagerInternal.getPackageUid(packageName, 0, userId);
            if (packageUid != callingUid && !this.hasPermission(callingPackage)) {
                throw new SecurityException("Don't have permission to query app standby bucket");
            }
            if (packageUid < 0) {
                throw new IllegalArgumentException("Cannot get standby bucket for non existent package (" + packageName + ")");
            }
            boolean obfuscateInstantApps = UsageStatsService.this.shouldObfuscateInstantAppsForCaller(callingUid, userId);
            long token = Binder.clearCallingIdentity();
            try {
                int n = UsageStatsService.this.mAppStandby.getAppStandbyBucket(packageName, userId, SystemClock.elapsedRealtime(), obfuscateInstantApps);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAppStandbyBucket(String packageName, int bucket, int userId) {
            UsageStatsService.this.getContext().enforceCallingPermission("android.permission.CHANGE_APP_IDLE_STATE", "No permission to change app standby state");
            if (bucket < 10 || bucket > 50) {
                throw new IllegalArgumentException("Cannot set the standby bucket to " + bucket);
            }
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, true, "setAppStandbyBucket", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            boolean shellCaller = callingUid == 0 || callingUid == 2000;
            boolean systemCaller = UserHandle.isCore(callingUid);
            int reason = systemCaller ? 1024 : 1280;
            long token = Binder.clearCallingIdentity();
            try {
                int packageUid = UsageStatsService.this.mPackageManagerInternal.getPackageUid(packageName, 0x400000, userId);
                if (packageUid == callingUid) {
                    throw new IllegalArgumentException("Cannot set your own standby bucket");
                }
                if (packageUid < 0) {
                    throw new IllegalArgumentException("Cannot set standby bucket for non existent package (" + packageName + ")");
                }
                UsageStatsService.this.mAppStandby.setAppStandbyBucket(packageName, userId, bucket, reason, SystemClock.elapsedRealtime(), shellCaller);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<AppStandbyInfo> getAppStandbyBuckets(String callingPackageName, int userId) {
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "getAppStandbyBucket", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            if (!this.hasPermission(callingPackageName)) {
                throw new SecurityException("Don't have permission to query app standby bucket");
            }
            long token = Binder.clearCallingIdentity();
            try {
                List<AppStandbyInfo> standbyBucketList = UsageStatsService.this.mAppStandby.getAppStandbyBuckets(userId);
                ParceledListSlice<AppStandbyInfo> parceledListSlice = standbyBucketList == null ? ParceledListSlice.emptyList() : new ParceledListSlice<AppStandbyInfo>(standbyBucketList);
                return parceledListSlice;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAppStandbyBuckets(ParceledListSlice appBuckets, int userId) {
            UsageStatsService.this.getContext().enforceCallingPermission("android.permission.CHANGE_APP_IDLE_STATE", "No permission to change app standby state");
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, true, "setAppStandbyBucket", null);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            boolean shellCaller = callingUid == 0 || callingUid == 2000;
            int reason = shellCaller ? 1024 : 1280;
            long token = Binder.clearCallingIdentity();
            try {
                long elapsedRealtime = SystemClock.elapsedRealtime();
                List bucketList = appBuckets.getList();
                for (AppStandbyInfo bucketInfo : bucketList) {
                    String packageName = bucketInfo.mPackageName;
                    int bucket = bucketInfo.mStandbyBucket;
                    if (bucket < 10 || bucket > 50) {
                        throw new IllegalArgumentException("Cannot set the standby bucket to " + bucket);
                    }
                    if (UsageStatsService.this.mPackageManagerInternal.getPackageUid(packageName, 0x400000, userId) == callingUid) {
                        throw new IllegalArgumentException("Cannot set your own standby bucket");
                    }
                    UsageStatsService.this.mAppStandby.setAppStandbyBucket(packageName, userId, bucket, reason, elapsedRealtime, shellCaller);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void whitelistAppTemporarily(String packageName, long duration, int userId) throws RemoteException {
            StringBuilder reason = new StringBuilder(32);
            reason.append("from:");
            UserHandle.formatUid(reason, Binder.getCallingUid());
            UsageStatsService.this.mDeviceIdleController.addPowerSaveTempWhitelistApp(packageName, duration, userId, reason.toString());
        }

        @Override
        public void onCarrierPrivilegedAppsChanged() {
            UsageStatsService.this.getContext().enforceCallingOrSelfPermission("android.permission.BIND_CARRIER_SERVICES", "onCarrierPrivilegedAppsChanged can only be called by privileged apps.");
            UsageStatsService.this.mAppStandby.clearCarrierPrivilegedApps();
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(UsageStatsService.this.getContext(), UsageStatsService.TAG, pw)) {
                return;
            }
            UsageStatsService.this.dump(args, pw);
        }

        @Override
        public void reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) {
            if (packageName == null) {
                Slog.w(UsageStatsService.TAG, "Event report user selecting a null package");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = packageName;
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 9;
            event.mAction = action;
            event.mContentType = contentType;
            event.mContentAnnotations = annotations;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerAppUsageObserver(int observerId, String[] packages, long timeLimitMs, PendingIntent callbackIntent, String callingPackage) {
            if (!this.hasObserverPermission(callingPackage)) {
                throw new SecurityException("Caller doesn't have OBSERVE_APP_USAGE permission");
            }
            if (packages == null || packages.length == 0) {
                throw new IllegalArgumentException("Must specify at least one package");
            }
            if (callbackIntent == null) {
                throw new NullPointerException("callbackIntent can't be null");
            }
            int callingUid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(callingUid);
            long token = Binder.clearCallingIdentity();
            try {
                UsageStatsService.this.registerAppUsageObserver(callingUid, observerId, packages, timeLimitMs, callbackIntent, userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterAppUsageObserver(int observerId, String callingPackage) {
            if (!this.hasObserverPermission(callingPackage)) {
                throw new SecurityException("Caller doesn't have OBSERVE_APP_USAGE permission");
            }
            int callingUid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(callingUid);
            long token = Binder.clearCallingIdentity();
            try {
                UsageStatsService.this.unregisterAppUsageObserver(callingUid, observerId, userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    UsageStatsService.this.reportEvent((UsageEvents.Event)msg.obj, msg.arg1);
                    break;
                }
                case 1: {
                    UsageStatsService.this.flushToDisk();
                    break;
                }
                case 2: {
                    UsageStatsService.this.onUserRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    int uid = msg.arg1;
                    int procState = msg.arg2;
                    int newCounter = procState <= 2 ? 0 : 1;
                    SparseIntArray sparseIntArray = UsageStatsService.this.mUidToKernelCounter;
                    synchronized (sparseIntArray) {
                        int oldCounter = UsageStatsService.this.mUidToKernelCounter.get(uid, 0);
                        if (newCounter != oldCounter) {
                            UsageStatsService.this.mUidToKernelCounter.put(uid, newCounter);
                            try {
                                FileUtils.stringToFile(KERNEL_COUNTER_FILE, uid + " " + newCounter);
                            }
                            catch (IOException e) {
                                Slog.w(UsageStatsService.TAG, "Failed to update counter set: " + e);
                            }
                        }
                        break;
                    }
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private class UserActionsReceiver
    extends BroadcastReceiver {
        private UserActionsReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            String action = intent.getAction();
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                if (userId >= 0) {
                    UsageStatsService.this.mHandler.obtainMessage(2, userId, 0).sendToTarget();
                }
            } else if ("android.intent.action.USER_STARTED".equals(action) && userId >= 0) {
                UsageStatsService.this.mAppStandby.postCheckIdleStates(userId);
            }
        }
    }
}

