/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;

class UsbSettingsManager {
    private static final String LOG_TAG = UsbSettingsManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final Context mContext;
    @GuardedBy(value="mSettingsByUser")
    private final SparseArray<UsbUserSettingsManager> mSettingsByUser = new SparseArray();
    @GuardedBy(value="mSettingsByProfileGroup")
    private final SparseArray<UsbProfileGroupSettingsManager> mSettingsByProfileGroup = new SparseArray();
    private UserManager mUserManager;

    public UsbSettingsManager(Context context) {
        this.mContext = context;
        this.mUserManager = (UserManager)context.getSystemService("user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsbUserSettingsManager getSettingsForUser(int userId) {
        SparseArray<UsbUserSettingsManager> sparseArray = this.mSettingsByUser;
        synchronized (sparseArray) {
            UsbUserSettingsManager settings = this.mSettingsByUser.get(userId);
            if (settings == null) {
                settings = new UsbUserSettingsManager(this.mContext, new UserHandle(userId));
                this.mSettingsByUser.put(userId, settings);
            }
            return settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsbProfileGroupSettingsManager getSettingsForProfileGroup(UserHandle user) {
        UserInfo parentUserInfo = this.mUserManager.getProfileParent(user.getIdentifier());
        UserHandle parentUser = parentUserInfo != null ? parentUserInfo.getUserHandle() : user;
        SparseArray<UsbProfileGroupSettingsManager> sparseArray = this.mSettingsByProfileGroup;
        synchronized (sparseArray) {
            UsbProfileGroupSettingsManager settings = this.mSettingsByProfileGroup.get(parentUser.getIdentifier());
            if (settings == null) {
                settings = new UsbProfileGroupSettingsManager(this.mContext, parentUser, this);
                this.mSettingsByProfileGroup.put(parentUser.getIdentifier(), settings);
            }
            return settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(UserHandle userToRemove) {
        SparseArray<Object> sparseArray = this.mSettingsByUser;
        synchronized (sparseArray) {
            this.mSettingsByUser.remove(userToRemove.getIdentifier());
        }
        sparseArray = this.mSettingsByProfileGroup;
        synchronized (sparseArray) {
            if (this.mSettingsByProfileGroup.indexOfKey(userToRemove.getIdentifier()) >= 0) {
                this.mSettingsByProfileGroup.remove(userToRemove.getIdentifier());
            } else {
                int numProfileGroups = this.mSettingsByProfileGroup.size();
                for (int i = 0; i < numProfileGroups; ++i) {
                    this.mSettingsByProfileGroup.valueAt(i).removeAllDefaultsForUser(userToRemove);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(DualDumpOutputStream dump, String idName, long id2) {
        int i;
        long token = dump.start(idName, id2);
        SparseArray<Object> sparseArray = this.mSettingsByUser;
        synchronized (sparseArray) {
            int numUsers = this.mSettingsByUser.size();
            for (i = 0; i < numUsers; ++i) {
                this.mSettingsByUser.valueAt(i).dump(dump, "user_settings", 2246267895809L);
            }
        }
        sparseArray = this.mSettingsByProfileGroup;
        synchronized (sparseArray) {
            int numProfileGroups = this.mSettingsByProfileGroup.size();
            for (i = 0; i < numProfileGroups; ++i) {
                this.mSettingsByProfileGroup.valueAt(i).dump(dump, "profile_group_settings", 0x20B00000002L);
            }
        }
        dump.end(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usbDeviceRemoved(UsbDevice device) {
        SparseArray<UsbUserSettingsManager> sparseArray = this.mSettingsByUser;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSettingsByUser.size(); ++i) {
                this.mSettingsByUser.valueAt(i).removeDevicePermissions(device);
            }
        }
        Intent intent = new Intent("android.hardware.usb.action.USB_DEVICE_DETACHED");
        intent.addFlags(0x1000000);
        intent.putExtra("device", device);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usbAccessoryRemoved(UsbAccessory accessory) {
        SparseArray<UsbUserSettingsManager> sparseArray = this.mSettingsByUser;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSettingsByUser.size(); ++i) {
                this.mSettingsByUser.valueAt(i).removeAccessoryPermissions(accessory);
            }
        }
        Intent intent = new Intent("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        intent.addFlags(0x1000000);
        intent.putExtra("accessory", accessory);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }
}

