/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACTerminal;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class Usb20ACInputTerminal
extends UsbACTerminal {
    private static final String TAG = "Usb20ACInputTerminal";
    private byte mClkSourceID;
    private byte mNumChannels;
    private int mChanConfig;
    private byte mChanNames;
    private int mControls;
    private byte mTerminalName;

    public Usb20ACInputTerminal(int length, byte type, byte subtype, int subclass) {
        super(length, type, subtype, subclass);
    }

    public byte getClkSourceID() {
        return this.mClkSourceID;
    }

    public byte getNumChannels() {
        return this.mNumChannels;
    }

    public int getChanConfig() {
        return this.mChanConfig;
    }

    public int getControls() {
        return this.mControls;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        super.parseRawDescriptors(stream);
        this.mClkSourceID = stream.getByte();
        this.mNumChannels = stream.getByte();
        this.mChanConfig = stream.unpackUsbInt();
        this.mChanNames = stream.getByte();
        this.mControls = stream.unpackUsbShort();
        this.mTerminalName = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Clock Source: " + this.getClkSourceID());
        canvas.writeListItem("" + this.getNumChannels() + " Channels. Config: " + ReportCanvas.getHexString(this.getChanConfig()));
        canvas.closeList();
    }
}

