/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.os.Parcelable;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.UsbEndpointDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.report.UsbStrings;
import java.util.ArrayList;

public class UsbInterfaceDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbInterfaceDescriptor";
    private static final boolean DEBUG = false;
    protected int mInterfaceNumber;
    protected byte mAlternateSetting;
    protected byte mNumEndpoints;
    protected int mUsbClass;
    protected int mUsbSubclass;
    protected int mProtocol;
    protected byte mDescrIndex;
    private ArrayList<UsbEndpointDescriptor> mEndpointDescriptors = new ArrayList();

    UsbInterfaceDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 3;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mInterfaceNumber = stream.getUnsignedByte();
        this.mAlternateSetting = stream.getByte();
        this.mNumEndpoints = stream.getByte();
        this.mUsbClass = stream.getUnsignedByte();
        this.mUsbSubclass = stream.getUnsignedByte();
        this.mProtocol = stream.getUnsignedByte();
        this.mDescrIndex = stream.getByte();
        return this.mLength;
    }

    public int getInterfaceNumber() {
        return this.mInterfaceNumber;
    }

    public byte getAlternateSetting() {
        return this.mAlternateSetting;
    }

    public byte getNumEndpoints() {
        return this.mNumEndpoints;
    }

    public int getUsbClass() {
        return this.mUsbClass;
    }

    public int getUsbSubclass() {
        return this.mUsbSubclass;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public byte getDescrIndex() {
        return this.mDescrIndex;
    }

    void addEndpointDescriptor(UsbEndpointDescriptor endpoint) {
        this.mEndpointDescriptors.add(endpoint);
    }

    UsbInterface toAndroid(UsbDescriptorParser parser) {
        String name = parser.getDescriptorString(this.mDescrIndex);
        UsbInterface ntrface = new UsbInterface(this.mInterfaceNumber, this.mAlternateSetting, name, this.mUsbClass, this.mUsbSubclass, this.mProtocol);
        Parcelable[] endpoints = new UsbEndpoint[this.mEndpointDescriptors.size()];
        for (int index = 0; index < this.mEndpointDescriptors.size(); ++index) {
            endpoints[index] = this.mEndpointDescriptors.get(index).toAndroid(parser);
        }
        ntrface.setEndpoints(endpoints);
        return ntrface;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        int usbClass = this.getUsbClass();
        int usbSubclass = this.getUsbSubclass();
        int protocol = this.getProtocol();
        String className = UsbStrings.getClassName(usbClass);
        String subclassName = "";
        if (usbClass == 1) {
            subclassName = UsbStrings.getAudioSubclassName(usbSubclass);
        }
        canvas.openList();
        canvas.writeListItem("Interface #" + this.getInterfaceNumber());
        canvas.writeListItem("Class: " + ReportCanvas.getHexString(usbClass) + ": " + className);
        canvas.writeListItem("Subclass: " + ReportCanvas.getHexString(usbSubclass) + ": " + subclassName);
        canvas.writeListItem("Protocol: " + protocol + ": " + ReportCanvas.getHexString(protocol));
        canvas.writeListItem("Endpoints: " + this.getNumEndpoints());
        canvas.closeList();
    }
}

