/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.app.ActivityManagerInternal;
import android.app.Vr2dDisplayProperties;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.ImageReader;
import android.os.Handler;
import android.os.RemoteException;
import android.service.vr.IPersistentVrStateCallbacks;
import android.service.vr.IVrManager;
import android.util.Log;
import android.view.Surface;
import com.android.server.wm.WindowManagerInternal;

class Vr2dDisplay {
    private static final String TAG = "Vr2dDisplay";
    private static final boolean DEBUG = false;
    private int mVirtualDisplayHeight;
    private int mVirtualDisplayWidth;
    private int mVirtualDisplayDpi;
    private static final int STOP_VIRTUAL_DISPLAY_DELAY_MILLIS = 2000;
    private static final String UNIQUE_DISPLAY_ID = "277f1a09-b88d-4d1e-8716-796f114d080b";
    private static final String DISPLAY_NAME = "VR 2D Display";
    private static final String DEBUG_ACTION_SET_MODE = "com.android.server.vr.Vr2dDisplay.SET_MODE";
    private static final String DEBUG_EXTRA_MODE_ON = "com.android.server.vr.Vr2dDisplay.EXTRA_MODE_ON";
    private static final String DEBUG_ACTION_SET_SURFACE = "com.android.server.vr.Vr2dDisplay.SET_SURFACE";
    private static final String DEBUG_EXTRA_SURFACE = "com.android.server.vr.Vr2dDisplay.EXTRA_SURFACE";
    public static final int DEFAULT_VIRTUAL_DISPLAY_WIDTH = 1400;
    public static final int DEFAULT_VIRTUAL_DISPLAY_HEIGHT = 1800;
    public static final int DEFAULT_VIRTUAL_DISPLAY_DPI = 320;
    public static final int MIN_VR_DISPLAY_WIDTH = 1;
    public static final int MIN_VR_DISPLAY_HEIGHT = 1;
    public static final int MIN_VR_DISPLAY_DPI = 1;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final WindowManagerInternal mWindowManagerInternal;
    private final DisplayManager mDisplayManager;
    private final IVrManager mVrManager;
    private final Object mVdLock = new Object();
    private final Handler mHandler = new Handler();
    private final IPersistentVrStateCallbacks mVrStateCallbacks = new IPersistentVrStateCallbacks.Stub(){

        @Override
        public void onPersistentVrStateChanged(boolean enabled) {
            if (enabled != Vr2dDisplay.this.mIsPersistentVrModeEnabled) {
                Vr2dDisplay.this.mIsPersistentVrModeEnabled = enabled;
                Vr2dDisplay.this.updateVirtualDisplay();
            }
        }
    };
    private VirtualDisplay mVirtualDisplay;
    private Surface mSurface;
    private ImageReader mImageReader;
    private Runnable mStopVDRunnable;
    private boolean mIsVrModeOverrideEnabled;
    private boolean mIsVirtualDisplayAllowed = true;
    private boolean mIsPersistentVrModeEnabled;
    private boolean mBootsToVr = false;

    public Vr2dDisplay(DisplayManager displayManager, ActivityManagerInternal activityManagerInternal, WindowManagerInternal windowManagerInternal, IVrManager vrManager) {
        this.mDisplayManager = displayManager;
        this.mActivityManagerInternal = activityManagerInternal;
        this.mWindowManagerInternal = windowManagerInternal;
        this.mVrManager = vrManager;
        this.mVirtualDisplayWidth = 1400;
        this.mVirtualDisplayHeight = 1800;
        this.mVirtualDisplayDpi = 320;
    }

    public void init(Context context, boolean bootsToVr) {
        this.startVrModeListener();
        this.startDebugOnlyBroadcastReceiver(context);
        this.mBootsToVr = bootsToVr;
        if (this.mBootsToVr) {
            this.updateVirtualDisplay();
        }
    }

    private void updateVirtualDisplay() {
        if (this.shouldRunVirtualDisplay()) {
            Log.i(TAG, "Attempting to start virtual display");
            this.startVirtualDisplay();
        } else {
            this.stopVirtualDisplay();
        }
    }

    private void startDebugOnlyBroadcastReceiver(Context context) {
    }

    private void startVrModeListener() {
        if (this.mVrManager != null) {
            try {
                this.mVrManager.registerPersistentVrStateListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Could not register VR State listener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualDisplayProperties(Vr2dDisplayProperties displayProperties) {
        Object object = this.mVdLock;
        synchronized (object) {
            int width = displayProperties.getWidth();
            int height = displayProperties.getHeight();
            int dpi = displayProperties.getDpi();
            boolean resized = false;
            if (width < 1 || height < 1 || dpi < 1) {
                Log.i(TAG, "Ignoring Width/Height/Dpi values of " + width + "," + height + "," + dpi);
            } else {
                Log.i(TAG, "Setting width/height/dpi to " + width + "," + height + "," + dpi);
                this.mVirtualDisplayWidth = width;
                this.mVirtualDisplayHeight = height;
                this.mVirtualDisplayDpi = dpi;
                resized = true;
            }
            if ((displayProperties.getFlags() & 1) == 1) {
                this.mIsVirtualDisplayAllowed = true;
            } else if ((displayProperties.getRemovedFlags() & 1) == 1) {
                this.mIsVirtualDisplayAllowed = false;
            }
            if (this.mVirtualDisplay != null && resized && this.mIsVirtualDisplayAllowed) {
                this.mVirtualDisplay.resize(this.mVirtualDisplayWidth, this.mVirtualDisplayHeight, this.mVirtualDisplayDpi);
                ImageReader oldImageReader = this.mImageReader;
                this.mImageReader = null;
                this.startImageReader();
                oldImageReader.close();
            }
            this.updateVirtualDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVirtualDisplayId() {
        Object object = this.mVdLock;
        synchronized (object) {
            if (this.mVirtualDisplay != null) {
                int virtualDisplayId = this.mVirtualDisplay.getDisplay().getDisplayId();
                return virtualDisplayId;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startVirtualDisplay() {
        if (this.mDisplayManager == null) {
            Log.w(TAG, "Cannot create virtual display because mDisplayManager == null");
            return;
        }
        Object object = this.mVdLock;
        synchronized (object) {
            if (this.mVirtualDisplay != null) {
                Log.i(TAG, "VD already exists, ignoring request");
                return;
            }
            int flags = 64;
            flags |= 0x80;
            flags |= 1;
            flags |= 8;
            this.mVirtualDisplay = this.mDisplayManager.createVirtualDisplay(null, DISPLAY_NAME, this.mVirtualDisplayWidth, this.mVirtualDisplayHeight, this.mVirtualDisplayDpi, null, flags |= 0x100, null, null, UNIQUE_DISPLAY_ID);
            if (this.mVirtualDisplay == null) {
                Log.w(TAG, "Virtual display id is null after createVirtualDisplay");
                this.updateDisplayId(-1);
                return;
            }
            this.updateDisplayId(this.mVirtualDisplay.getDisplay().getDisplayId());
            this.startImageReader();
        }
        Log.i(TAG, "VD created: " + this.mVirtualDisplay);
    }

    private void updateDisplayId(int displayId) {
        this.mActivityManagerInternal.setVr2dDisplayId(displayId);
        this.mWindowManagerInternal.setVr2dDisplayId(displayId);
    }

    private void stopVirtualDisplay() {
        if (this.mStopVDRunnable == null) {
            this.mStopVDRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Vr2dDisplay.this.shouldRunVirtualDisplay()) {
                        Log.i(Vr2dDisplay.TAG, "Virtual Display destruction stopped: VrMode is back on.");
                    } else {
                        Log.i(Vr2dDisplay.TAG, "Stopping Virtual Display");
                        Object object = Vr2dDisplay.this.mVdLock;
                        synchronized (object) {
                            Vr2dDisplay.this.updateDisplayId(-1);
                            Vr2dDisplay.this.setSurfaceLocked(null);
                            if (Vr2dDisplay.this.mVirtualDisplay != null) {
                                Vr2dDisplay.this.mVirtualDisplay.release();
                                Vr2dDisplay.this.mVirtualDisplay = null;
                            }
                            Vr2dDisplay.this.stopImageReader();
                        }
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mStopVDRunnable);
        this.mHandler.postDelayed(this.mStopVDRunnable, 2000L);
    }

    private void setSurfaceLocked(Surface surface) {
        if (this.mSurface != surface && (surface == null || surface.isValid())) {
            Log.i(TAG, "Setting the new surface from " + this.mSurface + " to " + surface);
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.setSurface(surface);
            }
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startImageReader() {
        if (this.mImageReader == null) {
            this.mImageReader = ImageReader.newInstance(this.mVirtualDisplayWidth, this.mVirtualDisplayHeight, 1, 2);
            Log.i(TAG, "VD startImageReader: res = " + this.mVirtualDisplayWidth + "X" + this.mVirtualDisplayHeight + ", dpi = " + this.mVirtualDisplayDpi);
        }
        Object object = this.mVdLock;
        synchronized (object) {
            this.setSurfaceLocked(this.mImageReader.getSurface());
        }
    }

    private void stopImageReader() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
    }

    private boolean shouldRunVirtualDisplay() {
        return this.mIsVirtualDisplayAllowed && (this.mBootsToVr || this.mIsPersistentVrModeEnabled || this.mIsVrModeOverrideEnabled);
    }
}

