/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.INotificationManager;
import android.app.NotificationManager;
import android.app.Vr2dDisplayProperties;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.vr.IPersistentVrStateCallbacks;
import android.service.vr.IVrListener;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.util.DumpUtils;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.utils.ManagedApplicationService;
import com.android.server.vr.EnabledComponentsObserver;
import com.android.server.vr.Vr2dDisplay;
import com.android.server.vr.VrManagerInternal;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class VrManagerService
extends SystemService
implements EnabledComponentsObserver.EnabledComponentChangeListener,
ActivityManagerInternal.ScreenObserver {
    public static final String TAG = "VrManagerService";
    static final boolean DBG = false;
    private static final int PENDING_STATE_DELAY_MS = 300;
    private static final int EVENT_LOG_SIZE = 64;
    private static final int INVALID_APPOPS_MODE = -1;
    private static final int FLAG_NONE = 0;
    private static final int FLAG_AWAKE = 1;
    private static final int FLAG_SCREEN_ON = 2;
    private static final int FLAG_KEYGUARD_UNLOCKED = 4;
    private static final int FLAG_ALL = 7;
    private final Object mLock = new Object();
    private final IBinder mOverlayToken = new Binder();
    private boolean mVrModeAllowed;
    private boolean mVrModeEnabled;
    private boolean mPersistentVrModeEnabled;
    private boolean mRunning2dInVr;
    private int mVrAppProcessId;
    private EnabledComponentsObserver mComponentObserver;
    private ManagedApplicationService mCurrentVrService;
    private ManagedApplicationService mCurrentVrCompositorService;
    private ComponentName mDefaultVrService;
    private Context mContext;
    private ComponentName mCurrentVrModeComponent;
    private int mCurrentVrModeUser;
    private boolean mWasDefaultGranted;
    private boolean mGuard;
    private final RemoteCallbackList<IVrStateCallbacks> mVrStateRemoteCallbacks = new RemoteCallbackList();
    private final RemoteCallbackList<IPersistentVrStateCallbacks> mPersistentVrStateRemoteCallbacks = new RemoteCallbackList();
    private int mPreviousCoarseLocationMode = -1;
    private int mPreviousManageOverlayMode = -1;
    private VrState mPendingState;
    private boolean mLogLimitHit;
    private final ArrayDeque<ManagedApplicationService.LogFormattable> mLoggingDeque = new ArrayDeque(64);
    private final NotificationAccessManager mNotifAccessManager = new NotificationAccessManager();
    private INotificationManager mNotificationManager;
    private int mSystemSleepFlags = 5;
    private boolean mUserUnlocked;
    private Vr2dDisplay mVr2dDisplay;
    private boolean mBootsToVr;
    private boolean mStandby;
    private boolean mUseStandbyToExitVrMode;
    private final ManagedApplicationService.EventCallback mEventCallback = new ManagedApplicationService.EventCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceEvent(ManagedApplicationService.LogEvent event) {
            VrManagerService.this.logEvent(event);
            ComponentName component = null;
            Object object = VrManagerService.this.mLock;
            synchronized (object) {
                ComponentName componentName = component = VrManagerService.this.mCurrentVrService == null ? null : VrManagerService.this.mCurrentVrService.getComponent();
                if (component != null && component.equals(event.component) && (event.event == 2 || event.event == 3)) {
                    VrManagerService.this.callFocusedActivityChangedLocked();
                }
            }
            if (!VrManagerService.this.mBootsToVr && event.event == 4 && (component == null || component.equals(event.component))) {
                Slog.e(VrManagerService.TAG, "VrListenerSevice has died permanently, leaving system VR mode.");
                VrManagerService.this.setPersistentVrModeEnabled(false);
            }
        }
    };
    private static final int MSG_VR_STATE_CHANGE = 0;
    private static final int MSG_PENDING_VR_STATE_CHANGE = 1;
    private static final int MSG_PERSISTENT_VR_MODE_STATE_CHANGE = 2;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    boolean state = msg.arg1 == 1;
                    int i = VrManagerService.this.mVrStateRemoteCallbacks.beginBroadcast();
                    while (i > 0) {
                        --i;
                        try {
                            ((IVrStateCallbacks)VrManagerService.this.mVrStateRemoteCallbacks.getBroadcastItem(i)).onVrStateChanged(state);
                        }
                        catch (RemoteException remoteException) {}
                    }
                    VrManagerService.this.mVrStateRemoteCallbacks.finishBroadcast();
                    break;
                }
                case 1: {
                    Object state = VrManagerService.this.mLock;
                    synchronized (state) {
                        if (VrManagerService.this.mVrModeAllowed) {
                            VrManagerService.this.consumeAndApplyPendingStateLocked();
                        }
                        break;
                    }
                }
                case 2: {
                    boolean state = msg.arg1 == 1;
                    int i = VrManagerService.this.mPersistentVrStateRemoteCallbacks.beginBroadcast();
                    while (i > 0) {
                        --i;
                        try {
                            ((IPersistentVrStateCallbacks)VrManagerService.this.mPersistentVrStateRemoteCallbacks.getBroadcastItem(i)).onPersistentVrStateChanged(state);
                        }
                        catch (RemoteException remoteException) {}
                    }
                    VrManagerService.this.mPersistentVrStateRemoteCallbacks.finishBroadcast();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown message type: " + msg.what);
                }
            }
        }
    };
    private static final ManagedApplicationService.BinderChecker sBinderChecker = new ManagedApplicationService.BinderChecker(){

        @Override
        public IInterface asInterface(IBinder binder) {
            return IVrListener.Stub.asInterface(binder);
        }

        @Override
        public boolean checkType(IInterface service) {
            return service instanceof IVrListener;
        }
    };
    private final IVrManager mVrManager = new IVrManager.Stub(){

        @Override
        public void registerListener(IVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.addStateCallback(cb);
        }

        @Override
        public void unregisterListener(IVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.removeStateCallback(cb);
        }

        @Override
        public void registerPersistentVrStateListener(IPersistentVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.addPersistentStateCallback(cb);
        }

        @Override
        public void unregisterPersistentVrStateListener(IPersistentVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.removePersistentStateCallback(cb);
        }

        @Override
        public boolean getVrModeState() {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            return VrManagerService.this.getVrMode();
        }

        @Override
        public boolean getPersistentVrModeEnabled() {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER", "android.permission.ACCESS_VR_STATE"});
            return VrManagerService.this.getPersistentVrMode();
        }

        @Override
        public void setPersistentVrModeEnabled(boolean enabled) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.RESTRICTED_VR_ACCESS"});
            VrManagerService.this.setPersistentVrModeEnabled(enabled);
        }

        @Override
        public void setVr2dDisplayProperties(Vr2dDisplayProperties vr2dDisplayProp) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.RESTRICTED_VR_ACCESS"});
            VrManagerService.this.setVr2dDisplayProperties(vr2dDisplayProp);
        }

        @Override
        public int getVr2dDisplayId() {
            return VrManagerService.this.getVr2dDisplayId();
        }

        @Override
        public void setAndBindCompositor(String componentName) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.RESTRICTED_VR_ACCESS"});
            VrManagerService.this.setAndBindCompositor(componentName == null ? null : ComponentName.unflattenFromString(componentName));
        }

        @Override
        public void setStandbyEnabled(boolean standby) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.ACCESS_VR_MANAGER"});
            VrManagerService.this.setStandbyEnabled(standby);
        }

        @Override
        public void setVrInputMethod(ComponentName componentName) {
            VrManagerService.this.enforceCallerPermissionAnyOf(new String[]{"android.permission.RESTRICTED_VR_ACCESS"});
            InputMethodManagerInternal imm = LocalServices.getService(InputMethodManagerInternal.class);
            imm.startVrInputMethodNoCheck(componentName);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(VrManagerService.this.mContext, VrManagerService.TAG, pw)) {
                return;
            }
            pw.println("********* Dump of VrManagerService *********");
            pw.println("VR mode is currently: " + (VrManagerService.this.mVrModeAllowed ? "allowed" : "disallowed"));
            pw.println("Persistent VR mode is currently: " + (VrManagerService.this.mPersistentVrModeEnabled ? "enabled" : "disabled"));
            pw.println("Currently bound VR listener service: " + (VrManagerService.this.mCurrentVrService == null ? "None" : VrManagerService.this.mCurrentVrService.getComponent().flattenToString()));
            pw.println("Currently bound VR compositor service: " + (VrManagerService.this.mCurrentVrCompositorService == null ? "None" : VrManagerService.this.mCurrentVrCompositorService.getComponent().flattenToString()));
            pw.println("Previous state transitions:\n");
            String tab = "  ";
            VrManagerService.this.dumpStateTransitions(pw);
            pw.println("\n\nRemote Callbacks:");
            int i = VrManagerService.this.mVrStateRemoteCallbacks.beginBroadcast();
            while (i-- > 0) {
                pw.print(tab);
                pw.print(VrManagerService.this.mVrStateRemoteCallbacks.getBroadcastItem(i));
                if (i <= 0) continue;
                pw.println(",");
            }
            VrManagerService.this.mVrStateRemoteCallbacks.finishBroadcast();
            pw.println("\n\nPersistent Vr State Remote Callbacks:");
            i = VrManagerService.this.mPersistentVrStateRemoteCallbacks.beginBroadcast();
            while (i-- > 0) {
                pw.print(tab);
                pw.print(VrManagerService.this.mPersistentVrStateRemoteCallbacks.getBroadcastItem(i));
                if (i <= 0) continue;
                pw.println(",");
            }
            VrManagerService.this.mPersistentVrStateRemoteCallbacks.finishBroadcast();
            pw.println("\n");
            pw.println("Installed VrListenerService components:");
            int userId = VrManagerService.this.mCurrentVrModeUser;
            ArraySet<ComponentName> installed = VrManagerService.this.mComponentObserver.getInstalled(userId);
            if (installed == null || installed.size() == 0) {
                pw.println("None");
            } else {
                for (ComponentName n : installed) {
                    pw.print(tab);
                    pw.println(n.flattenToString());
                }
            }
            pw.println("Enabled VrListenerService components:");
            ArraySet<ComponentName> enabled = VrManagerService.this.mComponentObserver.getEnabled(userId);
            if (enabled == null || enabled.size() == 0) {
                pw.println("None");
            } else {
                for (ComponentName n : enabled) {
                    pw.print(tab);
                    pw.println(n.flattenToString());
                }
            }
            pw.println("\n");
            pw.println("********* End of VrManagerService Dump *********");
        }
    };

    private static native void initializeNative();

    private static native void setVrModeNative(boolean var0);

    private void updateVrModeAllowedLocked() {
        boolean allowed;
        boolean ignoreSleepFlags = this.mBootsToVr && this.mUseStandbyToExitVrMode;
        boolean disallowedByStandby = this.mStandby && this.mUseStandbyToExitVrMode;
        boolean bl = allowed = (this.mSystemSleepFlags == 7 || ignoreSleepFlags) && this.mUserUnlocked && !disallowedByStandby;
        if (this.mVrModeAllowed != allowed) {
            this.mVrModeAllowed = allowed;
            if (this.mVrModeAllowed) {
                if (this.mBootsToVr) {
                    this.setPersistentVrModeEnabled(true);
                }
                if (this.mBootsToVr && !this.mVrModeEnabled) {
                    this.setVrMode(true, this.mDefaultVrService, 0, -1, null);
                }
            } else {
                this.setPersistentModeAndNotifyListenersLocked(false);
                this.mPendingState = this.mVrModeEnabled && this.mCurrentVrService != null ? new VrState(this.mVrModeEnabled, this.mRunning2dInVr, this.mCurrentVrService.getComponent(), this.mCurrentVrService.getUserId(), this.mVrAppProcessId, this.mCurrentVrModeComponent) : null;
                this.updateCurrentVrServiceLocked(false, false, null, 0, -1, null);
            }
        }
    }

    private void setScreenOn(boolean isScreenOn) {
        this.setSystemState(2, isScreenOn);
    }

    @Override
    public void onAwakeStateChanged(boolean isAwake) {
        this.setSystemState(1, isAwake);
    }

    @Override
    public void onKeyguardStateChanged(boolean isShowing) {
        this.setSystemState(4, !isShowing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemState(int flags, boolean isOn) {
        Object object = this.mLock;
        synchronized (object) {
            int oldState = this.mSystemSleepFlags;
            this.mSystemSleepFlags = isOn ? (this.mSystemSleepFlags |= flags) : (this.mSystemSleepFlags &= ~flags);
            if (oldState != this.mSystemSleepFlags) {
                this.updateVrModeAllowedLocked();
            }
        }
    }

    private String getStateAsString() {
        return ((this.mSystemSleepFlags & 1) != 0 ? "awake, " : "") + ((this.mSystemSleepFlags & 2) != 0 ? "screen_on, " : "") + ((this.mSystemSleepFlags & 4) != 0 ? "keyguard_off" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserUnlocked() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserUnlocked = true;
            this.updateVrModeAllowedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStandbyEnabled(boolean standby) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mBootsToVr) {
                Slog.e(TAG, "Attempting to set standby mode on a non-standalone device");
                return;
            }
            this.mStandby = standby;
            this.updateVrModeAllowedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEnabledComponentChanged() {
        Object object = this.mLock;
        synchronized (object) {
            int currentUser = ActivityManager.getCurrentUser();
            ArraySet<ComponentName> enabledListeners = this.mComponentObserver.getEnabled(currentUser);
            ArraySet<String> enabledPackages = new ArraySet<String>();
            for (ComponentName n : enabledListeners) {
                String pkg = n.getPackageName();
                if (!this.isDefaultAllowed(pkg)) continue;
                enabledPackages.add(n.getPackageName());
            }
            this.mNotifAccessManager.update(enabledPackages);
            if (!this.mVrModeAllowed) {
                return;
            }
            this.consumeAndApplyPendingStateLocked(false);
            if (this.mCurrentVrService == null) {
                return;
            }
            this.updateCurrentVrServiceLocked(this.mVrModeEnabled, this.mRunning2dInVr, this.mCurrentVrService.getComponent(), this.mCurrentVrService.getUserId(), this.mVrAppProcessId, this.mCurrentVrModeComponent);
        }
    }

    private void enforceCallerPermissionAnyOf(String ... permissions) {
        for (String permission2 : permissions) {
            if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) continue;
            return;
        }
        throw new SecurityException("Caller does not hold at least one of the permissions: " + Arrays.toString(permissions));
    }

    public VrManagerService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        Object object = this.mLock;
        synchronized (object) {
            VrManagerService.initializeNative();
            this.mContext = this.getContext();
        }
        this.mBootsToVr = SystemProperties.getBoolean("ro.boot.vr", false);
        this.mUseStandbyToExitVrMode = this.mBootsToVr && SystemProperties.getBoolean("persist.vr.use_standby_to_exit_vr_mode", true);
        this.publishLocalService(VrManagerInternal.class, new LocalService());
        this.publishBinderService("vrmanager", this.mVrManager.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            LocalServices.getService(ActivityManagerInternal.class).registerScreenObserver(this);
            this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
            Object object = this.mLock;
            synchronized (object) {
                Looper looper = Looper.getMainLooper();
                Handler handler = new Handler(looper);
                ArrayList<EnabledComponentsObserver.EnabledComponentChangeListener> listeners = new ArrayList<EnabledComponentsObserver.EnabledComponentChangeListener>();
                listeners.add(this);
                this.mComponentObserver = EnabledComponentsObserver.build(this.mContext, handler, "enabled_vr_listeners", looper, "android.permission.BIND_VR_LISTENER_SERVICE", "android.service.vr.VrListenerService", this.mLock, listeners);
                this.mComponentObserver.rebuildAll();
            }
            ArraySet<ComponentName> defaultVrComponents = SystemConfig.getInstance().getDefaultVrComponents();
            if (defaultVrComponents.size() > 0) {
                this.mDefaultVrService = defaultVrComponents.valueAt(0);
            } else {
                Slog.i(TAG, "No default vr listener service found.");
            }
            DisplayManager dm = (DisplayManager)this.getContext().getSystemService("display");
            this.mVr2dDisplay = new Vr2dDisplay(dm, LocalServices.getService(ActivityManagerInternal.class), LocalServices.getService(WindowManagerInternal.class), this.mVrManager);
            this.mVr2dDisplay.init(this.getContext(), this.mBootsToVr);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.USER_UNLOCKED");
            this.getContext().registerReceiver(new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                        VrManagerService.this.setUserUnlocked();
                    }
                }
            }, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        FgThread.getHandler().post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                this.mComponentObserver.onUsersChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    private void updateOverlayStateLocked(String exemptedPackage, int newUserId, int oldUserId) {
        String[] stringArray;
        AppOpsManager appOpsManager = this.getContext().getSystemService(AppOpsManager.class);
        if (oldUserId != newUserId) {
            appOpsManager.setUserRestrictionForUser(24, false, this.mOverlayToken, null, oldUserId);
        }
        if (exemptedPackage == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = exemptedPackage;
        }
        String[] exemptions = stringArray;
        appOpsManager.setUserRestrictionForUser(24, this.mVrModeEnabled, this.mOverlayToken, exemptions, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDependentAppOpsLocked(String newVrServicePackage, int newUserId, String oldVrServicePackage, int oldUserId) {
        if (Objects.equals(newVrServicePackage, oldVrServicePackage)) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.updateOverlayStateLocked(newVrServicePackage, newUserId, oldUserId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCurrentVrServiceLocked(boolean enabled, boolean running2dInVr, ComponentName component, int userId, int processId, ComponentName calling) {
        boolean sendUpdatedCaller = false;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean goingIntoVrMode;
            boolean validUserComponent = this.mComponentObserver.isValid(component, userId) == 0;
            boolean bl = goingIntoVrMode = validUserComponent && enabled;
            if (!this.mVrModeEnabled && !goingIntoVrMode) {
                boolean bl2 = validUserComponent;
                return bl2;
            }
            String oldVrServicePackage = this.mCurrentVrService != null ? this.mCurrentVrService.getComponent().getPackageName() : null;
            int oldUserId = this.mCurrentVrModeUser;
            this.changeVrModeLocked(goingIntoVrMode);
            boolean nothingChanged = false;
            if (!goingIntoVrMode) {
                if (this.mCurrentVrService != null) {
                    Slog.i(TAG, "Leaving VR mode, disconnecting " + this.mCurrentVrService.getComponent() + " for user " + this.mCurrentVrService.getUserId());
                    this.mCurrentVrService.disconnect();
                    this.updateCompositorServiceLocked(-10000, null);
                    this.mCurrentVrService = null;
                } else {
                    nothingChanged = true;
                }
            } else if (this.mCurrentVrService != null) {
                if (this.mCurrentVrService.disconnectIfNotMatching(component, userId)) {
                    Slog.i(TAG, "VR mode component changed to " + component + ", disconnecting " + this.mCurrentVrService.getComponent() + " for user " + this.mCurrentVrService.getUserId());
                    this.updateCompositorServiceLocked(-10000, null);
                    this.createAndConnectService(component, userId);
                    sendUpdatedCaller = true;
                } else {
                    nothingChanged = true;
                }
            } else {
                this.createAndConnectService(component, userId);
                sendUpdatedCaller = true;
            }
            if ((calling != null || this.mPersistentVrModeEnabled) && !Objects.equals(calling, this.mCurrentVrModeComponent) || this.mRunning2dInVr != running2dInVr) {
                sendUpdatedCaller = true;
            }
            this.mCurrentVrModeComponent = calling;
            this.mRunning2dInVr = running2dInVr;
            this.mVrAppProcessId = processId;
            if (this.mCurrentVrModeUser != userId) {
                this.mCurrentVrModeUser = userId;
                sendUpdatedCaller = true;
            }
            String newVrServicePackage = this.mCurrentVrService != null ? this.mCurrentVrService.getComponent().getPackageName() : null;
            int newUserId = this.mCurrentVrModeUser;
            this.updateDependentAppOpsLocked(newVrServicePackage, newUserId, oldVrServicePackage, oldUserId);
            if (this.mCurrentVrService != null && sendUpdatedCaller) {
                this.callFocusedActivityChangedLocked();
            }
            if (!nothingChanged) {
                this.logStateLocked();
            }
            boolean bl3 = validUserComponent;
            return bl3;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void callFocusedActivityChangedLocked() {
        final ComponentName c = this.mCurrentVrModeComponent;
        final boolean b = this.mRunning2dInVr;
        final int pid = this.mVrAppProcessId;
        this.mCurrentVrService.sendEvent(new ManagedApplicationService.PendingEvent(){

            @Override
            public void runEvent(IInterface service) throws RemoteException {
                IVrListener l = (IVrListener)service;
                l.focusedActivityChanged(c, b, pid);
            }
        });
    }

    private boolean isDefaultAllowed(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo info = null;
        try {
            info = pm.getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info != null && (info.isSystemApp() || info.isUpdatedSystemApp());
    }

    private void grantNotificationPolicyAccess(String pkg) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        nm.setNotificationPolicyAccessGranted(pkg, true);
    }

    private void revokeNotificationPolicyAccess(String pkg) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        nm.removeAutomaticZenRules(pkg);
        nm.setNotificationPolicyAccessGranted(pkg, false);
    }

    private void grantNotificationListenerAccess(String pkg, int userId) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        PackageManager pm = this.mContext.getPackageManager();
        ArraySet<ComponentName> possibleServices = EnabledComponentsObserver.loadComponentNames(pm, userId, "android.service.notification.NotificationListenerService", "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        for (ComponentName c : possibleServices) {
            if (!Objects.equals(c.getPackageName(), pkg)) continue;
            nm.setNotificationListenerAccessGrantedForUser(c, userId, true);
        }
    }

    private void revokeNotificationListenerAccess(String pkg, int userId) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        List<ComponentName> current = nm.getEnabledNotificationListeners(userId);
        for (ComponentName component : current) {
            if (component == null || !component.getPackageName().equals(pkg)) continue;
            nm.setNotificationListenerAccessGrantedForUser(component, userId, false);
        }
    }

    private void grantCoarseLocationPermissionIfNeeded(String pkg, int userId) {
        if (!this.isPermissionUserUpdated("android.permission.ACCESS_COARSE_LOCATION", pkg, userId)) {
            try {
                this.mContext.getPackageManager().grantRuntimePermission(pkg, "android.permission.ACCESS_COARSE_LOCATION", new UserHandle(userId));
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Could not grant coarse location permission, package " + pkg + " was removed.");
            }
        }
    }

    private void revokeCoarseLocationPermissionIfNeeded(String pkg, int userId) {
        if (!this.isPermissionUserUpdated("android.permission.ACCESS_COARSE_LOCATION", pkg, userId)) {
            try {
                this.mContext.getPackageManager().revokeRuntimePermission(pkg, "android.permission.ACCESS_COARSE_LOCATION", new UserHandle(userId));
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Could not revoke coarse location permission, package " + pkg + " was removed.");
            }
        }
    }

    private boolean isPermissionUserUpdated(String permission2, String pkg, int userId) {
        int flags = this.mContext.getPackageManager().getPermissionFlags(permission2, pkg, new UserHandle(userId));
        return (flags & 3) != 0;
    }

    private ArraySet<String> getNotificationListeners(ContentResolver resolver, int userId) {
        String flat = Settings.Secure.getStringForUser(resolver, "enabled_notification_listeners", userId);
        ArraySet<String> current = new ArraySet<String>();
        if (flat != null) {
            String[] allowed;
            for (String s : allowed = flat.split(":")) {
                if (TextUtils.isEmpty(s)) continue;
                current.add(s);
            }
        }
        return current;
    }

    private static String formatSettings(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean start = true;
        for (String s : c) {
            if ("".equals(s)) continue;
            if (!start) {
                b.append(':');
            }
            b.append(s);
            start = false;
        }
        return b.toString();
    }

    private void createAndConnectService(ComponentName component, int userId) {
        this.mCurrentVrService = this.createVrListenerService(component, userId);
        this.mCurrentVrService.connect();
        Slog.i(TAG, "Connecting " + component + " for user " + userId);
    }

    private void changeVrModeLocked(boolean enabled) {
        if (this.mVrModeEnabled != enabled) {
            this.mVrModeEnabled = enabled;
            Slog.i(TAG, "VR mode " + (this.mVrModeEnabled ? "enabled" : "disabled"));
            VrManagerService.setVrModeNative(this.mVrModeEnabled);
            this.onVrModeChangedLocked();
        }
    }

    private void onVrModeChangedLocked() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0, this.mVrModeEnabled ? 1 : 0, 0));
    }

    private ManagedApplicationService createVrListenerService(ComponentName component, int userId) {
        int retryType = this.mBootsToVr ? 1 : 2;
        return ManagedApplicationService.build(this.mContext, component, userId, 17041055, "android.settings.VR_LISTENER_SETTINGS", sBinderChecker, true, retryType, this.mHandler, this.mEventCallback);
    }

    private ManagedApplicationService createVrCompositorService(ComponentName component, int userId) {
        int retryType = this.mBootsToVr ? 1 : 3;
        return ManagedApplicationService.build(this.mContext, component, userId, 0, null, null, true, retryType, this.mHandler, this.mEventCallback);
    }

    private void consumeAndApplyPendingStateLocked() {
        this.consumeAndApplyPendingStateLocked(true);
    }

    private void consumeAndApplyPendingStateLocked(boolean disconnectIfNoPendingState) {
        if (this.mPendingState != null) {
            this.updateCurrentVrServiceLocked(this.mPendingState.enabled, this.mPendingState.running2dInVr, this.mPendingState.targetPackageName, this.mPendingState.userId, this.mPendingState.processId, this.mPendingState.callingPackage);
            this.mPendingState = null;
        } else if (disconnectIfNoPendingState) {
            this.updateCurrentVrServiceLocked(false, false, null, 0, -1, null);
        }
    }

    private void logStateLocked() {
        ComponentName currentBoundService = this.mCurrentVrService == null ? null : this.mCurrentVrService.getComponent();
        this.logEvent(new VrState(this.mVrModeEnabled, this.mRunning2dInVr, currentBoundService, this.mCurrentVrModeUser, this.mVrAppProcessId, this.mCurrentVrModeComponent, this.mWasDefaultGranted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEvent(ManagedApplicationService.LogFormattable event) {
        ArrayDeque<ManagedApplicationService.LogFormattable> arrayDeque = this.mLoggingDeque;
        synchronized (arrayDeque) {
            if (this.mLoggingDeque.size() == 64) {
                this.mLoggingDeque.removeFirst();
                this.mLogLimitHit = true;
            }
            this.mLoggingDeque.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpStateTransitions(PrintWriter pw) {
        SimpleDateFormat d = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
        ArrayDeque<ManagedApplicationService.LogFormattable> arrayDeque = this.mLoggingDeque;
        synchronized (arrayDeque) {
            if (this.mLoggingDeque.size() == 0) {
                pw.print("  ");
                pw.println("None");
            }
            if (this.mLogLimitHit) {
                pw.println("...");
            }
            for (ManagedApplicationService.LogFormattable event : this.mLoggingDeque) {
                pw.println(event.toLogString(d));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVrMode(boolean enabled, ComponentName targetPackageName, int userId, int processId, ComponentName callingPackage) {
        Object object = this.mLock;
        synchronized (object) {
            boolean targetEnabledState = enabled || this.mPersistentVrModeEnabled;
            boolean running2dInVr = !enabled && this.mPersistentVrModeEnabled;
            ComponentName targetListener = running2dInVr ? this.mDefaultVrService : targetPackageName;
            VrState pending = new VrState(targetEnabledState, running2dInVr, targetListener, userId, processId, callingPackage);
            if (!this.mVrModeAllowed) {
                this.mPendingState = pending;
                return;
            }
            if (!targetEnabledState && this.mCurrentVrService != null) {
                if (this.mPendingState == null) {
                    this.mHandler.sendEmptyMessageDelayed(1, 300L);
                }
                this.mPendingState = pending;
                return;
            }
            this.mHandler.removeMessages(1);
            this.mPendingState = null;
            this.updateCurrentVrServiceLocked(targetEnabledState, running2dInVr, targetListener, userId, processId, callingPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPersistentVrModeEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.setPersistentModeAndNotifyListenersLocked(enabled);
            if (!enabled) {
                this.setVrMode(false, null, 0, -1, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVr2dDisplayProperties(Vr2dDisplayProperties compatDisplayProp) {
        long token = Binder.clearCallingIdentity();
        try {
            if (this.mVr2dDisplay != null) {
                this.mVr2dDisplay.setVirtualDisplayProperties(compatDisplayProp);
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        Slog.w(TAG, "Vr2dDisplay is null!");
    }

    private int getVr2dDisplayId() {
        if (this.mVr2dDisplay != null) {
            return this.mVr2dDisplay.getVirtualDisplayId();
        }
        Slog.w(TAG, "Vr2dDisplay is null!");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAndBindCompositor(ComponentName componentName) {
        int userId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.updateCompositorServiceLocked(userId, componentName);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void updateCompositorServiceLocked(int userId, ComponentName componentName) {
        if (this.mCurrentVrCompositorService != null && this.mCurrentVrCompositorService.disconnectIfNotMatching(componentName, userId)) {
            Slog.i(TAG, "Disconnecting compositor service: " + this.mCurrentVrCompositorService.getComponent());
            this.mCurrentVrCompositorService = null;
        }
        if (componentName != null && this.mCurrentVrCompositorService == null) {
            Slog.i(TAG, "Connecting compositor service: " + componentName);
            this.mCurrentVrCompositorService = this.createVrCompositorService(componentName, userId);
            this.mCurrentVrCompositorService.connect();
        }
    }

    private void setPersistentModeAndNotifyListenersLocked(boolean enabled) {
        if (this.mPersistentVrModeEnabled == enabled) {
            return;
        }
        String eventName = "Persistent VR mode " + (enabled ? "enabled" : "disabled");
        Slog.i(TAG, eventName);
        this.logEvent(new SettingEvent(eventName));
        this.mPersistentVrModeEnabled = enabled;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, this.mPersistentVrModeEnabled ? 1 : 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int hasVrPackage(ComponentName targetPackageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mComponentObserver.isValid(targetPackageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentVrListener(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentVrService == null) {
                return false;
            }
            return this.mCurrentVrService.getComponent().getPackageName().equals(packageName) && userId == this.mCurrentVrService.getUserId();
        }
    }

    private void addStateCallback(IVrStateCallbacks cb) {
        this.mVrStateRemoteCallbacks.register(cb);
    }

    private void removeStateCallback(IVrStateCallbacks cb) {
        this.mVrStateRemoteCallbacks.unregister(cb);
    }

    private void addPersistentStateCallback(IPersistentVrStateCallbacks cb) {
        this.mPersistentVrStateRemoteCallbacks.register(cb);
    }

    private void removePersistentStateCallback(IPersistentVrStateCallbacks cb) {
        this.mPersistentVrStateRemoteCallbacks.unregister(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getVrMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mVrModeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPersistentVrMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPersistentVrModeEnabled;
        }
    }

    private final class LocalService
    extends VrManagerInternal {
        private LocalService() {
        }

        @Override
        public void setVrMode(boolean enabled, ComponentName packageName, int userId, int processId, ComponentName callingPackage) {
            VrManagerService.this.setVrMode(enabled, packageName, userId, processId, callingPackage);
        }

        @Override
        public void onScreenStateChanged(boolean isScreenOn) {
            VrManagerService.this.setScreenOn(isScreenOn);
        }

        @Override
        public boolean isCurrentVrListener(String packageName, int userId) {
            return VrManagerService.this.isCurrentVrListener(packageName, userId);
        }

        @Override
        public int hasVrPackage(ComponentName packageName, int userId) {
            return VrManagerService.this.hasVrPackage(packageName, userId);
        }

        @Override
        public void setPersistentVrModeEnabled(boolean enabled) {
            VrManagerService.this.setPersistentVrModeEnabled(enabled);
        }

        @Override
        public void setVr2dDisplayProperties(Vr2dDisplayProperties compatDisplayProp) {
            VrManagerService.this.setVr2dDisplayProperties(compatDisplayProp);
        }

        @Override
        public int getVr2dDisplayId() {
            return VrManagerService.this.getVr2dDisplayId();
        }

        @Override
        public void addPersistentVrModeStateListener(IPersistentVrStateCallbacks listener) {
            VrManagerService.this.addPersistentStateCallback(listener);
        }
    }

    private final class NotificationAccessManager {
        private final SparseArray<ArraySet<String>> mAllowedPackages = new SparseArray();
        private final ArrayMap<String, Integer> mNotificationAccessPackageToUserId = new ArrayMap();

        private NotificationAccessManager() {
        }

        public void update(Collection<String> packageNames) {
            int currentUserId = ActivityManager.getCurrentUser();
            ArraySet<String> allowed = this.mAllowedPackages.get(currentUserId);
            if (allowed == null) {
                allowed = new ArraySet();
            }
            int listenerCount = this.mNotificationAccessPackageToUserId.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                int grantUserId = this.mNotificationAccessPackageToUserId.valueAt(i);
                if (grantUserId == currentUserId) continue;
                String packageName = this.mNotificationAccessPackageToUserId.keyAt(i);
                VrManagerService.this.revokeNotificationListenerAccess(packageName, grantUserId);
                VrManagerService.this.revokeNotificationPolicyAccess(packageName);
                VrManagerService.this.revokeCoarseLocationPermissionIfNeeded(packageName, grantUserId);
                this.mNotificationAccessPackageToUserId.removeAt(i);
            }
            for (String pkg : allowed) {
                if (packageNames.contains(pkg)) continue;
                VrManagerService.this.revokeNotificationListenerAccess(pkg, currentUserId);
                VrManagerService.this.revokeNotificationPolicyAccess(pkg);
                VrManagerService.this.revokeCoarseLocationPermissionIfNeeded(pkg, currentUserId);
                this.mNotificationAccessPackageToUserId.remove(pkg);
            }
            for (String pkg : packageNames) {
                if (allowed.contains(pkg)) continue;
                VrManagerService.this.grantNotificationPolicyAccess(pkg);
                VrManagerService.this.grantNotificationListenerAccess(pkg, currentUserId);
                VrManagerService.this.grantCoarseLocationPermissionIfNeeded(pkg, currentUserId);
                this.mNotificationAccessPackageToUserId.put(pkg, currentUserId);
            }
            allowed.clear();
            allowed.addAll(packageNames);
            this.mAllowedPackages.put(currentUserId, allowed);
        }
    }

    private static class VrState
    implements ManagedApplicationService.LogFormattable {
        final boolean enabled;
        final boolean running2dInVr;
        final int userId;
        final int processId;
        final ComponentName targetPackageName;
        final ComponentName callingPackage;
        final long timestamp;
        final boolean defaultPermissionsGranted;

        VrState(boolean enabled, boolean running2dInVr, ComponentName targetPackageName, int userId, int processId, ComponentName callingPackage) {
            this.enabled = enabled;
            this.running2dInVr = running2dInVr;
            this.userId = userId;
            this.processId = processId;
            this.targetPackageName = targetPackageName;
            this.callingPackage = callingPackage;
            this.defaultPermissionsGranted = false;
            this.timestamp = System.currentTimeMillis();
        }

        VrState(boolean enabled, boolean running2dInVr, ComponentName targetPackageName, int userId, int processId, ComponentName callingPackage, boolean defaultPermissionsGranted) {
            this.enabled = enabled;
            this.running2dInVr = running2dInVr;
            this.userId = userId;
            this.processId = processId;
            this.targetPackageName = targetPackageName;
            this.callingPackage = callingPackage;
            this.defaultPermissionsGranted = defaultPermissionsGranted;
            this.timestamp = System.currentTimeMillis();
        }

        @Override
        public String toLogString(SimpleDateFormat dateFormat) {
            String tab = "  ";
            String newLine = "\n";
            StringBuilder sb = new StringBuilder(dateFormat.format(new Date(this.timestamp)));
            sb.append(tab);
            sb.append("State changed to:");
            sb.append(tab);
            sb.append(this.enabled ? "ENABLED" : "DISABLED");
            sb.append(newLine);
            if (this.enabled) {
                sb.append(tab);
                sb.append("User=");
                sb.append(this.userId);
                sb.append(newLine);
                sb.append(tab);
                sb.append("Current VR Activity=");
                sb.append(this.callingPackage == null ? "None" : this.callingPackage.flattenToString());
                sb.append(newLine);
                sb.append(tab);
                sb.append("Bound VrListenerService=");
                sb.append(this.targetPackageName == null ? "None" : this.targetPackageName.flattenToString());
                sb.append(newLine);
                if (this.defaultPermissionsGranted) {
                    sb.append(tab);
                    sb.append("Default permissions granted to the bound VrListenerService.");
                    sb.append(newLine);
                }
            }
            return sb.toString();
        }
    }

    private static class SettingEvent
    implements ManagedApplicationService.LogFormattable {
        public final long timestamp = System.currentTimeMillis();
        public final String what;

        SettingEvent(String what) {
            this.what = what;
        }

        @Override
        public String toLogString(SimpleDateFormat dateFormat) {
            return dateFormat.format(new Date(this.timestamp)) + "   " + this.what;
        }
    }
}

