/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import com.android.server.policy.IconUtilities;
import com.android.server.wm.WindowManagerService;

class AlertWindowNotification {
    private static final String CHANNEL_PREFIX = "com.android.server.wm.AlertWindowNotification - ";
    private static final int NOTIFICATION_ID = 0;
    private static int sNextRequestCode = 0;
    private static NotificationChannelGroup sChannelGroup;
    private final int mRequestCode;
    private final WindowManagerService mService;
    private String mNotificationTag;
    private final NotificationManager mNotificationManager;
    private final String mPackageName;
    private boolean mPosted;
    private IconUtilities mIconUtilities;

    AlertWindowNotification(WindowManagerService service, String packageName) {
        this.mService = service;
        this.mPackageName = packageName;
        this.mNotificationManager = (NotificationManager)this.mService.mContext.getSystemService("notification");
        this.mNotificationTag = CHANNEL_PREFIX + this.mPackageName;
        this.mRequestCode = sNextRequestCode++;
        this.mIconUtilities = new IconUtilities(this.mService.mContext);
    }

    void post() {
        this.mService.mH.post(this::onPostNotification);
    }

    void cancel(boolean deleteChannel) {
        this.mService.mH.post(() -> this.onCancelNotification(deleteChannel));
    }

    private void onCancelNotification(boolean deleteChannel) {
        if (!this.mPosted) {
            return;
        }
        this.mPosted = false;
        this.mNotificationManager.cancel(this.mNotificationTag, 0);
        if (deleteChannel) {
            this.mNotificationManager.deleteNotificationChannel(this.mNotificationTag);
        }
    }

    private void onPostNotification() {
        Drawable drawable2;
        if (this.mPosted) {
            return;
        }
        this.mPosted = true;
        Context context = this.mService.mContext;
        PackageManager pm = context.getPackageManager();
        ApplicationInfo aInfo = this.getApplicationInfo(pm, this.mPackageName);
        String appName = aInfo != null ? pm.getApplicationLabel(aInfo).toString() : this.mPackageName;
        this.createNotificationChannel(context, appName);
        String message = context.getString(17039465, appName);
        Bundle extras = new Bundle();
        extras.putStringArray("android.foregroundApps", new String[]{this.mPackageName});
        Notification.Builder builder = new Notification.Builder(context, this.mNotificationTag).setOngoing(true).setContentTitle(context.getString(17039466, appName)).setContentText(message).setSmallIcon(17301708).setColor(context.getColor(17170774)).setStyle(new Notification.BigTextStyle().bigText(message)).setLocalOnly(true).addExtras(extras).setContentIntent(this.getContentIntent(context, this.mPackageName));
        if (aInfo != null && (drawable2 = pm.getApplicationIcon(aInfo)) != null) {
            Bitmap bitmap = this.mIconUtilities.createIconBitmap(drawable2);
            builder.setLargeIcon(bitmap);
        }
        this.mNotificationManager.notify(this.mNotificationTag, 0, builder.build());
    }

    private PendingIntent getContentIntent(Context context, String packageName) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.fromParts("package", packageName, null));
        intent.setFlags(0x10008000);
        return PendingIntent.getActivity(context, this.mRequestCode, intent, 0x10000000);
    }

    private void createNotificationChannel(Context context, String appName) {
        if (sChannelGroup == null) {
            sChannelGroup = new NotificationChannelGroup(CHANNEL_PREFIX, this.mService.mContext.getString(17039463));
            this.mNotificationManager.createNotificationChannelGroup(sChannelGroup);
        }
        String nameChannel = context.getString(17039464, appName);
        NotificationChannel channel = this.mNotificationManager.getNotificationChannel(this.mNotificationTag);
        if (channel != null) {
            return;
        }
        channel = new NotificationChannel(this.mNotificationTag, nameChannel, 1);
        channel.enableLights(false);
        channel.enableVibration(false);
        channel.setBlockableSystem(true);
        channel.setGroup(sChannelGroup.getId());
        channel.setBypassDnd(true);
        this.mNotificationManager.createNotificationChannel(channel);
    }

    private ApplicationInfo getApplicationInfo(PackageManager pm, String packageName) {
        try {
            return pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

