/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Looper;
import android.util.Slog;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MotionEvent;
import com.android.server.wm.DragDropController;

class DragInputEventReceiver
extends InputEventReceiver {
    private final DragDropController mDragDropController;
    private boolean mStylusButtonDownAtStart;
    private boolean mIsStartEvent = true;
    private boolean mMuteInput = false;

    DragInputEventReceiver(InputChannel inputChannel, Looper looper, DragDropController controller) {
        super(inputChannel, looper);
        this.mDragDropController = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInputEvent(InputEvent event, int displayId) {
        boolean handled = false;
        try {
            boolean isStylusButtonDown;
            if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || this.mMuteInput) {
                return;
            }
            MotionEvent motionEvent = (MotionEvent)event;
            float newX = motionEvent.getRawX();
            float newY = motionEvent.getRawY();
            boolean bl = isStylusButtonDown = (motionEvent.getButtonState() & 0x20) != 0;
            if (this.mIsStartEvent) {
                this.mStylusButtonDownAtStart = isStylusButtonDown;
                this.mIsStartEvent = false;
            }
            switch (motionEvent.getAction()) {
                case 0: {
                    return;
                }
                case 2: {
                    if (!this.mStylusButtonDownAtStart || isStylusButtonDown) break;
                    this.mMuteInput = true;
                    break;
                }
                case 1: {
                    this.mMuteInput = true;
                    break;
                }
                case 3: {
                    this.mMuteInput = true;
                    break;
                }
                default: {
                    return;
                }
            }
            this.mDragDropController.handleMotionEvent(!this.mMuteInput, newX, newY);
            handled = true;
        }
        catch (Exception e) {
            Slog.e("WindowManager", "Exception caught by drag handleMotion", e);
        }
        finally {
            this.finishInputEvent(event, handled);
        }
    }
}

