/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.StackWindowListener;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.lang.ref.WeakReference;

public class StackWindowController
extends WindowContainerController<TaskStack, StackWindowListener> {
    private final int mStackId;
    private final H mHandler;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpStableInsets = new Rect();
    private final Rect mTmpNonDecorInsets = new Rect();
    private final Rect mTmpDisplayBounds = new Rect();

    public StackWindowController(int stackId, StackWindowListener listener, int displayId, boolean onTop, Rect outBounds) {
        this(stackId, listener, displayId, onTop, outBounds, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public StackWindowController(int stackId, StackWindowListener listener, int displayId, boolean onTop, Rect outBounds, WindowManagerService service) {
        super(listener, service);
        this.mStackId = stackId;
        this.mHandler = new H(new WeakReference<StackWindowController>(this), service.mH.getLooper());
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent dc = this.mRoot.getDisplayContent(displayId);
                if (dc == null) {
                    throw new IllegalArgumentException("Trying to add stackId=" + stackId + " to unknown displayId=" + displayId);
                }
                dc.createStack(stackId, onTop, this);
                this.getRawBounds(outBounds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl21 : MonitorExitStatement: MONITOREXIT : var7_7
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    ((TaskStack)this.mContainer).removeIfPossible();
                    super.removeContainer();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(int displayId, Rect outStackBounds, boolean onTop) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("Trying to move unknown stackId=" + this.mStackId + " to displayId=" + displayId);
                }
                DisplayContent targetDc = this.mRoot.getDisplayContent(displayId);
                if (targetDc == null) {
                    throw new IllegalArgumentException("Trying to move stackId=" + this.mStackId + " to unknown displayId=" + displayId);
                }
                targetDc.moveStackToDisplay((TaskStack)this.mContainer, onTop);
                this.getRawBounds(outStackBounds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void positionChildAt(TaskWindowContainerController child, int position) {
        block6: {
            block5: {
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (child.mContainer != null) break block5;
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (this.mContainer != null) break block6;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((Task)child.mContainer).positionAt(position);
        ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void positionChildAtTop(TaskWindowContainerController child, boolean includingParents) {
        Task childTask;
        block6: {
            if (child == null) {
                return;
            }
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                childTask = (Task)child.mContainer;
                if (childTask != null) break block6;
                Slog.e("WindowManager", "positionChildAtTop: task=" + child + " not found");
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((TaskStack)this.mContainer).positionChildAt(Integer.MAX_VALUE, childTask, includingParents);
        if (this.mService.mAppTransition.isTransitionSet()) {
            childTask.setSendingToBottom(false);
        }
        ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void positionChildAtBottom(TaskWindowContainerController child, boolean includingParents) {
        Task childTask;
        block6: {
            if (child == null) {
                return;
            }
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                childTask = (Task)child.mContainer;
                if (childTask != null) break block6;
                Slog.e("WindowManager", "positionChildAtBottom: task=" + child + " not found");
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((TaskStack)this.mContainer).positionChildAt(Integer.MIN_VALUE, childTask, includingParents);
        if (this.mService.mAppTransition.isTransitionSet()) {
            childTask.setSendingToBottom(true);
        }
        ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Rect bounds, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("resizeStack: stack " + this + " not found.");
                }
                ((TaskStack)this.mContainer).prepareFreezingTaskBounds();
                if (((TaskStack)this.mContainer).setBounds(bounds, taskBounds, taskTempInsetBounds) && ((TaskStack)this.mContainer).isVisible()) {
                    ((TaskStack)this.mContainer).getDisplayContent().setLayoutNeeded();
                    this.mService.mWindowPlacerLocked.performSurfacePlacement();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPipAnimationEndResize() {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                ((TaskStack)this.mContainer).onPipAnimationEndResize();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getStackDockedModeBounds(Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds, boolean ignoreVisibility) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) break block4;
                ((TaskStack)this.mContainer).getStackDockedModeBoundsLocked(currentTempTaskBounds, outStackBounds, outTempTaskBounds, ignoreVisibility);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        outStackBounds.setEmpty();
        outTempTaskBounds.setEmpty();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareFreezingTaskBounds() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("prepareFreezingTaskBounds: stack " + this + " not found.");
                }
                ((TaskStack)this.mContainer).prepareFreezingTaskBounds();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRawBounds(Rect outBounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (((TaskStack)this.mContainer).matchParentBounds()) {
                    outBounds.setEmpty();
                } else {
                    ((TaskStack)this.mContainer).getRawBounds(outBounds);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getBounds(Rect outBounds) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) break block4;
                ((TaskStack)this.mContainer).getBounds(outBounds);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        outBounds.setEmpty();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBoundsForNewConfiguration(Rect outBounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                ((TaskStack)this.mContainer).getBoundsForNewConfiguration(outBounds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustConfigurationForBounds(Rect bounds, Rect insetBounds, Rect nonDecorBounds, Rect stableBounds, boolean overrideWidth, boolean overrideHeight, float density, Configuration config, Configuration parentConfig, int windowingMode) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                int height;
                int width;
                WindowManagerService.boostPriorityForLockedSection();
                TaskStack stack = (TaskStack)this.mContainer;
                DisplayContent displayContent = stack.getDisplayContent();
                DisplayInfo di = displayContent.getDisplayInfo();
                DisplayCutout displayCutout = di.displayCutout;
                this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, displayCutout, this.mTmpStableInsets);
                this.mService.mPolicy.getNonDecorInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, displayCutout, this.mTmpNonDecorInsets);
                this.mTmpDisplayBounds.set(0, 0, di.logicalWidth, di.logicalHeight);
                Rect parentAppBounds = parentConfig.windowConfiguration.getAppBounds();
                config.windowConfiguration.setBounds(bounds);
                config.windowConfiguration.setAppBounds(!bounds.isEmpty() ? bounds : null);
                boolean intersectParentBounds = false;
                if (WindowConfiguration.isFloating(windowingMode)) {
                    if (windowingMode == 2 && bounds.width() == this.mTmpDisplayBounds.width() && bounds.height() == this.mTmpDisplayBounds.height()) {
                        stableBounds.inset(this.mTmpStableInsets);
                        nonDecorBounds.inset(this.mTmpNonDecorInsets);
                        config.windowConfiguration.getAppBounds().offsetTo(0, 0);
                        intersectParentBounds = true;
                    }
                    width = (int)((float)stableBounds.width() / density);
                    height = (int)((float)stableBounds.height() / density);
                } else {
                    this.intersectDisplayBoundsExcludeInsets(nonDecorBounds, insetBounds != null ? insetBounds : bounds, this.mTmpNonDecorInsets, this.mTmpDisplayBounds, overrideWidth, overrideHeight);
                    this.intersectDisplayBoundsExcludeInsets(stableBounds, insetBounds != null ? insetBounds : bounds, this.mTmpStableInsets, this.mTmpDisplayBounds, overrideWidth, overrideHeight);
                    width = Math.min((int)((float)stableBounds.width() / density), parentConfig.screenWidthDp);
                    height = Math.min((int)((float)stableBounds.height() / density), parentConfig.screenHeightDp);
                    intersectParentBounds = true;
                }
                if (intersectParentBounds && config.windowConfiguration.getAppBounds() != null) {
                    config.windowConfiguration.getAppBounds().intersect(parentAppBounds);
                }
                config.screenWidthDp = width;
                config.screenHeightDp = height;
                config.smallestScreenWidthDp = this.getSmallestWidthForTaskBounds(insetBounds != null ? insetBounds : bounds, density, windowingMode);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl39 : MonitorExitStatement: MONITOREXIT : var11_11
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private void intersectDisplayBoundsExcludeInsets(Rect inOutBounds, Rect inInsetBounds, Rect stableInsets, Rect displayBounds, boolean overrideWidth, boolean overrideHeight) {
        this.mTmpRect.set(inInsetBounds);
        this.mService.intersectDisplayInsetBounds(displayBounds, stableInsets, this.mTmpRect);
        int leftInset = this.mTmpRect.left - inInsetBounds.left;
        int topInset = this.mTmpRect.top - inInsetBounds.top;
        int rightInset = overrideWidth ? 0 : inInsetBounds.right - this.mTmpRect.right;
        int bottomInset = overrideHeight ? 0 : inInsetBounds.bottom - this.mTmpRect.bottom;
        inOutBounds.inset(leftInset, topInset, rightInset, bottomInset);
    }

    private int getSmallestWidthForTaskBounds(Rect bounds, float density, int windowingMode) {
        DisplayContent displayContent = ((TaskStack)this.mContainer).getDisplayContent();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (bounds == null || bounds.width() == displayInfo.logicalWidth && bounds.height() == displayInfo.logicalHeight) {
            return displayContent.getConfiguration().smallestScreenWidthDp;
        }
        if (WindowConfiguration.isFloating(windowingMode)) {
            return (int)((float)Math.min(bounds.width(), bounds.height()) / density);
        }
        return displayContent.getDockedDividerController().getSmallestWidthDpForBounds(bounds);
    }

    void requestResize(Rect bounds) {
        this.mHandler.obtainMessage(0, bounds).sendToTarget();
    }

    public String toString() {
        return "{StackWindowController stackId=" + this.mStackId + "}";
    }

    private static final class H
    extends Handler {
        static final int REQUEST_RESIZE = 0;
        private final WeakReference<StackWindowController> mController;

        H(WeakReference<StackWindowController> controller, Looper looper) {
            super(looper);
            this.mController = controller;
        }

        @Override
        public void handleMessage(Message msg) {
            StackWindowListener listener;
            StackWindowController controller = (StackWindowController)this.mController.get();
            StackWindowListener stackWindowListener = listener = controller != null ? (StackWindowListener)controller.mListener : null;
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    listener.requestResize((Rect)msg.obj);
                }
            }
        }
    }
}

