/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.os.PowerManagerInternal;
import android.util.ArrayMap;
import android.view.Choreographer;
import android.view.SurfaceControl;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.SfVsyncFrameCallbackProvider;
import com.android.server.AnimationThread;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.SurfaceAnimationThread;

class SurfaceAnimationRunner {
    private final Object mLock = new Object();
    private final Object mCancelLock = new Object();
    @VisibleForTesting
    Choreographer mChoreographer;
    private final Runnable mApplyTransactionRunnable = this::applyTransaction;
    private final AnimationHandler mAnimationHandler;
    private final SurfaceControl.Transaction mFrameTransaction;
    private final AnimatorFactory mAnimatorFactory;
    private final PowerManagerInternal mPowerManagerInternal;
    private boolean mApplyScheduled;
    @GuardedBy(value="mLock")
    @VisibleForTesting
    final ArrayMap<SurfaceControl, RunningAnimation> mPendingAnimations = new ArrayMap();
    @GuardedBy(value="mLock")
    @VisibleForTesting
    final ArrayMap<SurfaceControl, RunningAnimation> mRunningAnimations = new ArrayMap();
    @GuardedBy(value="mLock")
    private boolean mAnimationStartDeferred;

    SurfaceAnimationRunner(PowerManagerInternal powerManagerInternal) {
        this(null, null, new SurfaceControl.Transaction(), powerManagerInternal);
    }

    @VisibleForTesting
    SurfaceAnimationRunner(AnimationHandler.AnimationFrameCallbackProvider callbackProvider, AnimatorFactory animatorFactory, SurfaceControl.Transaction frameTransaction, PowerManagerInternal powerManagerInternal) {
        SurfaceAnimationThread.getHandler().runWithScissors(() -> {
            this.mChoreographer = Choreographer.getSfInstance();
        }, 0L);
        this.mFrameTransaction = frameTransaction;
        this.mAnimationHandler = new AnimationHandler();
        this.mAnimationHandler.setProvider(callbackProvider != null ? callbackProvider : new SfVsyncFrameCallbackProvider(this.mChoreographer));
        this.mAnimatorFactory = animatorFactory != null ? animatorFactory : () -> new SfValueAnimator();
        this.mPowerManagerInternal = powerManagerInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deferStartingAnimations() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAnimationStartDeferred = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueStartingAnimations() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAnimationStartDeferred = false;
            if (!this.mPendingAnimations.isEmpty()) {
                this.mChoreographer.postFrameCallback(this::startAnimations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAnimation(LocalAnimationAdapter.AnimationSpec a, SurfaceControl animationLeash, SurfaceControl.Transaction t, Runnable finishCallback) {
        Object object = this.mLock;
        synchronized (object) {
            RunningAnimation runningAnim = new RunningAnimation(a, animationLeash, finishCallback);
            this.mPendingAnimations.put(animationLeash, runningAnim);
            if (!this.mAnimationStartDeferred) {
                this.mChoreographer.postFrameCallback(this::startAnimations);
            }
            this.applyTransformation(runningAnim, t, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAnimationCancelled(SurfaceControl leash) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingAnimations.containsKey(leash)) {
                this.mPendingAnimations.remove(leash);
                return;
            }
            RunningAnimation anim2 = this.mRunningAnimations.get(leash);
            if (anim2 != null) {
                this.mRunningAnimations.remove(leash);
                Object object2 = this.mCancelLock;
                synchronized (object2) {
                    anim2.mCancelled = true;
                }
                SurfaceAnimationThread.getHandler().post(() -> {
                    anim2.mAnim.cancel();
                    this.applyTransaction();
                });
            }
        }
    }

    @GuardedBy(value="mLock")
    private void startPendingAnimationsLocked() {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            this.startAnimationLocked(this.mPendingAnimations.valueAt(i));
        }
        this.mPendingAnimations.clear();
    }

    @GuardedBy(value="mLock")
    private void startAnimationLocked(final RunningAnimation a) {
        ValueAnimator anim2 = this.mAnimatorFactory.makeAnimator();
        anim2.overrideDurationScale(1.0f);
        anim2.setDuration(a.mAnimSpec.getDuration());
        anim2.addUpdateListener(animation -> {
            Object object = this.mCancelLock;
            synchronized (object) {
                if (!a.mCancelled) {
                    long duration = anim2.getDuration();
                    long currentPlayTime = anim2.getCurrentPlayTime();
                    if (currentPlayTime > duration) {
                        currentPlayTime = duration;
                    }
                    this.applyTransformation(a, this.mFrameTransaction, currentPlayTime);
                }
            }
            this.scheduleApplyTransaction();
        });
        anim2.addListener(new AnimatorListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnimationStart(Animator animation) {
                Object object = SurfaceAnimationRunner.this.mCancelLock;
                synchronized (object) {
                    if (!a.mCancelled) {
                        SurfaceAnimationRunner.this.mFrameTransaction.show(a.mLeash);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnimationEnd(Animator animation) {
                Object object = SurfaceAnimationRunner.this.mLock;
                synchronized (object) {
                    SurfaceAnimationRunner.this.mRunningAnimations.remove(a.mLeash);
                    Object object2 = SurfaceAnimationRunner.this.mCancelLock;
                    synchronized (object2) {
                        if (!a.mCancelled) {
                            AnimationThread.getHandler().post(a.mFinishCallback);
                        }
                    }
                }
            }
        });
        a.mAnim = anim2;
        this.mRunningAnimations.put(a.mLeash, a);
        anim2.start();
        if (a.mAnimSpec.canSkipFirstFrame()) {
            anim2.setCurrentPlayTime(this.mChoreographer.getFrameIntervalNanos() / 1000000L);
        }
        anim2.doAnimationFrame(this.mChoreographer.getFrameTime());
    }

    private void applyTransformation(RunningAnimation a, SurfaceControl.Transaction t, long currentPlayTime) {
        if (a.mAnimSpec.needsEarlyWakeup()) {
            t.setEarlyWakeup();
        }
        a.mAnimSpec.apply(t, a.mLeash, currentPlayTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnimations(long frameTimeNanos) {
        Object object = this.mLock;
        synchronized (object) {
            this.startPendingAnimationsLocked();
        }
        this.mPowerManagerInternal.powerHint(2, 0);
    }

    private void scheduleApplyTransaction() {
        if (!this.mApplyScheduled) {
            this.mChoreographer.postCallback(2, this.mApplyTransactionRunnable, null);
            this.mApplyScheduled = true;
        }
    }

    private void applyTransaction() {
        this.mFrameTransaction.setAnimationTransaction();
        this.mFrameTransaction.apply();
        this.mApplyScheduled = false;
    }

    private class SfValueAnimator
    extends ValueAnimator {
        SfValueAnimator() {
            this.setFloatValues(0.0f, 1.0f);
        }

        @Override
        public AnimationHandler getAnimationHandler() {
            return SurfaceAnimationRunner.this.mAnimationHandler;
        }
    }

    @VisibleForTesting
    static interface AnimatorFactory {
        public ValueAnimator makeAnimator();
    }

    private static final class RunningAnimation {
        final LocalAnimationAdapter.AnimationSpec mAnimSpec;
        final SurfaceControl mLeash;
        final Runnable mFinishCallback;
        ValueAnimator mAnim;
        @GuardedBy(value="mCancelLock")
        private boolean mCancelled;

        RunningAnimation(LocalAnimationAdapter.AnimationSpec animSpec, SurfaceControl leash, Runnable finishCallback) {
            this.mAnimSpec = animSpec;
            this.mLeash = leash;
            this.mFinishCallback = finishCallback;
        }
    }
}

