/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.AnimationHandler;
import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.IAssistDataReceiver;
import android.app.admin.DevicePolicyCache;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.configstore.V1_0.ISurfaceFlingerConfigs;
import android.hardware.configstore.V1_0.OptionalBool;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemService;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.MergedConfiguration;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.TypedValue;
import android.util.proto.ProtoOutputStream;
import android.view.AppTransitionAnimationSpec;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.IDockedStackListener;
import android.view.IInputFilter;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedStackListener;
import android.view.IRecentsAnimationRunner;
import android.view.IRotationWatcher;
import android.view.IWallpaperVisibilityListener;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InputEventReceiver;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.RemoteAnimationAdapter;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.WindowManagerPolicyConstants;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.graphics.SfVsyncFrameCallbackProvider;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.LatencyTracker;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.AnimationThread;
import com.android.server.DisplayThread;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.input.InputManagerService;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.power.ShutdownThread;
import com.android.server.utils.PriorityDump;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.CircularDisplayMask;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplaySettings;
import com.android.server.wm.DragDropController;
import com.android.server.wm.EmulatorDisplayOverlay;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.KeyguardDisableHandler;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.SurfaceAnimationRunner;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.SurfaceBuilderFactory;
import com.android.server.wm.Task;
import com.android.server.wm.TaskPositioningController;
import com.android.server.wm.TaskSnapshotController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TransactionFactory;
import com.android.server.wm.UnknownAppVisibilityController;
import com.android.server.wm.ViewServer;
import com.android.server.wm.WallpaperVisibilityListeners;
import com.android.server.wm.WallpaperWindowToken;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerInternal;
import com.android.server.wm.WindowManagerShellCommand;
import com.android.server.wm.WindowManagerThreadPriorityBooster;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import com.android.server.wm.WindowTracing;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs {
    private static final String TAG = "WindowManager";
    static final int LAYOUT_REPEAT_THRESHOLD = 4;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_THUMBNAIL = 4;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int WINDOW_FREEZE_TIMEOUT_DURATION = 2000;
    static final int SEAMLESS_ROTATION_TIMEOUT_DURATION = 2000;
    static final int WINDOW_REPLACEMENT_TIMEOUT_DURATION = 2000;
    static final int LAST_ANR_LIFETIME_DURATION_MSECS = 0x6DDD00;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    private static final int BOOT_ANIMATION_POLL_INTERVAL = 200;
    private static final String BOOT_ANIMATION_SERVICE = "bootanim";
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private static final String DENSITY_OVERRIDE = "ro.config.density_override";
    private static final String SIZE_OVERRIDE = "ro.config.size_override";
    private static final int MAX_SCREENSHOT_RETRIES = 3;
    private static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private static final boolean ALWAYS_KEEP_CURRENT = true;
    private static final int WINDOW_ANIMATION_SCALE = 0;
    private static final int TRANSITION_ANIMATION_SCALE = 1;
    private static final int ANIMATION_DURATION_SCALE = 2;
    final WindowTracing mWindowTracing;
    private final KeyguardDisableHandler mKeyguardDisableHandler;
    boolean mKeyguardGoingAway;
    boolean mKeyguardOrAodShowingOnDefaultDisplay;
    int mVr2dDisplayId = -1;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED": {
                    WindowManagerService.this.mKeyguardDisableHandler.sendEmptyMessage(3);
                }
            }
        }
    };
    final WindowSurfacePlacer mWindowPlacerLocked;
    private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

        @Override
        public void dumpCritical(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            WindowManagerService.this.doDump(fd, pw, new String[]{"-a"}, asProto);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            WindowManagerService.this.doDump(fd, pw, args, asProto);
        }
    };
    int mCurrentUserId;
    int[] mCurrentProfileIds = new int[0];
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mHasPermanentDpad;
    final long mDrawLockTimeoutMillis;
    final boolean mAllowAnimationsInLowPowerMode;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final int mMaxUiWidth;
    final WindowManagerPolicy mPolicy;
    final IActivityManager mActivityManager;
    final ActivityManagerInternal mAmInternal;
    final AppOpsManager mAppOps;
    final PackageManagerInternal mPmInternal;
    final DisplaySettings mDisplaySettings;
    boolean mShowAlertWindowNotifications = true;
    final ArraySet<Session> mSessions = new ArraySet();
    final WindowHashMap mWindowMap = new WindowHashMap();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    final ArrayList<AppWindowToken> mWindowReplacementTimeouts = new ArrayList();
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    final ArrayList<WindowState> mDestroyPreservedSurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    final ArrayList<WindowState> mForceRemoves = new ArrayList();
    ArrayList<WindowState> mWaitingForDrawn = new ArrayList();
    Runnable mWaitingForDrawnCallback;
    private ArrayList<WindowState> mHidingNonSystemOverlayWindows = new ArrayList();
    IInputMethodManager mInputMethodManager;
    AccessibilityController mAccessibilityController;
    private RecentsAnimationController mRecentsAnimationController;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    CircularDisplayMask mCircularDisplayMask;
    EmulatorDisplayOverlay mEmulatorDisplayOverlay;
    final float[] mTmpFloats = new float[9];
    final Rect mTmpRect = new Rect();
    final Rect mTmpRect2 = new Rect();
    final Rect mTmpRect3 = new Rect();
    final RectF mTmpRectF = new RectF();
    final Matrix mTmpTransform = new Matrix();
    boolean mDisplayReady;
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    boolean mBootAnimationStopped = false;
    WindowState mLastWakeLockHoldingWindow = null;
    WindowState mLastWakeLockObscuringWindow = null;
    String mLastANRState;
    RootWindowContainer mRoot;
    int mDockedStackCreateMode = 0;
    Rect mDockedStackCreateBounds;
    boolean mForceResizableTasks = false;
    boolean mSupportsPictureInPicture = false;
    boolean mDisableTransitionAnimation = false;
    ArrayList<RotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    final WallpaperVisibilityListeners mWallpaperVisibilityListeners = new WallpaperVisibilityListeners();
    int mSystemDecorLayer = 0;
    final Rect mScreenRect = new Rect();
    boolean mDisplayFrozen = false;
    long mDisplayFreezeTime = 0L;
    int mLastDisplayFreezeDuration = 0;
    Object mLastFinishedFreezeSource = null;
    boolean mWaitingForConfig = false;
    boolean mSwitchingUser = false;
    static final int WINDOWS_FREEZING_SCREENS_NONE = 0;
    static final int WINDOWS_FREEZING_SCREENS_ACTIVE = 1;
    static final int WINDOWS_FREEZING_SCREENS_TIMEOUT = 2;
    int mWindowsFreezingScreen = 0;
    boolean mClientFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastStatusBarVisibility = 0;
    int mLastDispatchedSystemUiVisibility = 0;
    boolean mFocusMayChange;
    private final PowerManager.WakeLock mScreenFrozenLock;
    final AppTransition mAppTransition;
    boolean mSkipAppTransitionAnimation = false;
    final ArraySet<AppWindowToken> mOpeningApps = new ArraySet();
    final ArraySet<AppWindowToken> mClosingApps = new ArraySet();
    final UnknownAppVisibilityController mUnknownAppVisibilityController = new UnknownAppVisibilityController(this);
    final TaskSnapshotController mTaskSnapshotController;
    boolean mIsTouchDevice;
    final H mH = new H();
    final Handler mAnimationHandler = new Handler(AnimationThread.getHandler().getLooper());
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    private final ArrayList<WindowState> mWinAddedSinceNullFocus = new ArrayList();
    private final ArrayList<WindowState> mWinRemovedSinceNullFocus = new ArrayList();
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    WindowState mInputMethodWindow = null;
    boolean mHardKeyboardAvailable;
    WindowManagerInternal.OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    SettingsObserver mSettingsObserver;
    private int mSeamlessRotationCount = 0;
    private boolean mRotatingSeamlessly = false;
    AppWindowToken mFocusedApp = null;
    PowerManager mPowerManager;
    PowerManagerInternal mPowerManagerInternal;
    private float mWindowAnimationScaleSetting = 1.0f;
    private float mTransitionAnimationScaleSetting = 1.0f;
    private float mAnimatorDurationScaleSetting = 1.0f;
    private boolean mAnimationsDisabled = false;
    final InputManagerService mInputManager;
    final DisplayManagerInternal mDisplayManagerInternal;
    final DisplayManager mDisplayManager;
    private boolean mHasWideColorGamutSupport;
    private Session mHoldingScreenOn;
    private PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mAllowTheaterModeWakeFromLayout;
    final TaskPositioningController mTaskPositioningController;
    final DragDropController mDragDropController;
    private int mExitAnimId;
    private int mEnterAnimId;
    private int mFrozenDisplayId;
    int mTransactionSequence;
    final WindowAnimator mAnimator;
    final SurfaceAnimationRunner mSurfaceAnimationRunner;
    final ArrayMap<AnimationAdapter, SurfaceAnimator> mAnimationTransferMap = new ArrayMap();
    final BoundsAnimationController mBoundsAnimationController;
    private final PointerEventDispatcher mPointerEventDispatcher;
    private WindowContentFrameStats mTempWindowRenderStats;
    private final LatencyTracker mLatencyTracker;
    boolean mInTouchMode;
    private ViewServer mViewServer;
    final ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    final boolean mOnlyCore;
    final List<IBinder> mNoAnimationNotifyOnTransitionFinished = new ArrayList<IBinder>();
    static WindowManagerThreadPriorityBooster sThreadPriorityBooster = new WindowManagerThreadPriorityBooster();
    SurfaceBuilderFactory mSurfaceBuilderFactory = SurfaceControl.Builder::new;
    TransactionFactory mTransactionFactory = SurfaceControl.Transaction::new;
    private final SurfaceControl.Transaction mTransaction = this.mTransactionFactory.make();
    final WindowManagerInternal.AppTransitionListener mActivityManagerAppTransitionNotifier = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionCancelledLocked(int transit) {
            WindowManagerService.this.mH.sendEmptyMessage(48);
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            WindowManagerService.this.mH.sendEmptyMessage(49);
            AppWindowToken atoken = WindowManagerService.this.mRoot.getAppWindowToken(token);
            if (atoken == null) {
                return;
            }
            if (atoken.mLaunchTaskBehind) {
                try {
                    WindowManagerService.this.mActivityManager.notifyLaunchTaskBehindComplete(atoken.token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                atoken.mLaunchTaskBehind = false;
            } else {
                atoken.updateReportedVisibilityLocked();
                if (atoken.mEnteringAnimation) {
                    if (WindowManagerService.this.getRecentsAnimationController() != null && WindowManagerService.this.getRecentsAnimationController().isTargetApp(atoken)) {
                        return;
                    }
                    atoken.mEnteringAnimation = false;
                    try {
                        WindowManagerService.this.mActivityManager.notifyEnterAnimationComplete(atoken.token);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    final ArrayList<AppFreezeListener> mAppFreezeListeners = new ArrayList();
    private static WindowManagerService sInstance;
    final InputMonitor mInputMonitor = new InputMonitor(this);
    private boolean mEventDispatchingEnabled;
    MousePositionTracker mMousePositionTracker = new MousePositionTracker();

    int getDragLayerLocked() {
        return this.mPolicy.getWindowLayerFromTypeLw(2016) * 10000 + 1000;
    }

    static void boostPriorityForLockedSection() {
        sThreadPriorityBooster.boost();
    }

    static void resetPriorityAfterLockedSection() {
        sThreadPriorityBooster.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void openSurfaceTransaction() {
        try {
            Trace.traceBegin(32L, "openSurfaceTransaction");
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    SurfaceControl.openTransaction();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeSurfaceTransaction(String where) {
        try {
            block10: {
                Trace.traceBegin(32L, "closeSurfaceTransaction");
                WindowHashMap windowHashMap = this.mWindowMap;
                synchronized (windowHashMap) {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.traceStateLocked(where);
                    {
                        break block10;
                    }
                    finally {
                        SurfaceControl.closeTransaction();
                    }
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    static WindowManagerService getInstance() {
        return sInstance;
    }

    public static WindowManagerService main(Context context, InputManagerService im, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore, WindowManagerPolicy policy) {
        DisplayThread.getHandler().runWithScissors(() -> {
            sInstance = new WindowManagerService(context, im, haveInputMethods, showBootMsgs, onlyCore, policy);
        }, 0L);
        return sInstance;
    }

    private void initPolicy() {
        UiThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                WindowManagerPolicyThread.set(Thread.currentThread(), Looper.myLooper());
                WindowManagerService.this.mPolicy.init(WindowManagerService.this.mContext, WindowManagerService.this, WindowManagerService.this);
            }
        }, 0L);
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver result) {
        new WindowManagerShellCommand(this).exec(this, in, out, err, args, callback, result);
    }

    private WindowManagerService(Context context, InputManagerService inputManager, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore, WindowManagerPolicy policy) {
        InputChannel inputChannel;
        LockGuard.installLock((Object)this, 5);
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mOnlyCore = onlyCore;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(17957018);
        this.mHasPermanentDpad = context.getResources().getBoolean(17956983);
        this.mInTouchMode = context.getResources().getBoolean(17956920);
        this.mDrawLockTimeoutMillis = context.getResources().getInteger(17694782);
        this.mAllowAnimationsInLowPowerMode = context.getResources().getBoolean(17956871);
        this.mMaxUiWidth = context.getResources().getInteger(17694812);
        this.mDisableTransitionAnimation = context.getResources().getBoolean(17956931);
        this.mInputManager = inputManager;
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        this.mDisplaySettings = new DisplaySettings();
        this.mDisplaySettings.readSettingsLocked();
        this.mPolicy = policy;
        this.mAnimator = new WindowAnimator(this);
        this.mRoot = new RootWindowContainer(this);
        this.mWindowPlacerLocked = new WindowSurfacePlacer(this);
        this.mTaskSnapshotController = new TaskSnapshotController(this);
        this.mWindowTracing = WindowTracing.createDefaultAndStartLooper(context);
        LocalServices.addService(WindowManagerPolicy.class, this.mPolicy);
        this.mPointerEventDispatcher = this.mInputManager != null ? ((inputChannel = this.mInputManager.monitorInput(TAG)) != null ? new PointerEventDispatcher(inputChannel) : null) : null;
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        this.mKeyguardDisableHandler = new KeyguardDisableHandler(this.mContext, this.mPolicy);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        if (this.mPowerManagerInternal != null) {
            this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                @Override
                public int getServiceType() {
                    return 3;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onLowPowerModeChanged(PowerSaveState result) {
                    WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
                    synchronized (windowHashMap) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            boolean enabled = result.batterySaverEnabled;
                            if (WindowManagerService.this.mAnimationsDisabled != enabled && !WindowManagerService.this.mAllowAnimationsInLowPowerMode) {
                                WindowManagerService.this.mAnimationsDisabled = enabled;
                                WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                }
            });
            this.mAnimationsDisabled = this.mPowerManagerInternal.getLowPowerState((int)3).batterySaverEnabled;
        }
        this.mScreenFrozenLock = this.mPowerManager.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mAppTransition = new AppTransition(context, this);
        this.mAppTransition.registerListenerLocked(this.mActivityManagerAppTransitionNotifier);
        AnimationHandler animationHandler = new AnimationHandler();
        animationHandler.setProvider(new SfVsyncFrameCallbackProvider());
        this.mBoundsAnimationController = new BoundsAnimationController(context, this.mAppTransition, AnimationThread.getHandler(), animationHandler);
        this.mActivityManager = ActivityManager.getService();
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        AppOpsManager.OnOpChangedInternalListener opListener = new AppOpsManager.OnOpChangedInternalListener(){

            @Override
            public void onOpChanged(int op, String packageName) {
                WindowManagerService.this.updateAppOpsState();
            }
        };
        this.mAppOps.startWatchingMode(24, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mAppOps.startWatchingMode(45, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mPmInternal = LocalServices.getService(PackageManagerInternal.class);
        IntentFilter suspendPackagesFilter = new IntentFilter();
        suspendPackagesFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        suspendPackagesFilter.addAction("android.intent.action.PACKAGES_UNSUSPENDED");
        context.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String[] affectedPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                boolean suspended = "android.intent.action.PACKAGES_SUSPENDED".equals(intent.getAction());
                WindowManagerService.this.updateHiddenWhileSuspendedState(new ArraySet<String>(Arrays.asList(affectedPackages)), suspended);
            }
        }, UserHandle.ALL, suspendPackagesFilter, null, null);
        this.mWindowAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "window_animation_scale", this.mWindowAnimationScaleSetting);
        this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "transition_animation_scale", context.getResources().getFloat(17104958));
        this.setAnimatorDurationScale(Settings.Global.getFloat(context.getContentResolver(), "animator_duration_scale", this.mAnimatorDurationScaleSetting));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mLatencyTracker = LatencyTracker.getInstance(context);
        this.mSettingsObserver = new SettingsObserver();
        this.mHoldingScreenWakeLock = this.mPowerManager.newWakeLock(0x2000000A, TAG);
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mSurfaceAnimationRunner = new SurfaceAnimationRunner(this.mPowerManagerInternal);
        this.mAllowTheaterModeWakeFromLayout = context.getResources().getBoolean(17956886);
        this.mTaskPositioningController = new TaskPositioningController(this, this.mInputManager, this.mInputMonitor, this.mActivityManager, this.mH.getLooper());
        this.mDragDropController = new DragDropController(this, this.mH.getLooper());
        LocalServices.addService(WindowManagerInternal.class, new LocalService());
    }

    public void onInitReady() {
        this.initPolicy();
        Watchdog.getInstance().addMonitor(this);
        this.openSurfaceTransaction();
        try {
            this.createWatermarkInTransaction();
        }
        finally {
            this.closeSurfaceTransaction("createWatermarkInTransaction");
        }
        this.showEmulatorDisplayOverlayIfNeeded();
    }

    public InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Window Manager Crash", e);
            }
            throw e;
        }
    }

    static boolean excludeWindowTypeFromTapOutTask(int windowType) {
        switch (windowType) {
            case 2000: 
            case 2012: 
            case 2019: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, DisplayCutout.ParcelableWrapper outDisplayCutout, InputChannel outInputChannel) {
        appOp = new int[1];
        res = this.mPolicy.checkAddPermission(attrs, appOp);
        if (res != 0) {
            return res;
        }
        reportNewConfig = false;
        parentWindow = null;
        callingUid = Binder.getCallingUid();
        type = attrs.type;
        var21_19 = this.mWindowMap;
        synchronized (var21_19) {
            WindowManagerService.boostPriorityForLockedSection();
            if (!this.mDisplayReady) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            displayContent = this.getDisplayContentOrCreate(displayId);
            if (displayContent != null) ** break block60
            Slog.w("WindowManager", "Attempted to add window to a display that does not exist: " + displayId + ".  Aborting.");
            v0 = -9;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            if (displayContent.hasAccess(session.mUid) || this.mDisplayManagerInternal.isUidPresentOnDisplay(session.mUid, displayId)) ** break block61
            Slog.w("WindowManager", "Attempted to add window to a display for which the application does not have access: " + displayId + ".  Aborting.");
            v1 = -9;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v1;
        {
            if (!this.mWindowMap.containsKey(client.asBinder())) ** break block62
            Slog.w("WindowManager", "Window " + client + " is already added");
            v2 = -5;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v2;
        {
            if (type < 1000 || type > 1999) ** break block63
            parentWindow = this.windowForClientLocked(null, attrs.token, false);
            if (parentWindow != null) ** break block64
            Slog.w("WindowManager", "Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting.");
            v3 = -2;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v3;
        {
            if (parentWindow.mAttrs.type < 1000 || parentWindow.mAttrs.type > 1999) ** break block63
            Slog.w("WindowManager", "Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting.");
            v4 = -2;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v4;
        {
            if (type != 2030 || displayContent.isPrivate()) ** break block65
            Slog.w("WindowManager", "Attempted to add private presentation window to a non-private display.  Aborting.");
            v5 = -8;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v5;
        {
            atoken = null;
            hasParent = parentWindow != null;
            token = displayContent.getWindowToken(hasParent != false ? parentWindow.mAttrs.token : attrs.token);
            rootType = hasParent != false ? parentWindow.mAttrs.type : type;
            addToastWindowRequiresToken = false;
            if (token != null) ** GOTO lbl140
            if (rootType < 1 || rootType > 99) ** break block66
            Slog.w("WindowManager", "Attempted to add application window with unknown token " + attrs.token + ".  Aborting.");
            v6 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v6;
        {
            if (rootType != 2011) ** break block67
            Slog.w("WindowManager", "Attempted to add input method window with unknown token " + attrs.token + ".  Aborting.");
            v7 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v7;
        {
            if (rootType != 2031) ** break block68
            Slog.w("WindowManager", "Attempted to add voice interaction window with unknown token " + attrs.token + ".  Aborting.");
            v8 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v8;
        {
            if (rootType != 2013) ** break block69
            Slog.w("WindowManager", "Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting.");
            v9 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v9;
        {
            if (rootType != 2023) ** break block70
            Slog.w("WindowManager", "Attempted to add Dream window with unknown token " + attrs.token + ".  Aborting.");
            v10 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v10;
        {
            if (rootType != 2035) ** break block71
            Slog.w("WindowManager", "Attempted to add QS dialog window with unknown token " + attrs.token + ".  Aborting.");
            v11 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v11;
        {
            if (rootType != 2032) ** break block72
            Slog.w("WindowManager", "Attempted to add Accessibility overlay window with unknown token " + attrs.token + ".  Aborting.");
            v12 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v12;
        {
            if (type != 2005 || !this.doesAddToastWindowRequireToken(attrs.packageName, callingUid, parentWindow)) ** break block73
            Slog.w("WindowManager", "Attempted to add a toast window with unknown token " + attrs.token + ".  Aborting.");
            v13 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v13;
        {
            binder = attrs.token != null ? attrs.token : client.asBinder();
            isRoundedCornerOverlay = (attrs.privateFlags & 0x100000) != 0;
            token = new WindowToken(this, binder, type, false, displayContent, session.mCanAddInternalSystemWindow, isRoundedCornerOverlay);
            ** GOTO lbl235
lbl140:
            // 1 sources

            if (rootType < 1 || rootType > 99) ** break block74
            atoken = token.asAppWindowToken();
            if (atoken != null) ** break block75
            Slog.w("WindowManager", "Attempted to add window with non-application token " + token + ".  Aborting.");
            v14 = -3;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v14;
        {
            if (!atoken.removed) ** break block76
            Slog.w("WindowManager", "Attempted to add window with exiting application token " + token + ".  Aborting.");
            v15 = -4;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v15;
        {
            if (type != 3 || atoken.startingWindow == null) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add starting window to token with already existing starting window");
            v16 = -5;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v16;
        {
            if (rootType != 2011) ** break block77
            if (token.windowType == 2011) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add input method window with bad token " + attrs.token + ".  Aborting.");
            v17 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v17;
        {
            if (rootType != 2031) ** break block78
            if (token.windowType == 2031) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add voice interaction window with bad token " + attrs.token + ".  Aborting.");
            v18 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v18;
        {
            if (rootType != 2013) ** break block79
            if (token.windowType == 2013) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting.");
            v19 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v19;
        {
            if (rootType != 2023) ** break block80
            if (token.windowType == 2023) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add Dream window with bad token " + attrs.token + ".  Aborting.");
            v20 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v20;
        {
            if (rootType != 2032) ** break block81
            if (token.windowType == 2032) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add Accessibility overlay window with bad token " + attrs.token + ".  Aborting.");
            v21 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v21;
        {
            if (type != 2005) ** break block82
            addToastWindowRequiresToken = this.doesAddToastWindowRequireToken(attrs.packageName, callingUid, parentWindow);
            if (!addToastWindowRequiresToken || token.windowType == 2005) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add a toast window with bad token " + attrs.token + ".  Aborting.");
            v22 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v22;
        {
            if (type != 2035) ** break block83
            if (token.windowType == 2035) ** GOTO lbl235
            Slog.w("WindowManager", "Attempted to add QS dialog window with bad token " + attrs.token + ".  Aborting.");
            v23 = -1;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v23;
        {
            if (token.asAppWindowToken() != null) {
                Slog.w("WindowManager", "Non-null appWindowToken for system window of rootType=" + rootType);
                attrs.token = null;
                token = new WindowToken(this, client.asBinder(), type, false, displayContent, session.mCanAddInternalSystemWindow);
            }
lbl235:
            // 12 sources

            win = new WindowState(this, session, client, token, parentWindow, appOp[0], seq, attrs, viewVisibility, session.mUid, session.mCanAddInternalSystemWindow);
            if (win.mDeathRecipient != null) ** break block84
            Slog.w("WindowManager", "Adding window client " + client.asBinder() + " that is dead, aborting.");
            v24 = -4;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v24;
        {
            if (win.getDisplayContent() != null) ** break block85
            Slog.w("WindowManager", "Adding window to Display that has been removed.");
            v25 = -9;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v25;
        {
            hasStatusBarServicePermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") == 0;
            this.mPolicy.adjustWindowParamsLw(win, win.mAttrs, hasStatusBarServicePermission);
            win.setShowToOwnerOnlyLocked(this.mPolicy.checkShowToOwnerOnly(attrs));
            res = this.mPolicy.prepareAddWindowLw(win, attrs);
            if (res == 0) ** break block86
            v26 = res;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v26;
        {
            v27 = openInputChannels = outInputChannel != null && (attrs.inputFeatures & 2) == 0;
            if (openInputChannels) {
                win.openInputChannel(outInputChannel);
            }
            if (type != 2005) ** GOTO lbl277
            if (this.getDefaultDisplayContentLocked().canAddToastWindowForUid(callingUid)) ** break block87
            Slog.w("WindowManager", "Adding more than one toast window for UID at a time.");
            v28 = -5;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v28;
        {
            try {
                if (addToastWindowRequiresToken || (attrs.flags & 8) == 0 || this.mCurrentFocus == null || this.mCurrentFocus.mOwnerUid != callingUid) {
                    this.mH.sendMessageDelayed(this.mH.obtainMessage(52, win), win.mAttrs.hideTimeoutMilliseconds);
                }
lbl277:
                // 4 sources

                res = 0;
                if (this.mCurrentFocus == null) {
                    this.mWinAddedSinceNullFocus.add(win);
                }
                if (WindowManagerService.excludeWindowTypeFromTapOutTask(type)) {
                    displayContent.mTapExcludedWindows.add(win);
                }
                origId = Binder.clearCallingIdentity();
                win.attach();
                this.mWindowMap.put(client.asBinder(), win);
                win.initAppOpsState();
                suspended = this.mPmInternal.isPackageSuspended(win.getOwningPackage(), UserHandle.getUserId(win.getOwningUid()));
                win.setHiddenWhileSuspended(suspended);
                hideSystemAlertWindows = this.mHidingNonSystemOverlayWindows.isEmpty() == false;
                win.setForceHideNonSystemOverlayWindowIfNeeded(hideSystemAlertWindows);
                aToken = token.asAppWindowToken();
                if (type == 3 && aToken != null) {
                    aToken.startingWindow = win;
                }
                imMayMove = true;
                win.mToken.addWindow(win);
                if (type == 2011) {
                    win.mGivenInsetsPending = true;
                    this.setInputMethodWindowLocked(win);
                    imMayMove = false;
                } else if (type == 2012) {
                    displayContent.computeImeTarget(true);
                    imMayMove = false;
                } else if (type == 2013) {
                    displayContent.mWallpaperController.clearLastWallpaperTimeoutTime();
                    displayContent.pendingLayoutChanges |= 4;
                } else if ((attrs.flags & 0x100000) != 0) {
                    displayContent.pendingLayoutChanges |= 4;
                } else if (displayContent.mWallpaperController.isBelowWallpaperTarget(win)) {
                    displayContent.pendingLayoutChanges |= 4;
                }
                win.applyAdjustForImeIfNeeded();
                if (type == 2034) {
                    this.mRoot.getDisplayContent(displayId).getDockedDividerController().setWindow(win);
                }
                winAnimator = win.mWinAnimator;
                winAnimator.mEnterAnimationPending = true;
                winAnimator.mEnteringAnimation = true;
                if (atoken != null && atoken.isVisible() && !this.prepareWindowReplacementTransition(atoken)) {
                    this.prepareNoneTransitionForRelaunching(atoken);
                }
                displayFrames = displayContent.mDisplayFrames;
                displayInfo = displayContent.getDisplayInfo();
                displayFrames.onDisplayInfoUpdated(displayInfo, displayContent.calculateDisplayCutoutForRotation(displayInfo.rotation));
                if (atoken != null && atoken.getTask() != null) {
                    taskBounds = this.mTmpRect;
                    atoken.getTask().getBounds(this.mTmpRect);
                } else {
                    taskBounds = null;
                }
                if (this.mPolicy.getLayoutHintLw(win.mAttrs, taskBounds, displayFrames, outFrame, outContentInsets, outStableInsets, outOutsets, outDisplayCutout)) {
                    res |= 4;
                }
                if (this.mInTouchMode) {
                    res |= 1;
                }
                if (win.mAppToken == null || !win.mAppToken.isClientHidden()) {
                    res |= 2;
                }
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                focusChanged = false;
                if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                    imMayMove = false;
                }
                if (imMayMove) {
                    displayContent.computeImeTarget(true);
                }
                win.getParent().assignChildLayers();
                if (focusChanged) {
                    this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, false);
                }
                this.mInputMonitor.updateInputWindowsLw(false);
                if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(displayId)) {
                    reportNewConfig = true;
                }
            }
            catch (Throwable var40_39) {
                // MONITOREXIT @DISABLED, blocks:[29, 30] lbl355 : MonitorExitStatement: MONITOREXIT : var21_19
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var40_39;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (reportNewConfig) {
            this.sendNewConfiguration(displayId);
        }
        Binder.restoreCallingIdentity(origId);
        return res;
    }

    private DisplayContent getDisplayContentOrCreate(int displayId) {
        Display display;
        DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
        if (displayContent == null && (display = this.mDisplayManager.getDisplay(displayId)) != null) {
            displayContent = this.mRoot.createDisplayContent(display, null);
        }
        return displayContent;
    }

    private boolean doesAddToastWindowRequireToken(String packageName, int callingUid, WindowState attachedWindow) {
        if (attachedWindow != null) {
            return attachedWindow.mAppToken != null && attachedWindow.mAppToken.mTargetSdk >= 26;
        }
        try {
            ApplicationInfo appInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(packageName, 0, UserHandle.getUserId(callingUid));
            if (appInfo.uid != callingUid) {
                throw new SecurityException("Package " + packageName + " not in UID " + callingUid);
            }
            if (appInfo.targetSdkVersion >= 26) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean prepareWindowReplacementTransition(AppWindowToken atoken) {
        atoken.clearAllDrawn();
        WindowState replacedWindow = atoken.getReplacingWindow();
        if (replacedWindow == null) {
            return false;
        }
        Rect frame = replacedWindow.mVisibleFrame;
        this.mOpeningApps.add(atoken);
        this.prepareAppTransition(18, true);
        this.mAppTransition.overridePendingAppTransitionClipReveal(frame.left, frame.top, frame.width(), frame.height());
        this.executeAppTransition();
        return true;
    }

    private void prepareNoneTransitionForRelaunching(AppWindowToken atoken) {
        if (this.mDisplayFrozen && !this.mOpeningApps.contains(atoken) && atoken.isRelaunching()) {
            this.mOpeningApps.add(atoken);
            this.prepareAppTransition(0, false);
            this.executeAppTransition();
        }
    }

    boolean isSecureLocked(WindowState w) {
        if ((w.mAttrs.flags & 0x2000) != 0) {
            return true;
        }
        return DevicePolicyCache.getInstance().getScreenCaptureDisabled(UserHandle.getUserId(w.mOwnerUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshScreenCaptureDisabled(int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("Only system can call refreshScreenCaptureDisabled.");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.setSecureSurfaceState(userId, DevicePolicyCache.getInstance().getScreenCaptureDisabled(userId));
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void removeWindow(Session session, IWindow client) {
        WindowState win;
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        win.removeIfPossible();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void postWindowRemoveCleanupLocked(WindowState win) {
        this.mWindowMap.remove(win.mClient.asBinder());
        this.markForSeamlessRotation(win, false);
        win.resetAppOpsState();
        if (this.mCurrentFocus == null) {
            this.mWinRemovedSinceNullFocus.add(win);
        }
        this.mPendingRemove.remove(win);
        this.mResizingWindows.remove(win);
        this.updateNonSystemOverlayWindowsVisibilityIfNeeded(win, false);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.setInputMethodWindowLocked(null);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        if (token.isEmpty()) {
            if (!token.mPersistOnEmpty) {
                token.removeImmediately();
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
                atoken.clearAllDrawn();
                TaskStack stack = atoken.getStack();
                if (stack != null) {
                    stack.mExitingAppTokens.remove(atoken);
                }
            }
        }
        if (atoken != null) {
            atoken.postWindowRemoveStartingWindowCleanup(win);
        }
        DisplayContent dc = win.getDisplayContent();
        if (win.mAttrs.type == 2013) {
            dc.mWallpaperController.clearLastWallpaperTimeoutTime();
            dc.pendingLayoutChanges |= 4;
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            dc.pendingLayoutChanges |= 4;
        }
        if (dc != null && !this.mWindowPlacerLocked.isInLayout()) {
            dc.assignWindowLayers(true);
            this.mWindowPlacerLocked.performSurfacePlacement();
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    void setInputMethodWindowLocked(WindowState win) {
        this.mInputMethodWindow = win;
        DisplayContent dc = win != null ? win.getDisplayContent() : this.getDefaultDisplayContentLocked();
        dc.computeImeTarget(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHiddenWhileSuspendedState(ArraySet<String> packages, boolean suspended) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.updateHiddenWhileSuspendedState(packages, suspended);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppOpsState() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.updateAppOpsState();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    static void logSurface(WindowState w, String msg, boolean withStackTrace) {
        String str = "  SURFACE " + msg + ": " + w;
        if (withStackTrace) {
            WindowManagerService.logWithStack(TAG, str);
        } else {
            Slog.i(TAG, str);
        }
    }

    static void logSurface(SurfaceControl s, String title, String msg) {
        String str = "  SURFACE " + s + ": " + msg + " / " + title;
        Slog.i(TAG, str);
    }

    static void logWithStack(String tag, String s) {
        Throwable e = null;
        Slog.i(tag, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState w = this.windowForClientLocked(session, client, false);
                    if (w != null && w.mHasSurface) {
                        w.mWinAnimator.setTransparentRegionHintLocked(region);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState w = this.windowForClientLocked(session, client, false);
                    if (w != null) {
                        w.mGivenInsetsPending = false;
                        w.mGivenContentInsets.set(contentInsets);
                        w.mGivenVisibleInsets.set(visibleInsets);
                        w.mGivenTouchableRegion.set(touchableRegion);
                        w.mTouchableInsets = touchableInsets;
                        if (w.mGlobalScale != 1.0f) {
                            w.mGivenContentInsets.scale(w.mGlobalScale);
                            w.mGivenVisibleInsets.scale(w.mGlobalScale);
                            w.mGivenTouchableRegion.scale(w.mGlobalScale);
                        }
                        w.setDisplayLayoutNeeded();
                        this.mWindowPlacerLocked.performSurfacePlacement();
                        if (this.mAccessibilityController != null && w.getDisplayContent().getDisplayId() == 0) {
                            this.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl26 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        WindowState win;
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block4;
                outDisplayFrame.setEmpty();
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        outDisplayFrame.set(win.mDisplayFrame);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowState window;
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mAccessibilityController != null && (window = (WindowState)this.mWindowMap.get(token)) != null && window.getDisplayId() == 0) {
                    this.mAccessibilityController.onRectangleOnScreenRequestedLocked(rectangle);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IWindowId getWindowId(IBinder token) {
        WindowState.WindowId windowId;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                WindowState window = (WindowState)this.mWindowMap.get(token);
                windowId = window != null ? window.mWindowId : null;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return windowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pokeDrawLock(Session session, IBinder token) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                WindowState window = this.windowForClientLocked(session, token, false);
                if (window != null) {
                    window.pokeDrawLockLw(this.mDrawLockTimeoutMillis);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, long frameNumber, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outOutsets, Rect outBackdropFrame, DisplayCutout.ParcelableWrapper outCutout, MergedConfiguration mergedConfiguration, Surface outSurface) {
        result = 0;
        hasStatusBarPermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") == 0;
        hasStatusBarServicePermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") == 0;
        origId = Binder.clearCallingIdentity();
        var28_24 = this.mWindowMap;
        synchronized (var28_24) {
            WindowManagerService.boostPriorityForLockedSection();
            win = this.windowForClientLocked(session, client, false);
            if (win != null) ** break block43
            v0 = 0;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            block45: {
                try {
                    displayId = win.getDisplayId();
                    winAnimator = win.mWinAnimator;
                    if (viewVisibility != 8) {
                        win.setRequestedSize(requestedWidth, requestedHeight);
                    }
                    win.setFrameNumber(frameNumber);
                    if (win.mPendingForcedSeamlessRotate != null && !this.mWaitingForConfig) {
                        win.mPendingForcedSeamlessRotate.finish(win.mToken, win);
                        win.mFinishForcedSeamlessRotateFrameNumber = win.getFrameNumber();
                        win.mPendingForcedSeamlessRotate = null;
                    }
                    attrChanges = 0;
                    flagChanges = 0;
                    if (attrs != null) {
                        this.mPolicy.adjustWindowParamsLw(win, attrs, hasStatusBarServicePermission);
                        if (seq == win.mSeq) {
                            systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility;
                            if ((systemUiVisibility & 0x3FF0000) != 0 && !hasStatusBarPermission) {
                                systemUiVisibility &= -67043329;
                            }
                            win.mSystemUiVisibility = systemUiVisibility;
                        }
                        if (win.mAttrs.type != attrs.type) {
                            throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                        }
                        if ((attrs.privateFlags & 8192) != 0) {
                            attrs.x = win.mAttrs.x;
                            attrs.y = win.mAttrs.y;
                            attrs.width = win.mAttrs.width;
                            attrs.height = win.mAttrs.height;
                        }
                        flagChanges = win.mAttrs.flags ^= attrs.flags;
                        attrChanges = win.mAttrs.copyFrom(attrs);
                        if ((attrChanges & 16385) != 0) {
                            win.mLayoutNeeded = true;
                        }
                        if (win.mAppToken != null && ((flagChanges & 524288) != 0 || (flagChanges & 0x400000) != 0)) {
                            win.mAppToken.checkKeyguardFlagsChanged();
                        }
                        if ((attrChanges & 0x2000000) != 0 && this.mAccessibilityController != null && win.getDisplayId() == 0) {
                            this.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
                        }
                        if ((flagChanges & 524288) != 0) {
                            this.updateNonSystemOverlayWindowsVisibilityIfNeeded(win, win.mWinAnimator.getShown());
                        }
                    }
                    winAnimator.mSurfaceDestroyDeferred = (flags & 2) != 0;
                    v1 = win.mEnforceSizeCompat = (win.mAttrs.privateFlags & 128) != 0;
                    if ((attrChanges & 128) != 0) {
                        winAnimator.mAlpha = attrs.alpha;
                    }
                    win.setWindowScale(win.mRequestedWidth, win.mRequestedHeight);
                    if (win.mAttrs.surfaceInsets.left != 0 || win.mAttrs.surfaceInsets.top != 0 || win.mAttrs.surfaceInsets.right != 0 || win.mAttrs.surfaceInsets.bottom != 0) {
                        winAnimator.setOpaqueLocked(false);
                    }
                    becameVisible = ((oldVisibility = win.mViewVisibility) == 4 || oldVisibility == 8) && viewVisibility == 0;
                    imMayMove = (flagChanges & 131080) != 0 || becameVisible != false;
                    isDefaultDisplay = win.isDefaultDisplay();
                    focusMayChange = isDefaultDisplay != false && (win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || win.mRelayoutCalled == false);
                    wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
                    wallpaperMayMove |= (flagChanges & 0x100000) != 0;
                    if ((flagChanges & 8192) != 0 && winAnimator.mSurfaceController != null) {
                        winAnimator.mSurfaceController.setSecure(this.isSecureLocked(win));
                    }
                    win.mRelayoutCalled = true;
                    win.mInRelayout = true;
                    win.mViewVisibility = viewVisibility;
                    win.setDisplayLayoutNeeded();
                    win.mGivenInsetsPending = (flags & 1) != 0;
                    v2 = shouldRelayout = viewVisibility == 0 && (win.mAppToken == null || win.mAttrs.type == 3 || win.mAppToken.isClientHidden() == false);
                    if (!shouldRelayout && winAnimator.hasSurface() && !win.mAnimatingExit) {
                        result |= 4;
                        if (!win.mWillReplaceWindow) {
                            focusMayChange = this.tryStartExitingAnimation(win, winAnimator, isDefaultDisplay, focusMayChange);
                        }
                    }
                    this.mWindowPlacerLocked.performSurfacePlacement(true);
                    if (!shouldRelayout) ** GOTO lbl104
                    Trace.traceBegin(32L, "relayoutWindow: viewVisibility_1");
                    result = win.relayoutVisibleWindow(result, attrChanges, oldVisibility);
                    try {
                        result = this.createSurfaceControl(outSurface, result, win, winAnimator);
                    }
                    catch (Exception e) {
                        this.mInputMonitor.updateInputWindowsLw(true);
                        Slog.w("WindowManager", "Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")", e);
                        Binder.restoreCallingIdentity(origId);
                        // MONITOREXIT @DISABLED, blocks:[1, 5, 6] lbl88 : MonitorExitStatement: MONITOREXIT : var28_24
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return 0;
                    }
                }
                catch (Throwable var43_43) {
                    // MONITOREXIT @DISABLED, blocks:[5, 8] lbl166 : MonitorExitStatement: MONITOREXIT : var28_24
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw var43_43;
                }
                if ((result & 2) != 0) {
                    focusMayChange = isDefaultDisplay;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.setInputMethodWindowLocked(win);
                    imMayMove = true;
                }
                win.adjustStartingWindowFlags();
                Trace.traceEnd(32L);
                break block45;
lbl104:
                // 1 sources

                Trace.traceBegin(32L, "relayoutWindow: viewVisibility_2");
                winAnimator.mEnterAnimationPending = false;
                winAnimator.mEnteringAnimation = false;
                if (viewVisibility == 0 && winAnimator.hasSurface()) {
                    Trace.traceBegin(32L, "relayoutWindow: getSurface");
                    winAnimator.mSurfaceController.getSurface(outSurface);
                    Trace.traceEnd(32L);
                } else {
                    try {
                        Trace.traceBegin(32L, "wmReleaseOutSurface_" + win.mAttrs.getTitle());
                        outSurface.release();
                    }
                    finally {
                        Trace.traceEnd(32L);
                    }
                }
                Trace.traceEnd(32L);
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            toBeDisplayed = (result & 2) != 0;
            dc = win.getDisplayContent();
            if (imMayMove) {
                dc.computeImeTarget(true);
                if (toBeDisplayed) {
                    dc.assignWindowLayers(false);
                }
            }
            if (wallpaperMayMove) {
                win.getDisplayContent().pendingLayoutChanges |= 4;
            }
            if (win.mAppToken != null) {
                this.mUnknownAppVisibilityController.notifyRelayouted(win.mAppToken);
            }
            Trace.traceBegin(32L, "relayoutWindow: updateOrientationFromAppTokens");
            configChanged = this.updateOrientationFromAppTokensLocked(displayId);
            Trace.traceEnd(32L);
            if (toBeDisplayed && win.mIsWallpaper) {
                displayInfo = win.getDisplayContent().getDisplayInfo();
                dc.mWallpaperController.updateWallpaperOffset(win, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            if (winAnimator.mReportSurfaceResized) {
                winAnimator.mReportSurfaceResized = false;
                result |= 32;
            }
            if (this.mPolicy.isNavBarForcedShownLw(win)) {
                result |= 64;
            }
            if (!win.isGoneForLayoutLw()) {
                win.mResizedWhileGone = false;
            }
            if (shouldRelayout) {
                win.getMergedConfiguration(mergedConfiguration);
            } else {
                win.getLastReportedMergedConfiguration(mergedConfiguration);
            }
            win.setLastReportedMergedConfiguration(mergedConfiguration);
            win.updateLastInsetValues();
            outFrame.set(win.mCompatFrame);
            outOverscanInsets.set(win.mOverscanInsets);
            outContentInsets.set(win.mContentInsets);
            win.mLastRelayoutContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            outStableInsets.set(win.mStableInsets);
            outCutout.set(win.mDisplayCutout.getDisplayCutout());
            outOutsets.set(win.mOutsets);
            outBackdropFrame.set(win.getBackdropFrame(win.mFrame));
            result |= this.mInTouchMode != false ? 1 : 0;
            this.mInputMonitor.updateInputWindowsLw(true);
            win.mInRelayout = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (configChanged) {
            Trace.traceBegin(32L, "relayoutWindow: sendNewConfiguration");
            this.sendNewConfiguration(displayId);
            Trace.traceEnd(32L);
        }
        Binder.restoreCallingIdentity(origId);
        return result;
    }

    private boolean tryStartExitingAnimation(WindowState win, WindowStateAnimator winAnimator, boolean isDefaultDisplay, boolean focusMayChange) {
        int transit = 2;
        if (win.mAttrs.type == 3) {
            transit = 5;
        }
        if (win.isWinVisibleLw() && winAnimator.applyAnimationLocked(transit, false)) {
            focusMayChange = isDefaultDisplay;
            win.mAnimatingExit = true;
        } else if (win.mWinAnimator.isAnimationSet()) {
            win.mAnimatingExit = true;
        } else if (win.getDisplayContent().mWallpaperController.isWallpaperTarget(win)) {
            win.mAnimatingExit = true;
        } else {
            if (this.mInputMethodWindow == win) {
                this.setInputMethodWindowLocked(null);
            }
            boolean stopped = win.mAppToken != null ? win.mAppToken.mAppStopped : true;
            win.mDestroying = true;
            win.destroySurface(false, stopped);
        }
        if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
            this.mAccessibilityController.onWindowTransitionLocked(win, transit);
        }
        SurfaceControl.openTransaction();
        winAnimator.detachChildren();
        SurfaceControl.closeTransaction();
        return focusMayChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createSurfaceControl(Surface outSurface, int result, WindowState win, WindowStateAnimator winAnimator) {
        WindowSurfaceController surfaceController;
        if (!win.mHasSurface) {
            result |= 4;
        }
        try {
            Trace.traceBegin(32L, "createSurfaceControl");
            surfaceController = winAnimator.createSurfaceLocked(win.mAttrs.type, win.mOwnerUid);
        }
        finally {
            Trace.traceEnd(32L);
        }
        if (surfaceController != null) {
            surfaceController.getSurface(outSurface);
        } else {
            Slog.w(TAG, "Failed to create surface control for " + win);
            outSurface.release();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState win = this.windowForClientLocked(session, client, false);
                    if (win != null && win.mWinAnimator.finishDrawingLocked()) {
                        if ((win.mAttrs.flags & 0x100000) != 0) {
                            win.getDisplayContent().pendingLayoutChanges |= 4;
                        }
                        win.setDisplayLayoutNeeded();
                        this.mWindowPlacerLocked.requestTraversal();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addWindowToken(IBinder binder, int type, int displayId) {
        DisplayContent dc;
        block7: {
            if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
                throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
            }
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                dc = this.mRoot.getDisplayContent(displayId);
                WindowToken token = dc.getWindowToken(binder);
                if (token == null) break block7;
                Slog.w(TAG, "addWindowToken: Attempted to add binder token: " + binder + " for already created window token: " + token + " displayId=" + displayId);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (type == 2013) {
            new WallpaperWindowToken(this, binder, true, dc, true);
        } else {
            new WindowToken(this, binder, type, true, dc, true);
        }
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeWindowToken(IBinder binder, int displayId) {
        block11: {
            DisplayContent dc;
            long origId;
            block10: {
                if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
                    throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
                }
                origId = Binder.clearCallingIdentity();
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    dc = this.mRoot.getDisplayContent(displayId);
                    if (dc != null) break block10;
                    Slog.w(TAG, "removeWindowToken: Attempted to remove token: " + binder + " for non-exiting displayId=" + displayId);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                Binder.restoreCallingIdentity(origId);
                return;
            }
            WindowToken token = dc.removeWindowToken(binder);
            if (token != null) break block11;
            Slog.w(TAG, "removeWindowToken: Attempted to remove non-existing token: " + binder);
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            Binder.restoreCallingIdentity(origId);
            return;
        }
        this.mInputMonitor.updateInputWindowsLw(true);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
    }

    @Override
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded, int displayId) {
        return this.updateOrientationFromAppTokens(currentConfig, freezeThisOneIfNeeded, displayId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded, int displayId, boolean forceUpdate) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Configuration config;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded, displayId, forceUpdate);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return config;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded, int displayId, boolean forceUpdate) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(displayId, forceUpdate)) {
            AppWindowToken atoken;
            if (freezeThisOneIfNeeded != null && !this.mRoot.mOrientationChangeComplete && (atoken = this.mRoot.getAppWindowToken(freezeThisOneIfNeeded)) != null) {
                atoken.startFreezingScreen();
            }
            config = this.computeNewConfigurationLocked(displayId);
        } else if (currentConfig != null) {
            this.mTempConfiguration.unset();
            this.mTempConfiguration.updateFrom(currentConfig);
            DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
            displayContent.computeScreenConfiguration(this.mTempConfiguration);
            if (currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                displayContent.setLayoutNeeded();
                int[] anim2 = new int[2];
                this.mPolicy.selectRotationAnimationLw(anim2);
                this.startFreezingDisplayLocked(anim2[0], anim2[1], displayContent);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    boolean updateOrientationFromAppTokensLocked(int displayId) {
        return this.updateOrientationFromAppTokensLocked(displayId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(int displayId, boolean forceUpdate) {
        long ident = Binder.clearCallingIdentity();
        try {
            DisplayContent dc = this.mRoot.getDisplayContent(displayId);
            int req = dc.getOrientation();
            if (req != dc.getLastOrientation() || forceUpdate) {
                dc.setLastOrientation(req);
                if (dc.isDefaultDisplay) {
                    this.mPolicy.setCurrentOrientationLw(req);
                }
                boolean bl = dc.updateRotationUnchecked(forceUpdate);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    boolean rotationNeedsUpdateLocked() {
        boolean altOrientation;
        DisplayContent defaultDisplayContent = this.getDefaultDisplayContentLocked();
        int lastOrientation = defaultDisplayContent.getLastOrientation();
        int oldRotation = defaultDisplayContent.getRotation();
        boolean oldAltOrientation = defaultDisplayContent.getAltOrientation();
        int rotation = this.mPolicy.rotationForOrientationLw(lastOrientation, oldRotation, true);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(lastOrientation, rotation);
        return oldRotation != rotation || oldAltOrientation != altOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] setNewDisplayOverrideConfiguration(Configuration overrideConfig, int displayId) {
        int[] nArray;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewDisplayOverrideConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mWaitingForConfig) {
                    this.mWaitingForConfig = false;
                    this.mLastFinishedFreezeSource = "new-config";
                }
                nArray = this.mRoot.setDisplayOverrideConfigurationIfNeeded(overrideConfig, displayId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return nArray;
    }

    void setFocusTaskRegionLocked(AppWindowToken previousFocus) {
        DisplayContent previousDisplayContent;
        Task focusedTask = this.mFocusedApp != null ? this.mFocusedApp.getTask() : null;
        Task previousTask = previousFocus != null ? previousFocus.getTask() : null;
        DisplayContent focusedDisplayContent = focusedTask != null ? focusedTask.getDisplayContent() : null;
        DisplayContent displayContent = previousDisplayContent = previousTask != null ? previousTask.getDisplayContent() : null;
        if (previousDisplayContent != null && previousDisplayContent != focusedDisplayContent) {
            previousDisplayContent.setTouchExcludeRegion(null);
        }
        if (focusedDisplayContent != null) {
            focusedDisplayContent.setTouchExcludeRegion(focusedTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                boolean changed;
                AppWindowToken newFocus;
                WindowManagerService.boostPriorityForLockedSection();
                if (token == null) {
                    newFocus = null;
                } else {
                    newFocus = this.mRoot.getAppWindowToken(token);
                    if (newFocus == null) {
                        Slog.w(TAG, "Attempted to set focus to non-existing app token: " + token);
                    }
                }
                boolean bl = changed = this.mFocusedApp != newFocus;
                if (changed) {
                    AppWindowToken prev = this.mFocusedApp;
                    this.mFocusedApp = newFocus;
                    this.mInputMonitor.setFocusedAppLw(newFocus);
                    this.setFocusTaskRegionLocked(prev);
                }
                if (moveFocusNow && changed) {
                    long origId = Binder.clearCallingIdentity();
                    this.updateFocusedWindowLocked(0, true);
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl28 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        this.prepareAppTransition(transit, alwaysKeepCurrent, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent, int flags, boolean forceOverride) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                boolean prepared = this.mAppTransition.prepareAppTransitionLocked(transit, alwaysKeepCurrent, flags, forceOverride);
                DisplayContent dc = this.mRoot.getDisplayContent(0);
                if (prepared && dc != null && dc.okToAnimate()) {
                    this.mSkipAppTransitionAnimation = false;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public int getPendingAppTransition() {
        return this.mAppTransition.getAppTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransition(packageName, enterAnim, exitAnim, startedCallback);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionScaleUp(startX, startY, startWidth, startHeight);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionClipReveal(startX, startY, startWidth, startHeight);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionThumb(GraphicBuffer srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionThumb(srcThumb, startX, startY, startedCallback, scaleUp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var6_6
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionAspectScaledThumb(GraphicBuffer srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionAspectScaledThumb(srcThumb, startX, startY, targetWidth, targetHeight, startedCallback, scaleUp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var8_8
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumb(AppTransitionAnimationSpec[] specs, IRemoteCallback onAnimationStartedCallback, IRemoteCallback onAnimationFinishedCallback, boolean scaleUp) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionMultiThumb(specs, onAnimationStartedCallback, onAnimationFinishedCallback, scaleUp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overridePendingAppTransitionStartCrossProfileApps() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionStartCrossProfileApps();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionInPlace(String packageName, int anim2) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overrideInPlaceAppTransition(packageName, anim2);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback callback, boolean scaleUp) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionMultiThumbFuture(specsFuture, callback, scaleUp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter) {
        if (!this.checkCallingPermission("android.permission.CONTROL_REMOTE_APP_TRANSITION_ANIMATIONS", "overridePendingAppTransitionRemote()")) {
            throw new SecurityException("Requires CONTROL_REMOTE_APP_TRANSITION_ANIMATIONS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAppTransition.overridePendingAppTransitionRemote(remoteAnimationAdapter);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void endProlongedAnimations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mAppTransition.isTransitionSet()) {
                    this.mAppTransition.setReady();
                    this.mWindowPlacerLocked.requestTraversal();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeRecentsAnimation(int targetActivityType, IRecentsAnimationRunner recentsAnimationRunner, RecentsAnimationController.RecentsAnimationCallbacks callbacks, int displayId, SparseBooleanArray recentTaskIds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRecentsAnimationController = new RecentsAnimationController(this, recentsAnimationRunner, callbacks, displayId);
                this.mAppTransition.updateBooster();
                this.mRecentsAnimationController.initialize(targetActivityType, recentTaskIds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var6_6
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public RecentsAnimationController getRecentsAnimationController() {
        return this.mRecentsAnimationController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean canStartRecentsAnimation() {
        block4: {
            boolean bl;
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mAppTransition.isTransitionSet()) break block4;
                bl = false;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        boolean bl = true;
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    public void cancelRecentsAnimationSynchronously(@RecentsAnimationController.ReorderMode int reorderMode, String reason) {
        if (this.mRecentsAnimationController != null) {
            this.mRecentsAnimationController.cancelAnimationSynchronously(reorderMode, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRecentsAnimation(@RecentsAnimationController.ReorderMode int reorderMode) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mRecentsAnimationController != null) {
                    this.mRecentsAnimationController.cleanupAnimation(reorderMode);
                    this.mRecentsAnimationController = null;
                    this.mAppTransition.updateBooster();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppFullscreen(IBinder token, boolean toOpaque) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken atoken = this.mRoot.getAppWindowToken(token);
                if (atoken != null) {
                    atoken.setFillsParent(toOpaque);
                    this.setWindowOpaqueLocked(token, toOpaque);
                    this.mWindowPlacerLocked.requestTraversal();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowOpaque(IBinder token, boolean isOpaque) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.setWindowOpaqueLocked(token, isOpaque);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private void setWindowOpaqueLocked(IBinder token, boolean isOpaque) {
        WindowState win;
        AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
        if (wtoken != null && (win = wtoken.findMainWindow()) != null) {
            win.mWinAnimator.setOpaqueLocked(isOpaque);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDockedStackCreateState(int mode, Rect bounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.setDockedStackCreateStateLocked(mode, bounds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void setDockedStackCreateStateLocked(int mode, Rect bounds) {
        this.mDockedStackCreateMode = mode;
        this.mDockedStackCreateBounds = bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSplitScreenMinimizedChanged(boolean animate) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                displayContent.getDockedDividerController().checkMinimizeChanged(animate);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public boolean isValidPictureInPictureAspectRatio(int displayId, float aspectRatio) {
        DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
        return displayContent.getPinnedStackController().isValidPictureInPictureAspectRatio(aspectRatio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getStackBounds(int windowingMode, int activityType, Rect bounds) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                TaskStack stack = this.mRoot.getStack(windowingMode, activityType);
                if (stack == null) break block4;
                stack.getBounds(bounds);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        bounds.setEmpty();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void notifyShowingDreamChanged() {
        this.notifyKeyguardFlagsChanged(null);
    }

    @Override
    public WindowManagerPolicy.WindowState getInputMethodWindowLw() {
        return this.mInputMethodWindow;
    }

    @Override
    public void notifyKeyguardTrustedChanged() {
        this.mH.sendEmptyMessage(57);
    }

    @Override
    public void screenTurningOff(WindowManagerPolicy.ScreenOffListener listener) {
        this.mTaskSnapshotController.screenTurningOff(listener);
    }

    @Override
    public void triggerAnimationFailsafe() {
        this.mH.sendEmptyMessage(60);
    }

    @Override
    public void onKeyguardShowingAndNotOccludedChanged() {
        this.mH.sendEmptyMessage(61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferSurfaceLayout() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWindowPlacerLocked.deferLayout();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueSurfaceLayout() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWindowPlacerLocked.continueLayout();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsShowWhenLockedWindow(IBinder token) {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
                bl = wtoken != null && wtoken.containsShowWhenLockedWindow();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsDismissKeyguardWindow(IBinder token) {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
                bl = wtoken != null && wtoken.containsDismissKeyguardWindow();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    void notifyKeyguardFlagsChanged(Runnable callback) {
        Runnable wrappedCallback = callback != null ? () -> {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    callback.run();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        } : null;
        this.mH.obtainMessage(56, wrappedCallback).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isKeyguardTrusted() {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mPolicy.isKeyguardTrustedLw();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyguardGoingAway(boolean keyguardGoingAway) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mKeyguardGoingAway = keyguardGoingAway;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyguardOrAodShowingOnDefaultDisplay(boolean showing) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mKeyguardOrAodShowingOnDefaultDisplay = showing;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFreezingScreen(int exitAnim, int enterAnim) {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "startFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mClientFreezingScreen) {
                    this.mClientFreezingScreen = true;
                    long origId = Binder.clearCallingIdentity();
                    try {
                        this.startFreezingDisplayLocked(exitAnim, enterAnim);
                        this.mH.removeMessages(30);
                        this.mH.sendEmptyMessageDelayed(30, 5000L);
                    }
                    finally {
                        Binder.restoreCallingIdentity(origId);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFreezingScreen() {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "stopFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mClientFreezingScreen) {
                    this.mClientFreezingScreen = false;
                    this.mLastFinishedFreezeSource = "client";
                    long origId = Binder.clearCallingIdentity();
                    try {
                        this.stopFreezingDisplayLocked();
                    }
                    finally {
                        Binder.restoreCallingIdentity(origId);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (Binder.getCallingUid() != 1000 && this.isKeyguardSecure()) {
            Log.d(TAG, "current mode is SecurityMode, ignore disableKeyguard");
            return;
        }
        if (!this.isCurrentProfileLocked(UserHandle.getCallingUserId())) {
            Log.d(TAG, "non-current profiles, ignore disableKeyguard");
            return;
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(1, new Pair<IBinder, String>(token, tag)));
    }

    @Override
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(2, token));
    }

    @Override
    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            @Override
            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    public boolean isKeyguardShowingAndNotOccluded() {
        return this.mPolicy.isKeyguardShowingAndNotOccluded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardSecure() {
        int userId = UserHandle.getCallingUserId();
        long origId = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mPolicy.isKeyguardSecure(userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isShowingDream() {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mPolicy.isShowingDreamLw();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) {
        if (!this.checkCallingPermission("android.permission.CONTROL_KEYGUARD", "dismissKeyguard")) {
            throw new SecurityException("Requires CONTROL_KEYGUARD permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.dismissKeyguardLw(callback, message);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyguardOccludedChanged(boolean occluded) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.onKeyguardOccludedChangedLw(occluded);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSwitchingUser(boolean switching) {
        if (!this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "setSwitchingUser()")) {
            throw new SecurityException("Requires INTERACT_ACROSS_USERS_FULL permission");
        }
        this.mPolicy.setSwitchingUser(switching);
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mSwitchingUser = switching;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void showGlobalActions() {
        this.mPolicy.showGlobalActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.closeSystemDialogs(reason);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    @Override
    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        scale = WindowManagerService.fixScale(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScaleSetting = scale;
                break;
            }
            case 1: {
                this.mTransitionAnimationScaleSetting = scale;
                break;
            }
            case 2: {
                this.mAnimatorDurationScaleSetting = scale;
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    @Override
    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScaleSetting = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScaleSetting = WindowManagerService.fixScale(scales[1]);
            }
            if (scales.length >= 3) {
                this.mAnimatorDurationScaleSetting = WindowManagerService.fixScale(scales[2]);
                this.dispatchNewAnimatorScaleLocked(null);
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    private void setAnimatorDurationScale(float scale) {
        this.mAnimatorDurationScaleSetting = scale;
        ValueAnimator.setDurationScale(scale);
    }

    public float getWindowAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mWindowAnimationScaleSetting;
    }

    public float getTransitionAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mTransitionAnimationScaleSetting;
    }

    @Override
    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScaleSetting;
            }
            case 1: {
                return this.mTransitionAnimationScaleSetting;
            }
            case 2: {
                return this.mAnimatorDurationScaleSetting;
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScaleSetting, this.mTransitionAnimationScaleSetting, this.mAnimatorDurationScaleSetting};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getCurrentAnimatorScale() {
        float f;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                f = this.mAnimationsDisabled ? 0.0f : this.mAnimatorDurationScaleSetting;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return f;
    }

    void dispatchNewAnimatorScaleLocked(Session session) {
        this.mH.obtainMessage(34, session).sendToTarget();
    }

    @Override
    public void registerPointerEventListener(WindowManagerPolicyConstants.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    @Override
    public void unregisterPointerEventListener(WindowManagerPolicyConstants.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    boolean canDispatchPointerEvents() {
        return this.mPointerEventDispatcher != null;
    }

    @Override
    public int getLidState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 0);
        if (sw > 0) {
            return 0;
        }
        if (sw == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public void lockDeviceNow() {
        this.lockNow(null);
    }

    @Override
    public int getCameraLensCoverState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 9);
        if (sw > 0) {
            return 1;
        }
        if (sw == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public void switchKeyboardLayout(int deviceId, int direction) {
        this.mInputManager.switchKeyboardLayout(deviceId, direction);
    }

    @Override
    public void switchInputMethod(boolean forwardDirection) {
        InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
        if (inputMethodManagerInternal != null) {
            inputMethodManagerInternal.switchInputMethod(forwardDirection);
        }
    }

    @Override
    public void shutdown(boolean confirm) {
        ShutdownThread.shutdown(ActivityThread.currentActivityThread().getSystemUiContext(), "userrequested", confirm);
    }

    @Override
    public void reboot(boolean confirm) {
        ShutdownThread.reboot(ActivityThread.currentActivityThread().getSystemUiContext(), "userrequested", confirm);
    }

    @Override
    public void rebootSafeMode(boolean confirm) {
        ShutdownThread.rebootSafeMode(ActivityThread.currentActivityThread().getSystemUiContext(), confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentProfileIds(int[] currentProfileIds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mCurrentProfileIds = currentProfileIds;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newUserId, int[] currentProfileIds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mCurrentUserId = newUserId;
                this.mCurrentProfileIds = currentProfileIds;
                this.mAppTransition.setCurrentUser(newUserId);
                this.mPolicy.setCurrentUserLw(newUserId);
                this.mPolicy.enableKeyguard(true);
                this.mRoot.switchUser();
                this.mWindowPlacerLocked.performSurfacePlacement();
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                TaskStack stack = displayContent.getSplitScreenPrimaryStackIgnoringVisibility();
                displayContent.mDividerControllerLocked.notifyDockedStackExistsChanged(stack != null && stack.hasTaskForUser(newUserId));
                if (this.mDisplayReady) {
                    int forcedDensity = this.getForcedDisplayDensityForUserLocked(newUserId);
                    int targetDensity = forcedDensity != 0 ? forcedDensity : displayContent.mInitialDisplayDensity;
                    this.setForcedDisplayDensityLocked(displayContent, targetDensity);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUserId) {
            return true;
        }
        for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
            if (this.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void enableScreenAfterBoot() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mSystemBooted) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mSystemBooted = true;
        this.hideBootMessagesLocked();
        this.mH.sendEmptyMessageDelayed(23, 30000L);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableScreenIfNeeded() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.enableScreenIfNeededLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendEmptyMessage(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void performBootTimeout() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mDisplayEnabled) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Slog.w(TAG, "***** BOOT TIMEOUT: forcing display enabled");
        this.mForceDisplayEnabled = true;
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        this.performEnableScreen();
    }

    public void onSystemUiStarted() {
        this.mPolicy.onSystemUiStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void performEnableScreen() {
        var1_1 = this.mWindowMap;
        synchronized (var1_1) {
            WindowManagerService.boostPriorityForLockedSection();
            if (!this.mDisplayEnabled) ** break block14
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (this.mSystemBooted || this.mShowingBootMessages) ** break block15
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (this.mShowingBootMessages || this.mPolicy.canDismissBootAnimation()) ** break block16
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (this.mForceDisplayEnabled || !this.getDefaultDisplayContentLocked().checkWaitingForWindows()) ** break block17
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (!this.mBootAnimationStopped) {
                Trace.asyncTraceBegin(32L, "Stop bootanim", 0);
                SystemProperties.set("service.bootanim.exit", "1");
                this.mBootAnimationStopped = true;
            }
            if (this.mForceDisplayEnabled || this.checkBootAnimationCompleteLocked()) ** break block18
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {
                try {
                    surfaceFlinger = ServiceManager.getService("SurfaceFlinger");
                    if (surfaceFlinger != null) {
                        Slog.i("WindowManager", "******* TELLING SURFACE FLINGER WE ARE BOOTED!");
                        data = Parcel.obtain();
                        data.writeInterfaceToken("android.ui.ISurfaceComposer");
                        surfaceFlinger.transact(1, data, null, 0);
                        data.recycle();
                    }
                }
                catch (RemoteException ex) {
                    Slog.e("WindowManager", "Boot completed: SurfaceFlinger is dead!");
                }
                EventLog.writeEvent(31007, SystemClock.uptimeMillis());
                Trace.asyncTraceEnd(32L, "Stop bootanim", 0);
                this.mDisplayEnabled = true;
                this.mInputMonitor.setEventDispatchingLw(this.mEventDispatchingEnabled);
            }
            catch (Throwable var4_6) {
                // MONITOREXIT @DISABLED, blocks:[8, 10] lbl57 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var4_6;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mActivityManager.bootAnimationComplete();
        }
        catch (RemoteException var1_2) {
            // empty catch block
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false, false);
    }

    private boolean checkBootAnimationCompleteLocked() {
        if (SystemService.isRunning(BOOT_ANIMATION_SERVICE)) {
            this.mH.removeMessages(37);
            this.mH.sendEmptyMessageDelayed(37, 200L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        first = false;
        var4_4 = this.mWindowMap;
        synchronized (var4_4) {
            WindowManagerService.boostPriorityForLockedSection();
            if (this.mAllowBootMessages) ** break block7
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (this.mShowingBootMessages) ** GOTO lbl18
            if (always) ** break block8
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            first = true;
lbl18:
            // 2 sources

            if (!this.mSystemBooted) ** break block9
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {
                this.mShowingBootMessages = true;
                this.mPolicy.showBootMessage(msg, always);
            }
            catch (Throwable var5_5) {
                // MONITOREXIT @DISABLED, blocks:[4, 5] lbl28 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var5_5;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mInTouchMode = mode;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircularDisplayMaskIfNeeded() {
        block3: {
            int currentUserId;
            if (!this.mContext.getResources().getConfiguration().isScreenRound() || !this.mContext.getResources().getBoolean(17957098)) break block3;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    currentUserId = this.mCurrentUserId;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            int inversionState = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_inversion_enabled", 0, currentUserId);
            int showMask = inversionState == 1 ? 0 : 1;
            Message m = this.mH.obtainMessage(35);
            m.arg1 = showMask;
            this.mH.sendMessage(m);
        }
    }

    public void showEmulatorDisplayOverlayIfNeeded() {
        if (this.mContext.getResources().getBoolean(17957094) && SystemProperties.getBoolean(PROPERTY_EMULATOR_CIRCULAR, false) && Build.IS_EMULATOR) {
            this.mH.sendMessage(this.mH.obtainMessage(36));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCircularMask(boolean visible) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.openSurfaceTransaction();
                try {
                    if (visible) {
                        if (this.mCircularDisplayMask == null) {
                            int screenOffset = this.mContext.getResources().getInteger(17694934);
                            int maskThickness = this.mContext.getResources().getDimensionPixelSize(17104956);
                            this.mCircularDisplayMask = new CircularDisplayMask(this.getDefaultDisplayContentLocked(), this.mPolicy.getWindowLayerFromTypeLw(2018) * 10000 + 10, screenOffset, maskThickness);
                        }
                        this.mCircularDisplayMask.setVisibility(true);
                    } else if (this.mCircularDisplayMask != null) {
                        this.mCircularDisplayMask.setVisibility(false);
                        this.mCircularDisplayMask = null;
                    }
                }
                finally {
                    this.closeSurfaceTransaction("showCircularMask");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEmulatorDisplayOverlay() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.openSurfaceTransaction();
                try {
                    if (this.mEmulatorDisplayOverlay == null) {
                        this.mEmulatorDisplayOverlay = new EmulatorDisplayOverlay(this.mContext, this.getDefaultDisplayContentLocked(), this.mPolicy.getWindowLayerFromTypeLw(2018) * 10000 + 10);
                    }
                    this.mEmulatorDisplayOverlay.setVisibility(true);
                }
                finally {
                    this.closeSurfaceTransaction("showEmulatorDisplayOverlay");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void showStrictModeViolation(boolean on) {
        int pid = Binder.getCallingPid();
        if (on) {
            this.mH.sendMessage(this.mH.obtainMessage(25, 1, pid));
            this.mH.sendMessageDelayed(this.mH.obtainMessage(25, 0, pid), 1000L);
        } else {
            this.mH.sendMessage(this.mH.obtainMessage(25, 0, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void showStrictModeViolation(int arg, int pid) {
        boolean on;
        block8: {
            on = arg != 0;
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!on || this.mRoot.canShowStrictModeViolation(pid)) break block8;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        SurfaceControl.openTransaction();
        try {
            if (this.mStrictModeFlash == null) {
                this.mStrictModeFlash = new StrictModeFlash(this.getDefaultDisplayContentLocked());
            }
            this.mStrictModeFlash.setVisibility(on);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set("persist.sys.strictmode.visual", value);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Bitmap screenshotWallpaper() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestAssistScreenshot(IAssistDataReceiver receiver) {
        Bitmap bm;
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "requestAssistScreenshot()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(0);
                bm = displayContent == null ? null : displayContent.screenshotDisplayLocked(Bitmap.Config.ARGB_8888);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        FgThread.getHandler().post(() -> {
            try {
                receiver.onHandleAssistScreenshot(bm);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
        return true;
    }

    public ActivityManager.TaskSnapshot getTaskSnapshot(int taskId, int userId, boolean reducedResolution) {
        return this.mTaskSnapshotController.getSnapshot(taskId, userId, true, reducedResolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObsoleteTaskFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mTaskSnapshotController.removeObsoleteTaskFiles(persistentTaskIds, runningUserIds);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        int defaultDisplayRotation = this.getDefaultDisplayRotation();
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(1, rotation == -1 ? defaultDisplayRotation : rotation);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(0, 777);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        this.updateRotationUnchecked(alwaysSendConfiguration, forceRelayout);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            DisplayContent displayContent;
            boolean changed;
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0 && (changed = (displayContent = this.getDefaultDisplayContentLocked()).updateRotationUnchecked())) {
                this.mH.obtainMessage(18, displayContent.getDisplayId()).sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRotationUnchecked(boolean alwaysSendConfiguration, boolean forceRelayout) {
        Trace.traceBegin(32L, "updateRotation");
        long origId = Binder.clearCallingIdentity();
        try {
            int displayId;
            boolean rotationChanged;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                    Trace.traceBegin(32L, "updateRotation: display");
                    rotationChanged = displayContent.updateRotationUnchecked();
                    Trace.traceEnd(32L);
                    if (!rotationChanged || forceRelayout) {
                        displayContent.setLayoutNeeded();
                        Trace.traceBegin(32L, "updateRotation: performSurfacePlacement");
                        this.mWindowPlacerLocked.performSurfacePlacement();
                        Trace.traceEnd(32L);
                    }
                    displayId = displayContent.getDisplayId();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var7_4
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            if (rotationChanged || alwaysSendConfiguration) {
                Trace.traceBegin(32L, "updateRotation: sendNewConfiguration");
                this.sendNewConfiguration(displayId);
                Trace.traceEnd(32L);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDefaultDisplayRotation() {
        int n;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                n = this.getDefaultDisplayContentLocked().getRotation();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    @Override
    public boolean isRotationFrozen() {
        return this.mPolicy.getUserRotationMode() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int watchRotation(IRotationWatcher watcher, int displayId) {
        int n;
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
                synchronized (windowHashMap) {
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                            if (watcherBinder != WindowManagerService.this.mRotationWatchers.get((int)i).mWatcher.asBinder()) continue;
                            RotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                            IBinder binder = removed.mWatcher.asBinder();
                            if (binder != null) {
                                binder.unlinkToDeath(this, 0);
                            }
                            --i;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                WindowManagerService.resetPriorityAfterLockedSection();
            }
        };
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    watcher.asBinder().linkToDeath(dr, 0);
                    this.mRotationWatchers.add(new RotationWatcher(watcher, dr, displayId));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                n = this.getDefaultDisplayRotation();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl18 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRotationWatcher(IRotationWatcher watcher) {
        IBinder watcherBinder = watcher.asBinder();
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                for (int i = 0; i < this.mRotationWatchers.size(); ++i) {
                    RotationWatcher rotationWatcher = this.mRotationWatchers.get(i);
                    if (watcherBinder != rotationWatcher.mWatcher.asBinder()) continue;
                    RotationWatcher removed = this.mRotationWatchers.remove(i);
                    IBinder binder = removed.mWatcher.asBinder();
                    if (binder != null) {
                        binder.unlinkToDeath(removed.mDeathRecipient, 0);
                    }
                    --i;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                if (displayContent == null) {
                    throw new IllegalArgumentException("Trying to register visibility event for invalid display: " + displayId);
                }
                this.mWallpaperVisibilityListeners.registerWallpaperVisibilityListener(listener, displayId);
                bl = displayContent.mWallpaperController.isWallpaperVisible();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWallpaperVisibilityListeners.unregisterWallpaperVisibilityListener(listener, displayId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPreferredOptionsPanelGravity() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w(TAG, "View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w(TAG, "View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get(SYSTEM_SECURE, "1")) && "0".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
    }

    @Override
    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    @Override
    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        ArrayList windows = new ArrayList();
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.forAllWindows(w -> windows.add(w), false);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[6, 7] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w2 = (WindowState)windows.get(i);
                out.write(Integer.toHexString(System.identityHashCode(w2)));
                out.write(32);
                out.append(w2.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket(client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not send command " + command + " with parameters " + parameters, e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWindowChangeListeners.add(listener);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWindowChangeListeners.remove(listener);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyWindowsChanged() {
        block5: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mWindowChangeListeners.isEmpty()) break block5;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        WindowChangeListener[] windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
        windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        int N = windowChangeListeners.length;
        int i = 0;
        while (i < N) {
            windowChangeListeners[i].windowsChanged();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyFocusChanged() {
        block5: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mWindowChangeListeners.isEmpty()) break block5;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        WindowChangeListener[] windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
        windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        int N = windowChangeListeners.length;
        int i = 0;
        while (i < N) {
            windowChangeListeners[i].focusChanged();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WindowState findWindow(int hashCode) {
        WindowState windowState;
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                windowState = this.mRoot.getWindow(w -> System.identityHashCode(w) == hashCode);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return windowState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendNewConfiguration(int displayId) {
        try {
            boolean configUpdated = this.mActivityManager.updateDisplayOverrideConfiguration(null, displayId);
            if (configUpdated) return;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mWaitingForConfig) {
                        this.mWaitingForConfig = false;
                        this.mLastFinishedFreezeSource = "config-unchanged";
                        DisplayContent dc = this.mRoot.getDisplayContent(displayId);
                        if (dc != null) {
                            dc.setLayoutNeeded();
                        }
                        this.mWindowPlacerLocked.performSurfacePlacement();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl18 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration computeNewConfiguration(int displayId) {
        Configuration configuration;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                configuration = this.computeNewConfigurationLocked(displayId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return configuration;
    }

    private Configuration computeNewConfigurationLocked(int displayId) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = new Configuration();
        DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
        displayContent.computeScreenConfiguration(config);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean available;
        WindowManagerInternal.OnHardKeyboardStatusChangeListener listener;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                listener = this.mHardKeyboardStatusChangeListener;
                available = this.mHardKeyboardAvailable;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setEventDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mEventDispatchingEnabled = enabled;
                if (this.mDisplayEnabled) {
                    this.mInputMonitor.setEventDispatchingLw(enabled);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WindowState getFocusedWindow() {
        WindowState windowState;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                windowState = this.getFocusedWindowLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return windowState;
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    TaskStack getImeFocusStackLocked() {
        return this.mFocusedApp != null && this.mFocusedApp.getTask() != null ? this.mFocusedApp.getTask().mStack : null;
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w(TAG, "Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "safe_boot_disallowed", 0) != 0) {
            return false;
        }
        int menuState = this.mInputManager.getKeyCodeState(-1, -256, 82);
        int sState = this.mInputManager.getKeyCodeState(-1, -256, 47);
        int dpadState = this.mInputManager.getKeyCodeState(-1, 513, 23);
        int trackballState = this.mInputManager.getScanCodeState(-1, 65540, 272);
        int volumeDownState = this.mInputManager.getKeyCodeState(-1, -256, 25);
        this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
        try {
            if (SystemProperties.getInt("persist.sys.safemode", 0) != 0 || SystemProperties.getInt("ro.sys.safemode", 0) != 0) {
                this.mSafeMode = true;
                SystemProperties.set("persist.sys.safemode", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.mSafeMode) {
            Log.i(TAG, "SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")");
            if (SystemProperties.getInt("ro.sys.safemode", 0) == 0) {
                SystemProperties.set("ro.sys.safemode", "1");
            }
        } else {
            Log.i(TAG, "SAFE MODE not enabled");
        }
        this.mPolicy.setSafeMode(this.mSafeMode);
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        int displayCount = this.mRoot.mChildren.size();
        for (int i = 0; i < displayCount; ++i) {
            DisplayContent display = (DisplayContent)this.mRoot.mChildren.get(i);
            this.displayReady(display.getDisplayId());
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                if (this.mMaxUiWidth > 0) {
                    displayContent.setMaxUiWidth(this.mMaxUiWidth);
                }
                this.readForcedDisplayPropertiesLocked(displayContent);
                this.mDisplayReady = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[4, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var2_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mIsTouchDevice = this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
                this.getDefaultDisplayContentLocked().configureDisplayPolicy();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl37 : MonitorExitStatement: MONITOREXIT : var2_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.updateCircularDisplayMaskIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayReady(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                if (displayContent != null) {
                    this.mAnimator.addDisplayLocked(displayId);
                    displayContent.initializeDisplayBaseInfo();
                    this.reconfigureDisplayLocked(displayContent);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public void systemReady() {
        this.mPolicy.systemReady();
        this.mTaskSnapshotController.systemReady();
        this.mHasWideColorGamutSupport = WindowManagerService.queryWideColorGamutSupport();
    }

    private static boolean queryWideColorGamutSupport() {
        try {
            ISurfaceFlingerConfigs surfaceFlinger = ISurfaceFlingerConfigs.getService();
            OptionalBool hasWideColor = surfaceFlinger.hasWideColorDisplay();
            if (hasWideColor != null) {
                return hasWideColor.value;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    void destroyPreservedSurfaceLocked() {
        for (int i = this.mDestroyPreservedSurface.size() - 1; i >= 0; --i) {
            WindowState w = this.mDestroyPreservedSurface.get(i);
            w.mWinAnimator.destroyPreservedSurfaceLocked();
        }
        this.mDestroyPreservedSurface.clear();
    }

    @Override
    public IWindowSession openSession(IWindowSessionCallback callback, IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, callback, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        block6: {
            block5: {
                boolean bl;
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (!this.getDefaultDisplayContentLocked().inputMethodClientHasFocus(client)) break block5;
                    bl = true;
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (this.mCurrentFocus == null || this.mCurrentFocus.mSession.mClient == null || this.mCurrentFocus.mSession.mClient.asBinder() != client.asBinder()) break block6;
            boolean bl = true;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInitialDisplaySize(int displayId, Point size) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                    size.x = displayContent.mInitialDisplayWidth;
                    size.y = displayContent.mInitialDisplayHeight;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBaseDisplaySize(int displayId, Point size) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                    size.x = displayContent.mBaseDisplayWidth;
                    size.y = displayContent.mBaseDisplayHeight;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setForcedDisplaySize(int displayId, int width, int height) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    int MIN_WIDTH = 200;
                    int MIN_HEIGHT = 200;
                    int MAX_SCALE = 2;
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null) {
                        width = Math.min(Math.max(width, 200), displayContent.mInitialDisplayWidth * 2);
                        height = Math.min(Math.max(height, 200), displayContent.mInitialDisplayHeight * 2);
                        this.setForcedDisplaySizeLocked(displayContent, width, height);
                        Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", width + "," + height);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl24 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setForcedDisplayScalingMode(int displayId, int mode) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null) {
                        if (mode < 0 || mode > 1) {
                            mode = 0;
                        }
                        this.setForcedDisplayScalingModeLocked(displayContent, mode);
                        Settings.Global.putInt(this.mContext.getContentResolver(), "display_scaling_force", mode);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setForcedDisplayScalingModeLocked(DisplayContent displayContent, int mode) {
        Slog.i(TAG, "Using display scaling mode: " + (mode == 0 ? "auto" : "off"));
        displayContent.mDisplayScalingDisabled = mode != 0;
        this.reconfigureDisplayLocked(displayContent);
    }

    private void readForcedDisplayPropertiesLocked(DisplayContent displayContent) {
        int mode;
        int density;
        int pos;
        String sizeStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_size_forced");
        if (sizeStr == null || sizeStr.length() == 0) {
            sizeStr = SystemProperties.get(SIZE_OVERRIDE, null);
        }
        if (sizeStr != null && sizeStr.length() > 0 && (pos = sizeStr.indexOf(44)) > 0 && sizeStr.lastIndexOf(44) == pos) {
            try {
                int width = Integer.parseInt(sizeStr.substring(0, pos));
                int height = Integer.parseInt(sizeStr.substring(pos + 1));
                if (displayContent.mBaseDisplayWidth != width || displayContent.mBaseDisplayHeight != height) {
                    Slog.i(TAG, "FORCED DISPLAY SIZE: " + width + "x" + height);
                    displayContent.updateBaseDisplayMetrics(width, height, displayContent.mBaseDisplayDensity);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((density = this.getForcedDisplayDensityForUserLocked(this.mCurrentUserId)) != 0) {
            displayContent.mBaseDisplayDensity = density;
        }
        if ((mode = Settings.Global.getInt(this.mContext.getContentResolver(), "display_scaling_force", 0)) != 0) {
            Slog.i(TAG, "FORCED DISPLAY SCALING DISABLED");
            displayContent.mDisplayScalingDisabled = true;
        }
    }

    private void setForcedDisplaySizeLocked(DisplayContent displayContent, int width, int height) {
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        displayContent.updateBaseDisplayMetrics(width, height, displayContent.mBaseDisplayDensity);
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearForcedDisplaySize(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null) {
                        this.setForcedDisplaySizeLocked(displayContent, displayContent.mInitialDisplayWidth, displayContent.mInitialDisplayHeight);
                        Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", "");
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl19 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInitialDisplayDensity(int displayId) {
        block5: {
            int n;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                        n = displayContent.mInitialDisplayDensity;
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getBaseDisplayDensity(int displayId) {
        block5: {
            int n;
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                        n = displayContent.mBaseDisplayDensity;
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setForcedDisplayDensityForUser(int displayId, int density, int userId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        int targetUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "setForcedDisplayDensityForUser", null);
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null && this.mCurrentUserId == targetUserId) {
                        this.setForcedDisplayDensityLocked(displayContent, density);
                    }
                    Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", Integer.toString(density), targetUserId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearForcedDisplayDensityForUser(int displayId, int userId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        int callingUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "clearForcedDisplayDensityForUser", null);
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null && this.mCurrentUserId == callingUserId) {
                        this.setForcedDisplayDensityLocked(displayContent, displayContent.mInitialDisplayDensity);
                    }
                    Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", "", callingUserId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private int getForcedDisplayDensityForUserLocked(int userId) {
        String densityStr = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "display_density_forced", userId);
        if (densityStr == null || densityStr.length() == 0) {
            densityStr = SystemProperties.get(DENSITY_OVERRIDE, null);
        }
        if (densityStr != null && densityStr.length() > 0) {
            try {
                return Integer.parseInt(densityStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setForcedDisplayDensityLocked(DisplayContent displayContent, int density) {
        displayContent.mBaseDisplayDensity = density;
        this.reconfigureDisplayLocked(displayContent);
    }

    void reconfigureDisplayLocked(DisplayContent displayContent) {
        if (!displayContent.isReady()) {
            return;
        }
        displayContent.configureDisplayPolicy();
        displayContent.setLayoutNeeded();
        int displayId = displayContent.getDisplayId();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(displayId);
        Configuration currentDisplayConfig = displayContent.getConfiguration();
        this.mTempConfiguration.setTo(currentDisplayConfig);
        displayContent.computeScreenConfiguration(this.mTempConfiguration);
        if (configChanged |= currentDisplayConfig.diff(this.mTempConfiguration) != 0) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(0, 0, displayContent);
            this.mH.obtainMessage(18, displayId).sendToTarget();
        }
        this.mWindowPlacerLocked.performSurfacePlacement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDisplaysInFocusOrder(SparseIntArray displaysInFocusOrder) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mRoot.getDisplaysInFocusOrder(displaysInFocusOrder);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setOverscan(int displayId, int left, int top, int right, int bottom) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                    if (displayContent != null) {
                        this.setOverscanLocked(displayContent, left, top, right, bottom);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl15 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setOverscanLocked(DisplayContent displayContent, int left, int top, int right, int bottom) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        displayInfo.overscanLeft = left;
        displayInfo.overscanTop = top;
        displayInfo.overscanRight = right;
        displayInfo.overscanBottom = bottom;
        this.mDisplaySettings.setOverscanLocked(displayInfo.uniqueId, displayInfo.name, left, top, right, bottom);
        this.mDisplaySettings.writeSettingsLocked();
        this.reconfigureDisplayLocked(displayContent);
    }

    @Override
    public void startWindowTrace() {
        try {
            this.mWindowTracing.startTrace(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stopWindowTrace() {
        this.mWindowTracing.stopTrace(null);
    }

    @Override
    public boolean isWindowTraceEnabled() {
        return this.mWindowTracing.isEnabled();
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = (WindowState)this.mWindowMap.get(client);
        if (win == null) {
            if (throwOnError) {
                throw new IllegalArgumentException("Requested window " + client + " does not exist");
            }
            Slog.w(TAG, "Failed looking up window callers=" + Debug.getCallers(3));
            return null;
        }
        if (session != null && win.mSession != session) {
            if (throwOnError) {
                throw new IllegalArgumentException("Requested window " + client + " is in session " + win.mSession + ", not " + session);
            }
            Slog.w(TAG, "Failed looking up window callers=" + Debug.getCallers(3));
            return null;
        }
        return win;
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (!w.mToken.okToDisplay() && this.mWindowsFreezingScreen != 2) {
            w.setOrientationChanging(true);
            w.mLastFreezeDuration = 0;
            this.mRoot.mOrientationChangeComplete = false;
            if (this.mWindowsFreezingScreen == 0) {
                this.mWindowsFreezingScreen = 1;
                this.mH.removeMessages(11);
                this.mH.sendEmptyMessageDelayed(11, 2000L);
            }
        }
    }

    int handleAnimatingStoppedAndTransitionLocked() {
        int changes = 0;
        this.mAppTransition.setIdle();
        for (int i = this.mNoAnimationNotifyOnTransitionFinished.size() - 1; i >= 0; --i) {
            IBinder token = this.mNoAnimationNotifyOnTransitionFinished.get(i);
            this.mAppTransition.notifyAppTransitionFinishedLocked(token);
        }
        this.mNoAnimationNotifyOnTransitionFinished.clear();
        DisplayContent dc = this.getDefaultDisplayContentLocked();
        dc.mWallpaperController.hideDeferredWallpapersIfNeeded();
        dc.onAppTransitionDone();
        dc.computeImeTarget(true);
        this.mRoot.mWallpaperMayChange = true;
        this.mFocusMayChange = true;
        return changes |= 1;
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.isEmpty() || this.mWaitingForDrawnCallback == null) {
            return;
        }
        for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
            WindowState win = this.mWaitingForDrawn.get(j);
            if (win.mRemoved || !win.mHasSurface || !win.mPolicyVisibility) {
                this.mWaitingForDrawn.remove(win);
                continue;
            }
            if (!win.hasDrawnLw()) continue;
            this.mWaitingForDrawn.remove(win);
        }
        if (this.mWaitingForDrawn.isEmpty()) {
            this.mH.removeMessages(24);
            this.mH.sendEmptyMessage(33);
        }
    }

    void setHoldScreenLocked(Session newHoldScreen) {
        boolean hold;
        boolean bl = hold = newHoldScreen != null;
        if (hold && this.mHoldingScreenOn != newHoldScreen) {
            this.mHoldingScreenWakeLock.setWorkSource(new WorkSource(newHoldScreen.mUid));
        }
        this.mHoldingScreenOn = newHoldScreen;
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (hold != state) {
            if (hold) {
                this.mLastWakeLockHoldingWindow = this.mRoot.mHoldScreenWindow;
                this.mLastWakeLockObscuringWindow = null;
                this.mHoldingScreenWakeLock.acquire();
                this.mPolicy.keepScreenOnStartedLw();
            } else {
                this.mLastWakeLockHoldingWindow = null;
                this.mLastWakeLockObscuringWindow = this.mRoot.mObscuringWindow;
                this.mPolicy.keepScreenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTraversal() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mWindowPlacerLocked.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void scheduleAnimationLocked() {
        if (this.mAnimator != null) {
            this.mAnimator.scheduleAnimation();
        }
    }

    boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.mRoot.computeFocusedWindow();
        if (this.mCurrentFocus != newFocus) {
            Trace.traceBegin(32L, "wmUpdateFocus");
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            boolean imWindowChanged = false;
            if (this.mInputMethodWindow != null) {
                WindowState prevTarget = this.mInputMethodTarget;
                WindowState newTarget = displayContent.computeImeTarget(true);
                boolean bl = imWindowChanged = prevTarget != newTarget;
                if (mode != 1 && mode != 3) {
                    int prevImeAnimLayer = this.mInputMethodWindow.mWinAnimator.mAnimLayer;
                    displayContent.assignWindowLayers(false);
                    imWindowChanged |= prevImeAnimLayer != this.mInputMethodWindow.mWinAnimator.mAnimLayer;
                }
            }
            if (imWindowChanged) {
                this.mWindowsChanged = true;
                displayContent.setLayoutNeeded();
                newFocus = this.mRoot.computeFocusedWindow();
            }
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            if (this.mCurrentFocus != null) {
                this.mWinAddedSinceNullFocus.clear();
                this.mWinRemovedSinceNullFocus.clear();
            }
            int focusChanged = this.mPolicy.focusChangedLw(oldFocus, newFocus);
            if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
                if (mode == 2) {
                    displayContent.performLayout(true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    displayContent.assignWindowLayers(false);
                }
            }
            if ((focusChanged & 1) != 0) {
                displayContent.setLayoutNeeded();
                if (mode == 2) {
                    displayContent.performLayout(true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
            }
            displayContent.adjustForImeIfNeeded();
            displayContent.scheduleToastWindowsTimeoutIfNeededLocked(oldFocus, newFocus);
            Trace.traceEnd(32L);
            return true;
        }
        return false;
    }

    void startFreezingDisplayLocked(int exitAnim, int enterAnim) {
        this.startFreezingDisplayLocked(exitAnim, enterAnim, this.getDefaultDisplayContentLocked());
    }

    void startFreezingDisplayLocked(int exitAnim, int enterAnim, DisplayContent displayContent) {
        if (this.mDisplayFrozen || this.mRotatingSeamlessly) {
            return;
        }
        if (!(displayContent.isReady() && this.mPolicy.isScreenOn() && displayContent.okToAnimate())) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mDisplayFreezeTime = SystemClock.elapsedRealtime();
        this.mLastFinishedFreezeSource = null;
        this.mFrozenDisplayId = displayContent.getDisplayId();
        this.mInputMonitor.freezeInputDispatchingLw();
        this.mPolicy.setLastInputMethodWindowLw(null, null);
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.freeze();
        }
        this.mLatencyTracker.onActionStart(6);
        if (displayContent.isDefaultDisplay) {
            this.mExitAnimId = exitAnim;
            this.mEnterAnimId = enterAnim;
            ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(this.mFrozenDisplayId);
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
            }
            boolean isSecure = displayContent.hasSecureWindowOnScreen();
            displayContent.updateDisplayInfo();
            screenRotationAnimation = new ScreenRotationAnimation(this.mContext, displayContent, this.mPolicy.isDefaultOrientationForced(), isSecure, this);
            this.mAnimator.setScreenRotationAnimationLocked(this.mFrozenDisplayId, screenRotationAnimation);
        }
    }

    void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen == 1 || this.mClientFreezingScreen || !this.mOpeningApps.isEmpty()) {
            return;
        }
        DisplayContent displayContent = this.mRoot.getDisplayContent(this.mFrozenDisplayId);
        int displayId = this.mFrozenDisplayId;
        this.mFrozenDisplayId = -1;
        this.mDisplayFrozen = false;
        this.mInputMonitor.thawInputDispatchingLw();
        this.mLastDisplayFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Screen frozen for ");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, sb);
        if (this.mLastFinishedFreezeSource != null) {
            sb.append(" due to ");
            sb.append(this.mLastFinishedFreezeSource);
        }
        Slog.i(TAG, sb.toString());
        this.mH.removeMessages(17);
        this.mH.removeMessages(30);
        boolean updateRotation = false;
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            if (!this.mPolicy.validateRotationAnimationLw(this.mExitAnimId, this.mEnterAnimId, false)) {
                this.mEnterAnimId = 0;
                this.mExitAnimId = 0;
            }
            if (screenRotationAnimation.dismiss(this.mTransaction, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight, this.mExitAnimId, this.mEnterAnimId)) {
                this.mTransaction.apply();
                this.scheduleAnimationLocked();
            } else {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
                updateRotation = true;
            }
        } else {
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
            }
            updateRotation = true;
        }
        boolean configChanged = this.updateOrientationFromAppTokensLocked(displayId);
        this.mH.removeMessages(15);
        this.mH.sendEmptyMessageDelayed(15, 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= displayContent.updateRotationUnchecked();
        }
        if (configChanged) {
            this.mH.obtainMessage(18, displayId).sendToTarget();
        }
        this.mLatencyTracker.onActionEnd(6);
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension(defUnits, defDps, dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermarkInTransaction() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        FilterInputStream ind = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            ind = new DataInputStream(in);
            String line = ((DataInputStream)ind).readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                this.mWatermark = new Watermark(displayContent, displayContent.mRealDisplayMetrics, toks);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (ind != null) {
                try {
                    ind.close();
                }
                catch (IOException iOException) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecentsVisibility(boolean visible) {
        this.mAmInternal.enforceCallerIsRecentsOrHasPermission("android.permission.STATUS_BAR", "setRecentsVisibility()");
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.setRecentsVisibilityLw(visible);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPipVisibility(boolean visible) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.setPipVisibilityLw(visible);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShelfHeight(boolean visible, int shelfHeight) {
        this.mAmInternal.enforceCallerIsRecentsOrHasPermission("android.permission.STATUS_BAR", "setShelfHeight()");
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getDefaultDisplayContentLocked().getPinnedStackController().setAdjustedForShelf(visible, shelfHeight);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mLastStatusBarVisibility = visibility;
                visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
                this.updateStatusBarVisibilityLocked(visibility);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.setNavBarVirtualKeyHapticFeedbackEnabledLw(enabled);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private boolean updateStatusBarVisibilityLocked(int visibility) {
        if (this.mLastDispatchedSystemUiVisibility == visibility) {
            return false;
        }
        int globalDiff = (visibility ^ this.mLastDispatchedSystemUiVisibility) & 7 & ~visibility;
        this.mLastDispatchedSystemUiVisibility = visibility;
        this.mInputManager.setSystemUiVisibility(visibility);
        this.getDefaultDisplayContentLocked().updateSystemUiVisibility(visibility, globalDiff);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reevaluateStatusBarVisibility() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
                if (this.updateStatusBarVisibilityLocked(visibility)) {
                    this.mWindowPlacerLocked.requestTraversal();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getNavBarPosition() {
        int n;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent defaultDisplayContent = this.getDefaultDisplayContentLocked();
                defaultDisplayContent.performLayout(false, false);
                n = this.mPolicy.getNavBarPosition();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WindowManagerPolicy.InputConsumer createInputConsumer(Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory) {
        WindowManagerPolicy.InputConsumer inputConsumer;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                inputConsumer = this.mInputMonitor.createInputConsumer(looper, name, inputEventReceiverFactory);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return inputConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInputConsumer(IBinder token, String name, InputChannel inputChannel) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mInputMonitor.createInputConsumer(token, name, inputChannel, Binder.getCallingPid(), Binder.getCallingUserHandle());
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean destroyInputConsumer(String name) {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mInputMonitor.destroyInputConsumer(name);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Region getCurrentImeTouchRegion() {
        Region region;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.RESTRICTED_VR_ACCESS") != 0) {
            throw new SecurityException("getCurrentImeTouchRegion is restricted to VR services");
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                Region r = new Region();
                if (this.mInputMethodWindow != null) {
                    this.mInputMethodWindow.getTouchableRegion(r);
                }
                region = r;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return region;
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    @Override
    public void lockNow(Bundle options) {
        this.mPolicy.lockNow(options);
    }

    public void showRecentApps() {
        this.mPolicy.showRecentApps();
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean clearWindowContentFrameStats(IBinder token) {
        WindowSurfaceController surfaceController;
        block7: {
            WindowState windowState;
            block6: {
                boolean bl;
                if (!this.checkCallingPermission("android.permission.FRAME_STATS", "clearWindowContentFrameStats()")) {
                    throw new SecurityException("Requires FRAME_STATS permission");
                }
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    windowState = (WindowState)this.mWindowMap.get(token);
                    if (windowState != null) break block6;
                    bl = false;
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            surfaceController = windowState.mWinAnimator.mSurfaceController;
            if (surfaceController != null) break block7;
            boolean bl = false;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        boolean bl = surfaceController.clearWindowContentFrameStats();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(IBinder token) {
        WindowContentFrameStats stats;
        block10: {
            WindowSurfaceController surfaceController;
            block9: {
                WindowState windowState;
                block8: {
                    WindowContentFrameStats windowContentFrameStats;
                    if (!this.checkCallingPermission("android.permission.FRAME_STATS", "getWindowContentFrameStats()")) {
                        throw new SecurityException("Requires FRAME_STATS permission");
                    }
                    WindowHashMap windowHashMap = this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        windowState = (WindowState)this.mWindowMap.get(token);
                        if (windowState != null) break block8;
                        windowContentFrameStats = null;
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return windowContentFrameStats;
                }
                surfaceController = windowState.mWinAnimator.mSurfaceController;
                if (surfaceController != null) break block9;
                WindowContentFrameStats windowContentFrameStats = null;
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return windowContentFrameStats;
            }
            if (this.mTempWindowRenderStats == null) {
                this.mTempWindowRenderStats = new WindowContentFrameStats();
            }
            if (surfaceController.getWindowContentFrameStats(stats = this.mTempWindowRenderStats)) break block10;
            WindowContentFrameStats windowContentFrameStats = null;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return windowContentFrameStats;
        }
        WindowContentFrameStats windowContentFrameStats = stats;
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return windowContentFrameStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunching(IBinder token) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
                if (appWindow != null) {
                    appWindow.startRelaunching();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchingFinished(IBinder token) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
                if (appWindow != null) {
                    appWindow.finishRelaunching();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchesCleared(IBinder token) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
                if (appWindow != null) {
                    appWindow.clearRelaunching();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppResumedFinished(IBinder token) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
                if (appWindow != null) {
                    this.mUnknownAppVisibilityController.notifyAppResumedFinished(appWindow);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskRemovedFromRecents(int taskId, int userId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mTaskSnapshotController.notifyTaskRemovedFromRecents(taskId, userId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public int getDockedDividerInsetsLw() {
        return this.getDefaultDisplayContentLocked().getDockedDividerController().getContentInsets();
    }

    private void dumpPolicyLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", pw, args);
    }

    private void dumpAnimatorLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER ANIMATOR STATE (dumpsys window animator)");
        this.mAnimator.dumpLocked(pw, "    ", dumpAll);
    }

    private void dumpTokensLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        this.mRoot.dumpTokens(pw, dumpAll);
        if (!this.mOpeningApps.isEmpty() || !this.mClosingApps.isEmpty()) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
        }
    }

    private void dumpSessionsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        for (int i = 0; i < this.mSessions.size(); ++i) {
            Session s = this.mSessions.valueAt(i);
            pw.print("  Session ");
            pw.print(s);
            pw.println(':');
            s.dump(pw, "    ");
        }
    }

    void writeToProtoLocked(ProtoOutputStream proto, boolean trim) {
        this.mPolicy.writeToProto(proto, 0x10B00000001L);
        this.mRoot.writeToProto(proto, 1146756268034L, trim);
        if (this.mCurrentFocus != null) {
            this.mCurrentFocus.writeIdentifierToProto(proto, 1146756268035L);
        }
        if (this.mFocusedApp != null) {
            this.mFocusedApp.writeNameToProto(proto, 1138166333444L);
        }
        if (this.mInputMethodWindow != null) {
            this.mInputMethodWindow.writeIdentifierToProto(proto, 1146756268037L);
        }
        proto.write(1133871366150L, this.mDisplayFrozen);
        DisplayContent defaultDisplayContent = this.getDefaultDisplayContentLocked();
        proto.write(1120986464263L, defaultDisplayContent.getRotation());
        proto.write(1120986464264L, defaultDisplayContent.getLastOrientation());
        this.mAppTransition.writeToProto(proto, 1146756268041L);
    }

    void traceStateLocked(String where) {
        Trace.traceBegin(32L, "traceStateLocked");
        try {
            this.mWindowTracing.traceStateLocked(where, this);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Exception while tracing state", e);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    private void dumpWindowsLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        this.dumpWindowsNoHeaderLocked(pw, dumpAll, windows);
    }

    private void dumpWindowsNoHeaderLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        this.mRoot.dumpWindowsNoHeader(pw, dumpAll, windows);
        if (!this.mHidingNonSystemOverlayWindows.isEmpty()) {
            pw.println();
            pw.println("  Hiding System Alert Windows:");
            for (i = this.mHidingNonSystemOverlayWindows.size() - 1; i >= 0; --i) {
                w = this.mHidingNonSystemOverlayWindows.get(i);
                pw.print("  #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                WindowState win = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(win);
            }
        }
        pw.println();
        pw.print("  mGlobalConfiguration=");
        pw.println(this.mRoot.getConfiguration());
        pw.print("  mHasPermanentDpad=");
        pw.println(this.mHasPermanentDpad);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.println(this.mInTouchMode);
        pw.print("  mLastDisplayFreezeDuration=");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, pw);
        if (this.mLastFinishedFreezeSource != null) {
            pw.print(" due to ");
            pw.print(this.mLastFinishedFreezeSource);
        }
        pw.println();
        pw.print("  mLastWakeLockHoldingWindow=");
        pw.print(this.mLastWakeLockHoldingWindow);
        pw.print(" mLastWakeLockObscuringWindow=");
        pw.print(this.mLastWakeLockObscuringWindow);
        pw.println();
        this.mInputMonitor.dump(pw, "  ");
        this.mUnknownAppVisibilityController.dump(pw, "  ");
        this.mTaskSnapshotController.dump(pw, "  ");
        if (dumpAll) {
            pw.print("  mSystemDecorLayer=");
            pw.print(this.mSystemDecorLayer);
            pw.print(" mScreenRect=");
            pw.println(this.mScreenRect.toShortString());
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            this.mWindowPlacerLocked.dump(pw, "  ");
            this.mRoot.mWallpaperController.dump(pw, "  ");
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            this.mRoot.dumpLayoutNeededDisplayIds(pw);
            pw.print("  mTransactionSequence=");
            pw.println(this.mTransactionSequence);
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" windows=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" client=");
            pw.print(this.mClientFreezingScreen);
            pw.print(" apps=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" waitingForConfig=");
            pw.println(this.mWaitingForConfig);
            DisplayContent defaultDisplayContent = this.getDefaultDisplayContentLocked();
            pw.print("  mRotation=");
            pw.print(defaultDisplayContent.getRotation());
            pw.print(" mAltOrientation=");
            pw.println(defaultDisplayContent.getAltOrientation());
            pw.print("  mLastWindowForcedOrientation=");
            pw.print(defaultDisplayContent.getLastWindowForcedOrientation());
            pw.print(" mLastOrientation=");
            pw.println(defaultDisplayContent.getLastOrientation());
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  Animation settings: disabled=");
            pw.print(this.mAnimationsDisabled);
            pw.print(" window=");
            pw.print(this.mWindowAnimationScaleSetting);
            pw.print(" transition=");
            pw.print(this.mTransitionAnimationScaleSetting);
            pw.print(" animator=");
            pw.println(this.mAnimatorDurationScaleSetting);
            pw.print("  mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
            pw.println("  mLayoutToAnim:");
            this.mAppTransition.dump(pw, "    ");
            if (this.mRecentsAnimationController != null) {
                pw.print("  mRecentsAnimationController=");
                pw.println(this.mRecentsAnimationController);
                this.mRecentsAnimationController.dump(pw, "    ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dumpWindows(PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<WindowState> windows = new ArrayList<WindowState>();
        if ("apps".equals(name) || "visible".equals(name) || "visible-apps".equals(name)) {
            boolean appsOnly = name.contains("apps");
            boolean visibleOnly = name.contains("visible");
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (appsOnly) {
                        this.mRoot.dumpDisplayContents(pw);
                    }
                    this.mRoot.forAllWindows(w -> {
                        if (!(visibleOnly && !w.mWinAnimator.getShown() || appsOnly && w.mAppToken == null)) {
                            windows.add((WindowState)w);
                        }
                    }, true);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 12] lbl15 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        } else {
            WindowHashMap windowHashMap = this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.mRoot.getWindowsByName(windows, name);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 11] lbl28 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }
        if (windows.size() <= 0) {
            return false;
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.dumpWindowsLocked(pw, dumpAll, windows);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl42 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return true;
    }

    private void dumpLastANRLocked(PrintWriter pw) {
        pw.println("WINDOW MANAGER LAST ANR (dumpsys window lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    void saveANRStateLocked(AppWindowToken appWindowToken, WindowState windowState, String reason) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        pw.println("  ANR time: " + DateFormat.getDateTimeInstance().format(new Date()));
        if (appWindowToken != null) {
            pw.println("  Application at fault: " + appWindowToken.stringName);
        }
        if (windowState != null) {
            pw.println("  Window at fault: " + windowState.mAttrs.getTitle());
        }
        if (reason != null) {
            pw.println("  Reason: " + reason);
        }
        if (!this.mWinAddedSinceNullFocus.isEmpty()) {
            pw.println("  Windows added since null focus: " + this.mWinAddedSinceNullFocus);
        }
        if (!this.mWinRemovedSinceNullFocus.isEmpty()) {
            pw.println("  Windows removed since null focus: " + this.mWinRemovedSinceNullFocus);
        }
        ((PrintWriter)pw).println();
        this.dumpWindowsNoHeaderLocked(pw, true, null);
        ((PrintWriter)pw).println();
        pw.println("Last ANR continued");
        this.mRoot.dumpDisplayContents(pw);
        ((PrintWriter)pw).close();
        this.mLastANRState = sw.toString();
        this.mH.removeMessages(38);
        this.mH.sendEmptyMessageDelayed(38, 0x6DDD00L);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        PriorityDump.dump(this.mPriorityDumper, fd, pw, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(FileDescriptor fd, PrintWriter pw, String[] args, boolean useProto) {
        boolean dumpAll;
        block47: {
            String cmd;
            int opti;
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block46: {
                                                    String opt;
                                                    if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
                                                        return;
                                                    }
                                                    dumpAll = false;
                                                    for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
                                                        if ("-a".equals(opt)) {
                                                            dumpAll = true;
                                                            continue;
                                                        }
                                                        if ("-h".equals(opt)) {
                                                            pw.println("Window manager dump options:");
                                                            pw.println("  [-a] [-h] [cmd] ...");
                                                            pw.println("  cmd may be one of:");
                                                            pw.println("    l[astanr]: last ANR information");
                                                            pw.println("    p[policy]: policy state");
                                                            pw.println("    a[animator]: animator state");
                                                            pw.println("    s[essions]: active sessions");
                                                            pw.println("    surfaces: active surfaces (debugging enabled only)");
                                                            pw.println("    d[isplays]: active display contents");
                                                            pw.println("    t[okens]: token list");
                                                            pw.println("    w[indows]: window list");
                                                            pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                                                            pw.println("    be a partial substring in a window name, a");
                                                            pw.println("    Window hex object identifier, or");
                                                            pw.println("    \"all\" for all windows, or");
                                                            pw.println("    \"visible\" for the visible windows.");
                                                            pw.println("    \"visible-apps\" for the visible app windows.");
                                                            pw.println("  -a: include all available server state.");
                                                            pw.println("  --proto: output dump in protocol buffer format.");
                                                            return;
                                                        }
                                                        pw.println("Unknown argument: " + opt + "; use -h for help");
                                                    }
                                                    if (!useProto) break block46;
                                                    ProtoOutputStream proto = new ProtoOutputStream(fd);
                                                    WindowHashMap windowHashMap = this.mWindowMap;
                                                    synchronized (windowHashMap) {
                                                        try {
                                                            WindowManagerService.boostPriorityForLockedSection();
                                                            this.writeToProtoLocked(proto, false);
                                                        }
                                                        catch (Throwable throwable) {
                                                            // MONITOREXIT @DISABLED, blocks:[22, 12] lbl41 : MonitorExitStatement: MONITOREXIT : var8_8
                                                            WindowManagerService.resetPriorityAfterLockedSection();
                                                            throw throwable;
                                                        }
                                                    }
                                                    WindowManagerService.resetPriorityAfterLockedSection();
                                                    proto.flush();
                                                    return;
                                                }
                                                if (opti >= args.length) break block47;
                                                cmd = args[opti];
                                                ++opti;
                                                if (!"lastanr".equals(cmd) && !"l".equals(cmd)) break block48;
                                                WindowHashMap windowHashMap = this.mWindowMap;
                                                synchronized (windowHashMap) {
                                                    try {
                                                        WindowManagerService.boostPriorityForLockedSection();
                                                        this.dumpLastANRLocked(pw);
                                                    }
                                                    catch (Throwable throwable) {
                                                        // MONITOREXIT @DISABLED, blocks:[23, 13] lbl59 : MonitorExitStatement: MONITOREXIT : var8_9
                                                        WindowManagerService.resetPriorityAfterLockedSection();
                                                        throw throwable;
                                                    }
                                                }
                                                WindowManagerService.resetPriorityAfterLockedSection();
                                                return;
                                            }
                                            if (!"policy".equals(cmd) && !"p".equals(cmd)) break block49;
                                            WindowHashMap windowHashMap = this.mWindowMap;
                                            synchronized (windowHashMap) {
                                                try {
                                                    WindowManagerService.boostPriorityForLockedSection();
                                                    this.dumpPolicyLocked(pw, args, true);
                                                }
                                                catch (Throwable throwable) {
                                                    // MONITOREXIT @DISABLED, blocks:[24, 14] lbl73 : MonitorExitStatement: MONITOREXIT : var8_10
                                                    WindowManagerService.resetPriorityAfterLockedSection();
                                                    throw throwable;
                                                }
                                            }
                                            WindowManagerService.resetPriorityAfterLockedSection();
                                            return;
                                        }
                                        if (!"animator".equals(cmd) && !"a".equals(cmd)) break block50;
                                        WindowHashMap windowHashMap = this.mWindowMap;
                                        synchronized (windowHashMap) {
                                            try {
                                                WindowManagerService.boostPriorityForLockedSection();
                                                this.dumpAnimatorLocked(pw, args, true);
                                            }
                                            catch (Throwable throwable) {
                                                // MONITOREXIT @DISABLED, blocks:[25, 15] lbl87 : MonitorExitStatement: MONITOREXIT : var8_11
                                                WindowManagerService.resetPriorityAfterLockedSection();
                                                throw throwable;
                                            }
                                        }
                                        WindowManagerService.resetPriorityAfterLockedSection();
                                        return;
                                    }
                                    if (!"sessions".equals(cmd) && !"s".equals(cmd)) break block51;
                                    WindowHashMap windowHashMap = this.mWindowMap;
                                    synchronized (windowHashMap) {
                                        try {
                                            WindowManagerService.boostPriorityForLockedSection();
                                            this.dumpSessionsLocked(pw, true);
                                        }
                                        catch (Throwable throwable) {
                                            // MONITOREXIT @DISABLED, blocks:[16, 26] lbl101 : MonitorExitStatement: MONITOREXIT : var8_12
                                            WindowManagerService.resetPriorityAfterLockedSection();
                                            throw throwable;
                                        }
                                    }
                                    WindowManagerService.resetPriorityAfterLockedSection();
                                    return;
                                }
                                if (!"displays".equals(cmd) && !"d".equals(cmd)) break block52;
                                WindowHashMap windowHashMap = this.mWindowMap;
                                synchronized (windowHashMap) {
                                    try {
                                        WindowManagerService.boostPriorityForLockedSection();
                                        this.mRoot.dumpDisplayContents(pw);
                                    }
                                    catch (Throwable throwable) {
                                        // MONITOREXIT @DISABLED, blocks:[17, 27] lbl115 : MonitorExitStatement: MONITOREXIT : var8_13
                                        WindowManagerService.resetPriorityAfterLockedSection();
                                        throw throwable;
                                    }
                                }
                                WindowManagerService.resetPriorityAfterLockedSection();
                                return;
                            }
                            if (!"tokens".equals(cmd) && !"t".equals(cmd)) break block53;
                            WindowHashMap windowHashMap = this.mWindowMap;
                            synchronized (windowHashMap) {
                                try {
                                    WindowManagerService.boostPriorityForLockedSection();
                                    this.dumpTokensLocked(pw, true);
                                }
                                catch (Throwable throwable) {
                                    // MONITOREXIT @DISABLED, blocks:[18, 28] lbl129 : MonitorExitStatement: MONITOREXIT : var8_14
                                    WindowManagerService.resetPriorityAfterLockedSection();
                                    throw throwable;
                                }
                            }
                            WindowManagerService.resetPriorityAfterLockedSection();
                            return;
                        }
                        if (!"windows".equals(cmd) && !"w".equals(cmd)) break block54;
                        WindowHashMap windowHashMap = this.mWindowMap;
                        synchronized (windowHashMap) {
                            try {
                                WindowManagerService.boostPriorityForLockedSection();
                                this.dumpWindowsLocked(pw, true, null);
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[19, 29] lbl143 : MonitorExitStatement: MONITOREXIT : var8_15
                                WindowManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (!"all".equals(cmd) && !"a".equals(cmd)) break block55;
                    WindowHashMap windowHashMap = this.mWindowMap;
                    synchronized (windowHashMap) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            this.dumpWindowsLocked(pw, true, null);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[20, 30] lbl157 : MonitorExitStatement: MONITOREXIT : var8_16
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (!"containers".equals(cmd)) break block56;
                WindowHashMap windowHashMap = this.mWindowMap;
                synchronized (windowHashMap) {
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        this.mRoot.dumpChildrenNames(pw, " ");
                        pw.println(" ");
                        this.mRoot.forAllWindows(w -> pw.println(w), true);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[21, 31] lbl173 : MonitorExitStatement: MONITOREXIT : var8_17
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (!this.dumpWindows(pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpLastANRLocked(pw);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpPolicyLocked(pw, args, dumpAll);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpAnimatorLocked(pw, args, dumpAll);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpSessionsLocked(pw, dumpAll);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mRoot.dumpDisplayContents(pw);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpTokensLocked(pw, dumpAll);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpWindowsLocked(pw, dumpAll, null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[32, 11] lbl219 : MonitorExitStatement: MONITOREXIT : var7_7
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    DisplayContent getDefaultDisplayContentLocked() {
        return this.mRoot.getDisplayContent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayAdded(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                Display display = this.mDisplayManager.getDisplay(displayId);
                if (display != null) {
                    this.displayReady(displayId);
                }
                this.mWindowPlacerLocked.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayRemoved(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mAnimator.removeDisplayLocked(displayId);
                this.mWindowPlacerLocked.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOverlayChanged() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.onOverlayChangedLw();
                this.getDefaultDisplayContentLocked().updateDisplayInfo();
                this.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayChanged(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                if (displayContent != null) {
                    displayContent.updateDisplayInfo();
                }
                this.mWindowPlacerLocked.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public Object getWindowManagerLock() {
        return this.mWindowMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setWillReplaceWindow(IBinder token, boolean animate) {
        AppWindowToken appWindowToken;
        block6: {
            block5: {
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    appWindowToken = this.mRoot.getAppWindowToken(token);
                    if (appWindowToken != null) break block5;
                    Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (appWindowToken.hasContentToDisplay()) break block6;
            Slog.w(TAG, "Attempted to set replacing window on app token with no content" + token);
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        appWindowToken.setWillReplaceWindows(animate);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void setWillReplaceWindows(IBinder token, boolean childrenOnly) {
        AppWindowToken appWindowToken;
        block8: {
            block7: {
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    appWindowToken = this.mRoot.getAppWindowToken(token);
                    if (appWindowToken != null) break block7;
                    Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (appWindowToken.hasContentToDisplay()) break block8;
            Slog.w(TAG, "Attempted to set replacing window on app token with no content" + token);
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (childrenOnly) {
            appWindowToken.setWillReplaceChildWindows();
        } else {
            appWindowToken.setWillReplaceWindows(false);
        }
        this.scheduleClearWillReplaceWindows(token, true);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void scheduleClearWillReplaceWindows(IBinder token, boolean replacing) {
        AppWindowToken appWindowToken;
        block6: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                appWindowToken = this.mRoot.getAppWindowToken(token);
                if (appWindowToken != null) break block6;
                Slog.w(TAG, "Attempted to reset replacing window on non-existing app token " + token);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (replacing) {
            this.scheduleWindowReplacementTimeouts(appWindowToken);
        } else {
            appWindowToken.clearWillReplaceWindows();
        }
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void scheduleWindowReplacementTimeouts(AppWindowToken appWindowToken) {
        if (!this.mWindowReplacementTimeouts.contains(appWindowToken)) {
            this.mWindowReplacementTimeouts.add(appWindowToken);
        }
        this.mH.removeMessages(46);
        this.mH.sendEmptyMessageDelayed(46, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDockedStackSide() {
        int n;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                TaskStack dockedStack = this.getDefaultDisplayContentLocked().getSplitScreenPrimaryStackIgnoringVisibility();
                n = dockedStack == null ? -1 : dockedStack.getDockSide();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDockedStackResizing(boolean resizing) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getDefaultDisplayContentLocked().getDockedDividerController().setResizing(resizing);
                this.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDockedStackDividerTouchRegion(Rect touchRegion) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getDefaultDisplayContentLocked().getDockedDividerController().setTouchRegion(touchRegion);
                this.setFocusTaskRegionLocked(null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResizeDimLayer(boolean visible, int targetWindowingMode, float alpha) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getDefaultDisplayContentLocked().getDockedDividerController().setResizeDimLayer(visible, targetWindowingMode, alpha);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceResizableTasks(boolean forceResizableTasks) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mForceResizableTasks = forceResizableTasks;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportsPictureInPicture(boolean supportsPictureInPicture) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mSupportsPictureInPicture = supportsPictureInPicture;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    static int dipToPixel(int dip, DisplayMetrics displayMetrics) {
        return (int)TypedValue.applyDimension(1, dip, displayMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDockedStackListener(IDockedStackListener listener) {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerDockedStackListener()")) {
            return;
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getDefaultDisplayContentLocked().mDividerControllerLocked.registerDockedStackListener(listener);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPinnedStackListener(int displayId, IPinnedStackListener listener) {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerPinnedStackListener()")) {
            return;
        }
        if (!this.mSupportsPictureInPicture) {
            return;
        }
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                displayContent.getPinnedStackController().registerPinnedStackListener(listener);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
        try {
            WindowState focusedWindow = this.getFocusedWindow();
            if (focusedWindow != null && focusedWindow.mClient != null) {
                this.getFocusedWindow().mClient.requestAppKeyboardShortcuts(receiver, deviceId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.getStableInsetsLocked(displayId, outInsets);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void getStableInsetsLocked(int displayId, Rect outInsets) {
        outInsets.setEmpty();
        DisplayContent dc = this.mRoot.getDisplayContent(displayId);
        if (dc != null) {
            DisplayInfo di = dc.getDisplayInfo();
            this.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, di.displayCutout, outInsets);
        }
    }

    void intersectDisplayInsetBounds(Rect display, Rect insets, Rect inOutBounds) {
        this.mTmpRect3.set(display);
        this.mTmpRect3.inset(insets);
        inOutBounds.intersect(this.mTmpRect3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updatePointerIcon(IWindow client) {
        WindowState windowUnderPointer;
        float mouseY;
        float mouseX;
        block15: {
            DisplayContent displayContent;
            WindowState callingWin;
            block14: {
                block13: {
                    block12: {
                        Object object = this.mMousePositionTracker;
                        // MONITORENTER : object
                        if (!this.mMousePositionTracker.mLatestEventWasMouse) {
                            // MONITOREXIT : object
                            return;
                        }
                        mouseX = this.mMousePositionTracker.mLatestMouseX;
                        mouseY = this.mMousePositionTracker.mLatestMouseY;
                        // MONITOREXIT : object
                        object = this.mWindowMap;
                        // MONITORENTER : object
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (!this.mDragDropController.dragDropActiveLocked()) break block12;
                            // MONITOREXIT : object
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : object
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    callingWin = this.windowForClientLocked(null, client, false);
                    if (callingWin != null) break block13;
                    Slog.w(TAG, "Bad requesting window " + client);
                    // MONITOREXIT : object
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                displayContent = callingWin.getDisplayContent();
                if (displayContent != null) break block14;
                // MONITOREXIT : object
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            windowUnderPointer = displayContent.getTouchableWinAtPointLocked(mouseX, mouseY);
            if (windowUnderPointer == callingWin) break block15;
            // MONITOREXIT : object
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(mouseX), windowUnderPointer.translateToWindowY(mouseY));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "unable to update pointer icon");
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void restorePointerIconLocked(DisplayContent displayContent, float latestX, float latestY) {
        this.mMousePositionTracker.updatePosition(latestX, latestY);
        WindowState windowUnderPointer = displayContent.getTouchableWinAtPointLocked(latestX, latestY);
        if (windowUnderPointer != null) {
            try {
                windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(latestX), windowUnderPointer.translateToWindowY(latestY));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "unable to restore pointer icon");
            }
        } else {
            InputManager.getInstance().setPointerIconType(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateTapExcludeRegion(IWindow client, int regionId, int left, int top, int width, int height) {
        WindowState callingWin;
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                callingWin = this.windowForClientLocked(null, client, false);
                if (callingWin != null) break block4;
                Slog.w(TAG, "Bad requesting window " + client);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        callingWin.updateTapExcludeRegion(regionId, left, top, width, height);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dontOverrideDisplayInfo(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent dc = this.getDisplayContentOrCreate(displayId);
                if (dc == null) {
                    throw new IllegalArgumentException("Trying to register a non existent display.");
                }
                dc.mShouldOverrideDisplayConfiguration = false;
                this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayId, null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void registerShortcutKey(long shortcutCode, IShortcutService shortcutKeyReceiver) throws RemoteException {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerShortcutKey")) {
            throw new SecurityException("Requires REGISTER_WINDOW_MANAGER_LISTENERS permission");
        }
        this.mPolicy.registerShortcutKey(shortcutCode, shortcutKeyReceiver);
    }

    @Override
    public void requestUserActivityNotification() {
        if (!this.checkCallingPermission("android.permission.USER_ACTIVITY", "requestUserActivityNotification()")) {
            throw new SecurityException("Requires USER_ACTIVITY permission");
        }
        this.mPolicy.requestUserActivityNotification();
    }

    void markForSeamlessRotation(WindowState w, boolean seamlesslyRotated) {
        if (seamlesslyRotated == w.mSeamlesslyRotated) {
            return;
        }
        w.mSeamlesslyRotated = seamlesslyRotated;
        this.mSeamlessRotationCount = seamlesslyRotated ? ++this.mSeamlessRotationCount : --this.mSeamlessRotationCount;
        if (this.mSeamlessRotationCount == 0) {
            this.finishSeamlessRotation();
            DisplayContent displayContent = w.getDisplayContent();
            if (displayContent.updateRotationUnchecked()) {
                this.mH.obtainMessage(18, displayContent.getDisplayId()).sendToTarget();
            }
        }
    }

    void registerAppFreezeListener(AppFreezeListener listener) {
        if (!this.mAppFreezeListeners.contains(listener)) {
            this.mAppFreezeListeners.add(listener);
        }
    }

    void unregisterAppFreezeListener(AppFreezeListener listener) {
        this.mAppFreezeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inSurfaceTransaction(Runnable exec) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                SurfaceControl.openTransaction();
                try {
                    exec.run();
                }
                finally {
                    SurfaceControl.closeTransaction();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void disableNonVrUi(boolean disable) {
        boolean showAlertWindowNotifications;
        block5: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            WindowManagerService.boostPriorityForLockedSection();
            boolean bl = showAlertWindowNotifications = !disable;
            if (showAlertWindowNotifications != this.mShowAlertWindowNotifications) break block5;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            this.mShowAlertWindowNotifications = showAlertWindowNotifications;
            for (int i = this.mSessions.size() - 1; i >= 0; --i) {
                Session s = this.mSessions.valueAt(i);
                s.setShowingAlertWindowNotificationAllowed(this.mShowAlertWindowNotifications);
            }
            // MONITOREXIT : windowHashMap
        }
        catch (Throwable throwable) {
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            throw throwable;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    boolean hasWideColorGamutSupport() {
        return this.mHasWideColorGamutSupport && SystemProperties.getInt("persist.sys.sf.native_mode", 0) != 1;
    }

    void updateNonSystemOverlayWindowsVisibilityIfNeeded(WindowState win, boolean surfaceShown) {
        boolean hideSystemAlertWindows;
        boolean systemAlertWindowsHidden;
        if (!win.hideNonSystemOverlayWindowsWhenVisible() && !this.mHidingNonSystemOverlayWindows.contains(win)) {
            return;
        }
        boolean bl = systemAlertWindowsHidden = !this.mHidingNonSystemOverlayWindows.isEmpty();
        if (surfaceShown) {
            if (!this.mHidingNonSystemOverlayWindows.contains(win)) {
                this.mHidingNonSystemOverlayWindows.add(win);
            }
        } else {
            this.mHidingNonSystemOverlayWindows.remove(win);
        }
        boolean bl2 = hideSystemAlertWindows = !this.mHidingNonSystemOverlayWindows.isEmpty();
        if (systemAlertWindowsHidden == hideSystemAlertWindows) {
            return;
        }
        this.mRoot.forAllWindows(w -> w.setForceHideNonSystemOverlayWindowIfNeeded(hideSystemAlertWindows), false);
    }

    public void applyMagnificationSpec(MagnificationSpec spec) {
        this.getDefaultDisplayContentLocked().applyMagnificationSpec(spec);
    }

    SurfaceControl.Builder makeSurfaceBuilder(SurfaceSession s) {
        return this.mSurfaceBuilderFactory.make(s);
    }

    void sendSetRunningRemoteAnimation(int pid, boolean runningRemoteAnimation) {
        this.mH.obtainMessage(59, pid, runningRemoteAnimation ? 1 : 0).sendToTarget();
    }

    void startSeamlessRotation() {
        this.mSeamlessRotationCount = 0;
        this.mRotatingSeamlessly = true;
    }

    void finishSeamlessRotation() {
        this.mRotatingSeamlessly = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLockTaskStateChanged(int lockTaskState) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mPolicy.onLockTaskStateChangedLw(lockTaskState);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAodShowing(boolean aodShowing) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mPolicy.setAodShowing(aodShowing)) {
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    static /* synthetic */ void access$700(WindowManagerService x0) {
        x0.notifyFocusChanged();
    }

    static /* synthetic */ float access$800(WindowManagerService x0) {
        return x0.mWindowAnimationScaleSetting;
    }

    static /* synthetic */ float access$900(WindowManagerService x0) {
        return x0.mTransitionAnimationScaleSetting;
    }

    static /* synthetic */ float access$1000(WindowManagerService x0) {
        return x0.mAnimatorDurationScaleSetting;
    }

    static /* synthetic */ float access$802(WindowManagerService x0, float x1) {
        x0.mWindowAnimationScaleSetting = x1;
        return x0.mWindowAnimationScaleSetting;
    }

    static /* synthetic */ float access$902(WindowManagerService x0, float x1) {
        x0.mTransitionAnimationScaleSetting = x1;
        return x0.mTransitionAnimationScaleSetting;
    }

    static /* synthetic */ float access$1002(WindowManagerService x0, float x1) {
        x0.mAnimatorDurationScaleSetting = x1;
        return x0.mAnimatorDurationScaleSetting;
    }

    static /* synthetic */ void access$1100(WindowManagerService x0) {
        x0.performEnableScreen();
    }

    static /* synthetic */ void access$1200(WindowManagerService x0) {
        x0.notifyWindowsChanged();
    }

    static /* synthetic */ void access$1300(WindowManagerService x0, int x1, int x2) {
        x0.showStrictModeViolation(x1, x2);
    }

    static /* synthetic */ boolean access$1400(WindowManagerService x0) {
        return x0.checkBootAnimationCompleteLocked();
    }

    static /* synthetic */ RecentsAnimationController access$1500(WindowManagerService x0) {
        return x0.mRecentsAnimationController;
    }

    private final class LocalService
    extends WindowManagerInternal {
        private LocalService() {
        }

        @Override
        public void requestTraversalFromDisplayManager() {
            WindowManagerService.this.requestTraversal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationSpec(MagnificationSpec spec) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mAccessibilityController == null) {
                        throw new IllegalStateException("Magnification callbacks not set!");
                    }
                    WindowManagerService.this.mAccessibilityController.setMagnificationSpecLocked(spec);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            if (Binder.getCallingPid() != Process.myPid()) {
                spec.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setForceShowMagnifiableBounds(boolean show) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mAccessibilityController == null) {
                        throw new IllegalStateException("Magnification callbacks not set!");
                    }
                    WindowManagerService.this.mAccessibilityController.setForceShowMagnifiableBoundsLocked(show);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getMagnificationRegion(Region magnificationRegion) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mAccessibilityController == null) {
                        throw new IllegalStateException("Magnification callbacks not set!");
                    }
                    WindowManagerService.this.mAccessibilityController.getMagnificationRegionLocked(magnificationRegion);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder windowToken) {
            MagnificationSpec spec;
            WindowState windowState;
            block7: {
                block6: {
                    MagnificationSpec magnificationSpec;
                    WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        windowState = (WindowState)WindowManagerService.this.mWindowMap.get(windowToken);
                        if (windowState != null) break block6;
                        magnificationSpec = null;
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return magnificationSpec;
                }
                spec = null;
                if (WindowManagerService.this.mAccessibilityController != null) {
                    spec = WindowManagerService.this.mAccessibilityController.getMagnificationSpecForWindowLocked(windowState);
                }
                if (spec != null && !spec.isNop() || windowState.mGlobalScale != 1.0f) break block7;
                MagnificationSpec magnificationSpec = null;
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return magnificationSpec;
            }
            spec = spec == null ? MagnificationSpec.obtain() : MagnificationSpec.obtain(spec);
            spec.scale *= windowState.mGlobalScale;
            MagnificationSpec magnificationSpec = spec;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return magnificationSpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationCallbacks(WindowManagerInternal.MagnificationCallbacks callbacks) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mAccessibilityController == null) {
                        WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                    }
                    WindowManagerService.this.mAccessibilityController.setMagnificationCallbacksLocked(callbacks);
                    if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                        WindowManagerService.this.mAccessibilityController = null;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setWindowsForAccessibilityCallback(WindowManagerInternal.WindowsForAccessibilityCallback callback) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mAccessibilityController == null) {
                        WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                    }
                    WindowManagerService.this.mAccessibilityController.setWindowsForAccessibilityCallback(callback);
                    if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                        WindowManagerService.this.mAccessibilityController = null;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public void setInputFilter(IInputFilter filter) {
            WindowManagerService.this.mInputManager.setInputFilter(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public IBinder getFocusedWindowToken() {
            block4: {
                IBinder iBinder;
                WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState windowState = WindowManagerService.this.getFocusedWindowLocked();
                    if (windowState == null) break block4;
                    iBinder = windowState.mClient.asBinder();
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return iBinder;
            }
            IBinder iBinder = null;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return iBinder;
        }

        @Override
        public boolean isKeyguardLocked() {
            return WindowManagerService.this.isKeyguardLocked();
        }

        @Override
        public boolean isKeyguardShowingAndNotOccluded() {
            return WindowManagerService.this.isKeyguardShowingAndNotOccluded();
        }

        @Override
        public void showGlobalActions() {
            WindowManagerService.this.showGlobalActions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getWindowFrame(IBinder token, Rect outBounds) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState windowState = (WindowState)WindowManagerService.this.mWindowMap.get(token);
                    if (windowState != null) {
                        outBounds.set(windowState.mFrame);
                    } else {
                        outBounds.setEmpty();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForAllWindowsDrawn(Runnable callback, long timeout) {
            boolean allWindowsDrawn = false;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowManagerService.this.mWaitingForDrawnCallback = callback;
                    WindowManagerService.this.getDefaultDisplayContentLocked().waitForAllWindowsDrawn();
                    WindowManagerService.this.mWindowPlacerLocked.requestTraversal();
                    WindowManagerService.this.mH.removeMessages(24);
                    if (WindowManagerService.this.mWaitingForDrawn.isEmpty()) {
                        allWindowsDrawn = true;
                    } else {
                        WindowManagerService.this.mH.sendEmptyMessageDelayed(24, timeout);
                        WindowManagerService.this.checkDrawnWindowsLocked();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl19 : MonitorExitStatement: MONITOREXIT : var5_4
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            if (allWindowsDrawn) {
                callback.run();
            }
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId) {
            WindowManagerService.this.addWindowToken(token, type, displayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void removeWindowToken(IBinder binder, boolean removeWindows, int displayId) {
            var4_4 = WindowManagerService.this.mWindowMap;
            synchronized (var4_4) {
                WindowManagerService.boostPriorityForLockedSection();
                if (!removeWindows) ** GOTO lbl23
                dc = WindowManagerService.this.mRoot.getDisplayContent(displayId);
                if (dc != null) ** break block5
                Slog.w("WindowManager", "removeWindowToken: Attempted to remove token: " + binder + " for non-exiting displayId=" + displayId);
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
            {
                token = dc.removeWindowToken(binder);
                if (token != null) ** break block6
                Slog.w("WindowManager", "removeWindowToken: Attempted to remove non-existing token: " + binder);
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
            {
                try {
                    token.removeAllWindowsIfPossible();
lbl23:
                    // 2 sources

                    WindowManagerService.this.removeWindowToken(binder, displayId);
                }
                catch (Throwable var7_7) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4] lbl27 : MonitorExitStatement: MONITOREXIT : var4_4
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw var7_7;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerAppTransitionListener(WindowManagerInternal.AppTransitionListener listener) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowManagerService.this.mAppTransition.registerListenerLocked(listener);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getInputMethodWindowVisibleHeight() {
            int n;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent dc = WindowManagerService.this.getDefaultDisplayContentLocked();
                    n = dc.mDisplayFrames.getInputMethodWindowVisibleHeight();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveLastInputMethodWindowForTransition() {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (WindowManagerService.this.mInputMethodWindow != null) {
                        WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(WindowManagerService.this.mInputMethodWindow, WindowManagerService.this.mInputMethodTarget);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearLastInputMethodWindowForTransition() {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(null, null);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public void updateInputMethodWindowStatus(IBinder imeToken, boolean imeWindowVisible, boolean dismissImeOnBackKeyPressed, IBinder targetWindowToken) {
            WindowManagerService.this.mPolicy.setDismissImeOnBackKeyPressed(dismissImeOnBackKeyPressed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isHardKeyboardAvailable() {
            boolean bl;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    bl = WindowManagerService.this.mHardKeyboardAvailable;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnHardKeyboardStatusChangeListener(WindowManagerInternal.OnHardKeyboardStatusChangeListener listener) {
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowManagerService.this.mHardKeyboardStatusChangeListener = listener;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isStackVisible(int windowingMode) {
            boolean bl;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    DisplayContent dc = WindowManagerService.this.getDefaultDisplayContentLocked();
                    bl = dc.isStackVisible(windowingMode);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isDockedDividerResizing() {
            boolean bl;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    bl = WindowManagerService.this.getDefaultDisplayContentLocked().getDockedDividerController().isResizing();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeWindowsForAccessibility() {
            AccessibilityController accessibilityController;
            WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    accessibilityController = WindowManagerService.this.mAccessibilityController;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            if (accessibilityController != null) {
                accessibilityController.performComputeChangedWindowsNotLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVr2dDisplayId(int vr2dDisplayId) {
            WindowManagerService windowManagerService = WindowManagerService.this;
            synchronized (windowManagerService) {
                WindowManagerService.this.mVr2dDisplayId = vr2dDisplayId;
            }
        }

        @Override
        public void registerDragDropControllerCallback(WindowManagerInternal.IDragDropCallback callback) {
            WindowManagerService.this.mDragDropController.registerCallback(callback);
        }

        @Override
        public void lockNow() {
            WindowManagerService.this.lockNow(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public int getWindowOwnerUserId(IBinder token) {
            block4: {
                int n;
                WindowHashMap windowHashMap = WindowManagerService.this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    WindowState window = (WindowState)WindowManagerService.this.mWindowMap.get(token);
                    if (window == null) break block4;
                    n = UserHandle.getUserId(window.mOwnerUid);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return n;
            }
            int n = -10000;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }
    }

    private static class MousePositionTracker
    implements WindowManagerPolicyConstants.PointerEventListener {
        private boolean mLatestEventWasMouse;
        private float mLatestMouseX;
        private float mLatestMouseY;

        private MousePositionTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updatePosition(float x, float y) {
            MousePositionTracker mousePositionTracker = this;
            synchronized (mousePositionTracker) {
                this.mLatestEventWasMouse = true;
                this.mLatestMouseX = x;
                this.mLatestMouseY = y;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPointerEvent(MotionEvent motionEvent) {
            if (motionEvent.isFromSource(8194)) {
                this.updatePosition(motionEvent.getRawX(), motionEvent.getRawY());
            } else {
                MousePositionTracker mousePositionTracker = this;
                synchronized (mousePositionTracker) {
                    this.mLatestEventWasMouse = false;
                }
            }
        }
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        public static final int SHOW_STRICT_MODE_VIOLATION = 25;
        public static final int DO_ANIMATION_CALLBACK = 26;
        public static final int CLIENT_FREEZE_TIMEOUT = 30;
        public static final int NOTIFY_ACTIVITY_DRAWN = 32;
        public static final int ALL_WINDOWS_DRAWN = 33;
        public static final int NEW_ANIMATOR_SCALE = 34;
        public static final int SHOW_CIRCULAR_DISPLAY_MASK = 35;
        public static final int SHOW_EMULATOR_DISPLAY_OVERLAY = 36;
        public static final int CHECK_IF_BOOT_ANIMATION_FINISHED = 37;
        public static final int RESET_ANR_MESSAGE = 38;
        public static final int WALLPAPER_DRAW_PENDING_TIMEOUT = 39;
        public static final int UPDATE_DOCKED_STACK_DIVIDER = 41;
        public static final int WINDOW_REPLACEMENT_TIMEOUT = 46;
        public static final int NOTIFY_APP_TRANSITION_STARTING = 47;
        public static final int NOTIFY_APP_TRANSITION_CANCELLED = 48;
        public static final int NOTIFY_APP_TRANSITION_FINISHED = 49;
        public static final int UPDATE_ANIMATION_SCALE = 51;
        public static final int WINDOW_HIDE_TIMEOUT = 52;
        public static final int NOTIFY_DOCKED_STACK_MINIMIZED_CHANGED = 53;
        public static final int SEAMLESS_ROTATION_TIMEOUT = 54;
        public static final int RESTORE_POINTER_ICON = 55;
        public static final int NOTIFY_KEYGUARD_FLAGS_CHANGED = 56;
        public static final int NOTIFY_KEYGUARD_TRUSTED_CHANGED = 57;
        public static final int SET_HAS_OVERLAY_UI = 58;
        public static final int SET_RUNNING_REMOTE_ANIMATION = 59;
        public static final int ANIMATION_FAILSAFE = 60;
        public static final int RECOMPUTE_FOCUS = 61;
        public static final int UNUSED = 0;

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    accessibilityController = null;
                    var5_7 = WindowManagerService.this.mWindowMap;
                    synchronized (var5_7) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (WindowManagerService.this.mAccessibilityController != null && WindowManagerService.this.getDefaultDisplayContentLocked().getDisplayId() == 0) {
                            accessibilityController = WindowManagerService.this.mAccessibilityController;
                        }
                        if ((lastFocus = WindowManagerService.this.mLastFocus) != (newFocus = WindowManagerService.this.mCurrentFocus)) ** GOTO lbl-1000
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            WindowManagerService.this.mLastFocus = newFocus;
                            if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                                WindowManagerService.this.mLosingFocus.add(lastFocus);
                                lastFocus = null;
                            }
                        }
                        catch (Throwable var6_47) {
                            // MONITOREXIT @DISABLED, blocks:[96, 49, 50, 44] lbl23 : MonitorExitStatement: MONITOREXIT : var5_7
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var6_47;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (accessibilityController != null) {
                        accessibilityController.onWindowFocusChangedNotLocked();
                    }
                    if (newFocus != null) {
                        newFocus.reportFocusChangedSerialized(true, WindowManagerService.this.mInTouchMode);
                        WindowManagerService.access$700(WindowManagerService.this);
                    }
                    if (lastFocus == null) break;
                    lastFocus.reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    break;
                }
                case 3: {
                    newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            losers = WindowManagerService.this.mLosingFocus;
                            WindowManagerService.this.mLosingFocus = new ArrayList<E>();
                        }
                        catch (Throwable var7_50) {
                            // MONITOREXIT @DISABLED, blocks:[97, 49, 51, 28] lbl45 : MonitorExitStatement: MONITOREXIT : newFocus
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var7_50;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    N = losers.size();
                    for (i = 0; i < N; ++i) {
                        losers.get(i).reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    }
                    break;
                }
                case 11: {
                    losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.boostPriorityForLockedSection();
                        WindowManagerService.this.getDefaultDisplayContentLocked().onWindowFreezeTimeout();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var8_51) {
                            // MONITOREXIT @DISABLED, blocks:[49, 98, 52, 29] lbl64 : MonitorExitStatement: MONITOREXIT : losers
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var8_51;
                        }
                    }
                }
                case 13: {
                    losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (WindowManagerService.this.mAppTransition.isTransitionSet() || !WindowManagerService.this.mOpeningApps.isEmpty() || !WindowManagerService.this.mClosingApps.isEmpty()) {
                            WindowManagerService.this.mAppTransition.setTimeout();
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var9_52) {
                            // MONITOREXIT @DISABLED, blocks:[49, 99, 53, 30] lbl79 : MonitorExitStatement: MONITOREXIT : losers
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var9_52;
                        }
                    }
                }
                case 14: {
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.access$800(WindowManagerService.this));
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.access$900(WindowManagerService.this));
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.access$1000(WindowManagerService.this));
                    break;
                }
                case 51: {
                    mode = msg.arg1;
                    switch (mode) {
                        case 0: {
                            WindowManagerService.access$802(WindowManagerService.this, Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.access$800(WindowManagerService.this)));
                            break;
                        }
                        case 1: {
                            WindowManagerService.access$902(WindowManagerService.this, Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.access$900(WindowManagerService.this)));
                            break;
                        }
                        case 2: {
                            WindowManagerService.access$1002(WindowManagerService.this, Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.access$1000(WindowManagerService.this)));
                            WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                        }
                    }
                    break;
                }
                case 15: {
                    mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (!WindowManagerService.this.mAnimator.isAnimating() && !WindowManagerService.this.mAnimator.isAnimationScheduled()) ** GOTO lbl-1000
                        this.sendEmptyMessageDelayed(15, 2000L);
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!WindowManagerService.this.mDisplayFrozen) ** GOTO lbl-1000
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        try {}
                        catch (Throwable var10_53) {
                            // MONITOREXIT @DISABLED, blocks:[49, 100, 56, 31] lbl128 : MonitorExitStatement: MONITOREXIT : mode
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var10_53;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.access$1100(WindowManagerService.this);
                    break;
                }
                case 17: {
                    mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        WindowManagerService.boostPriorityForLockedSection();
                        Slog.w("WindowManager", "App freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        for (i = WindowManagerService.this.mAppFreezeListeners.size() - 1; i >= 0; --i) {
                            WindowManagerService.this.mAppFreezeListeners.get(i).onAppFreezeTimeout();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var11_54) {
                            // MONITOREXIT @DISABLED, blocks:[32, 49, 101, 58] lbl152 : MonitorExitStatement: MONITOREXIT : mode
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var11_54;
                        }
                    }
                }
                case 30: {
                    mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (WindowManagerService.this.mClientFreezingScreen) {
                            WindowManagerService.this.mClientFreezingScreen = false;
                            WindowManagerService.this.mLastFinishedFreezeSource = "client-timeout";
                            WindowManagerService.this.stopFreezingDisplayLocked();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var12_55) {
                            // MONITOREXIT @DISABLED, blocks:[49, 33, 102, 59] lbl168 : MonitorExitStatement: MONITOREXIT : mode
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var12_55;
                        }
                    }
                }
                case 18: {
                    this.removeMessages(18, msg.obj);
                    displayId = (Integer)msg.obj;
                    if (WindowManagerService.this.mRoot.getDisplayContent(displayId) == null) break;
                    WindowManagerService.this.sendNewConfiguration(displayId);
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    displayId = WindowManagerService.this.mWindowMap;
                    synchronized (displayId) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            WindowManagerService.this.mWindowsChanged = false;
                        }
                        catch (Throwable var13_56) {
                            // MONITOREXIT @DISABLED, blocks:[49, 103, 61, 46] lbl187 : MonitorExitStatement: MONITOREXIT : displayId
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var13_56;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    WindowManagerService.access$1200(WindowManagerService.this);
                    break;
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    callback = null;
                    i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            Slog.w("WindowManager", "Timeout waiting for drawn: undrawn=" + WindowManagerService.this.mWaitingForDrawn);
                            WindowManagerService.this.mWaitingForDrawn.clear();
                            callback = WindowManagerService.this.mWaitingForDrawnCallback;
                            WindowManagerService.this.mWaitingForDrawnCallback = null;
                        }
                        catch (Throwable var14_57) {
                            // MONITOREXIT @DISABLED, blocks:[64, 49, 104, 45] lbl213 : MonitorExitStatement: MONITOREXIT : i
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var14_57;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 25: {
                    WindowManagerService.access$1300(WindowManagerService.this, msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    WindowManagerService.this.showCircularMask(msg.arg1 == 1);
                    break;
                }
                case 36: {
                    WindowManagerService.this.showEmulatorDisplayOverlay();
                    break;
                }
                case 26: {
                    try {
                        ((IRemoteCallback)msg.obj).sendResult(null);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 32: {
                    try {
                        WindowManagerService.this.mActivityManager.notifyActivityDrawn((IBinder)msg.obj);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 33: {
                    i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            callback = WindowManagerService.this.mWaitingForDrawnCallback;
                            WindowManagerService.this.mWaitingForDrawnCallback = null;
                        }
                        catch (Throwable var15_58) {
                            // MONITOREXIT @DISABLED, blocks:[49, 34, 70, 107] lbl251 : MonitorExitStatement: MONITOREXIT : i
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var15_58;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 34: {
                    scale = WindowManagerService.this.getCurrentAnimatorScale();
                    ValueAnimator.setDurationScale(scale);
                    session = (Session)msg.obj;
                    if (session != null) {
                        try {
                            session.mCallback.onAnimatorScaleChanged(scale);
                        }
                        catch (RemoteException i) {}
                        break;
                    }
                    callbacks = new ArrayList<IWindowSessionCallback>();
                    var5_8 = WindowManagerService.this.mWindowMap;
                    synchronized (var5_8) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            for (i = 0; i < WindowManagerService.this.mSessions.size(); ++i) {
                                callbacks.add(WindowManagerService.this.mSessions.valueAt((int)i).mCallback);
                            }
                        }
                        catch (Throwable var16_59) {
                            // MONITOREXIT @DISABLED, blocks:[48, 49, 71, 109] lbl280 : MonitorExitStatement: MONITOREXIT : var5_8
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var16_59;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    for (i = 0; i < callbacks.size(); ++i) {
                        try {
                            ((IWindowSessionCallback)callbacks.get(i)).onAnimatorScaleChanged(scale);
                            continue;
                        }
                        catch (RemoteException var6_49) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 37: {
                    session = WindowManagerService.this.mWindowMap;
                    synchronized (session) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            bootAnimationComplete = WindowManagerService.access$1400(WindowManagerService.this);
                        }
                        catch (Throwable var17_60) {
                            // MONITOREXIT @DISABLED, blocks:[49, 35, 72, 111] lbl301 : MonitorExitStatement: MONITOREXIT : session
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var17_60;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (!bootAnimationComplete) break;
                    WindowManagerService.access$1100(WindowManagerService.this);
                    break;
                }
                case 38: {
                    bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            WindowManagerService.this.mLastANRState = null;
                        }
                        catch (Throwable var18_61) {
                            // MONITOREXIT @DISABLED, blocks:[112, 49, 36, 73] lbl317 : MonitorExitStatement: MONITOREXIT : bootAnimationComplete
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var18_61;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    WindowManagerService.this.mAmInternal.clearSavedANRState();
                    break;
                }
                case 39: {
                    bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (WindowManagerService.this.mRoot.mWallpaperController.processWallpaperDrawPendingTimeout()) {
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var19_62) {
                            // MONITOREXIT @DISABLED, blocks:[49, 113, 37, 74] lbl334 : MonitorExitStatement: MONITOREXIT : bootAnimationComplete
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var19_62;
                        }
                    }
                }
                case 41: {
                    bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        WindowManagerService.boostPriorityForLockedSection();
                        displayContent = WindowManagerService.this.getDefaultDisplayContentLocked();
                        displayContent.getDockedDividerController().reevaluateVisibility(false);
                        displayContent.adjustForImeIfNeeded();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var20_63) {
                            // MONITOREXIT @DISABLED, blocks:[49, 114, 38, 75] lbl349 : MonitorExitStatement: MONITOREXIT : bootAnimationComplete
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var20_63;
                        }
                    }
                }
                case 46: {
                    bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        WindowManagerService.boostPriorityForLockedSection();
                        for (i = WindowManagerService.this.mWindowReplacementTimeouts.size() - 1; i >= 0; --i) {
                            token = WindowManagerService.this.mWindowReplacementTimeouts.get(i);
                            token.onWindowReplacementTimeout();
                        }
                        WindowManagerService.this.mWindowReplacementTimeouts.clear();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var21_64) {
                            // MONITOREXIT @DISABLED, blocks:[49, 115, 39, 76] lbl366 : MonitorExitStatement: MONITOREXIT : bootAnimationComplete
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var21_64;
                        }
                    }
                }
                case 47: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionStarting((SparseIntArray)msg.obj, msg.getWhen());
                    break;
                }
                case 48: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionCancelled();
                    break;
                }
                case 49: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionFinished();
                    break;
                }
                case 52: {
                    window = (WindowState)msg.obj;
                    i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        WindowManagerService.boostPriorityForLockedSection();
                        window.mAttrs.flags &= -129;
                        window.hidePermanentlyLw();
                        window.setDisplayLayoutNeeded();
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var22_65) {
                            // MONITOREXIT @DISABLED, blocks:[80, 49, 116, 47] lbl392 : MonitorExitStatement: MONITOREXIT : i
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var22_65;
                        }
                    }
                }
                case 53: {
                    WindowManagerService.this.mAmInternal.notifyDockedStackMinimizedChanged(msg.arg1 == 1);
                    break;
                }
                case 55: {
                    var2_31 = WindowManagerService.this.mWindowMap;
                    synchronized (var2_31) {
                        WindowManagerService.boostPriorityForLockedSection();
                        WindowManagerService.this.restorePointerIconLocked((DisplayContent)msg.obj, msg.arg1, msg.arg2);
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var23_66) {
                            // MONITOREXIT @DISABLED, blocks:[49, 82, 117, 40] lbl408 : MonitorExitStatement: MONITOREXIT : var2_31
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var23_66;
                        }
                    }
                }
                case 54: {
                    var2_32 = WindowManagerService.this.mWindowMap;
                    synchronized (var2_32) {
                        WindowManagerService.boostPriorityForLockedSection();
                        dc = WindowManagerService.this.getDefaultDisplayContentLocked();
                        dc.onSeamlessRotationTimeout();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var24_67) {
                            // MONITOREXIT @DISABLED, blocks:[49, 83, 118, 41] lbl422 : MonitorExitStatement: MONITOREXIT : var2_32
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var24_67;
                        }
                    }
                }
                case 56: {
                    WindowManagerService.this.mAmInternal.notifyKeyguardFlagsChanged((Runnable)msg.obj);
                    break;
                }
                case 57: {
                    WindowManagerService.this.mAmInternal.notifyKeyguardTrustedChanged();
                    break;
                }
                case 58: {
                    WindowManagerService.this.mAmInternal.setHasOverlayUi(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 59: {
                    WindowManagerService.this.mAmInternal.setRunningRemoteAnimation(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 60: {
                    var2_33 = WindowManagerService.this.mWindowMap;
                    synchronized (var2_33) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (WindowManagerService.access$1500(WindowManagerService.this) != null) {
                            WindowManagerService.access$1500(WindowManagerService.this).scheduleFailsafe();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var25_68) {
                            // MONITOREXIT @DISABLED, blocks:[49, 119, 88, 42] lbl448 : MonitorExitStatement: MONITOREXIT : var2_33
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var25_68;
                        }
                    }
                }
                case 61: {
                    var2_34 = WindowManagerService.this.mWindowMap;
                    synchronized (var2_34) {
                        WindowManagerService.boostPriorityForLockedSection();
                        WindowManagerService.this.updateFocusedWindowLocked(0, true);
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var26_69) {
                            // MONITOREXIT @DISABLED, blocks:[49, 120, 89, 43] lbl462 : MonitorExitStatement: MONITOREXIT : var2_34
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var26_69;
                        }
                    }
                }
            }
        }
    }

    static interface AppFreezeListener {
        public void onAppFreezeTimeout();
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mWindowAnimationScaleUri;
        private final Uri mTransitionAnimationScaleUri;
        private final Uri mAnimationDurationScaleUri;

        public SettingsObserver() {
            super(new Handler());
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mWindowAnimationScaleUri = Settings.Global.getUriFor("window_animation_scale");
            this.mTransitionAnimationScaleUri = Settings.Global.getUriFor("transition_animation_scale");
            this.mAnimationDurationScaleUri = Settings.Global.getUriFor("animator_duration_scale");
            ContentResolver resolver = WindowManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            resolver.registerContentObserver(this.mWindowAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mTransitionAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mAnimationDurationScaleUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (this.mDisplayInversionEnabledUri.equals(uri)) {
                WindowManagerService.this.updateCircularDisplayMaskIfNeeded();
            } else {
                int mode;
                if (this.mWindowAnimationScaleUri.equals(uri)) {
                    mode = 0;
                } else if (this.mTransitionAnimationScaleUri.equals(uri)) {
                    mode = 1;
                } else if (this.mAnimationDurationScaleUri.equals(uri)) {
                    mode = 2;
                } else {
                    return;
                }
                Message m = WindowManagerService.this.mH.obtainMessage(51, mode, 0);
                WindowManagerService.this.mH.sendMessage(m);
            }
        }
    }

    class RotationWatcher {
        final IRotationWatcher mWatcher;
        final IBinder.DeathRecipient mDeathRecipient;
        final int mDisplayId;

        RotationWatcher(IRotationWatcher watcher, IBinder.DeathRecipient deathRecipient, int displayId) {
            this.mWatcher = watcher;
            this.mDeathRecipient = deathRecipient;
            this.mDisplayId = displayId;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface UpdateAnimationScaleMode {
    }
}

