/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import libcore.io.ClassPathURLStreamHandler;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DexPathList
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String DEX_SUFFIX = ".dex";
    private static String zipSeparator = "!/";
    private ClassLoader definingContext;
    private Element[] dexElements;
    NativeLibraryElement[] nativeLibraryPathElements;
    private List<File> nativeLibraryDirectories;
    private List<File> systemNativeLibraryDirectories;
    private IOException[] dexElementsSuppressedExceptions;

    private void $$robo$$dalvik_system_DexPathList$__constructor__(ClassLoader definingContext, ByteBuffer[] dexFiles) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexFiles == null) {
            throw new NullPointerException("dexFiles == null");
        }
        if (Arrays.stream(dexFiles).anyMatch(v -> v == null)) {
            throw new NullPointerException("dexFiles contains a null Buffer!");
        }
        this.definingContext = definingContext;
        this.nativeLibraryDirectories = Collections.emptyList();
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        this.nativeLibraryPathElements = DexPathList.makePathElements(this.systemNativeLibraryDirectories);
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeInMemoryDexElements(dexFiles, suppressedExceptions);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    private void $$robo$$dalvik_system_DexPathList$__constructor__(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory) {
    }

    private void $$robo$$dalvik_system_DexPathList$__constructor__(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory, boolean isTrusted) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions, definingContext, isTrusted);
        this.nativeLibraryDirectories = DexPathList.splitPaths(librarySearchPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        this.nativeLibraryPathElements = DexPathList.makePathElements(allNativeLibraryDirectories);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    private final String $$robo$$dalvik_system_DexPathList$toString() {
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        Object[] nativeLibraryDirectoriesArray = allNativeLibraryDirectories.toArray(new File[allNativeLibraryDirectories.size()]);
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(nativeLibraryDirectoriesArray) + "]";
    }

    private final List<File> $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    private final void $$robo$$dalvik_system_DexPathList$addDexPath(String dexPath, File optimizedDirectory) {
        this.addDexPath(dexPath, optimizedDirectory, false);
    }

    private final void $$robo$$dalvik_system_DexPathList$addDexPath(String dexPath, File optimizedDirectory, boolean isTrusted) {
        ArrayList<IOException> suppressedExceptionList = new ArrayList<IOException>();
        Element[] newElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptionList, this.definingContext, isTrusted);
        if (newElements != null && newElements.length > 0) {
            Element[] oldElements = this.dexElements;
            this.dexElements = new Element[oldElements.length + newElements.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldElements, (int)0, (Object)this.dexElements, (int)0, (int)oldElements.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)newElements, (int)0, (Object)this.dexElements, (int)oldElements.length, (int)newElements.length);
        }
        if (suppressedExceptionList.size() > 0) {
            IOException[] newSuppressedExceptions = suppressedExceptionList.toArray(new IOException[suppressedExceptionList.size()]);
            if (this.dexElementsSuppressedExceptions != null) {
                IOException[] oldSuppressedExceptions = this.dexElementsSuppressedExceptions;
                int suppressedExceptionsLength = oldSuppressedExceptions.length + newSuppressedExceptions.length;
                this.dexElementsSuppressedExceptions = new IOException[suppressedExceptionsLength];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldSuppressedExceptions, (int)0, (Object)this.dexElementsSuppressedExceptions, (int)0, (int)oldSuppressedExceptions.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)newSuppressedExceptions, (int)0, (Object)this.dexElementsSuppressedExceptions, (int)oldSuppressedExceptions.length, (int)newSuppressedExceptions.length);
            } else {
                this.dexElementsSuppressedExceptions = newSuppressedExceptions;
            }
        }
    }

    private static final List<File> $$robo$$dalvik_system_DexPathList$splitDexPath(String path) {
        return DexPathList.splitPaths(path, false);
    }

    private static final List<File> $$robo$$dalvik_system_DexPathList$splitPaths(String searchPath, boolean directoriesOnly) {
        ArrayList<File> result = new ArrayList<File>();
        if (searchPath != null) {
            for (String path : searchPath.split(File.pathSeparator)) {
                if (directoriesOnly) {
                    try {
                        StructStat sb = Libcore.os.stat(path);
                        if (!OsConstants.S_ISDIR(sb.st_mode)) {
                        }
                    }
                    catch (ErrnoException ignored) {}
                    continue;
                }
                result.add(new File(path));
            }
        }
        return result;
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeInMemoryDexElements(ByteBuffer[] dexFiles, List<IOException> suppressedExceptions) {
        Element[] elements = new Element[dexFiles.length];
        int elementPos = 0;
        for (ByteBuffer buf : dexFiles) {
            try {
                DexFile dex = new DexFile(buf);
                elements[elementPos++] = new Element(dex);
            }
            catch (IOException suppressed) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to load dex file: " + buf), (Throwable)suppressed);
                suppressedExceptions.add(suppressed);
            }
        }
        if (elementPos != elements.length) {
            elements = Arrays.copyOf(elements, elementPos);
        }
        return elements;
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader) {
        return DexPathList.makeDexElements(files, optimizedDirectory, suppressedExceptions, loader, false);
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader, boolean isTrusted) {
        Element[] elements = new Element[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                elements[elementsPos++] = new Element(file);
                continue;
            }
            if (file.isFile()) {
                String name = file.getName();
                DexFile dex = null;
                if (name.endsWith(".dex")) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                        if (dex != null) {
                            elements[elementsPos++] = new Element(dex, null);
                        }
                    }
                    catch (IOException suppressed) {
                        InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to load dex file: " + file), (Throwable)suppressed);
                        suppressedExceptions.add(suppressed);
                    }
                } else {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                    }
                    catch (IOException suppressed) {
                        suppressedExceptions.add(suppressed);
                    }
                    elements[elementsPos++] = dex == null ? new Element(file) : new Element(dex, file);
                }
                if (dex == null || !isTrusted) continue;
                dex.setTrusted();
                continue;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("ClassLoader referenced unknown path: " + file));
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    private static final DexFile $$robo$$dalvik_system_DexPathList$loadDexFile(File file, File optimizedDirectory, ClassLoader loader, Element[] elements) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file, loader, elements);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0, loader, elements);
    }

    private static final String $$robo$$dalvik_system_DexPathList$optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(".dex");
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makePathElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions) {
        return DexPathList.makeDexElements(files, optimizedDirectory, suppressedExceptions, null);
    }

    private static final NativeLibraryElement[] $$robo$$dalvik_system_DexPathList$makePathElements(List<File> files) {
        NativeLibraryElement[] elements = new NativeLibraryElement[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            String path = file.getPath();
            if (path.contains("!/")) {
                String[] split = path.split("!/", 2);
                File zip = new File(split[0]);
                String dir = split[1];
                elements[elementsPos++] = new NativeLibraryElement(zip, dir);
                continue;
            }
            if (!file.isDirectory()) continue;
            elements[elementsPos++] = new NativeLibraryElement(file);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    private final Class<?> $$robo$$dalvik_system_DexPathList$findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class<?> clazz = element.findClass(name, this.definingContext, suppressed);
            if (clazz == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    private final URL $$robo$$dalvik_system_DexPathList$findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private final Enumeration<URL> $$robo$$dalvik_system_DexPathList$findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    private final String $$robo$$dalvik_system_DexPathList$findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (NativeLibraryElement element : this.nativeLibraryPathElements) {
            String path = element.findNativeLibrary(fileName);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private final List<String> $$robo$$dalvik_system_DexPathList$getDexPaths() {
        ArrayList<String> dexPaths = new ArrayList<String>();
        for (Element e : this.dexElements) {
            String dexPath = e.getDexPath();
            if (dexPath == null) continue;
            dexPaths.add(dexPath);
        }
        return dexPaths;
    }

    private final void $$robo$$dalvik_system_DexPathList$addNativePath(Collection<String> libPaths) {
        if (libPaths.isEmpty()) {
            return;
        }
        ArrayList<File> libFiles = new ArrayList<File>(libPaths.size());
        for (String path : libPaths) {
            libFiles.add(new File(path));
        }
        ArrayList<NativeLibraryElement> newPaths = new ArrayList<NativeLibraryElement>(this.nativeLibraryPathElements.length + libPaths.size());
        newPaths.addAll(Arrays.asList(this.nativeLibraryPathElements));
        for (NativeLibraryElement element : DexPathList.makePathElements(libFiles)) {
            if (newPaths.contains(element)) continue;
            newPaths.add(element);
        }
        this.nativeLibraryPathElements = newPaths.toArray(new NativeLibraryElement[newPaths.size()]);
    }

    private void __constructor__(ClassLoader classLoader, ByteBuffer[] byteBufferArray) {
        this.$$robo$$dalvik_system_DexPathList$__constructor__(classLoader, byteBufferArray);
    }

    public DexPathList(ClassLoader classLoader, ByteBuffer[] byteBufferArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList$__constructor__(java.lang.ClassLoader java.nio.ByteBuffer[] ), 0, this, classLoader, byteBufferArray);
    }

    private void __constructor__(ClassLoader classLoader, String string2, String string3, File file) {
        this.$$robo$$dalvik_system_DexPathList$__constructor__(classLoader, string2, string3, file);
    }

    public DexPathList(ClassLoader classLoader, String string2, String string3, File file) {
        this(classLoader, string2, string3, file, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList$__constructor__(java.lang.ClassLoader java.lang.String java.lang.String java.io.File ), 0, this, classLoader, string2, string3, file);
    }

    private void __constructor__(ClassLoader classLoader, String string2, String string3, File file, boolean bl) {
        this.$$robo$$dalvik_system_DexPathList$__constructor__(classLoader, string2, string3, file, bl);
    }

    DexPathList(ClassLoader classLoader, String string2, String string3, File file, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList$__constructor__(java.lang.ClassLoader java.lang.String java.lang.String java.io.File boolean ), 0, this, classLoader, string2, string3, file, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList$toString(), 0, this);
    }

    public List<File> getNativeLibraryDirectories() {
        return InvokeDynamicSupport.bootstrap("getNativeLibraryDirectories", $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories(), 0, this);
    }

    public void addDexPath(String string2, File file) {
        InvokeDynamicSupport.bootstrap("addDexPath", $$robo$$dalvik_system_DexPathList$addDexPath(java.lang.String java.io.File ), 0, this, string2, file);
    }

    public void addDexPath(String string2, File file, boolean bl) {
        InvokeDynamicSupport.bootstrap("addDexPath", $$robo$$dalvik_system_DexPathList$addDexPath(java.lang.String java.io.File boolean ), 0, this, string2, file, bl);
    }

    private static List<File> splitDexPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitDexPath", $$robo$$dalvik_system_DexPathList$splitDexPath(java.lang.String ), 0, (String)string2);
    }

    private static List<File> splitPaths(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("splitPaths", $$robo$$dalvik_system_DexPathList$splitPaths(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static Element[] makeInMemoryDexElements(ByteBuffer[] byteBufferArray, List<IOException> list) {
        return InvokeDynamicSupport.bootstrapStatic("makeInMemoryDexElements", $$robo$$dalvik_system_DexPathList$makeInMemoryDexElements(java.nio.ByteBuffer[] java.util.List<java.io.IOException> ), 0, (ByteBuffer[])byteBufferArray, list);
    }

    private static Element[] makeDexElements(List<File> list, File file, List<IOException> list2, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrapStatic("makeDexElements", $$robo$$dalvik_system_DexPathList$makeDexElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> java.lang.ClassLoader ), 0, list, (File)file, list2, (ClassLoader)classLoader);
    }

    private static Element[] makeDexElements(List<File> list, File file, List<IOException> list2, ClassLoader classLoader, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("makeDexElements", $$robo$$dalvik_system_DexPathList$makeDexElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> java.lang.ClassLoader boolean ), 0, list, (File)file, list2, (ClassLoader)classLoader, (boolean)bl);
    }

    private static DexFile loadDexFile(File file, File file2, ClassLoader classLoader, Element[] elementArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("loadDexFile", $$robo$$dalvik_system_DexPathList$loadDexFile(java.io.File java.io.File java.lang.ClassLoader dalvik.system.DexPathList$Element[] ), 0, (File)file, (File)file2, (ClassLoader)classLoader, (Element[])elementArray);
    }

    private static String optimizedPathFor(File file, File file2) {
        return InvokeDynamicSupport.bootstrapStatic("optimizedPathFor", $$robo$$dalvik_system_DexPathList$optimizedPathFor(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    private static Element[] makePathElements(List<File> list, File file, List<IOException> list2) {
        return InvokeDynamicSupport.bootstrapStatic("makePathElements", $$robo$$dalvik_system_DexPathList$makePathElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> ), 0, list, (File)file, list2);
    }

    private static NativeLibraryElement[] makePathElements(List<File> list) {
        return InvokeDynamicSupport.bootstrapStatic("makePathElements", $$robo$$dalvik_system_DexPathList$makePathElements(java.util.List<java.io.File> ), 0, list);
    }

    public Class<?> findClass(String string2, List<Throwable> list) {
        return InvokeDynamicSupport.bootstrap("findClass", $$robo$$dalvik_system_DexPathList$findClass(java.lang.String java.util.List<java.lang.Throwable> ), 0, this, string2, list);
    }

    public URL findResource(String string2) {
        return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList$findResource(java.lang.String ), 0, this, string2);
    }

    public Enumeration<URL> findResources(String string2) {
        return InvokeDynamicSupport.bootstrap("findResources", $$robo$$dalvik_system_DexPathList$findResources(java.lang.String ), 0, this, string2);
    }

    public String findLibrary(String string2) {
        return InvokeDynamicSupport.bootstrap("findLibrary", $$robo$$dalvik_system_DexPathList$findLibrary(java.lang.String ), 0, this, string2);
    }

    List<String> getDexPaths() {
        return InvokeDynamicSupport.bootstrap("getDexPaths", $$robo$$dalvik_system_DexPathList$getDexPaths(), 0, this);
    }

    public void addNativePath(Collection<String> collection) {
        InvokeDynamicSupport.bootstrap("addNativePath", $$robo$$dalvik_system_DexPathList$addNativePath(java.util.Collection<java.lang.String> ), 0, this, collection);
    }

    public /* synthetic */ DexPathList() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexPathList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class NativeLibraryElement
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File path;
        private String zipDir;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        private void $$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(File dir) {
            this.path = dir;
            this.zipDir = null;
        }

        private void $$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(File zip, String zipDir) {
            this.path = zip;
            this.zipDir = zipDir;
            if (zipDir == null) {
                throw new IllegalArgumentException();
            }
        }

        private final String $$robo$$dalvik_system_DexPathList_NativeLibraryElement$toString() {
            if (this.zipDir == null) {
                return "directory \"" + this.path + "\"";
            }
            return "zip file \"" + this.path + "\"" + (!this.zipDir.isEmpty() ? ", dir \"" + this.zipDir + "\"" : "");
        }

        private final synchronized void $$robo$$dalvik_system_DexPathList_NativeLibraryElement$maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.zipDir == null) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to open zip file: " + this.path), (Throwable)ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        private final String $$robo$$dalvik_system_DexPathList_NativeLibraryElement$findNativeLibrary(String name) {
            String entryName;
            this.maybeInit();
            if (this.zipDir == null) {
                String entryPath = new File(this.path, name).getPath();
                if (IoUtils.canOpenReadOnly(entryPath)) {
                    return entryPath;
                }
            } else if (this.urlHandler != null && this.urlHandler.isEntryStored(entryName = this.zipDir + '/' + name)) {
                return this.path.getPath() + "!/" + entryName;
            }
            return null;
        }

        private final boolean $$robo$$dalvik_system_DexPathList_NativeLibraryElement$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NativeLibraryElement)) {
                return false;
            }
            NativeLibraryElement that = (NativeLibraryElement)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.zipDir, that.zipDir);
        }

        private final int $$robo$$dalvik_system_DexPathList_NativeLibraryElement$hashCode() {
            return Objects.hash(this.path, this.zipDir);
        }

        private void __constructor__(File file) {
            this.$$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(file);
        }

        public NativeLibraryElement(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(java.io.File ), 0, this, file);
        }

        private void __constructor__(File file, String string2) {
            this.$$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(file, string2);
        }

        public NativeLibraryElement(File file, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$__constructor__(java.io.File java.lang.String ), 0, this, file, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$toString(), 0, this);
        }

        public synchronized void maybeInit() {
            InvokeDynamicSupport.bootstrap("maybeInit", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$maybeInit(), 0, this);
        }

        public String findNativeLibrary(String string2) {
            return InvokeDynamicSupport.bootstrap("findNativeLibrary", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$findNativeLibrary(java.lang.String ), 0, this, string2);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$dalvik_system_DexPathList_NativeLibraryElement$hashCode(), 0, this);
        }

        public /* synthetic */ NativeLibraryElement() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeLibraryElement)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Element
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File path;
        private DexFile dexFile;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(DexFile dexFile, File dexZipPath) {
            this.dexFile = dexFile;
            this.path = dexZipPath;
        }

        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(DexFile dexFile) {
            this.dexFile = dexFile;
            this.path = null;
        }

        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(File path) {
            this.path = path;
            this.dexFile = null;
        }

        @Deprecated
        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(File dir, boolean isDirectory, File zip, DexFile dexFile) {
            System.err.println("Warning: Using deprecated Element constructor. Do not use internal APIs, this constructor will be removed in the future.");
            if (dir != null && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Using dir and zip|dexFile no longer supported.");
            }
            if (isDirectory && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Unsupported argument combination.");
            }
            if (dir != null) {
                this.path = dir;
                this.dexFile = null;
            } else {
                this.path = zip;
                this.dexFile = dexFile;
            }
        }

        private final String $$robo$$dalvik_system_DexPathList_Element$getDexPath() {
            if (this.path != null) {
                return this.path.isDirectory() ? null : this.path.getAbsolutePath();
            }
            if (this.dexFile != null) {
                return this.dexFile.getName();
            }
            return null;
        }

        private final String $$robo$$dalvik_system_DexPathList_Element$toString() {
            if (this.dexFile == null) {
                return (this.path.isDirectory() ? "directory \"" : "zip file \"") + this.path + "\"";
            }
            if (this.path == null) {
                return "dex file \"" + this.dexFile + "\"";
            }
            return "zip file \"" + this.path + "\"";
        }

        private final synchronized void $$robo$$dalvik_system_DexPathList_Element$maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.path == null || this.path.isDirectory()) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to open zip file: " + this.path), (Throwable)ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        private final Class<?> $$robo$$dalvik_system_DexPathList_Element$findClass(String name, ClassLoader definingContext, List<Throwable> suppressed) {
            return this.dexFile != null ? this.dexFile.loadClassBinaryName(name, definingContext, suppressed) : null;
        }

        private final URL $$robo$$dalvik_system_DexPathList_Element$findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.urlHandler != null) {
                return this.urlHandler.getEntryUrlOrNull(name);
            }
            if (this.path != null && this.path.isDirectory() && (resourceFile = new File(this.path, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }

        private void __constructor__(DexFile dexFile, File file) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(dexFile, file);
        }

        public Element(DexFile dexFile, File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(dalvik.system.DexFile java.io.File ), 0, this, dexFile, file);
        }

        private void __constructor__(DexFile dexFile) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(dexFile);
        }

        public Element(DexFile dexFile) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(dalvik.system.DexFile ), 0, this, dexFile);
        }

        private void __constructor__(File file) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(file);
        }

        public Element(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(java.io.File ), 0, this, file);
        }

        private void __constructor__(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(file, bl, file2, dexFile);
        }

        public Element(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(java.io.File boolean java.io.File dalvik.system.DexFile ), 0, this, file, bl, file2, dexFile);
        }

        private String getDexPath() {
            return InvokeDynamicSupport.bootstrap("getDexPath", $$robo$$dalvik_system_DexPathList_Element$getDexPath(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList_Element$toString(), 0, this);
        }

        public synchronized void maybeInit() {
            InvokeDynamicSupport.bootstrap("maybeInit", $$robo$$dalvik_system_DexPathList_Element$maybeInit(), 0, this);
        }

        public Class<?> findClass(String string2, ClassLoader classLoader, List<Throwable> list) {
            return InvokeDynamicSupport.bootstrap("findClass", $$robo$$dalvik_system_DexPathList_Element$findClass(java.lang.String java.lang.ClassLoader java.util.List<java.lang.Throwable> ), 0, this, string2, classLoader, list);
        }

        public URL findResource(String string2) {
            return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList_Element$findResource(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Element() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Element)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

