/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.util.Calendar;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.text.FieldPosition;
import java.util.TimeZone;
import libcore.icu.DateUtilsBridge;
import libcore.util.BasicLruCache;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateIntervalFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static BasicLruCache<String, android.icu.text.DateIntervalFormat> CACHED_FORMATTERS;

    private void $$robo$$libcore_icu_DateIntervalFormat$__constructor__() {
    }

    private static final String $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(long startMs, long endMs, int flags, String olsonId) {
        if ((flags & 0x2000) != 0) {
            olsonId = "UTC";
        }
        TimeZone tz = olsonId != null ? TimeZone.getTimeZone(olsonId) : TimeZone.getDefault();
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        ULocale icuLocale = ULocale.getDefault();
        return DateIntervalFormat.formatDateRange(icuLocale, icuTimeZone, startMs, endMs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(ULocale icuLocale, android.icu.util.TimeZone icuTimeZone, long startMs, long endMs, int flags) {
        Calendar startCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, startMs);
        Calendar endCalendar = startMs == endMs ? startCalendar : DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, endMs);
        if (DateIntervalFormat.isExactlyMidnight(endCalendar)) {
            boolean endsDayAfterStart;
            boolean showTime = (flags & 1) == 1;
            boolean bl = endsDayAfterStart = DateUtilsBridge.dayDistance(startCalendar, endCalendar) == 1;
            if (!showTime && startMs != endMs || endsDayAfterStart && !DateUtilsBridge.isDisplayMidnightUsingSkeleton(startCalendar)) {
                endCalendar.add(5, -1);
            }
        }
        String skeleton = DateUtilsBridge.toSkeleton(startCalendar, endCalendar, flags);
        BasicLruCache<String, android.icu.text.DateIntervalFormat> basicLruCache = CACHED_FORMATTERS;
        synchronized (basicLruCache) {
            android.icu.text.DateIntervalFormat formatter = DateIntervalFormat.getFormatter(skeleton, icuLocale, icuTimeZone);
            return formatter.format(startCalendar, endCalendar, new StringBuffer(), new FieldPosition(0)).toString();
        }
    }

    private static final android.icu.text.DateIntervalFormat $$robo$$libcore_icu_DateIntervalFormat$getFormatter(String skeleton, ULocale locale, android.icu.util.TimeZone icuTimeZone) {
        String key = skeleton + "\t" + locale + "\t" + icuTimeZone;
        android.icu.text.DateIntervalFormat formatter = CACHED_FORMATTERS.get(key);
        if (formatter != null) {
            return formatter;
        }
        formatter = android.icu.text.DateIntervalFormat.getInstance(skeleton, locale);
        formatter.setTimeZone(icuTimeZone);
        CACHED_FORMATTERS.put(key, formatter);
        return formatter;
    }

    private static final boolean $$robo$$libcore_icu_DateIntervalFormat$isExactlyMidnight(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }

    static void __staticInitializer__() {
        CACHED_FORMATTERS = new BasicLruCache(8);
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_DateIntervalFormat$__constructor__();
    }

    private DateIntervalFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_DateIntervalFormat$__constructor__(), 0, this);
    }

    public static String formatDateRange(long l, long l2, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(long long int java.lang.String ), 0, (long)l, (long)l2, (int)n, (String)string2);
    }

    public static String formatDateRange(ULocale uLocale, android.icu.util.TimeZone timeZone, long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$libcore_icu_DateIntervalFormat$formatDateRange(android.icu.util.ULocale android.icu.util.TimeZone long long int ), 0, (ULocale)uLocale, (android.icu.util.TimeZone)timeZone, (long)l, (long)l2, (int)n);
    }

    private static android.icu.text.DateIntervalFormat getFormatter(String string2, ULocale uLocale, android.icu.util.TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("getFormatter", $$robo$$libcore_icu_DateIntervalFormat$getFormatter(java.lang.String android.icu.util.ULocale android.icu.util.TimeZone ), 0, (String)string2, (ULocale)uLocale, (android.icu.util.TimeZone)timeZone);
    }

    private static boolean isExactlyMidnight(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExactlyMidnight", $$robo$$libcore_icu_DateIntervalFormat$isExactlyMidnight(android.icu.util.Calendar ), 0, (Calendar)calendar);
    }

    static {
        RobolectricInternals.classInitializing(DateIntervalFormat.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateIntervalFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

