/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import libcore.icu.LocaleData;
import libcore.util.BasicLruCache;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ICU
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static BasicLruCache<String, String> CACHED_PATTERNS;
    private static Locale[] availableLocalesCache;
    private static String[] isoCountries;
    private static String[] isoLanguages;
    private static int IDX_LANGUAGE = 0;
    private static int IDX_SCRIPT = 1;
    private static int IDX_REGION = 2;
    private static int IDX_VARIANT = 3;
    public static int U_ZERO_ERROR = 0;
    public static int U_INVALID_CHAR_FOUND = 10;
    public static int U_TRUNCATED_CHAR_FOUND = 11;
    public static int U_ILLEGAL_CHAR_FOUND = 12;
    public static int U_BUFFER_OVERFLOW_ERROR = 15;

    private void $$robo$$libcore_icu_ICU$__constructor__() {
    }

    private static final String[] $$robo$$libcore_icu_ICU$getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = ICU.getISOLanguagesNative();
        }
        return (String[])isoLanguages.clone();
    }

    private static final String[] $$robo$$libcore_icu_ICU$getISOCountries() {
        if (isoCountries == null) {
            isoCountries = ICU.getISOCountriesNative();
        }
        return (String[])isoCountries.clone();
    }

    private static final void $$robo$$libcore_icu_ICU$parseLangScriptRegionAndVariants(String string2, String[] outputArray) {
        int first = string2.indexOf(95);
        int second = string2.indexOf(95, first + 1);
        int third = string2.indexOf(95, second + 1);
        if (first == -1) {
            outputArray[0] = string2;
        } else if (second == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
            } else if (secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
            } else {
                outputArray[3] = secondString;
            }
        } else if (third == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            String thirdString = string2.substring(second + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                if (thirdString.length() == 2 || thirdString.length() == 3 || thirdString.isEmpty()) {
                    outputArray[2] = thirdString;
                } else {
                    outputArray[3] = thirdString;
                }
            } else if (secondString.isEmpty() || secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
                outputArray[3] = thirdString;
            } else {
                outputArray[3] = string2.substring(first + 1);
            }
        } else {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                outputArray[2] = string2.substring(second + 1, third);
                outputArray[3] = string2.substring(third + 1);
            } else {
                outputArray[2] = secondString;
                outputArray[3] = string2.substring(second + 1);
            }
        }
    }

    private static final Locale $$robo$$libcore_icu_ICU$localeFromIcuLocaleId(String localeId) {
        int extensionsIndex = localeId.indexOf(64);
        HashMap<Character, String> extensionsMap = Collections.EMPTY_MAP;
        HashMap<String, String> unicodeKeywordsMap = Collections.EMPTY_MAP;
        HashSet<String> unicodeAttributeSet = Collections.EMPTY_SET;
        if (extensionsIndex != -1) {
            extensionsMap = new HashMap<Character, String>();
            unicodeKeywordsMap = new HashMap<String, String>();
            unicodeAttributeSet = new HashSet<String>();
            String extensionsString = localeId.substring(extensionsIndex + 1);
            String[] extensions = extensionsString.split(";");
            for (String extension : extensions) {
                if (extension.startsWith("attribute=")) {
                    String unicodeAttributeValues = extension.substring("attribute=".length());
                    for (String unicodeAttribute : unicodeAttributeValues.split("-")) {
                        unicodeAttributeSet.add(unicodeAttribute);
                    }
                    continue;
                }
                int separatorIndex = extension.indexOf(61);
                if (separatorIndex == 1) {
                    String value = extension.substring(2);
                    char extensionId = extension.charAt(0);
                    extensionsMap.put(Character.valueOf(extensionId), value);
                    continue;
                }
                unicodeKeywordsMap.put(extension.substring(0, separatorIndex), extension.substring(separatorIndex + 1));
            }
        }
        String[] outputArray = new String[]{"", "", "", ""};
        if (extensionsIndex == -1) {
            ICU.parseLangScriptRegionAndVariants(localeId, outputArray);
        } else {
            ICU.parseLangScriptRegionAndVariants(localeId.substring(0, extensionsIndex), outputArray);
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLanguage(outputArray[0]);
        builder.setRegion(outputArray[2]);
        builder.setVariant(outputArray[3]);
        builder.setScript(outputArray[1]);
        for (String string2 : unicodeAttributeSet) {
            builder.addUnicodeLocaleAttribute(string2);
        }
        for (Map.Entry entry : unicodeKeywordsMap.entrySet()) {
            builder.setUnicodeLocaleKeyword((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : extensionsMap.entrySet()) {
            builder.setExtension(((Character)entry.getKey()).charValue(), (String)entry.getValue());
        }
        return builder.build();
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$localesFromStrings(String[] localeNames) {
        LinkedHashSet<Locale> set = new LinkedHashSet<Locale>();
        for (String localeName : localeNames) {
            set.add(ICU.localeFromIcuLocaleId(localeName));
        }
        return set.toArray(new Locale[set.size()]);
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableLocales() {
        if (availableLocalesCache == null) {
            availableLocalesCache = ICU.localesFromStrings(ICU.getAvailableLocalesNative());
        }
        return (Locale[])availableLocalesCache.clone();
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableBreakIteratorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableBreakIteratorLocalesNative());
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableCalendarLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCalendarLocalesNative());
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableCollatorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCollatorLocalesNative());
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableDateFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableDateFormatLocalesNative());
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableDateFormatSymbolsLocales() {
        return ICU.getAvailableDateFormatLocales();
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableDecimalFormatSymbolsLocales() {
        return ICU.getAvailableNumberFormatLocales();
    }

    private static final Locale[] $$robo$$libcore_icu_ICU$getAvailableNumberFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableNumberFormatLocalesNative());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_icu_ICU$getBestDateTimePattern(String skeleton, Locale locale) {
        String languageTag = locale.toLanguageTag();
        String key = skeleton + "\t" + languageTag;
        BasicLruCache<String, String> basicLruCache = CACHED_PATTERNS;
        synchronized (basicLruCache) {
            String pattern = CACHED_PATTERNS.get(key);
            if (pattern == null) {
                pattern = ICU.getBestDateTimePatternNative(skeleton, languageTag);
                CACHED_PATTERNS.put(key, pattern);
            }
            return pattern;
        }
    }

    private static final String $$robo$$libcore_icu_ICU$getBestDateTimePatternNative(String string2, String string3) {
        return null;
    }

    private static final char[] $$robo$$libcore_icu_ICU$getDateFormatOrder(String pattern) {
        char[] result = new char[3];
        int resultIndex = 0;
        boolean sawDay = false;
        boolean sawMonth = false;
        boolean sawYear = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == 'd' || ch == 'L' || ch == 'M' || ch == 'y') {
                if (ch == 'd' && !sawDay) {
                    result[resultIndex++] = 100;
                    sawDay = true;
                    continue;
                }
                if (!(ch != 'L' && ch != 'M' || sawMonth)) {
                    result[resultIndex++] = 77;
                    sawMonth = true;
                    continue;
                }
                if (ch != 'y' || sawYear) continue;
                result[resultIndex++] = 121;
                sawYear = true;
                continue;
            }
            if (ch == 'G') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException("Bad pattern character '" + ch + "' in " + pattern);
            }
            if (ch != '\'') continue;
            if (i < pattern.length() - 1 && pattern.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if ((i = pattern.indexOf(39, i + 1)) == -1) {
                throw new IllegalArgumentException("Bad quoting in " + pattern);
            }
            ++i;
        }
        return result;
    }

    private static final String $$robo$$libcore_icu_ICU$getCldrVersion() {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getIcuVersion() {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getUnicodeVersion() {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$toLowerCase(String s, Locale locale) {
        return ICU.toLowerCase(s, locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$toLowerCase(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$toUpperCase(String s, Locale locale) {
        return ICU.toUpperCase(s, locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$toUpperCase(String string2, String string3) {
        return null;
    }

    private static final boolean $$robo$$libcore_icu_ICU$U_FAILURE(int error) {
        return error > 0;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableBreakIteratorLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableCalendarLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableCollatorLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableDateFormatLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableNumberFormatLocalesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getAvailableCurrencyCodes() {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getCurrencyCode(String string2) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getCurrencyDisplayName(Locale locale, String currencyCode) {
        return ICU.getCurrencyDisplayName(locale.toLanguageTag(), currencyCode);
    }

    private static final String $$robo$$libcore_icu_ICU$getCurrencyDisplayName(String string2, String string3) {
        return null;
    }

    private static final int $$robo$$libcore_icu_ICU$getCurrencyFractionDigits(String string2) {
        return 0;
    }

    private static final int $$robo$$libcore_icu_ICU$getCurrencyNumericCode(String string2) {
        return 0;
    }

    private static final String $$robo$$libcore_icu_ICU$getCurrencySymbol(Locale locale, String currencyCode) {
        return ICU.getCurrencySymbol(locale.toLanguageTag(), currencyCode);
    }

    private static final String $$robo$$libcore_icu_ICU$getCurrencySymbol(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayCountry(Locale targetLocale, Locale locale) {
        return ICU.getDisplayCountryNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayCountryNative(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayLanguage(Locale targetLocale, Locale locale) {
        return ICU.getDisplayLanguageNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayLanguageNative(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayVariant(Locale targetLocale, Locale locale) {
        return ICU.getDisplayVariantNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayVariantNative(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayScript(Locale targetLocale, Locale locale) {
        return ICU.getDisplayScriptNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static final String $$robo$$libcore_icu_ICU$getDisplayScriptNative(String string2, String string3) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getISO3Country(String string2) {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getISO3Language(String string2) {
        return null;
    }

    private static final Locale $$robo$$libcore_icu_ICU$addLikelySubtags(Locale locale) {
        return Locale.forLanguageTag(ICU.addLikelySubtags(locale.toLanguageTag()).replace('_', '-'));
    }

    @Deprecated
    private static final String $$robo$$libcore_icu_ICU$addLikelySubtags(String string2) {
        return null;
    }

    @Deprecated
    private static final String $$robo$$libcore_icu_ICU$getScript(String string2) {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getISOLanguagesNative() {
        return null;
    }

    private static final String[] $$robo$$libcore_icu_ICU$getISOCountriesNative() {
        return null;
    }

    private static final boolean $$robo$$libcore_icu_ICU$initLocaleDataNative(String string2, LocaleData localeData) {
        return false;
    }

    private static final void $$robo$$libcore_icu_ICU$setDefaultLocale(String string2) {
    }

    private static final String $$robo$$libcore_icu_ICU$getDefaultLocale() {
        return null;
    }

    private static final String $$robo$$libcore_icu_ICU$getTZDataVersion() {
        return null;
    }

    static void __staticInitializer__() {
        CACHED_PATTERNS = new BasicLruCache(8);
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_ICU$__constructor__();
    }

    public ICU() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_ICU$__constructor__(), 0, this);
    }

    public static String[] getISOLanguages() {
        return InvokeDynamicSupport.bootstrapStatic("getISOLanguages", $$robo$$libcore_icu_ICU$getISOLanguages(), 0);
    }

    public static String[] getISOCountries() {
        return InvokeDynamicSupport.bootstrapStatic("getISOCountries", $$robo$$libcore_icu_ICU$getISOCountries(), 0);
    }

    private static void parseLangScriptRegionAndVariants(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("parseLangScriptRegionAndVariants", $$robo$$libcore_icu_ICU$parseLangScriptRegionAndVariants(java.lang.String java.lang.String[] ), 0, (String)string2, (String[])stringArray);
    }

    public static Locale localeFromIcuLocaleId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("localeFromIcuLocaleId", $$robo$$libcore_icu_ICU$localeFromIcuLocaleId(java.lang.String ), 0, (String)string2);
    }

    public static Locale[] localesFromStrings(String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("localesFromStrings", $$robo$$libcore_icu_ICU$localesFromStrings(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$libcore_icu_ICU$getAvailableLocales(), 0);
    }

    public static Locale[] getAvailableBreakIteratorLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableBreakIteratorLocales", $$robo$$libcore_icu_ICU$getAvailableBreakIteratorLocales(), 0);
    }

    public static Locale[] getAvailableCalendarLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCalendarLocales", $$robo$$libcore_icu_ICU$getAvailableCalendarLocales(), 0);
    }

    public static Locale[] getAvailableCollatorLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCollatorLocales", $$robo$$libcore_icu_ICU$getAvailableCollatorLocales(), 0);
    }

    public static Locale[] getAvailableDateFormatLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableDateFormatLocales", $$robo$$libcore_icu_ICU$getAvailableDateFormatLocales(), 0);
    }

    public static Locale[] getAvailableDateFormatSymbolsLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableDateFormatSymbolsLocales", $$robo$$libcore_icu_ICU$getAvailableDateFormatSymbolsLocales(), 0);
    }

    public static Locale[] getAvailableDecimalFormatSymbolsLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableDecimalFormatSymbolsLocales", $$robo$$libcore_icu_ICU$getAvailableDecimalFormatSymbolsLocales(), 0);
    }

    public static Locale[] getAvailableNumberFormatLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableNumberFormatLocales", $$robo$$libcore_icu_ICU$getAvailableNumberFormatLocales(), 0);
    }

    public static String getBestDateTimePattern(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getBestDateTimePattern", $$robo$$libcore_icu_ICU$getBestDateTimePattern(java.lang.String java.util.Locale ), 0, (String)string2, (Locale)locale);
    }

    private static final native /* synthetic */ String $$robo$$getBestDateTimePatternNative$nativeBinding(String var0, String var1);

    private static String getBestDateTimePatternNative(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getBestDateTimePatternNative", $$robo$$libcore_icu_ICU$getBestDateTimePatternNative(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static char[] getDateFormatOrder(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatOrder", $$robo$$libcore_icu_ICU$getDateFormatOrder(java.lang.String ), 0, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getCldrVersion$nativeBinding();

    public static String getCldrVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getCldrVersion", $$robo$$libcore_icu_ICU$getCldrVersion(), 1);
    }

    private static final native /* synthetic */ String $$robo$$getIcuVersion$nativeBinding();

    public static String getIcuVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getIcuVersion", $$robo$$libcore_icu_ICU$getIcuVersion(), 1);
    }

    private static final native /* synthetic */ String $$robo$$getUnicodeVersion$nativeBinding();

    public static String getUnicodeVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getUnicodeVersion", $$robo$$libcore_icu_ICU$getUnicodeVersion(), 1);
    }

    public static String toLowerCase(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$libcore_icu_ICU$toLowerCase(java.lang.String java.util.Locale ), 0, (String)string2, (Locale)locale);
    }

    private static final native /* synthetic */ String $$robo$$toLowerCase$nativeBinding(String var0, String var1);

    private static String toLowerCase(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$libcore_icu_ICU$toLowerCase(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static String toUpperCase(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$libcore_icu_ICU$toUpperCase(java.lang.String java.util.Locale ), 0, (String)string2, (Locale)locale);
    }

    private static final native /* synthetic */ String $$robo$$toUpperCase$nativeBinding(String var0, String var1);

    private static String toUpperCase(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("toUpperCase", $$robo$$libcore_icu_ICU$toUpperCase(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static boolean U_FAILURE(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("U_FAILURE", $$robo$$libcore_icu_ICU$U_FAILURE(int ), 0, (int)n);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableBreakIteratorLocalesNative$nativeBinding();

    private static String[] getAvailableBreakIteratorLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableBreakIteratorLocalesNative", $$robo$$libcore_icu_ICU$getAvailableBreakIteratorLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableCalendarLocalesNative$nativeBinding();

    private static String[] getAvailableCalendarLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCalendarLocalesNative", $$robo$$libcore_icu_ICU$getAvailableCalendarLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableCollatorLocalesNative$nativeBinding();

    private static String[] getAvailableCollatorLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCollatorLocalesNative", $$robo$$libcore_icu_ICU$getAvailableCollatorLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableDateFormatLocalesNative$nativeBinding();

    private static String[] getAvailableDateFormatLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableDateFormatLocalesNative", $$robo$$libcore_icu_ICU$getAvailableDateFormatLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableLocalesNative$nativeBinding();

    private static String[] getAvailableLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocalesNative", $$robo$$libcore_icu_ICU$getAvailableLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableNumberFormatLocalesNative$nativeBinding();

    private static String[] getAvailableNumberFormatLocalesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableNumberFormatLocalesNative", $$robo$$libcore_icu_ICU$getAvailableNumberFormatLocalesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getAvailableCurrencyCodes$nativeBinding();

    public static String[] getAvailableCurrencyCodes() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCurrencyCodes", $$robo$$libcore_icu_ICU$getAvailableCurrencyCodes(), 1);
    }

    private static final native /* synthetic */ String $$robo$$getCurrencyCode$nativeBinding(String var0);

    public static String getCurrencyCode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyCode", $$robo$$libcore_icu_ICU$getCurrencyCode(java.lang.String ), 1, (String)string2);
    }

    public static String getCurrencyDisplayName(Locale locale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyDisplayName", $$robo$$libcore_icu_ICU$getCurrencyDisplayName(java.util.Locale java.lang.String ), 0, (Locale)locale, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getCurrencyDisplayName$nativeBinding(String var0, String var1);

    private static String getCurrencyDisplayName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyDisplayName", $$robo$$libcore_icu_ICU$getCurrencyDisplayName(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ int $$robo$$getCurrencyFractionDigits$nativeBinding(String var0);

    public static int getCurrencyFractionDigits(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrencyFractionDigits", $$robo$$libcore_icu_ICU$getCurrencyFractionDigits(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$getCurrencyNumericCode$nativeBinding(String var0);

    public static int getCurrencyNumericCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrencyNumericCode", $$robo$$libcore_icu_ICU$getCurrencyNumericCode(java.lang.String ), 1, (String)string2);
    }

    public static String getCurrencySymbol(Locale locale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencySymbol", $$robo$$libcore_icu_ICU$getCurrencySymbol(java.util.Locale java.lang.String ), 0, (Locale)locale, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getCurrencySymbol$nativeBinding(String var0, String var1);

    private static String getCurrencySymbol(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencySymbol", $$robo$$libcore_icu_ICU$getCurrencySymbol(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static String getDisplayCountry(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountry", $$robo$$libcore_icu_ICU$getDisplayCountry(java.util.Locale java.util.Locale ), 0, (Locale)locale, (Locale)locale2);
    }

    private static final native /* synthetic */ String $$robo$$getDisplayCountryNative$nativeBinding(String var0, String var1);

    private static String getDisplayCountryNative(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountryNative", $$robo$$libcore_icu_ICU$getDisplayCountryNative(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static String getDisplayLanguage(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguage", $$robo$$libcore_icu_ICU$getDisplayLanguage(java.util.Locale java.util.Locale ), 0, (Locale)locale, (Locale)locale2);
    }

    private static final native /* synthetic */ String $$robo$$getDisplayLanguageNative$nativeBinding(String var0, String var1);

    private static String getDisplayLanguageNative(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguageNative", $$robo$$libcore_icu_ICU$getDisplayLanguageNative(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static String getDisplayVariant(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayVariant", $$robo$$libcore_icu_ICU$getDisplayVariant(java.util.Locale java.util.Locale ), 0, (Locale)locale, (Locale)locale2);
    }

    private static final native /* synthetic */ String $$robo$$getDisplayVariantNative$nativeBinding(String var0, String var1);

    private static String getDisplayVariantNative(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayVariantNative", $$robo$$libcore_icu_ICU$getDisplayVariantNative(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    public static String getDisplayScript(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScript", $$robo$$libcore_icu_ICU$getDisplayScript(java.util.Locale java.util.Locale ), 0, (Locale)locale, (Locale)locale2);
    }

    private static final native /* synthetic */ String $$robo$$getDisplayScriptNative$nativeBinding(String var0, String var1);

    private static String getDisplayScriptNative(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScriptNative", $$robo$$libcore_icu_ICU$getDisplayScriptNative(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ String $$robo$$getISO3Country$nativeBinding(String var0);

    public static String getISO3Country(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getISO3Country", $$robo$$libcore_icu_ICU$getISO3Country(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getISO3Language$nativeBinding(String var0);

    public static String getISO3Language(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getISO3Language", $$robo$$libcore_icu_ICU$getISO3Language(java.lang.String ), 1, (String)string2);
    }

    public static Locale addLikelySubtags(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("addLikelySubtags", $$robo$$libcore_icu_ICU$addLikelySubtags(java.util.Locale ), 0, (Locale)locale);
    }

    private static final native /* synthetic */ String $$robo$$addLikelySubtags$nativeBinding(String var0);

    @Deprecated
    public static String addLikelySubtags(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("addLikelySubtags", $$robo$$libcore_icu_ICU$addLikelySubtags(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getScript$nativeBinding(String var0);

    @Deprecated
    public static String getScript(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getScript", $$robo$$libcore_icu_ICU$getScript(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String[] $$robo$$getISOLanguagesNative$nativeBinding();

    private static String[] getISOLanguagesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getISOLanguagesNative", $$robo$$libcore_icu_ICU$getISOLanguagesNative(), 1);
    }

    private static final native /* synthetic */ String[] $$robo$$getISOCountriesNative$nativeBinding();

    private static String[] getISOCountriesNative() {
        return InvokeDynamicSupport.bootstrapStatic("getISOCountriesNative", $$robo$$libcore_icu_ICU$getISOCountriesNative(), 1);
    }

    private static final native /* synthetic */ boolean $$robo$$initLocaleDataNative$nativeBinding(String var0, LocaleData var1);

    static boolean initLocaleDataNative(String string2, LocaleData localeData) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("initLocaleDataNative", $$robo$$libcore_icu_ICU$initLocaleDataNative(java.lang.String libcore.icu.LocaleData ), 1, (String)string2, (LocaleData)localeData);
    }

    private static final native /* synthetic */ void $$robo$$setDefaultLocale$nativeBinding(String var0);

    public static void setDefaultLocale(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultLocale", $$robo$$libcore_icu_ICU$setDefaultLocale(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getDefaultLocale$nativeBinding();

    public static String getDefaultLocale() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultLocale", $$robo$$libcore_icu_ICU$getDefaultLocale(), 1);
    }

    private static final native /* synthetic */ String $$robo$$getTZDataVersion$nativeBinding();

    public static String getTZDataVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getTZDataVersion", $$robo$$libcore_icu_ICU$getTZDataVersion(), 1);
    }

    static {
        RobolectricInternals.classInitializing(ICU.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICU)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

