/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.GaiException;
import android.system.Int64Ref;
import android.system.OsConstants;
import android.system.StructAddrinfo;
import android.system.StructLinger;
import android.system.StructPollfd;
import android.system.StructStat;
import android.system.StructStatVfs;
import dalvik.system.BlockGuard;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import libcore.io.ForwardingOs;
import libcore.io.Libcore;
import libcore.io.Os;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BlockGuardOs
extends ForwardingOs
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$libcore_io_BlockGuardOs$__constructor__(Os os) {
    }

    private final FileDescriptor $$robo$$libcore_io_BlockGuardOs$tagSocket(FileDescriptor fd) throws ErrnoException {
        try {
            SocketTagger.get().tag(fd);
            return fd;
        }
        catch (SocketException e) {
            throw new ErrnoException("socket", OsConstants.EINVAL, e);
        }
    }

    private final FileDescriptor $$robo$$libcore_io_BlockGuardOs$accept(FileDescriptor fd, SocketAddress peerAddress) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        FileDescriptor acceptFd = this.os.accept(fd, peerAddress);
        if (BlockGuardOs.isInetSocket(acceptFd)) {
            this.tagSocket(acceptFd);
        }
        return acceptFd;
    }

    private final boolean $$robo$$libcore_io_BlockGuardOs$access(String path, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.access(path, mode);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$chmod(String path, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.chmod(path, mode);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$chown(String path, int uid, int gid) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.chown(path, uid, gid);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$close(FileDescriptor fd) throws ErrnoException {
        try {
            if (fd.isSocket$() && BlockGuardOs.isLingerSocket(fd)) {
                BlockGuard.getThreadPolicy().onNetwork();
            }
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
        this.os.close(fd);
    }

    private static final boolean $$robo$$libcore_io_BlockGuardOs$isInetSocket(FileDescriptor fd) throws ErrnoException {
        return BlockGuardOs.isInetDomain(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_DOMAIN));
    }

    private static final boolean $$robo$$libcore_io_BlockGuardOs$isInetDomain(int domain) {
        return domain == OsConstants.AF_INET || domain == OsConstants.AF_INET6;
    }

    private static final boolean $$robo$$libcore_io_BlockGuardOs$isLingerSocket(FileDescriptor fd) throws ErrnoException {
        StructLinger linger = Libcore.os.getsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
        return linger.isOn() && linger.l_linger > 0;
    }

    private final void $$robo$$libcore_io_BlockGuardOs$connect(FileDescriptor fd, InetAddress address, int port) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        this.os.connect(fd, address, port);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$connect(FileDescriptor fd, SocketAddress address) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        this.os.connect(fd, address);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$fchmod(FileDescriptor fd, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.fchmod(fd, mode);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$fchown(FileDescriptor fd, int uid, int gid) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.fchown(fd, uid, gid);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$fdatasync(FileDescriptor fd) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.fdatasync(fd);
    }

    private final StructStat $$robo$$libcore_io_BlockGuardOs$fstat(FileDescriptor fd) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.fstat(fd);
    }

    private final StructStatVfs $$robo$$libcore_io_BlockGuardOs$fstatvfs(FileDescriptor fd) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.fstatvfs(fd);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$fsync(FileDescriptor fd) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.fsync(fd);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$ftruncate(FileDescriptor fd, long length) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.ftruncate(fd, length);
    }

    private final InetAddress[] $$robo$$libcore_io_BlockGuardOs$android_getaddrinfo(String node, StructAddrinfo hints, int netId) throws GaiException {
        boolean isNumericHost;
        boolean bl = isNumericHost = (hints.ai_flags & OsConstants.AI_NUMERICHOST) != 0;
        if (!isNumericHost) {
            BlockGuard.getThreadPolicy().onNetwork();
        }
        return this.os.android_getaddrinfo(node, hints, netId);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$lchown(String path, int uid, int gid) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.lchown(path, uid, gid);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$link(String oldPath, String newPath) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.link(oldPath, newPath);
    }

    private final long $$robo$$libcore_io_BlockGuardOs$lseek(FileDescriptor fd, long offset, int whence) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.lseek(fd, offset, whence);
    }

    private final StructStat $$robo$$libcore_io_BlockGuardOs$lstat(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.lstat(path);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$mkdir(String path, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.mkdir(path, mode);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$mkfifo(String path, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.mkfifo(path, mode);
    }

    private final FileDescriptor $$robo$$libcore_io_BlockGuardOs$open(String path, int flags, int mode) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        if ((flags & OsConstants.O_ACCMODE) != OsConstants.O_RDONLY) {
            BlockGuard.getThreadPolicy().onWriteToDisk();
        }
        return this.os.open(path, flags, mode);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$poll(StructPollfd[] fds, int timeoutMs) throws ErrnoException {
        if (timeoutMs != 0) {
            BlockGuard.getThreadPolicy().onNetwork();
        }
        return this.os.poll(fds, timeoutMs);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$posix_fallocate(FileDescriptor fd, long offset, long length) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.posix_fallocate(fd, offset, length);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.pread(fd, buffer, offset);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.pread(fd, bytes, byteOffset, byteCount, offset);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.pwrite(fd, buffer, offset);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.pwrite(fd, bytes, byteOffset, byteCount, offset);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.read(fd, buffer);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.read(fd, bytes, byteOffset, byteCount);
    }

    private final String $$robo$$libcore_io_BlockGuardOs$readlink(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.readlink(path);
    }

    private final String $$robo$$libcore_io_BlockGuardOs$realpath(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.realpath(path);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$readv(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.readv(fd, buffers, offsets, byteCounts);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        return this.os.recvfrom(fd, buffer, flags, srcAddress);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        return this.os.recvfrom(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$remove(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.remove(path);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$rename(String oldPath, String newPath) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.rename(oldPath, newPath);
    }

    private final long $$robo$$libcore_io_BlockGuardOs$sendfile(FileDescriptor outFd, FileDescriptor inFd, Int64Ref offset, long byteCount) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.sendfile(outFd, inFd, offset, byteCount);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        return this.os.sendto(fd, buffer, flags, inetAddress, port);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        if (inetAddress != null) {
            BlockGuard.getThreadPolicy().onNetwork();
        }
        return this.os.sendto(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    private final FileDescriptor $$robo$$libcore_io_BlockGuardOs$socket(int domain, int type, int protocol) throws ErrnoException {
        FileDescriptor fd = this.os.socket(domain, type, protocol);
        if (BlockGuardOs.isInetDomain(domain)) {
            this.tagSocket(fd);
        }
        return fd;
    }

    private final void $$robo$$libcore_io_BlockGuardOs$socketpair(int domain, int type, int protocol, FileDescriptor fd1, FileDescriptor fd2) throws ErrnoException {
        this.os.socketpair(domain, type, protocol, fd1, fd2);
        if (BlockGuardOs.isInetDomain(domain)) {
            this.tagSocket(fd1);
            this.tagSocket(fd2);
        }
    }

    private final StructStat $$robo$$libcore_io_BlockGuardOs$stat(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.stat(path);
    }

    private final StructStatVfs $$robo$$libcore_io_BlockGuardOs$statvfs(String path) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.statvfs(path);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$symlink(String oldPath, String newPath) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.symlink(oldPath, newPath);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.write(fd, buffer);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.write(fd, bytes, byteOffset, byteCount);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$writev(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws ErrnoException, InterruptedIOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.os.writev(fd, buffers, offsets, byteCounts);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$execv(String filename, String[] argv) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        this.os.execv(filename, argv);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$execve(String filename, String[] argv, String[] envp) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        this.os.execve(filename, argv, envp);
    }

    private final byte[] $$robo$$libcore_io_BlockGuardOs$getxattr(String path, String name) throws ErrnoException {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.getxattr(path, name);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$msync(long address, long byteCount, int flags) throws ErrnoException {
        if ((flags & OsConstants.MS_SYNC) != 0) {
            BlockGuard.getThreadPolicy().onWriteToDisk();
        }
        this.os.msync(address, byteCount, flags);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$removexattr(String path, String name) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.removexattr(path, name);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$setxattr(String path, String name, byte[] value, int flags) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.setxattr(path, name, value, flags);
    }

    private final int $$robo$$libcore_io_BlockGuardOs$sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, SocketAddress address) throws ErrnoException, SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        return this.os.sendto(fd, bytes, byteOffset, byteCount, flags, address);
    }

    private final void $$robo$$libcore_io_BlockGuardOs$unlink(String pathname) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.os.unlink(pathname);
    }

    private final long $$robo$$libcore_io_BlockGuardOs$splice(FileDescriptor fdIn, Int64Ref offIn, FileDescriptor fdOut, Int64Ref offOut, long len, int flags) throws ErrnoException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.os.splice(fdIn, offIn, fdOut, offOut, len, flags);
    }

    private void __constructor__(Os os) {
        this.$$robo$$libcore_io_BlockGuardOs$__constructor__(os);
    }

    public BlockGuardOs(Os os) {
        super(os);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_BlockGuardOs$__constructor__(libcore.io.Os ), 0, this, os);
    }

    private FileDescriptor tagSocket(FileDescriptor fileDescriptor) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("tagSocket", $$robo$$libcore_io_BlockGuardOs$tagSocket(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    @Override
    public FileDescriptor accept(FileDescriptor fileDescriptor, SocketAddress socketAddress) throws ErrnoException, SocketException {
        return InvokeDynamicSupport.bootstrap("accept", $$robo$$libcore_io_BlockGuardOs$accept(java.io.FileDescriptor java.net.SocketAddress ), 0, this, fileDescriptor, socketAddress);
    }

    @Override
    public boolean access(String string2, int n) throws ErrnoException {
        return (boolean)InvokeDynamicSupport.bootstrap("access", $$robo$$libcore_io_BlockGuardOs$access(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public void chmod(String string2, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("chmod", $$robo$$libcore_io_BlockGuardOs$chmod(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public void chown(String string2, int n, int n2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("chown", $$robo$$libcore_io_BlockGuardOs$chown(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public void close(FileDescriptor fileDescriptor) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_BlockGuardOs$close(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    private static boolean isInetSocket(FileDescriptor fileDescriptor) throws ErrnoException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInetSocket", $$robo$$libcore_io_BlockGuardOs$isInetSocket(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    private static boolean isInetDomain(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInetDomain", $$robo$$libcore_io_BlockGuardOs$isInetDomain(int ), 0, (int)n);
    }

    private static boolean isLingerSocket(FileDescriptor fileDescriptor) throws ErrnoException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLingerSocket", $$robo$$libcore_io_BlockGuardOs$isLingerSocket(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    @Override
    public void connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_io_BlockGuardOs$connect(java.io.FileDescriptor java.net.InetAddress int ), 0, this, fileDescriptor, inetAddress, n);
    }

    @Override
    public void connect(FileDescriptor fileDescriptor, SocketAddress socketAddress) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$libcore_io_BlockGuardOs$connect(java.io.FileDescriptor java.net.SocketAddress ), 0, this, fileDescriptor, socketAddress);
    }

    @Override
    public void fchmod(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("fchmod", $$robo$$libcore_io_BlockGuardOs$fchmod(java.io.FileDescriptor int ), 0, this, fileDescriptor, n);
    }

    @Override
    public void fchown(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("fchown", $$robo$$libcore_io_BlockGuardOs$fchown(java.io.FileDescriptor int int ), 0, this, fileDescriptor, n, n2);
    }

    @Override
    public void fdatasync(FileDescriptor fileDescriptor) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("fdatasync", $$robo$$libcore_io_BlockGuardOs$fdatasync(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    @Override
    public StructStat fstat(FileDescriptor fileDescriptor) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("fstat", $$robo$$libcore_io_BlockGuardOs$fstat(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    @Override
    public StructStatVfs fstatvfs(FileDescriptor fileDescriptor) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("fstatvfs", $$robo$$libcore_io_BlockGuardOs$fstatvfs(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    @Override
    public void fsync(FileDescriptor fileDescriptor) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("fsync", $$robo$$libcore_io_BlockGuardOs$fsync(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    @Override
    public void ftruncate(FileDescriptor fileDescriptor, long l) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("ftruncate", $$robo$$libcore_io_BlockGuardOs$ftruncate(java.io.FileDescriptor long ), 0, this, fileDescriptor, l);
    }

    @Override
    public InetAddress[] android_getaddrinfo(String string2, StructAddrinfo structAddrinfo, int n) throws GaiException {
        return InvokeDynamicSupport.bootstrap("android_getaddrinfo", $$robo$$libcore_io_BlockGuardOs$android_getaddrinfo(java.lang.String android.system.StructAddrinfo int ), 0, this, string2, structAddrinfo, n);
    }

    @Override
    public void lchown(String string2, int n, int n2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("lchown", $$robo$$libcore_io_BlockGuardOs$lchown(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public void link(String string2, String string3) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("link", $$robo$$libcore_io_BlockGuardOs$link(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public long lseek(FileDescriptor fileDescriptor, long l, int n) throws ErrnoException {
        return (long)InvokeDynamicSupport.bootstrap("lseek", $$robo$$libcore_io_BlockGuardOs$lseek(java.io.FileDescriptor long int ), 0, this, fileDescriptor, l, n);
    }

    @Override
    public StructStat lstat(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("lstat", $$robo$$libcore_io_BlockGuardOs$lstat(java.lang.String ), 0, this, string2);
    }

    @Override
    public void mkdir(String string2, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("mkdir", $$robo$$libcore_io_BlockGuardOs$mkdir(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public void mkfifo(String string2, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("mkfifo", $$robo$$libcore_io_BlockGuardOs$mkfifo(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public FileDescriptor open(String string2, int n, int n2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$libcore_io_BlockGuardOs$open(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public int poll(StructPollfd[] structPollfdArray, int n) throws ErrnoException {
        return (int)InvokeDynamicSupport.bootstrap("poll", $$robo$$libcore_io_BlockGuardOs$poll(android.system.StructPollfd[] int ), 0, this, structPollfdArray, n);
    }

    @Override
    public void posix_fallocate(FileDescriptor fileDescriptor, long l, long l2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("posix_fallocate", $$robo$$libcore_io_BlockGuardOs$posix_fallocate(java.io.FileDescriptor long long ), 0, this, fileDescriptor, l, l2);
    }

    @Override
    public int pread(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("pread", $$robo$$libcore_io_BlockGuardOs$pread(java.io.FileDescriptor java.nio.ByteBuffer long ), 0, this, fileDescriptor, byteBuffer, l);
    }

    @Override
    public int pread(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, long l) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("pread", $$robo$$libcore_io_BlockGuardOs$pread(java.io.FileDescriptor byte[] int int long ), 0, this, fileDescriptor, byArray, n, n2, l);
    }

    @Override
    public int pwrite(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("pwrite", $$robo$$libcore_io_BlockGuardOs$pwrite(java.io.FileDescriptor java.nio.ByteBuffer long ), 0, this, fileDescriptor, byteBuffer, l);
    }

    @Override
    public int pwrite(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, long l) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("pwrite", $$robo$$libcore_io_BlockGuardOs$pwrite(java.io.FileDescriptor byte[] int int long ), 0, this, fileDescriptor, byArray, n, n2, l);
    }

    @Override
    public int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$libcore_io_BlockGuardOs$read(java.io.FileDescriptor java.nio.ByteBuffer ), 0, this, fileDescriptor, byteBuffer);
    }

    @Override
    public int read(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$libcore_io_BlockGuardOs$read(java.io.FileDescriptor byte[] int int ), 0, this, fileDescriptor, byArray, n, n2);
    }

    @Override
    public String readlink(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("readlink", $$robo$$libcore_io_BlockGuardOs$readlink(java.lang.String ), 0, this, string2);
    }

    @Override
    public String realpath(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("realpath", $$robo$$libcore_io_BlockGuardOs$realpath(java.lang.String ), 0, this, string2);
    }

    @Override
    public int readv(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("readv", $$robo$$libcore_io_BlockGuardOs$readv(java.io.FileDescriptor java.lang.Object[] int[] int[] ), 0, this, fileDescriptor, objectArray, nArray, nArray2);
    }

    @Override
    public int recvfrom(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, InetSocketAddress inetSocketAddress) throws ErrnoException, SocketException {
        return (int)InvokeDynamicSupport.bootstrap("recvfrom", $$robo$$libcore_io_BlockGuardOs$recvfrom(java.io.FileDescriptor java.nio.ByteBuffer int java.net.InetSocketAddress ), 0, this, fileDescriptor, byteBuffer, n, inetSocketAddress);
    }

    @Override
    public int recvfrom(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3, InetSocketAddress inetSocketAddress) throws ErrnoException, SocketException {
        return (int)InvokeDynamicSupport.bootstrap("recvfrom", $$robo$$libcore_io_BlockGuardOs$recvfrom(java.io.FileDescriptor byte[] int int int java.net.InetSocketAddress ), 0, this, fileDescriptor, byArray, n, n2, n3, inetSocketAddress);
    }

    @Override
    public void remove(String string2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$libcore_io_BlockGuardOs$remove(java.lang.String ), 0, this, string2);
    }

    @Override
    public void rename(String string2, String string3) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("rename", $$robo$$libcore_io_BlockGuardOs$rename(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public long sendfile(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, Int64Ref int64Ref, long l) throws ErrnoException {
        return (long)InvokeDynamicSupport.bootstrap("sendfile", $$robo$$libcore_io_BlockGuardOs$sendfile(java.io.FileDescriptor java.io.FileDescriptor android.system.Int64Ref long ), 0, this, fileDescriptor, fileDescriptor2, int64Ref, l);
    }

    @Override
    public int sendto(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, InetAddress inetAddress, int n2) throws ErrnoException, SocketException {
        return (int)InvokeDynamicSupport.bootstrap("sendto", $$robo$$libcore_io_BlockGuardOs$sendto(java.io.FileDescriptor java.nio.ByteBuffer int java.net.InetAddress int ), 0, this, fileDescriptor, byteBuffer, n, inetAddress, n2);
    }

    @Override
    public int sendto(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3, InetAddress inetAddress, int n4) throws ErrnoException, SocketException {
        return (int)InvokeDynamicSupport.bootstrap("sendto", $$robo$$libcore_io_BlockGuardOs$sendto(java.io.FileDescriptor byte[] int int int java.net.InetAddress int ), 0, this, fileDescriptor, byArray, n, n2, n3, inetAddress, n4);
    }

    @Override
    public FileDescriptor socket(int n, int n2, int n3) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("socket", $$robo$$libcore_io_BlockGuardOs$socket(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void socketpair(int n, int n2, int n3, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("socketpair", $$robo$$libcore_io_BlockGuardOs$socketpair(int int int java.io.FileDescriptor java.io.FileDescriptor ), 0, this, n, n2, n3, fileDescriptor, fileDescriptor2);
    }

    @Override
    public StructStat stat(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("stat", $$robo$$libcore_io_BlockGuardOs$stat(java.lang.String ), 0, this, string2);
    }

    @Override
    public StructStatVfs statvfs(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("statvfs", $$robo$$libcore_io_BlockGuardOs$statvfs(java.lang.String ), 0, this, string2);
    }

    @Override
    public void symlink(String string2, String string3) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("symlink", $$robo$$libcore_io_BlockGuardOs$symlink(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$libcore_io_BlockGuardOs$write(java.io.FileDescriptor java.nio.ByteBuffer ), 0, this, fileDescriptor, byteBuffer);
    }

    @Override
    public int write(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$libcore_io_BlockGuardOs$write(java.io.FileDescriptor byte[] int int ), 0, this, fileDescriptor, byArray, n, n2);
    }

    @Override
    public int writev(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrap("writev", $$robo$$libcore_io_BlockGuardOs$writev(java.io.FileDescriptor java.lang.Object[] int[] int[] ), 0, this, fileDescriptor, objectArray, nArray, nArray2);
    }

    @Override
    public void execv(String string2, String[] stringArray) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("execv", $$robo$$libcore_io_BlockGuardOs$execv(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    @Override
    public void execve(String string2, String[] stringArray, String[] stringArray2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("execve", $$robo$$libcore_io_BlockGuardOs$execve(java.lang.String java.lang.String[] java.lang.String[] ), 0, this, string2, stringArray, stringArray2);
    }

    @Override
    public byte[] getxattr(String string2, String string3) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("getxattr", $$robo$$libcore_io_BlockGuardOs$getxattr(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void msync(long l, long l2, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("msync", $$robo$$libcore_io_BlockGuardOs$msync(long long int ), 0, this, l, l2, n);
    }

    @Override
    public void removexattr(String string2, String string3) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("removexattr", $$robo$$libcore_io_BlockGuardOs$removexattr(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void setxattr(String string2, String string3, byte[] byArray, int n) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("setxattr", $$robo$$libcore_io_BlockGuardOs$setxattr(java.lang.String java.lang.String byte[] int ), 0, this, string2, string3, byArray, n);
    }

    @Override
    public int sendto(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3, SocketAddress socketAddress) throws ErrnoException, SocketException {
        return (int)InvokeDynamicSupport.bootstrap("sendto", $$robo$$libcore_io_BlockGuardOs$sendto(java.io.FileDescriptor byte[] int int int java.net.SocketAddress ), 0, this, fileDescriptor, byArray, n, n2, n3, socketAddress);
    }

    @Override
    public void unlink(String string2) throws ErrnoException {
        InvokeDynamicSupport.bootstrap("unlink", $$robo$$libcore_io_BlockGuardOs$unlink(java.lang.String ), 0, this, string2);
    }

    @Override
    public long splice(FileDescriptor fileDescriptor, Int64Ref int64Ref, FileDescriptor fileDescriptor2, Int64Ref int64Ref2, long l, int n) throws ErrnoException {
        return (long)InvokeDynamicSupport.bootstrap("splice", $$robo$$libcore_io_BlockGuardOs$splice(java.io.FileDescriptor android.system.Int64Ref java.io.FileDescriptor android.system.Int64Ref long int ), 0, this, fileDescriptor, int64Ref, fileDescriptor2, int64Ref2, l, n);
    }

    public /* synthetic */ BlockGuardOs() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockGuardOs)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

