/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.google.errorprone.annotations.DoNotMock;
import libcore.io.BufferIterator;
import libcore.io.Memory;
import libcore.io.MemoryMappedFile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NioBufferIterator
extends BufferIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private MemoryMappedFile file;
    private long address;
    private int length;
    private boolean swap;
    private int position;

    private void $$robo$$libcore_io_NioBufferIterator$__constructor__(MemoryMappedFile file, long address, int length, boolean swap) {
        file.checkNotClosed();
        this.file = file;
        this.address = address;
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        long MAX_VALID_ADDRESS = -1L;
        if (Long.compareUnsigned(address, -1L - (long)length) > 0) {
            throw new IllegalArgumentException("length " + length + " would overflow 64-bit address space");
        }
        this.length = length;
        this.swap = swap;
    }

    private final void $$robo$$libcore_io_NioBufferIterator$seek(int offset) {
        this.position = offset;
    }

    private final void $$robo$$libcore_io_NioBufferIterator$skip(int byteCount) {
        this.position += byteCount;
    }

    private final int $$robo$$libcore_io_NioBufferIterator$pos() {
        return this.position;
    }

    private final void $$robo$$libcore_io_NioBufferIterator$readByteArray(byte[] dst, int dstOffset, int byteCount) {
        NioBufferIterator.checkDstBounds(dstOffset, dst.length, byteCount);
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekByteArray(this.address + (long)this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
    }

    private final byte $$robo$$libcore_io_NioBufferIterator$readByte() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 1);
        byte result = Memory.peekByte(this.address + (long)this.position);
        ++this.position;
        return result;
    }

    private final int $$robo$$libcore_io_NioBufferIterator$readInt() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 4);
        int result = Memory.peekInt(this.address + (long)this.position, this.swap);
        this.position += 4;
        return result;
    }

    private final void $$robo$$libcore_io_NioBufferIterator$readIntArray(int[] dst, int dstOffset, int intCount) {
        NioBufferIterator.checkDstBounds(dstOffset, dst.length, intCount);
        this.file.checkNotClosed();
        int byteCount = 4 * intCount;
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekIntArray(this.address + (long)this.position, dst, dstOffset, intCount, this.swap);
        this.position += byteCount;
    }

    private final short $$robo$$libcore_io_NioBufferIterator$readShort() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 2);
        short result = Memory.peekShort(this.address + (long)this.position, this.swap);
        this.position += 2;
        return result;
    }

    private static final void $$robo$$libcore_io_NioBufferIterator$checkReadBounds(int position, int length, int byteCount) {
        if (position < 0 || byteCount < 0) {
            throw new IndexOutOfBoundsException("Invalid read args: position=" + position + ", byteCount=" + byteCount);
        }
        int finalReadPos = position + byteCount;
        if (finalReadPos < 0 || finalReadPos > length) {
            throw new IndexOutOfBoundsException("Read outside range: position=" + position + ", byteCount=" + byteCount + ", length=" + length);
        }
    }

    private static final void $$robo$$libcore_io_NioBufferIterator$checkDstBounds(int dstOffset, int dstLength, int count) {
        if (dstOffset < 0 || count < 0) {
            throw new IndexOutOfBoundsException("Invalid dst args: offset=" + dstLength + ", count=" + count);
        }
        int targetPos = dstOffset + count;
        if (targetPos < 0 || targetPos > dstLength) {
            throw new IndexOutOfBoundsException("Write outside range: dst.length=" + dstLength + ", offset=" + dstOffset + ", count=" + count);
        }
    }

    private void __constructor__(MemoryMappedFile memoryMappedFile, long l, int n, boolean bl) {
        this.$$robo$$libcore_io_NioBufferIterator$__constructor__(memoryMappedFile, l, n, bl);
    }

    NioBufferIterator(MemoryMappedFile memoryMappedFile, long l, int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_NioBufferIterator$__constructor__(libcore.io.MemoryMappedFile long int boolean ), 0, this, memoryMappedFile, l, n, bl);
    }

    @Override
    public void seek(int n) {
        InvokeDynamicSupport.bootstrap("seek", $$robo$$libcore_io_NioBufferIterator$seek(int ), 0, this, n);
    }

    @Override
    public void skip(int n) {
        InvokeDynamicSupport.bootstrap("skip", $$robo$$libcore_io_NioBufferIterator$skip(int ), 0, this, n);
    }

    @Override
    public int pos() {
        return (int)InvokeDynamicSupport.bootstrap("pos", $$robo$$libcore_io_NioBufferIterator$pos(), 0, this);
    }

    @Override
    public void readByteArray(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("readByteArray", $$robo$$libcore_io_NioBufferIterator$readByteArray(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public byte readByte() {
        return (byte)InvokeDynamicSupport.bootstrap("readByte", $$robo$$libcore_io_NioBufferIterator$readByte(), 0, this);
    }

    @Override
    public int readInt() {
        return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$libcore_io_NioBufferIterator$readInt(), 0, this);
    }

    @Override
    public void readIntArray(int[] nArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("readIntArray", $$robo$$libcore_io_NioBufferIterator$readIntArray(int[] int int ), 0, this, nArray, n, n2);
    }

    @Override
    public short readShort() {
        return (short)InvokeDynamicSupport.bootstrap("readShort", $$robo$$libcore_io_NioBufferIterator$readShort(), 0, this);
    }

    private static void checkReadBounds(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("checkReadBounds", $$robo$$libcore_io_NioBufferIterator$checkReadBounds(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    private static void checkDstBounds(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("checkDstBounds", $$robo$$libcore_io_NioBufferIterator$checkDstBounds(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public /* synthetic */ NioBufferIterator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NioBufferIterator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

