/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.icu.util.TimeZone;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CountryTimeZones
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String countryIso;
    private String defaultTimeZoneId;
    private List<TimeZoneMapping> timeZoneMappings;
    private boolean everUsesUtc;
    private TimeZone icuDefaultTimeZone;
    private List<TimeZone> icuTimeZones;

    private void $$robo$$libcore_util_CountryTimeZones$__constructor__(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings) {
        this.countryIso = Objects.requireNonNull(countryIso);
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.everUsesUtc = everUsesUtc;
        this.timeZoneMappings = Collections.unmodifiableList(new ArrayList<TimeZoneMapping>(timeZoneMappings));
    }

    private static final CountryTimeZones $$robo$$libcore_util_CountryTimeZones$createValidated(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings, String debugInfo) {
        String[] validTimeZoneIdsArray = ZoneInfoDB.getInstance().getAvailableIDs();
        HashSet<String> validTimeZoneIdsSet = new HashSet<String>(Arrays.asList(validTimeZoneIdsArray));
        ArrayList<TimeZoneMapping> validCountryTimeZoneMappings = new ArrayList<TimeZoneMapping>();
        for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            String timeZoneId = timeZoneMapping.timeZoneId;
            if (!validTimeZoneIdsSet.contains(timeZoneId)) {
                InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("Skipping invalid zone: " + timeZoneId + " at " + debugInfo));
                continue;
            }
            validCountryTimeZoneMappings.add(timeZoneMapping);
        }
        if (!validTimeZoneIdsSet.contains(defaultTimeZoneId)) {
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("Invalid default time zone ID: " + defaultTimeZoneId + " at " + debugInfo));
            defaultTimeZoneId = null;
        }
        String normalizedCountryIso = CountryTimeZones.normalizeCountryIso(countryIso);
        return new CountryTimeZones(normalizedCountryIso, defaultTimeZoneId, everUsesUtc, validCountryTimeZoneMappings);
    }

    private final String $$robo$$libcore_util_CountryTimeZones$getCountryIso() {
        return this.countryIso;
    }

    private final boolean $$robo$$libcore_util_CountryTimeZones$isForCountryCode(String countryIso) {
        return this.countryIso.equals(CountryTimeZones.normalizeCountryIso(countryIso));
    }

    private final synchronized TimeZone $$robo$$libcore_util_CountryTimeZones$getDefaultTimeZone() {
        if (this.icuDefaultTimeZone == null) {
            TimeZone defaultTimeZone = this.defaultTimeZoneId == null ? null : CountryTimeZones.getValidFrozenTimeZoneOrNull(this.defaultTimeZoneId);
            this.icuDefaultTimeZone = defaultTimeZone;
        }
        return this.icuDefaultTimeZone;
    }

    private final String $$robo$$libcore_util_CountryTimeZones$getDefaultTimeZoneId() {
        return this.defaultTimeZoneId;
    }

    private final List<TimeZoneMapping> $$robo$$libcore_util_CountryTimeZones$getTimeZoneMappings() {
        return this.timeZoneMappings;
    }

    private final boolean $$robo$$libcore_util_CountryTimeZones$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryTimeZones that = (CountryTimeZones)o;
        if (this.everUsesUtc != that.everUsesUtc) {
            return false;
        }
        if (!this.countryIso.equals(that.countryIso)) {
            return false;
        }
        if (this.defaultTimeZoneId != null ? !this.defaultTimeZoneId.equals(that.defaultTimeZoneId) : that.defaultTimeZoneId != null) {
            return false;
        }
        return this.timeZoneMappings.equals(that.timeZoneMappings);
    }

    private final int $$robo$$libcore_util_CountryTimeZones$hashCode() {
        int result = this.countryIso.hashCode();
        result = 31 * result + (this.defaultTimeZoneId != null ? this.defaultTimeZoneId.hashCode() : 0);
        result = 31 * result + this.timeZoneMappings.hashCode();
        result = 31 * result + (this.everUsesUtc ? 1 : 0);
        return result;
    }

    private final synchronized List<TimeZone> $$robo$$libcore_util_CountryTimeZones$getIcuTimeZones() {
        if (this.icuTimeZones == null) {
            ArrayList<TimeZone> mutableList = new ArrayList<TimeZone>(this.timeZoneMappings.size());
            for (TimeZoneMapping timeZoneMapping : this.timeZoneMappings) {
                String timeZoneId = timeZoneMapping.timeZoneId;
                TimeZone timeZone = timeZoneId.equals(this.defaultTimeZoneId) ? this.getDefaultTimeZone() : CountryTimeZones.getValidFrozenTimeZoneOrNull(timeZoneId);
                if (timeZone == null) {
                    InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("Skipping invalid zone: " + timeZoneId));
                    continue;
                }
                mutableList.add(timeZone);
            }
            this.icuTimeZones = Collections.unmodifiableList(mutableList);
        }
        return this.icuTimeZones;
    }

    private final boolean $$robo$$libcore_util_CountryTimeZones$hasUtcZone(long whenMillis) {
        if (!this.everUsesUtc) {
            return false;
        }
        for (TimeZone zone : this.getIcuTimeZones()) {
            if (zone.getOffset(whenMillis) != 0) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$libcore_util_CountryTimeZones$isDefaultOkForCountryTimeZoneDetection(long whenMillis) {
        if (this.timeZoneMappings.isEmpty()) {
            return false;
        }
        if (this.timeZoneMappings.size() == 1) {
            return true;
        }
        TimeZone countryDefault = this.getDefaultTimeZone();
        if (countryDefault == null) {
            return false;
        }
        int countryDefaultOffset = countryDefault.getOffset(whenMillis);
        List<TimeZone> candidates = this.getIcuTimeZones();
        for (TimeZone candidate : candidates) {
            int candidateOffset;
            if (candidate == countryDefault || countryDefaultOffset == (candidateOffset = candidate.getOffset(whenMillis))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    private final OffsetResult $$robo$$libcore_util_CountryTimeZones$lookupByOffsetWithBias(int offsetMillis, boolean isDst, long whenMillis, TimeZone bias) {
        if (this.timeZoneMappings == null || this.timeZoneMappings.isEmpty()) {
            return null;
        }
        List<TimeZone> candidates = this.getIcuTimeZones();
        TimeZone firstMatch = null;
        boolean biasMatched = false;
        boolean oneMatch = true;
        for (TimeZone match : candidates) {
            if (!CountryTimeZones.offsetMatchesAtTime(match, offsetMillis, isDst, whenMillis)) continue;
            if (firstMatch == null) {
                firstMatch = match;
            } else {
                oneMatch = false;
            }
            if (bias != null && match.getID().equals(bias.getID())) {
                biasMatched = true;
            }
            if (firstMatch == null || oneMatch || bias != null && !biasMatched) continue;
            break;
        }
        if (firstMatch == null) {
            return null;
        }
        TimeZone toReturn = biasMatched ? bias : firstMatch;
        return new OffsetResult(toReturn, oneMatch);
    }

    private static final boolean $$robo$$libcore_util_CountryTimeZones$offsetMatchesAtTime(TimeZone timeZone, int offsetMillis, boolean isDst, long whenMillis) {
        boolean zoneIsDst;
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        boolean bl = zoneIsDst = offsets[1] != 0;
        if (isDst != zoneIsDst) {
            return false;
        }
        return offsetMillis == offsets[0] + offsets[1];
    }

    private final OffsetResult $$robo$$libcore_util_CountryTimeZones$lookupByOffsetWithBias(int offsetMillis, Integer dstOffsetMillis, long whenMillis, TimeZone bias) {
        if (this.timeZoneMappings == null || this.timeZoneMappings.isEmpty()) {
            return null;
        }
        List<TimeZone> candidates = this.getIcuTimeZones();
        TimeZone firstMatch = null;
        boolean biasMatched = false;
        boolean oneMatch = true;
        for (TimeZone match : candidates) {
            if (!CountryTimeZones.offsetMatchesAtTime(match, offsetMillis, dstOffsetMillis, whenMillis)) continue;
            if (firstMatch == null) {
                firstMatch = match;
            } else {
                oneMatch = false;
            }
            if (bias != null && match.getID().equals(bias.getID())) {
                biasMatched = true;
            }
            if (firstMatch == null || oneMatch || bias != null && !biasMatched) continue;
            break;
        }
        if (firstMatch == null) {
            return null;
        }
        TimeZone toReturn = biasMatched ? bias : firstMatch;
        return new OffsetResult(toReturn, oneMatch);
    }

    private static final boolean $$robo$$libcore_util_CountryTimeZones$offsetMatchesAtTime(TimeZone timeZone, int offsetMillis, Integer dstOffsetMillis, long whenMillis) {
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        if (dstOffsetMillis != null && dstOffsetMillis != offsets[1]) {
            return false;
        }
        return offsetMillis == offsets[0] + offsets[1];
    }

    private static final TimeZone $$robo$$libcore_util_CountryTimeZones$getValidFrozenTimeZoneOrNull(String timeZoneId) {
        TimeZone timeZone = TimeZone.getFrozenTimeZone(timeZoneId);
        if (timeZone.getID().equals("Etc/Unknown")) {
            return null;
        }
        return timeZone;
    }

    private static final String $$robo$$libcore_util_CountryTimeZones$normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    private void __constructor__(String string2, String string3, boolean bl, List<TimeZoneMapping> list) {
        this.$$robo$$libcore_util_CountryTimeZones$__constructor__(string2, string3, bl, list);
    }

    private CountryTimeZones(String string2, String string3, boolean bl, List<TimeZoneMapping> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_CountryTimeZones$__constructor__(java.lang.String java.lang.String boolean java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> ), 0, this, string2, string3, bl, list);
    }

    public static CountryTimeZones createValidated(String string2, String string3, boolean bl, List<TimeZoneMapping> list, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("createValidated", $$robo$$libcore_util_CountryTimeZones$createValidated(java.lang.String java.lang.String boolean java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> java.lang.String ), 0, (String)string2, (String)string3, (boolean)bl, list, (String)string4);
    }

    public String getCountryIso() {
        return InvokeDynamicSupport.bootstrap("getCountryIso", $$robo$$libcore_util_CountryTimeZones$getCountryIso(), 0, this);
    }

    public boolean isForCountryCode(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isForCountryCode", $$robo$$libcore_util_CountryTimeZones$isForCountryCode(java.lang.String ), 0, this, string2);
    }

    public synchronized TimeZone getDefaultTimeZone() {
        return InvokeDynamicSupport.bootstrap("getDefaultTimeZone", $$robo$$libcore_util_CountryTimeZones$getDefaultTimeZone(), 0, this);
    }

    public String getDefaultTimeZoneId() {
        return InvokeDynamicSupport.bootstrap("getDefaultTimeZoneId", $$robo$$libcore_util_CountryTimeZones$getDefaultTimeZoneId(), 0, this);
    }

    public List<TimeZoneMapping> getTimeZoneMappings() {
        return InvokeDynamicSupport.bootstrap("getTimeZoneMappings", $$robo$$libcore_util_CountryTimeZones$getTimeZoneMappings(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_util_CountryTimeZones$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_util_CountryTimeZones$hashCode(), 0, this);
    }

    public synchronized List<TimeZone> getIcuTimeZones() {
        return InvokeDynamicSupport.bootstrap("getIcuTimeZones", $$robo$$libcore_util_CountryTimeZones$getIcuTimeZones(), 0, this);
    }

    public boolean hasUtcZone(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUtcZone", $$robo$$libcore_util_CountryTimeZones$hasUtcZone(long ), 0, this, l);
    }

    public boolean isDefaultOkForCountryTimeZoneDetection(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultOkForCountryTimeZoneDetection", $$robo$$libcore_util_CountryTimeZones$isDefaultOkForCountryTimeZoneDetection(long ), 0, this, l);
    }

    @Deprecated
    public OffsetResult lookupByOffsetWithBias(int n, boolean bl, long l, TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("lookupByOffsetWithBias", $$robo$$libcore_util_CountryTimeZones$lookupByOffsetWithBias(int boolean long android.icu.util.TimeZone ), 0, this, n, bl, l, timeZone);
    }

    private static boolean offsetMatchesAtTime(TimeZone timeZone, int n, boolean bl, long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("offsetMatchesAtTime", $$robo$$libcore_util_CountryTimeZones$offsetMatchesAtTime(android.icu.util.TimeZone int boolean long ), 0, (TimeZone)timeZone, (int)n, (boolean)bl, (long)l);
    }

    public OffsetResult lookupByOffsetWithBias(int n, Integer n2, long l, TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("lookupByOffsetWithBias", $$robo$$libcore_util_CountryTimeZones$lookupByOffsetWithBias(int java.lang.Integer long android.icu.util.TimeZone ), 0, this, n, n2, l, timeZone);
    }

    private static boolean offsetMatchesAtTime(TimeZone timeZone, int n, Integer n2, long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("offsetMatchesAtTime", $$robo$$libcore_util_CountryTimeZones$offsetMatchesAtTime(android.icu.util.TimeZone int java.lang.Integer long ), 0, (TimeZone)timeZone, (int)n, (Integer)n2, (long)l);
    }

    private static TimeZone getValidFrozenTimeZoneOrNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getValidFrozenTimeZoneOrNull", $$robo$$libcore_util_CountryTimeZones$getValidFrozenTimeZoneOrNull(java.lang.String ), 0, (String)string2);
    }

    private static String normalizeCountryIso(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeCountryIso", $$robo$$libcore_util_CountryTimeZones$normalizeCountryIso(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ CountryTimeZones() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryTimeZones)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TimeZoneMapping
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String timeZoneId;
        public boolean showInPicker;
        public Long notUsedAfter;

        private void $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$__constructor__(String timeZoneId, boolean showInPicker, Long notUsedAfter) {
            this.timeZoneId = timeZoneId;
            this.showInPicker = showInPicker;
            this.notUsedAfter = notUsedAfter;
        }

        private static final TimeZoneMapping $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$createForTests(String timeZoneId, boolean showInPicker, Long notUsedAfter) {
            return new TimeZoneMapping(timeZoneId, showInPicker, notUsedAfter);
        }

        private final boolean $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeZoneMapping that = (TimeZoneMapping)o;
            return this.showInPicker == that.showInPicker && Objects.equals(this.timeZoneId, that.timeZoneId) && Objects.equals(this.notUsedAfter, that.notUsedAfter);
        }

        private final int $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$hashCode() {
            return Objects.hash(this.timeZoneId, this.showInPicker, this.notUsedAfter);
        }

        private final String $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$toString() {
            return "TimeZoneMapping{timeZoneId='" + this.timeZoneId + '\'' + ", showInPicker=" + this.showInPicker + ", notUsedAfter=" + this.notUsedAfter + '}';
        }

        private static final boolean $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$containsTimeZoneId(List<TimeZoneMapping> timeZoneMappings, String timeZoneId) {
            for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
                if (!timeZoneMapping.timeZoneId.equals(timeZoneId)) continue;
                return true;
            }
            return false;
        }

        private void __constructor__(String string2, boolean bl, Long l) {
            this.$$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$__constructor__(string2, bl, l);
        }

        TimeZoneMapping(String string2, boolean bl, Long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$__constructor__(java.lang.String boolean java.lang.Long ), 0, this, string2, bl, l);
        }

        public static TimeZoneMapping createForTests(String string2, boolean bl, Long l) {
            return InvokeDynamicSupport.bootstrapStatic("createForTests", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$createForTests(java.lang.String boolean java.lang.Long ), 0, (String)string2, (boolean)bl, (Long)l);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$toString(), 0, this);
        }

        public static boolean containsTimeZoneId(List<TimeZoneMapping> list, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("containsTimeZoneId", $$robo$$libcore_util_CountryTimeZones_TimeZoneMapping$containsTimeZoneId(java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> java.lang.String ), 0, list, (String)string2);
        }

        public /* synthetic */ TimeZoneMapping() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneMapping)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class OffsetResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public TimeZone mTimeZone;
        public boolean mOneMatch;

        private void $$robo$$libcore_util_CountryTimeZones_OffsetResult$__constructor__(TimeZone timeZone, boolean oneMatch) {
            this.mTimeZone = Objects.requireNonNull(timeZone);
            this.mOneMatch = oneMatch;
        }

        private final String $$robo$$libcore_util_CountryTimeZones_OffsetResult$toString() {
            return "Result{mTimeZone='" + this.mTimeZone + '\'' + ", mOneMatch=" + this.mOneMatch + '}';
        }

        private void __constructor__(TimeZone timeZone, boolean bl) {
            this.$$robo$$libcore_util_CountryTimeZones_OffsetResult$__constructor__(timeZone, bl);
        }

        public OffsetResult(TimeZone timeZone, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_CountryTimeZones_OffsetResult$__constructor__(android.icu.util.TimeZone boolean ), 0, this, timeZone, bl);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_util_CountryTimeZones_OffsetResult$toString(), 0, this);
        }

        public /* synthetic */ OffsetResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

